/*
 * Decompiled with CFR 0.152.
 */
package org.apache.java.recycle.pool;

import org.apache.java.recycle.Recyclable;
import org.apache.java.recycle.RecycleBin;
import org.apache.java.recycle.RecycleBinIsEmpty;
import org.apache.java.recycle.RecycleBinIsFull;
import org.apache.java.recycle.pool.Worker;

class WorkerContainer
implements RecycleBin {
    private RecycleBin container;
    private ThreadGroup group;
    private int capacity;
    private int level;

    protected WorkerContainer(RecycleBin recycleBin, ThreadGroup threadGroup, int n) {
        this.container = recycleBin;
        this.capacity = n;
        this.group = threadGroup;
    }

    public synchronized Recyclable getRecyclable() {
        while (true) {
            try {
                return (Worker)this.container.getRecyclable();
            }
            catch (RecycleBinIsEmpty recycleBinIsEmpty) {
                if (this.level < this.capacity) {
                    Worker worker = new Worker(this.group, this, "Worker #" + this.level);
                    worker.start();
                    ++this.level;
                    return worker;
                }
                try {
                    this.wait();
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
            }
            break;
        }
    }

    public synchronized void recycle(Recyclable recyclable) {
        try {
            this.container.recycle(recyclable);
            this.notify();
            return;
        }
        catch (RecycleBinIsFull recycleBinIsFull) {
            --this.level;
            return;
        }
    }

    public int getSize() {
        return this.container.getSize();
    }
}

