/*
 * Decompiled with CFR 0.152.
 */
package com.sun.activation.registries;

public class MailcapTokenizer {
    public static final int UNKNOWN_TOKEN = 0;
    public static final int START_TOKEN = 1;
    public static final int STRING_TOKEN = 2;
    public static final int EOI_TOKEN = 5;
    public static final int SLASH_TOKEN = 47;
    public static final int SEMICOLON_TOKEN = 59;
    public static final int EQUALS_TOKEN = 61;
    private String data;
    private int dataIndex;
    private int dataLength;
    private int currentToken;
    private String currentTokenValue;
    private boolean isAutoquoting;
    private char autoquoteChar;

    public MailcapTokenizer(String string) {
        this.data = string;
        this.dataIndex = 0;
        this.dataLength = string.length();
        this.currentToken = 1;
        this.currentTokenValue = "";
        this.isAutoquoting = false;
        this.autoquoteChar = (char)59;
    }

    private static String fixEscapeSequences(String string) {
        int n2 = string.length();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.ensureCapacity(n2);
        int n3 = 0;
        while (n3 < n2) {
            char c10 = string.charAt(n3);
            if (c10 != '\\') {
                stringBuffer.append(c10);
            } else if (n3 < n2 - 1) {
                char c11 = string.charAt(n3 + 1);
                stringBuffer.append(c11);
                ++n3;
            } else {
                stringBuffer.append(c10);
            }
            ++n3;
        }
        return stringBuffer.toString();
    }

    public int getCurrentToken() {
        return this.currentToken;
    }

    public String getCurrentTokenValue() {
        return this.currentTokenValue;
    }

    public static boolean isAutoquoteSpecialChar(char c10) {
        boolean bl2 = false;
        switch (c10) {
            case ';': 
            case '=': {
                bl2 = true;
                break;
            }
        }
        return bl2;
    }

    public static boolean isControlChar(char c10) {
        return Character.isISOControl(c10);
    }

    public static boolean isSpecialChar(char c10) {
        boolean bl2 = false;
        switch (c10) {
            case '\"': 
            case '(': 
            case ')': 
            case ',': 
            case '/': 
            case ':': 
            case ';': 
            case '<': 
            case '=': 
            case '>': 
            case '?': 
            case '@': 
            case '[': 
            case '\\': 
            case ']': {
                bl2 = true;
                break;
            }
        }
        return bl2;
    }

    public static boolean isStringTokenChar(char c10) {
        return !MailcapTokenizer.isSpecialChar(c10) && !MailcapTokenizer.isControlChar(c10) && !MailcapTokenizer.isWhiteSpaceChar(c10);
    }

    public static boolean isWhiteSpaceChar(char c10) {
        return Character.isWhitespace(c10);
    }

    public static String nameForToken(int n2) {
        String string = "really unknown";
        switch (n2) {
            case 0: {
                string = "unknown";
                break;
            }
            case 1: {
                string = "start";
                break;
            }
            case 2: {
                string = "string";
                break;
            }
            case 5: {
                string = "EOI";
                break;
            }
            case 47: {
                string = "'/'";
                break;
            }
            case 59: {
                string = "';'";
                break;
            }
            case 61: {
                string = "'='";
                break;
            }
        }
        return string;
    }

    public int nextToken() {
        if (this.dataIndex < this.dataLength) {
            while (this.dataIndex < this.dataLength && MailcapTokenizer.isWhiteSpaceChar(this.data.charAt(this.dataIndex))) {
                ++this.dataIndex;
            }
            if (this.dataIndex < this.dataLength) {
                char c10 = this.data.charAt(this.dataIndex);
                if (this.isAutoquoting) {
                    if (!MailcapTokenizer.isAutoquoteSpecialChar(c10)) {
                        this.processAutoquoteToken();
                    } else if (c10 == ';' || c10 == '=') {
                        this.currentToken = c10;
                        this.currentTokenValue = new Character(c10).toString();
                        ++this.dataIndex;
                    } else {
                        this.currentToken = 0;
                        this.currentTokenValue = new Character(c10).toString();
                        ++this.dataIndex;
                    }
                } else if (MailcapTokenizer.isStringTokenChar(c10)) {
                    this.processStringToken();
                } else if (c10 == '/' || c10 == ';' || c10 == '=') {
                    this.currentToken = c10;
                    this.currentTokenValue = new Character(c10).toString();
                    ++this.dataIndex;
                } else {
                    this.currentToken = 0;
                    this.currentTokenValue = new Character(c10).toString();
                    ++this.dataIndex;
                }
            } else {
                this.currentToken = 5;
                this.currentTokenValue = null;
            }
        } else {
            this.currentToken = 5;
            this.currentTokenValue = null;
        }
        return this.currentToken;
    }

    private void processAutoquoteToken() {
        int n2 = this.dataIndex;
        boolean bl2 = false;
        while (this.dataIndex < this.dataLength && !bl2) {
            char c10 = this.data.charAt(this.dataIndex);
            if (c10 != this.autoquoteChar) {
                ++this.dataIndex;
                continue;
            }
            bl2 = true;
        }
        this.currentToken = 2;
        this.currentTokenValue = MailcapTokenizer.fixEscapeSequences(this.data.substring(n2, this.dataIndex));
    }

    private void processStringToken() {
        int n2 = this.dataIndex;
        while (this.dataIndex < this.dataLength && MailcapTokenizer.isStringTokenChar(this.data.charAt(this.dataIndex))) {
            ++this.dataIndex;
        }
        this.currentToken = 2;
        this.currentTokenValue = this.data.substring(n2, this.dataIndex);
    }

    public void setAutoquoteChar(char c10) {
        this.autoquoteChar = c10;
    }

    public void setIsAutoquoting(boolean bl2) {
        this.isAutoquoting = bl2;
    }
}

