/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.internal.Activation;

import com.sun.corba.ee.ActivationIDL.Locator;
import com.sun.corba.ee.ActivationIDL.LocatorHelper;
import com.sun.corba.ee.ActivationIDL.LocatorPackage.ServerLocation;
import com.sun.corba.ee.ActivationIDL.NoSuchEndPoint;
import com.sun.corba.ee.ActivationIDL.ServerHeldDown;
import com.sun.corba.ee.ActivationIDL.ServerNotRegistered;
import com.sun.corba.ee.internal.Activation.CommandHandler;
import com.sun.corba.ee.internal.Activation.ServerTool;
import java.io.PrintStream;
import org.omg.CORBA.ORB;

class LocateServer
implements CommandHandler {
    static final int illegalServerId = -1;

    LocateServer() {
    }

    public String getCommandName() {
        return "locate";
    }

    public void printCommandHelp(PrintStream printStream, boolean bl2) {
        if (!bl2) {
            printStream.println("\tlocate [ -serverid <server id> | -applicationName <name> ]\n");
        } else {
            printStream.println("locate a registered server");
        }
    }

    public boolean processCommand(String[] stringArray, ORB oRB, PrintStream printStream) {
        int n2 = -1;
        if (stringArray.length == 2) {
            if (stringArray[0].equals("-serverid")) {
                n2 = Integer.valueOf(stringArray[1]);
            } else if (stringArray[0].equals("-applicationName")) {
                n2 = ServerTool.getServerIdForAlias(oRB, stringArray[1]);
            }
        }
        if (n2 == -1) {
            return true;
        }
        try {
            Locator locator = LocatorHelper.narrow(oRB.resolve_initial_references("ServerLocator"));
            ServerLocation serverLocation = locator.locateServer(n2, 0);
            Integer n3 = new Integer(serverLocation.port);
            printStream.println("\tserver hostname=" + serverLocation.hostname + " port=" + n3.toString());
        }
        catch (NoSuchEndPoint noSuchEndPoint) {
        }
        catch (ServerHeldDown serverHeldDown) {
            printStream.println("\tserver is held down.");
        }
        catch (ServerNotRegistered serverNotRegistered) {
            printStream.println("\tno such server found.");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return false;
    }
}

