/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.internal.Activation;

import com.sun.corba.ee.ActivationIDL._POAIdMapImplBase;
import com.sun.corba.ee.internal.POA.POAORB;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.INITIALIZE;
import org.omg.CORBA.INTERNAL;

public class POAIdMapImpl
extends _POAIdMapImplBase
implements Serializable {
    private transient boolean debug = false;
    private transient POAIdDB db = null;
    transient POAORB orb = null;

    public POAIdMapImpl(POAORB pOAORB, File file, boolean bl2) {
        this.orb = pOAORB;
        this.debug = bl2;
        File file2 = new File(file, "poaids.db");
        if (!file2.exists()) {
            this.db = new POAIdDB(file2);
            this.db.flush();
        } else {
            try {
                FileInputStream fileInputStream = new FileInputStream(file2);
                ObjectInputStream objectInputStream = new ObjectInputStream(fileInputStream);
                this.db = (POAIdDB)objectInputStream.readObject();
                objectInputStream.close();
            }
            catch (Exception exception) {
                System.err.println(exception.toString());
                System.err.println("Unable to read POA Id Database!");
                throw new INITIALIZE(1398082491, CompletionStatus.COMPLETED_NO);
            }
        }
        pOAORB.connect(this);
    }

    public int getId(String[] stringArray) {
        POAIdRecord pOAIdRecord = null;
        String[] stringArray2 = null;
        POAIdDB pOAIdDB = this.db;
        synchronized (pOAIdDB) {
            int n2;
            Enumeration enumeration = this.db.poaIdTable.elements();
            while (enumeration.hasMoreElements()) {
                pOAIdRecord = (POAIdRecord)enumeration.nextElement();
                stringArray2 = pOAIdRecord.name;
                if (stringArray.length != stringArray2.length) continue;
                n2 = 1;
                int n3 = 0;
                while (n3 < stringArray2.length) {
                    if (!stringArray[n3].equals(stringArray2[n3])) {
                        n2 = 0;
                        break;
                    }
                    ++n3;
                }
                if (n2 == 0) continue;
                int n4 = pOAIdRecord.id;
                if (this.debug) {
                    System.out.println("POAIDMap: found POA name " + this.printName(stringArray2) + " in table. getId returns " + n4);
                }
                int n5 = n4;
                Object var6_13 = null;
                return n5;
            }
            n2 = this.db.incrementPoaIdCounter();
            Integer n6 = new Integer(n2);
            POAIdRecord pOAIdRecord2 = new POAIdRecord(stringArray, n2);
            this.db.poaIdTable.put(n6, pOAIdRecord2);
            this.db.flush();
            if (this.debug) {
                System.out.println("POAIDMap: creating new entry for POA name " + this.printName(stringArray) + " in table. getId returns " + n2);
            }
            int n7 = n2;
            Object var6_14 = null;
            return n7;
        }
    }

    public String[] getName(int n2) {
        Integer n3 = new Integer(n2);
        POAIdRecord pOAIdRecord = (POAIdRecord)this.db.poaIdTable.get(n3);
        if (pOAIdRecord != null) {
            if (this.debug) {
                System.out.println("POAIdMap: getName for ID " + n2 + " returns " + this.printName(pOAIdRecord.name));
            }
            return pOAIdRecord.name;
        }
        if (this.debug) {
            System.out.println("POAIdMap: getName for ID " + n2 + " returns null");
        }
        return null;
    }

    public String[][] getNames() {
        int n2 = this.db.poaIdTable.size();
        int n3 = 0;
        String[][] stringArray = new String[n2][];
        Enumeration enumeration = this.db.poaIdTable.elements();
        while (enumeration.hasMoreElements()) {
            POAIdRecord pOAIdRecord = (POAIdRecord)enumeration.nextElement();
            stringArray[n3++] = pOAIdRecord.name;
        }
        return stringArray;
    }

    private String printName(String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl2 = true;
        int n2 = 0;
        while (n2 < stringArray.length) {
            if (bl2) {
                bl2 = false;
            } else {
                stringBuffer.append("/");
            }
            stringBuffer.append(stringArray[n2]);
            ++n2;
        }
        return stringBuffer.toString();
    }

    class POAIdDB
    implements Serializable {
        File db;
        Hashtable poaIdTable;
        Integer poaIdCounter;

        POAIdDB(File file) {
            this.db = file;
            this.poaIdTable = new Hashtable(255);
            this.poaIdCounter = new Integer(65536);
        }

        void flush() {
            try {
                this.db.delete();
                FileOutputStream fileOutputStream = new FileOutputStream(this.db);
                ObjectOutputStream objectOutputStream = new ObjectOutputStream(fileOutputStream);
                objectOutputStream.writeObject(this);
                objectOutputStream.flush();
                objectOutputStream.close();
            }
            catch (Exception exception) {
                System.err.println(exception.toString());
                System.err.println("Unable to write POA Id Database!");
                throw new INTERNAL(1398082490, CompletionStatus.COMPLETED_NO);
            }
        }

        int incrementPoaIdCounter() {
            int n2 = this.poaIdCounter;
            this.poaIdCounter = new Integer(++n2);
            return n2;
        }
    }

    class POAIdRecord
    implements Serializable {
        String[] name;
        Integer id;

        POAIdRecord(String[] stringArray, int n2) {
            this.name = stringArray;
            this.id = new Integer(n2);
        }
    }
}

