/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.internal.Activation;

import com.sun.corba.ee.ActivationIDL.LocatorPackage.ServerLocation;
import com.sun.corba.ee.ActivationIDL.NoSuchEndPoint;
import com.sun.corba.ee.ActivationIDL.Repository;
import com.sun.corba.ee.ActivationIDL.RepositoryPackage.ServerDef;
import com.sun.corba.ee.ActivationIDL.Server;
import com.sun.corba.ee.ActivationIDL.ServerAlreadyActive;
import com.sun.corba.ee.ActivationIDL.ServerAlreadyInstalled;
import com.sun.corba.ee.ActivationIDL.ServerAlreadyUninstalled;
import com.sun.corba.ee.ActivationIDL.ServerHeldDown;
import com.sun.corba.ee.ActivationIDL.ServerNotActive;
import com.sun.corba.ee.ActivationIDL.ServerNotRegistered;
import com.sun.corba.ee.ActivationIDL._ServerManagerImplBase;
import com.sun.corba.ee.internal.Activation.ServerTableEntry;
import com.sun.corba.ee.internal.POA.BadServerIdHandler;
import com.sun.corba.ee.internal.POA.ForwardException;
import com.sun.corba.ee.internal.POA.POAORB;
import com.sun.corba.ee.internal.core.IOR;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.INTERNAL;
import org.omg.CORBA.OBJECT_NOT_EXIST;

public class ServerManagerImpl
extends _ServerManagerImplBase
implements BadServerIdHandler {
    Hashtable serverTable;
    Repository repository;
    short ORBDport;
    short initialPort;
    POAORB orb;
    String dbDirName;
    boolean debug = false;

    ServerManagerImpl(POAORB pOAORB, int n2, Repository repository, String string, boolean bl2) {
        this.orb = pOAORB;
        this.ORBDport = (short)n2;
        this.repository = repository;
        this.dbDirName = string;
        this.debug = bl2;
        this.initialPort = (short)pOAORB.getServerGIOP().getBootstrapEndpoint(0).getPort();
        this.serverTable = new Hashtable(256);
        pOAORB.setBadServerIdHandler(this);
        pOAORB.connect(this);
    }

    public void activate(int n2) throws ServerAlreadyActive, ServerNotRegistered, ServerHeldDown {
        block6: {
            Integer n3;
            ServerTableEntry serverTableEntry;
            if (this.debug) {
                System.out.println("ServerManagerImpl: activate for server Id " + n2 + " called.");
            }
            if ((serverTableEntry = (ServerTableEntry)this.serverTable.get(n3 = new Integer(n2))) != null && serverTableEntry.isActive()) {
                if (this.debug) {
                    System.out.println("ServerManagerImpl: activate for server Id " + n2 + " failed because server is already active. " + "entry = " + serverTableEntry);
                }
                throw new ServerAlreadyActive(n2);
            }
            try {
                ServerLocation serverLocation = this.locateServer(n2, 0, false);
                if (this.debug) {
                    System.out.println("ServerManagerImpl: activate for server Id " + n2 + " found location " + this.convertServerLocation(serverLocation) + " and activated it");
                }
            }
            catch (NoSuchEndPoint noSuchEndPoint) {
                if (!this.debug) break block6;
                System.out.println("ServerManagerImpl: activate for server Id  threw NoSuchEndpoint exception, which was ignored");
            }
        }
    }

    public void active(int n2, Server server) throws ServerNotRegistered {
        Integer n3 = new Integer(n2);
        Hashtable hashtable = this.serverTable;
        synchronized (hashtable) {
            ServerTableEntry serverTableEntry = (ServerTableEntry)this.serverTable.get(n3);
            if (serverTableEntry == null) {
                if (this.debug) {
                    System.out.println("ServerManagerImpl: active for server Id " + n2 + " called, but no such server is registered.");
                }
                throw new INTERNAL(1398082491, CompletionStatus.COMPLETED_NO);
            }
            if (this.debug) {
                System.out.println("ServerManagerImpl: active for server Id " + n2 + " called.  This server is now active.");
            }
            serverTableEntry.register(server);
        }
    }

    private String convertServerLocation(ServerLocation serverLocation) {
        return "hostname = " + serverLocation.hostname + " port = " + serverLocation.port;
    }

    public int[] getActiveServers() {
        int[] nArray = null;
        Vector<ServerTableEntry> vector = new Vector<ServerTableEntry>();
        Serializable serializable = this.serverTable;
        synchronized (serializable) {
            ServerTableEntry serverTableEntry;
            Enumeration enumeration = this.serverTable.elements();
            while (enumeration.hasMoreElements()) {
                serverTableEntry = (ServerTableEntry)enumeration.nextElement();
                if (!serverTableEntry.isValid() || !serverTableEntry.isActive()) continue;
                vector.addElement(serverTableEntry);
            }
            nArray = new int[vector.size()];
            int n2 = 0;
            while (n2 < vector.size()) {
                serverTableEntry = (ServerTableEntry)vector.elementAt(n2);
                nArray[n2] = serverTableEntry.getServerId();
                ++n2;
            }
        }
        if (this.debug) {
            serializable = new StringBuffer();
            int n3 = 0;
            while (n3 < nArray.length) {
                ((StringBuffer)serializable).append(' ');
                ((StringBuffer)serializable).append(nArray[n3]);
                ++n3;
            }
            System.out.println("ServerManagerImpl: getActiveServers returns" + ((StringBuffer)serializable).toString());
        }
        return nArray;
    }

    public short getEndpoint(int n2) throws NoSuchEndPoint {
        return this.ORBDport;
    }

    private ServerTableEntry getEntry(int n2) throws ServerNotRegistered {
        Integer n3 = new Integer(n2);
        ServerTableEntry serverTableEntry = null;
        Hashtable hashtable = this.serverTable;
        synchronized (hashtable) {
            serverTableEntry = (ServerTableEntry)this.serverTable.get(n3);
            if (this.debug) {
                if (serverTableEntry == null) {
                    System.out.println("ServerManagerImpl: getEntry: no active server found.");
                } else {
                    System.out.println("ServerManagerImpl: getEntry:  active server found " + serverTableEntry + ".");
                }
            }
            if (serverTableEntry != null && !serverTableEntry.isValid()) {
                this.serverTable.remove(n3);
                serverTableEntry = null;
            }
            if (serverTableEntry == null) {
                ServerDef serverDef = this.repository.getServer(n2);
                serverTableEntry = new ServerTableEntry(n2, serverDef, this.initialPort, this.dbDirName, false, this.debug);
                this.serverTable.put(n3, serverTableEntry);
                serverTableEntry.activate();
            }
        }
        return serverTableEntry;
    }

    private ServerTableEntry getRunningEntry(int n2) throws ServerNotRegistered {
        ServerTableEntry serverTableEntry = this.getEntry(n2);
        try {
            short s2 = serverTableEntry.lookup();
        }
        catch (Exception exception) {
            return null;
        }
        return serverTableEntry;
    }

    public void handle(int n2, byte[] byArray) throws ForwardException {
        IOR iOR = null;
        if (this.debug) {
            System.out.println("ServerManagerImpl: handle called for server id" + n2);
        }
        try {
            ServerLocation serverLocation = this.locateServer(n2, 0);
            iOR = new IOR(this.orb, "IDL:org/omg/CORBA/Object:1.0", serverLocation.hostname, serverLocation.port, byArray);
        }
        catch (Exception exception) {
            if (this.debug) {
                System.out.println("ServerManagerImpl: handle throws OBJECT_NOT_EXIST");
            }
            throw new OBJECT_NOT_EXIST();
        }
        if (this.debug) {
            System.out.println("ServerManagerImpl: handle throws ForwardException");
        }
        throw new ForwardException(iOR);
    }

    public void install(int n2) throws ServerNotRegistered, ServerHeldDown, ServerAlreadyInstalled {
        ServerTableEntry serverTableEntry = this.getRunningEntry(n2);
        this.repository.install(n2);
        serverTableEntry.install();
    }

    public ServerLocation locateServer(int n2, int n3) throws NoSuchEndPoint, ServerNotRegistered, ServerHeldDown {
        return this.locateServer(n2, n3, true);
    }

    public ServerLocation locateServer(int n2, int n3, boolean bl2) throws NoSuchEndPoint, ServerNotRegistered, ServerHeldDown {
        ServerLocation serverLocation = new ServerLocation();
        if (this.debug) {
            System.out.println("ServerManagerImpl: locateServer called with  serverId=" + n2 + " endpointType=" + n3 + " block=" + bl2);
        }
        ServerTableEntry serverTableEntry = this.getEntry(n2);
        if (bl2) {
            String string;
            short s2 = 0;
            try {
                s2 = serverTableEntry.lookup();
            }
            catch (Exception exception) {
                if (this.debug) {
                    System.out.println("ServerManagerImpl: locateServer: server held down");
                }
                throw new ServerHeldDown(n2);
            }
            serverLocation.hostname = string = this.orb.getServerEndpoint().getHostName();
            serverLocation.port = s2;
            if (this.debug) {
                System.out.println("ServerManagerImpl: locateServer: server located at location " + this.convertServerLocation(serverLocation));
            }
        }
        return serverLocation;
    }

    public void shutdown(int n2) throws ServerNotActive {
        block5: {
            Integer n3 = new Integer(n2);
            ServerTableEntry serverTableEntry = (ServerTableEntry)this.serverTable.remove(n3);
            if (serverTableEntry == null) {
                if (this.debug) {
                    System.out.println("ServerManagerImpl: shutdown for server Id " + n2 + " throws ServerNotActive.");
                }
                throw new ServerNotActive(n2);
            }
            try {
                serverTableEntry.destroy();
                if (this.debug) {
                    System.out.println("ServerManagerImpl: shutdown for server Id " + n2 + " completed.");
                }
            }
            catch (Exception exception) {
                if (!this.debug) break block5;
                System.out.println("ServerManagerImpl: shutdown for server Id " + n2 + " threw exception " + exception);
            }
        }
    }

    public void uninstall(int n2) throws ServerNotRegistered, ServerHeldDown, ServerAlreadyUninstalled {
        ServerTableEntry serverTableEntry = this.getRunningEntry(n2);
        this.repository.uninstall(n2);
        serverTableEntry.uninstall();
    }
}

