/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.internal.POA;

import com.sun.corba.ee.internal.POA.POAPolicyCombinationValidator;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.Policy;
import org.omg.CORBA.portable.IDLEntity;
import org.omg.PortableServer.IdAssignmentPolicy;
import org.omg.PortableServer.IdAssignmentPolicyValue;
import org.omg.PortableServer.IdUniquenessPolicy;
import org.omg.PortableServer.IdUniquenessPolicyValue;
import org.omg.PortableServer.ImplicitActivationPolicy;
import org.omg.PortableServer.ImplicitActivationPolicyValue;
import org.omg.PortableServer.LifespanPolicy;
import org.omg.PortableServer.LifespanPolicyValue;
import org.omg.PortableServer.POAPackage.InvalidPolicy;
import org.omg.PortableServer.RequestProcessingPolicy;
import org.omg.PortableServer.RequestProcessingPolicyValue;
import org.omg.PortableServer.ServantRetentionPolicy;
import org.omg.PortableServer.ServantRetentionPolicyValue;
import org.omg.PortableServer.ThreadPolicy;
import org.omg.PortableServer.ThreadPolicyValue;

final class Policies {
    private int threadModel;
    private int lifespan;
    private int idUniqueness;
    private int idAssignment;
    private int retention;
    private int requestProcessing;
    private int implicitActivation;
    static final Policies defaultPolicies = new Policies(0, 0, 0, 1, 0, 0, 1);

    Policies() {
        this.threadModel = Policies.defaultPolicies.threadModel;
        this.lifespan = Policies.defaultPolicies.lifespan;
        this.idUniqueness = Policies.defaultPolicies.idUniqueness;
        this.idAssignment = Policies.defaultPolicies.idAssignment;
        this.retention = Policies.defaultPolicies.retention;
        this.requestProcessing = Policies.defaultPolicies.requestProcessing;
        this.implicitActivation = Policies.defaultPolicies.implicitActivation;
    }

    Policies(int n2) {
        this.threadModel = (n2 & 0x80) >> 7;
        this.lifespan = (n2 & 0x40) >> 6;
        this.idUniqueness = (n2 & 0x20) >> 5;
        this.idAssignment = (n2 & 0x10) >> 4;
        this.implicitActivation = (n2 & 8) >> 3;
        this.retention = (n2 & 4) >> 2;
        this.requestProcessing = n2 & 3;
    }

    private Policies(int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        this.threadModel = n2;
        this.lifespan = n3;
        this.idUniqueness = n4;
        this.idAssignment = n5;
        this.retention = n6;
        this.requestProcessing = n7;
        this.implicitActivation = n8;
    }

    Policies(Policy[] policyArray) throws InvalidPolicy {
        this();
        if (policyArray == null) {
            return;
        }
        short s2 = 0;
        while (s2 < policyArray.length) {
            IDLEntity iDLEntity;
            Policy policy = policyArray[s2];
            if (policy instanceof ThreadPolicy) {
                this.threadModel = ((ThreadPolicy)policy).value().value();
                try {
                    iDLEntity = ThreadPolicyValue.from_int(this.threadModel);
                }
                catch (BAD_PARAM bAD_PARAM) {
                    this.invalidPolicy(s2);
                }
            } else if (policy instanceof LifespanPolicy) {
                this.lifespan = ((LifespanPolicy)policy).value().value();
                try {
                    iDLEntity = LifespanPolicyValue.from_int(this.lifespan);
                }
                catch (BAD_PARAM bAD_PARAM) {
                    this.invalidPolicy(s2);
                }
            } else if (policy instanceof IdUniquenessPolicy) {
                this.idUniqueness = ((IdUniquenessPolicy)policy).value().value();
                try {
                    iDLEntity = IdUniquenessPolicyValue.from_int(this.idUniqueness);
                }
                catch (BAD_PARAM bAD_PARAM) {
                    this.invalidPolicy(s2);
                }
            } else if (policy instanceof IdAssignmentPolicy) {
                this.idAssignment = ((IdAssignmentPolicy)policy).value().value();
                try {
                    iDLEntity = IdAssignmentPolicyValue.from_int(this.idAssignment);
                }
                catch (BAD_PARAM bAD_PARAM) {
                    this.invalidPolicy(s2);
                }
            } else if (policy instanceof ServantRetentionPolicy) {
                this.retention = ((ServantRetentionPolicy)policy).value().value();
                try {
                    iDLEntity = ServantRetentionPolicyValue.from_int(this.retention);
                }
                catch (BAD_PARAM bAD_PARAM) {
                    this.invalidPolicy(s2);
                }
            } else if (policy instanceof RequestProcessingPolicy) {
                this.requestProcessing = ((RequestProcessingPolicy)policy).value().value();
                try {
                    iDLEntity = RequestProcessingPolicyValue.from_int(this.requestProcessing);
                }
                catch (BAD_PARAM bAD_PARAM) {
                    this.invalidPolicy(s2);
                }
            } else if (policy instanceof ImplicitActivationPolicy) {
                this.implicitActivation = ((ImplicitActivationPolicy)policy).value().value();
                try {
                    iDLEntity = ImplicitActivationPolicyValue.from_int(this.implicitActivation);
                }
                catch (BAD_PARAM bAD_PARAM) {
                    this.invalidPolicy(s2);
                }
            } else {
                this.invalidPolicy(s2);
            }
            s2 = (short)(s2 + 1);
        }
        short s3 = POAPolicyCombinationValidator.checkForInvalidPolicyCombinations(policyArray);
        if (s3 > -1) {
            this.invalidPolicy(s3);
        }
    }

    public final int getBitMap() {
        return this.threadModel << 7 | this.lifespan << 6 | this.idUniqueness << 5 | this.idAssignment << 4 | this.implicitActivation << 3 | this.retention << 2 | this.requestProcessing;
    }

    private void invalidPolicy(short s2) throws InvalidPolicy {
        throw new InvalidPolicy(s2);
    }

    public final boolean isImplicitlyActivated() {
        return this.implicitActivation == 0;
    }

    public final boolean isMultipleIds() {
        return this.idUniqueness == 1;
    }

    public final boolean isOrbControlledThreads() {
        return this.threadModel == 0;
    }

    public final boolean isPersistent() {
        return this.lifespan == 1;
    }

    public final boolean isSingleThreaded() {
        return this.threadModel == 1;
    }

    public final boolean isSystemAssignedIds() {
        return this.idAssignment == 1;
    }

    public final boolean isTransient() {
        return this.lifespan == 0;
    }

    public final boolean isUniqueIds() {
        return this.idUniqueness == 0;
    }

    public final boolean isUserAssignedIds() {
        return this.idAssignment == 0;
    }

    public final boolean retainServants() {
        return this.retention == 0;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("threadModel = ");
        if (this.isSingleThreaded()) {
            stringBuffer.append("SINGLE_THREAD_MODEL");
        } else {
            stringBuffer.append("ORB_CTRL_MODEL");
        }
        stringBuffer.append(";");
        stringBuffer.append("lifespan = ");
        if (this.isPersistent()) {
            stringBuffer.append("PERSISTENT");
        } else {
            stringBuffer.append("TRANSIENT");
        }
        stringBuffer.append(";");
        stringBuffer.append("idUniqueness = ");
        if (this.isUniqueIds()) {
            stringBuffer.append("UNIQUE_ID");
        } else {
            stringBuffer.append("MULTIPLE_ID");
        }
        stringBuffer.append(";");
        stringBuffer.append("idAssignment = ");
        if (this.isUserAssignedIds()) {
            stringBuffer.append("USER_ID");
        } else {
            stringBuffer.append("SYSTEM_ID");
        }
        stringBuffer.append(";");
        stringBuffer.append("implicitActivation = ");
        if (this.isImplicitlyActivated()) {
            stringBuffer.append("IMPLICIT_ACTIVATION");
        } else {
            stringBuffer.append("NO_IMPLICIT_ACTIVATION");
        }
        stringBuffer.append(";");
        stringBuffer.append("retention = ");
        if (this.retainServants()) {
            stringBuffer.append("RETAIN");
        } else {
            stringBuffer.append("NON_RETAIN");
        }
        stringBuffer.append(";");
        stringBuffer.append("requestProcessing = ");
        if (this.useActiveMapOnly()) {
            stringBuffer.append("USE_ACTIVE_OBJECT_MAP_ONLY");
        } else if (this.useDefaultServant()) {
            stringBuffer.append("USE_DEFAULT_SERVANT");
        } else {
            stringBuffer.append("USE_SERVANT_MANAGER");
        }
        stringBuffer.append(";");
        return stringBuffer.toString();
    }

    public final boolean useActiveMapOnly() {
        return this.requestProcessing == 0;
    }

    public final boolean useDefaultServant() {
        return this.requestProcessing == 1;
    }

    public final boolean useServantManager() {
        return this.requestProcessing == 2;
    }
}

