/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.internal.iiop;

import com.sun.corba.ee.internal.core.EndPoint;
import com.sun.corba.ee.internal.core.IOR;
import com.sun.corba.ee.internal.core.MarshalOutputStream;
import com.sun.corba.ee.internal.core.ServerGIOP;
import com.sun.corba.ee.internal.iiop.ConnectionTable;
import com.sun.corba.ee.internal.iiop.IIOPInputStream;
import com.sun.corba.ee.internal.iiop.IIOPOutputStream;
import com.sun.corba.ee.internal.iiop.LocateReplyMessage;
import com.sun.corba.ee.internal.iiop.LocateRequestMessage;
import com.sun.corba.ee.internal.iiop.ORB;
import com.sun.corba.ee.internal.util.Utility;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.rmi.server.RMISocketFactory;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.INTERNAL;
import org.omg.CORBA.OBJECT_NOT_EXIST;
import org.omg.CORBA.SystemException;

public abstract class Connection {
    public static final int CONN_ABORT = 1;
    public static final int CONN_REBIND = 2;
    protected ORB orb;
    protected Socket socket;
    protected long timeStamp = 0L;
    protected boolean isServer = false;
    protected ConnectionTable connectionTable = null;
    protected static String localHostString = null;

    public abstract void abortConnection();

    public abstract void cleanUp() throws Exception;

    public abstract IIOPInputStream createInputStream() throws Exception;

    public abstract void delete();

    void dprint(String string) {
        Utility.dprint(this, string);
    }

    public abstract InputStream getInputStream();

    public static String getLocalHost() {
        if (localHostString != null) {
            return localHostString;
        }
        try {
            localHostString = InetAddress.getLocalHost().getHostAddress();
            return localHostString;
        }
        catch (Exception exception) {
            throw new INTERNAL(1398079495, CompletionStatus.COMPLETED_NO);
        }
    }

    public ORB getORB() {
        return this.orb;
    }

    public abstract ServerGIOP getServerGIOP();

    Socket getSocket() {
        return this.socket;
    }

    public abstract IIOPInputStream invoke(IIOPOutputStream var1) throws SystemException;

    public abstract boolean isBusy();

    public abstract boolean isPostInitialContexts();

    public IOR locate(int n2, byte[] byArray) {
        LocateRequestMessage locateRequestMessage = new LocateRequestMessage(n2, byArray, this.orb.transportDebugFlag);
        IIOPOutputStream iIOPOutputStream = this.orb.newOutputStream(this);
        locateRequestMessage.write(iIOPOutputStream);
        iIOPOutputStream.setMessage(locateRequestMessage);
        IIOPInputStream iIOPInputStream = this.send(iIOPOutputStream, false);
        LocateReplyMessage locateReplyMessage = (LocateReplyMessage)iIOPInputStream.getMessage();
        switch (locateReplyMessage.getRequestStatus()) {
            case 0: {
                throw new OBJECT_NOT_EXIST(1398079489, CompletionStatus.COMPLETED_NO);
            }
            case 1: {
                return null;
            }
            case 2: {
                IOR iOR = new IOR(this.orb);
                iOR.read(iIOPInputStream);
                return iOR;
            }
        }
        throw new INTERNAL(1398079497, CompletionStatus.COMPLETED_NO);
    }

    public static Socket newSocket(ORB oRB, EndPoint endPoint) throws IOException {
        RMISocketFactory rMISocketFactory = endPoint.getSocketFactory();
        return rMISocketFactory.createSocket(endPoint.getHostName(), endPoint.getPort());
    }

    public abstract void print();

    public abstract void requestBegins();

    public abstract void requestEnds();

    public abstract IIOPInputStream send(IIOPOutputStream var1, boolean var2);

    public abstract void sendReply(MarshalOutputStream var1) throws Exception;

    public abstract void setConnection(Socket var1, ConnectionTable var2) throws Exception;

    public abstract void setPostInitialContexts();

    public void stampTime() {
        this.connectionTable.stampTime(this);
    }
}

