/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.internal.iiop;

import com.sun.corba.ee.internal.core.ClientGIOP;
import com.sun.corba.ee.internal.core.EndPoint;
import com.sun.corba.ee.internal.core.IOR;
import com.sun.corba.ee.internal.core.Profile;
import com.sun.corba.ee.internal.core.RequestHandler;
import com.sun.corba.ee.internal.core.ServerGIOP;
import com.sun.corba.ee.internal.iiop.Connection;
import com.sun.corba.ee.internal.iiop.ConnectionTable;
import com.sun.corba.ee.internal.iiop.EndPointImpl;
import com.sun.corba.ee.internal.iiop.ListenerThread;
import com.sun.corba.ee.internal.iiop.ORB;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Enumeration;
import java.util.Vector;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.INTERNAL;

public class GIOPImpl
implements ClientGIOP,
ServerGIOP {
    private int requestId = 5;
    protected ConnectionTable table;
    protected ORB orb;
    private RequestHandler handler;
    protected int listenerPort;
    protected Vector endPoints = new Vector();
    protected ListenerThread listenerThread;
    private EndPoint bootstrapEndpoint;

    public GIOPImpl(ORB oRB, RequestHandler requestHandler) {
        this.orb = oRB;
        this.table = new ConnectionTable(oRB, this);
        this.setRequestHandler(requestHandler);
    }

    public int allocateRequestId() {
        return this.getNextRequestId();
    }

    private synchronized ListenerThread createListener(int n2) {
        ListenerThread listenerThread;
        final ConnectionTable connectionTable = this.table;
        try {
            final ServerSocket serverSocket = this.orb.getSocketFactory().createServerSocket(n2);
            listenerThread = (ListenerThread)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    ListenerThread listenerThread = new ListenerThread(connectionTable, serverSocket);
                    listenerThread.setDaemon(true);
                    return listenerThread;
                }
            });
            listenerThread.start();
        }
        catch (Exception exception) {
            throw new INTERNAL(1398079496, CompletionStatus.COMPLETED_NO);
        }
        return listenerThread;
    }

    public void deleteConnection(EndPoint endPoint) {
        try {
            this.table.deleteConn(endPoint);
        }
        catch (Exception exception) {}
    }

    public synchronized EndPoint getBootstrapEndpoint(int n2) {
        if (this.bootstrapEndpoint == null) {
            this.bootstrapEndpoint = this.getEndpoint(123, n2, null);
        }
        return this.bootstrapEndpoint;
    }

    public Connection getConnection(EndPoint endPoint) {
        return this.table.get(endPoint);
    }

    public synchronized EndPoint getDefaultEndpoint() {
        if (this.endPoints.size() == 0) {
            return null;
        }
        return (EndPoint)this.endPoints.elementAt(0);
    }

    public synchronized EndPoint getEndpoint(int n2, int n3, InetAddress inetAddress) {
        Object object;
        String string = null;
        if (inetAddress != null) {
            string = inetAddress.getHostName().toLowerCase();
        }
        Enumeration enumeration = this.endPoints.elements();
        while (enumeration.hasMoreElements()) {
            object = (EndPoint)enumeration.nextElement();
            if (object.getType() != n2 || object.getPort() != n3 || !object.getHostName().equals(string)) continue;
            return object;
        }
        if (n3 == 0 && this.orb.getORBServerPort() != 0) {
            n3 = this.orb.getORBServerPort();
        }
        this.listenerThread = this.createListener(n3);
        object = this.listenerThread.getSocket();
        this.listenerPort = ((ServerSocket)object).getLocalPort();
        EndPointImpl endPointImpl = new EndPointImpl(n2, this.listenerPort, this.orb.getORBServerHost());
        this.endPoints.addElement(endPointImpl);
        return endPointImpl;
    }

    protected synchronized int getNextRequestId() {
        return this.requestId++;
    }

    public RequestHandler getRequestHandler() {
        return this.handler;
    }

    public synchronized void initEndpoints() {
        if (this.endPoints.size() == 0) {
            this.getEndpoint(123, 0, null);
        }
    }

    public IOR locate(IOR iOR) {
        Profile profile = iOR.getProfile();
        byte[] byArray = profile.getObjectKey();
        Connection connection = this.table.get(iOR.getEndpoint());
        IOR iOR2 = connection.locate(this.getNextRequestId(), byArray);
        if (iOR2 == null) {
            iOR2 = iOR;
        }
        return iOR2;
    }

    public void setRequestHandler(RequestHandler requestHandler) {
        this.handler = requestHandler;
    }
}

