/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.internal.iiop;

import com.sun.corba.ee.internal.core.EndPoint;
import com.sun.corba.ee.internal.core.IOR;
import com.sun.corba.ee.internal.core.MarshalOutputStream;
import com.sun.corba.ee.internal.core.ServerGIOP;
import com.sun.corba.ee.internal.iiop.CachedWorkerThread;
import com.sun.corba.ee.internal.iiop.ClientResponseImpl;
import com.sun.corba.ee.internal.iiop.Connection;
import com.sun.corba.ee.internal.iiop.ConnectionTable;
import com.sun.corba.ee.internal.iiop.DeleteConn;
import com.sun.corba.ee.internal.iiop.IIOPInputStream;
import com.sun.corba.ee.internal.iiop.IIOPOutputStream;
import com.sun.corba.ee.internal.iiop.Message;
import com.sun.corba.ee.internal.iiop.ORB;
import com.sun.corba.ee.internal.iiop.OutCallDesc;
import com.sun.corba.ee.internal.iiop.ReaderThread;
import com.sun.corba.ee.internal.iiop.ReplyMessage;
import com.sun.corba.ee.internal.iiop.RequestMessage;
import com.sun.corba.ee.internal.iiop.ServerRequestImpl;
import com.sun.corba.ee.internal.io.FVDCodeBaseImpl;
import com.sun.corba.ee.internal.util.Condition;
import com.sun.corba.ee.internal.util.Lock;
import com.sun.org.omg.CORBA.ValueDefPackage.FullValueDescription;
import com.sun.org.omg.SendingContext.CodeBase;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Enumeration;
import java.util.Hashtable;
import org.omg.CORBA.COMM_FAILURE;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.INTERNAL;
import org.omg.CORBA.SystemException;

public final class IIOPConnection
extends Connection {
    private static final int OPENING = 1;
    private static final int ESTABLISHED = 2;
    private static final int CLOSE_SENT = 3;
    private static final int CLOSE_RECVD = 4;
    private static final int ABORT = 5;
    private Hashtable out_calls = new Hashtable();
    private String threadName;
    protected EndPoint endpoint;
    protected int requestCount = 0;
    private ServerGIOP server;
    private Hashtable implementations = null;
    private Hashtable fvds = null;
    private Hashtable bases = null;
    private CodeBase codeBaseRef;
    private boolean postInitialContexts = false;
    private IOR codeBaseServerIOR = null;
    Thread reader;
    int state;
    private Condition event;
    private Lock lock;
    private boolean writeLocked;
    InputStream inputStream;
    OutputStream outputStream;

    public IIOPConnection(ORB oRB, ServerGIOP serverGIOP, EndPoint endPoint, Socket socket, InputStream inputStream, OutputStream outputStream, ConnectionTable connectionTable) {
        this(oRB, serverGIOP, connectionTable, endPoint);
        this.socket = socket;
        this.inputStream = inputStream;
        this.outputStream = outputStream;
        this.connectionTable = connectionTable;
        this.isServer = true;
        this.state = 2;
        try {
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    IIOPConnection.this.reader.setDaemon(true);
                    return null;
                }
            });
        }
        catch (Exception exception) {}
        this.reader.start();
    }

    public IIOPConnection(ORB oRB, ServerGIOP serverGIOP, ConnectionTable connectionTable, EndPoint endPoint) {
        this.orb = oRB;
        this.server = serverGIOP;
        this.connectionTable = connectionTable;
        this.endpoint = endPoint;
        String string = this.endpoint.getHostName();
        int n2 = this.endpoint.getPort();
        this.threadName = "JavaIDL Reader for " + string + ":" + n2;
        final ThreadGroup threadGroup = oRB.threadGroup;
        final String string2 = this.threadName;
        IIOPConnection iIOPConnection = this;
        final boolean bl2 = oRB.transportDebugFlag;
        try {
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    reader = new ReaderThread(threadGroup, IIOPConnection.this, string2, bl2);
                    return null;
                }
            });
        }
        catch (SecurityException securityException) {
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    reader = new ReaderThread(IIOPConnection.this, string2, bl2);
                    return null;
                }
            });
        }
        this.state = 1;
        this.event = new Condition();
        this.lock = new Lock();
    }

    public void abortConnection() {
        this.lock.lock();
        this.state = 5;
        this.event.signalAll();
        this.lock.unlock();
    }

    public synchronized void cleanUp() throws Exception {
        this.writeLock();
        if (this.requestCount > 0 || this.out_calls.size() > 0) {
            this.writeUnlock();
            throw new Exception();
        }
        try {
            if (this.isServer) {
                this.sendCloseConnection();
                this.lock.lock();
                this.state = 3;
                this.lock.unlock();
            }
            Exception exception = new Exception();
            this.reader.stop(exception);
            this.purge_calls(2, false, true);
        }
        catch (Exception exception) {}
    }

    public IIOPInputStream createInputStream() throws Exception {
        byte[] byArray = new byte[1024];
        Message message = Message.createFromStream(this.orb, byArray, this.inputStream);
        switch (message.getType()) {
            case 0: {
                if (this.orb.transportDebugFlag) {
                    this.dprint("Handling GIOP request");
                }
                return new ServerRequestImpl((Connection)this, byArray, (RequestMessage)message);
            }
            case 1: {
                if (this.orb.transportDebugFlag) {
                    this.dprint("Handling GIOP reply");
                }
                return new ClientResponseImpl((Connection)this, byArray, (ReplyMessage)message);
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                if (this.orb.transportDebugFlag) {
                    this.dprint("Handling other GIOP message");
                }
                return new IIOPInputStream(this, byArray, message);
            }
        }
        if (this.orb.transportDebugFlag) {
            this.dprint("Unknown GIOP message");
        }
        throw new INTERNAL(1398079499, CompletionStatus.COMPLETED_NO);
    }

    public void delete() {
        this.delete(1);
    }

    void delete(int n2) {
        DeleteConn deleteConn = new DeleteConn(n2);
        this.reader.stop(deleteConn);
    }

    public String[] getBases(String string) {
        String[] stringArray = null;
        if (this.bases == null) {
            this.bases = new Hashtable();
        } else {
            stringArray = (String[])this.bases.get(string);
        }
        if (stringArray == null) {
            if (this.codeBaseRef == null) {
                this.codeBaseRef = FVDCodeBaseImpl.connect(this.orb, this.codeBaseServerIOR);
            }
            if ((stringArray = this.codeBaseRef.bases(string)) != null) {
                this.bases.put(string, stringArray);
            }
        }
        return stringArray;
    }

    public synchronized IOR getCodeBaseRef() {
        return this.codeBaseServerIOR;
    }

    public static IIOPConnection getCurrentReaderConnection() {
        try {
            CachedWorkerThread cfr_ignored_0 = (CachedWorkerThread)Thread.currentThread();
            return CachedWorkerThread.getCurrentConnection();
        }
        catch (ClassCastException classCastException) {
            return ((ReaderThread)Thread.currentThread()).getCurrentConnection();
        }
    }

    EndPoint getEndpoint() {
        return this.endpoint;
    }

    public FullValueDescription getFVD(String string) {
        FullValueDescription fullValueDescription = null;
        if (this.fvds == null) {
            this.fvds = new Hashtable();
        } else {
            fullValueDescription = (FullValueDescription)this.fvds.get(string);
        }
        if (fullValueDescription == null) {
            if (this.codeBaseRef == null) {
                this.codeBaseRef = FVDCodeBaseImpl.connect(this.orb, this.codeBaseServerIOR);
            }
            if ((fullValueDescription = this.codeBaseRef.meta(string)) != null) {
                this.fvds.put(string, fullValueDescription);
            }
        }
        return fullValueDescription;
    }

    String getHost() {
        return this.endpoint.getHostName();
    }

    public String getImplementation(String string) {
        String string2 = null;
        if (this.implementations == null) {
            this.implementations = new Hashtable();
        } else {
            string2 = (String)this.implementations.get(string);
        }
        if (string2 == null) {
            if (this.codeBaseRef == null) {
                this.codeBaseRef = FVDCodeBaseImpl.connect(this.orb, this.codeBaseServerIOR);
            }
            if ((string2 = this.codeBaseRef.implementation(string)) != null) {
                this.implementations.put(string, string2);
            }
        }
        return string2;
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }

    int getPort() {
        return this.endpoint.getPort();
    }

    public ServerGIOP getServerGIOP() {
        return this.server;
    }

    private String getStateString(int n2) {
        switch (n2) {
            case 1: {
                return "OPENING";
            }
            case 2: {
                return "ESTABLISHED";
            }
            case 3: {
                return "CLOSE_SENT";
            }
            case 4: {
                return "CLOSE_RECVD";
            }
            case 5: {
                return "ABORT";
            }
        }
        return "???";
    }

    public IIOPInputStream invoke(IIOPOutputStream iIOPOutputStream) throws SystemException {
        return this.send(iIOPOutputStream, false);
    }

    public boolean isBusy() {
        return this.requestCount > 0 || this.out_calls.size() > 0;
    }

    public synchronized boolean isPostInitialContexts() {
        return this.postInitialContexts;
    }

    public void print() {
        System.out.println("Connection for " + this.endpoint.getHostName() + " @ " + this.endpoint.getPort());
        System.out.println("    Time stamp = " + this.timeStamp);
        boolean bl2 = this.reader.isAlive();
        if (bl2) {
            System.out.println(" Reader is Alive");
        } else {
            System.out.println(" Reader is not Alive");
        }
    }

    void processInput(IIOPInputStream iIOPInputStream) throws DeleteConn {
        int n2 = iIOPInputStream.getMessage().getType();
        switch (n2) {
            case 0: 
            case 3: {
                if (this.orb.transportDebugFlag) {
                    this.dprint("Connection:processInput: got incoming request");
                }
                CachedWorkerThread.addWorkToDo(this.server.getRequestHandler(), this, iIOPInputStream);
                break;
            }
            case 1: 
            case 4: {
                if (this.orb.transportDebugFlag) {
                    this.dprint("Connection:processInput: got RESPONSE");
                }
                Integer n3 = new Integer(iIOPInputStream.getMessage().getRequestId());
                OutCallDesc outCallDesc = (OutCallDesc)this.out_calls.get(n3);
                this.out_calls.remove(n3);
                this.lock.lock();
                outCallDesc.s = iIOPInputStream;
                outCallDesc.done.signal();
                this.lock.unlock();
                break;
            }
            case 2: {
                if (!this.orb.transportDebugFlag) break;
                this.dprint("Connection:processInput: got cancel");
                break;
            }
            case 5: {
                if (this.orb.transportDebugFlag) {
                    this.dprint("Connection.processInput: got CloseConn, purging");
                }
                this.purge_calls(2, true, false);
                break;
            }
            default: {
                if (this.orb.transportDebugFlag) {
                    this.dprint("Connection: bad message type " + String.valueOf(n2));
                }
                this.purge_calls(1, true, false);
            }
        }
    }

    void purge_calls(int n2, boolean bl2, boolean bl3) {
        CompletionStatus completionStatus;
        block12: {
            if (this.orb.transportDebugFlag) {
                this.dprint("purge_calls: starting: code = " + n2 + " die = " + bl2);
            }
            if (this.state == 5 || this.state == 4) {
                if (this.orb.transportDebugFlag) {
                    this.dprint("purge_calls: exiting duplicate invocation");
                }
                return;
            }
            try {
                if (!bl3) {
                    this.writeLock();
                }
            }
            catch (SystemException systemException) {
                if (!this.orb.transportDebugFlag) break block12;
                this.dprint("purge_calls: caught exception " + systemException + "; continuing");
            }
        }
        this.lock.lock();
        if (n2 == 2) {
            this.state = 4;
            completionStatus = CompletionStatus.COMPLETED_NO;
        } else {
            this.state = 5;
            completionStatus = CompletionStatus.COMPLETED_MAYBE;
        }
        this.lock.unlock();
        try {
            this.inputStream.close();
            this.outputStream.close();
            this.socket.close();
        }
        catch (Exception exception) {}
        COMM_FAILURE cOMM_FAILURE = new COMM_FAILURE(n2, completionStatus);
        Enumeration enumeration = this.out_calls.elements();
        while (enumeration.hasMoreElements()) {
            OutCallDesc outCallDesc = (OutCallDesc)enumeration.nextElement();
            this.lock.lock();
            outCallDesc.exc = cOMM_FAILURE;
            outCallDesc.done.signal();
            this.lock.unlock();
        }
        this.out_calls.clear();
        this.connectionTable.deleteConn(this.endpoint);
        this.writeUnlock();
        if (bl2) {
            Thread.currentThread().stop();
        }
    }

    public synchronized void requestBegins() {
        ++this.requestCount;
    }

    public synchronized void requestEnds() {
        --this.requestCount;
    }

    public IIOPInputStream send(IIOPOutputStream iIOPOutputStream, boolean bl2) {
        OutCallDesc outCallDesc;
        boolean bl3;
        block9: {
            bl3 = false;
            outCallDesc = new OutCallDesc();
            outCallDesc.thd = Thread.currentThread();
            int n2 = iIOPOutputStream.getMessage().getRequestId();
            try {
                this.writeLock();
                bl3 = true;
                this.out_calls.put(new Integer(n2), outCallDesc);
                try {
                    iIOPOutputStream.writeTo(this.outputStream);
                    this.outputStream.flush();
                }
                catch (IOException iOException) {
                    throw new COMM_FAILURE(0x53550003, CompletionStatus.COMPLETED_NO);
                }
                this.writeUnlock();
                bl3 = false;
                if (bl2) {
                    IIOPInputStream iIOPInputStream = null;
                    Object var8_7 = null;
                    if (bl3) {
                        this.writeUnlock();
                    }
                    return iIOPInputStream;
                }
                this.lock.lock();
                while (outCallDesc.s == null && outCallDesc.exc == null) {
                    outCallDesc.done.wait(this.lock);
                }
                this.lock.unlock();
                if (outCallDesc.exc == null) break block9;
                throw outCallDesc.exc;
            }
            catch (Throwable throwable) {
                Object var8_9 = null;
                if (bl3) {
                    this.writeUnlock();
                }
                throw throwable;
            }
        }
        Object var8_8 = null;
        if (bl3) {
            this.writeUnlock();
        }
        return outCallDesc.s;
    }

    private void sendCloseConnection() {
        Message message = new Message(this.orb.transportDebugFlag);
        message.setType(5);
        IIOPOutputStream iIOPOutputStream = this.orb.newOutputStream(this);
        message.write(iIOPOutputStream);
        iIOPOutputStream.setMessage(message);
        try {
            iIOPOutputStream.writeTo(this.outputStream);
            this.outputStream.flush();
        }
        catch (IOException iOException) {}
    }

    public void sendReply(MarshalOutputStream marshalOutputStream) throws Exception {
        block2: {
            boolean bl2 = false;
            try {
                this.writeLock();
                bl2 = true;
                marshalOutputStream.writeTo(this.outputStream);
                this.outputStream.flush();
                this.writeUnlock();
                bl2 = false;
            }
            catch (Exception exception) {
                if (!bl2) break block2;
                this.writeUnlock();
            }
        }
    }

    public synchronized void setCodeBaseRef(IOR iOR) {
        this.codeBaseServerIOR = iOR;
    }

    public void setConnection(Socket socket, ConnectionTable connectionTable) throws Exception {
        this.socket = socket;
        this.inputStream = this.socket.getInputStream();
        this.outputStream = this.socket.getOutputStream();
        this.connectionTable = connectionTable;
        this.lock.lock();
        this.state = 2;
        this.event.signalAll();
        try {
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    IIOPConnection.this.reader.setDaemon(true);
                    return null;
                }
            });
        }
        catch (Exception exception) {}
        this.reader.start();
        this.lock.unlock();
    }

    public synchronized void setPostInitialContexts() {
        this.postInitialContexts = true;
    }

    public String toString() {
        return "Connection[remote_host=" + this.endpoint.getHostName() + " remote_port=" + this.endpoint.getPort() + " state=" + this.getStateString(this.state) + "]";
    }

    private boolean writeLock() {
        this.lock.lock();
        block5: while (true) {
            switch (this.state) {
                case 1: {
                    this.event.wait(this.lock);
                    continue block5;
                }
                case 2: {
                    if (!this.writeLocked) {
                        this.writeLocked = true;
                        this.lock.unlock();
                        return true;
                    }
                    this.event.wait(this.lock);
                    continue block5;
                }
                case 4: 
                case 5: {
                    this.lock.unlock();
                    throw new COMM_FAILURE(1398079490, CompletionStatus.COMPLETED_NO);
                }
            }
            break;
        }
        if (this.orb.transportDebugFlag) {
            this.dprint("Connection:writeLock: weird state");
        }
        this.lock.unlock();
        this.delete(1);
        return false;
    }

    private void writeUnlock() {
        this.lock.lock();
        this.writeLocked = false;
        this.event.signalAll();
        this.lock.unlock();
    }
}

