/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.internal.util;

import com.sun.corba.ee.internal.io.IIOPInputStream;
import com.sun.corba.ee.internal.io.IIOPOutputStream;
import com.sun.corba.ee.internal.io.LibraryManager;
import com.sun.corba.ee.internal.util.CreateIIOPInputStream;
import com.sun.corba.ee.internal.util.CreateIIOPOutputStream;
import com.sun.corba.ee.internal.util.JDKClassLoader;
import java.io.ObjectStreamClass;
import java.io.ObjectStreamField;
import java.net.MalformedURLException;
import java.rmi.NoSuchObjectException;
import java.rmi.Remote;
import java.rmi.server.RMIClassLoader;
import java.rmi.server.RemoteObject;
import java.rmi.server.UnicastRemoteObject;
import java.security.AccessController;
import java.util.Hashtable;
import sun.security.action.GetPropertyAction;

public class JDKBridge {
    private static final String LOCAL_CODEBASE_KEY = "java.rmi.server.codebase";
    private static final String USE_CODEBASE_ONLY_KEY = "java.rmi.server.useCodebaseOnly";
    private static String localCodebase = null;
    private static boolean useCodebaseOnly;
    private static final boolean isJDK12 = true;
    private static boolean libraryLoaded;

    static {
        libraryLoaded = false;
        JDKBridge.setCodebaseProperties();
    }

    public static IIOPInputStream createInputStream() {
        IIOPInputStream iIOPInputStream = (IIOPInputStream)AccessController.doPrivileged(new CreateIIOPInputStream());
        iIOPInputStream.useOldNativeInterface = false;
        return iIOPInputStream;
    }

    public static IIOPOutputStream createOutputStream() {
        IIOPOutputStream iIOPOutputStream = (IIOPOutputStream)AccessController.doPrivileged(new CreateIIOPOutputStream());
        iIOPOutputStream.useOldNativeInterface = false;
        return iIOPOutputStream;
    }

    public static String getCodebase(Class clazz) {
        return RMIClassLoader.getClassAnnotation(clazz);
    }

    public static Remote getJRMPStub(Remote remote) throws NoSuchObjectException {
        return RemoteObject.toStub(remote);
    }

    public static String getLocalCodebase() {
        return localCodebase;
    }

    public static Hashtable getPersistentFields(Class clazz) {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        ObjectStreamClass objectStreamClass = ObjectStreamClass.lookup(clazz);
        if (objectStreamClass != null) {
            ObjectStreamField[] objectStreamFieldArray = objectStreamClass.getFields();
            int n2 = 0;
            while (n2 < objectStreamFieldArray.length) {
                String string;
                String string2 = String.valueOf(objectStreamFieldArray[n2].getTypeCode());
                if (objectStreamFieldArray[n2].isPrimitive()) {
                    string = string2;
                } else {
                    if (objectStreamFieldArray[n2].getTypeCode() == '[') {
                        string2 = "";
                    }
                    if ((string = String.valueOf(string2) + objectStreamFieldArray[n2].getType().getName().replace('.', '/')).endsWith(";")) {
                        string = string.substring(0, string.length() - 1);
                    }
                }
                hashtable.put(objectStreamFieldArray[n2].getName(), string);
                ++n2;
            }
        }
        return hashtable;
    }

    public static boolean is12VM() {
        return true;
    }

    public static boolean isPre118() {
        return false;
    }

    public static boolean isPre12VM() {
        return false;
    }

    public static Class loadClass(String string) throws ClassNotFoundException {
        return JDKBridge.loadClass(string, null, null);
    }

    public static Class loadClass(String string, String string2) throws ClassNotFoundException {
        return JDKBridge.loadClass(string, string2, null);
    }

    public static Class loadClass(String string, String string2, ClassLoader classLoader) throws ClassNotFoundException {
        if (!libraryLoaded) {
            LibraryManager.load();
            libraryLoaded = true;
        }
        if (classLoader == null) {
            return JDKBridge.loadClassM(string, string2, useCodebaseOnly);
        }
        try {
            return JDKBridge.loadClassM(string, string2, useCodebaseOnly);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return classLoader.loadClass(string);
        }
    }

    private static Class loadClassM(String string, String string2, boolean bl2) throws ClassNotFoundException {
        try {
            return JDKClassLoader.loadClass(null, string, true);
        }
        catch (ClassNotFoundException classNotFoundException) {
            try {
                if (!bl2 && string2 != null) {
                    return RMIClassLoader.loadClass(string2, string);
                }
                return RMIClassLoader.loadClass(string);
            }
            catch (MalformedURLException malformedURLException) {
                string = String.valueOf(string) + ": " + malformedURLException.toString();
                throw new ClassNotFoundException(string);
            }
        }
    }

    public static final void main(String[] stringArray) {
        System.out.println("1.2 VM");
    }

    public static synchronized void setCodebaseProperties() {
        String string = AccessController.doPrivileged(new GetPropertyAction(LOCAL_CODEBASE_KEY));
        if (string != null && string.trim().length() > 0) {
            localCodebase = string;
        }
        if ((string = AccessController.doPrivileged(new GetPropertyAction(USE_CODEBASE_ONLY_KEY))) != null && string.trim().length() > 0) {
            useCodebaseOnly = Boolean.valueOf(string);
        }
    }

    public static synchronized void setLocalCodebase(String string) {
        localCodebase = string;
    }

    public static void unexportJRMP(Remote remote) throws NoSuchObjectException {
        UnicastRemoteObject.unexportObject(remote, true);
    }

    public static boolean useCodebaseOnly() {
        return useCodebaseOnly;
    }
}

