/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.internal.util;

import com.sun.corba.ee.internal.util.Element;
import com.sun.corba.ee.internal.util.Utility;

public final class TransientObjectManager {
    private int maxSize = 128;
    private Element[] elementArray = new Element[this.maxSize];
    private Element freeList;

    public TransientObjectManager() {
        this.elementArray[this.maxSize - 1] = new Element(this.maxSize - 1, null);
        int n2 = this.maxSize - 2;
        while (n2 >= 0) {
            this.elementArray[n2] = new Element(n2, this.elementArray[n2 + 1]);
            --n2;
        }
        this.freeList = this.elementArray[0];
    }

    public synchronized void deleteServant(byte[] byArray) {
        int n2 = Utility.bytesToInt(byArray, 0);
        this.elementArray[n2].delete(this.freeList);
    }

    private void doubleSize() {
        Element[] elementArray = this.elementArray;
        int n2 = this.maxSize;
        this.maxSize *= 2;
        this.elementArray = new Element[this.maxSize];
        int n3 = 0;
        while (n3 < n2) {
            this.elementArray[n3] = elementArray[n3];
            ++n3;
        }
        this.elementArray[this.maxSize - 1] = new Element(this.maxSize - 1, null);
        int n4 = this.maxSize - 2;
        while (n4 >= n2) {
            this.elementArray[n4] = new Element(n4, this.elementArray[n4 + 1]);
            --n4;
        }
        this.freeList = this.elementArray[n2];
    }

    public synchronized byte[] getKey(Object object) {
        int n2 = 0;
        while (n2 < this.maxSize) {
            if (this.elementArray[n2].valid && this.elementArray[n2].servant == object) {
                return this.elementArray[n2].toBytes();
            }
            ++n2;
        }
        return null;
    }

    public synchronized Object lookupServant(byte[] byArray) {
        int n2 = Utility.bytesToInt(byArray, 0);
        int n3 = Utility.bytesToInt(byArray, 4);
        if (this.elementArray[n2].counter == n3 && this.elementArray[n2].valid) {
            return this.elementArray[n2].servant;
        }
        return null;
    }

    public synchronized Object lookupServantData(byte[] byArray) {
        int n2 = Utility.bytesToInt(byArray, 0);
        int n3 = Utility.bytesToInt(byArray, 4);
        if (this.elementArray[n2].counter == n3 && this.elementArray[n2].valid) {
            return this.elementArray[n2].servantData;
        }
        return null;
    }

    public synchronized byte[] storeServant(Object object, Object object2) {
        if (this.freeList == null) {
            this.doubleSize();
        }
        Element element = this.freeList;
        this.freeList = (Element)this.freeList.servant;
        return element.getKey(object, object2);
    }
}

