/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ejb.containers;

import com.sun.ejb.ComponentContext;
import com.sun.ejb.Container;
import com.sun.ejb.Invocation;
import com.sun.ejb.containers.EJBContextImpl;
import com.sun.ejb.containers.EJBMetaDataImpl;
import com.sun.ejb.containers.EJBObjectInputStream;
import com.sun.ejb.containers.EJBObjectOutputStream;
import com.sun.ejb.containers.PreInvokeException;
import com.sun.ejb.containers.SafeProperties;
import com.sun.ejb.containers.SessionContextImpl;
import com.sun.ejb.containers.SyncImpl;
import com.sun.enterprise.ComponentInvocation;
import com.sun.enterprise.InvocationManager;
import com.sun.enterprise.J2EETransactionManager;
import com.sun.enterprise.NamingManager;
import com.sun.enterprise.ProtocolManager;
import com.sun.enterprise.SecurityManager;
import com.sun.enterprise.Switch;
import com.sun.enterprise.deployment.ContainerTransaction;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.EjbEntityDescriptor;
import com.sun.enterprise.deployment.EjbSessionDescriptor;
import com.sun.enterprise.log.Log;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.Method;
import java.rmi.NoSuchObjectException;
import java.rmi.RemoteException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Set;
import javax.ejb.CreateException;
import javax.ejb.EJBHome;
import javax.ejb.EJBMetaData;
import javax.ejb.EJBObject;
import javax.ejb.EnterpriseBean;
import javax.ejb.FinderException;
import javax.ejb.NoSuchEntityException;
import javax.ejb.RemoveException;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.rmi.PortableRemoteObject;
import javax.transaction.InvalidTransactionException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionRequiredException;
import javax.transaction.TransactionRolledbackException;
import javax.transaction.UserTransaction;

public abstract class BaseContainer
implements Container {
    public static final byte EJBHOME_MARKER = -1;
    protected static final boolean debug = false;
    protected static final int TX_NOT_SUPPORTED = 0;
    protected static final int TX_BEAN_MANAGED = 1;
    protected static final int TX_REQUIRED = 2;
    protected static final int TX_SUPPORTS = 3;
    protected static final int TX_REQUIRES_NEW = 4;
    protected static final int TX_MANDATORY = 5;
    protected static final int TX_NEVER = 6;
    protected int contId = -1;
    protected ClassLoader loader = null;
    protected Class ejbClass = null;
    protected Class ejbObjectClass = null;
    protected Class remoteClass = null;
    protected Class homeIntf = null;
    protected Method ejbPassivateMethod = null;
    protected Method ejbActivateMethod = null;
    protected EJBMetaData metadata = null;
    protected ProtocolManager protocolMgr = null;
    protected EJBHome ejbHome;
    protected EJBHome ejbHomeStub;
    protected J2EETransactionManager transactionManager;
    protected InvocationManager invocationManager;
    protected NamingManager namingManager;
    protected UserTransaction userTx;
    protected Switch theSwitch;
    protected boolean isSession;
    protected boolean isStatelessSession;
    protected EjbDescriptor ejbDescriptor;
    protected Hashtable methodTable;
    protected SecurityManager securityManager;
    protected Properties envProps;
    boolean isBeanManagedTran = false;
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(class$com$sun$ejb$containers$BaseContainer != null ? class$com$sun$ejb$containers$BaseContainer : (class$com$sun$ejb$containers$BaseContainer = BaseContainer.class$("com.sun.ejb.containers.BaseContainer")));
    static /* synthetic */ Class class$com$sun$ejb$containers$BaseContainer;
    static /* synthetic */ Class class$javax$ejb$EJBObject;

    /*
     * WARNING - void declaration
     */
    protected BaseContainer(EjbDescriptor ejbDesc, ClassLoader loader) throws Exception {
        try {
            this.loader = loader;
            this.ejbDescriptor = ejbDesc;
            this.theSwitch = Switch.getSwitch();
            this.protocolMgr = this.theSwitch.getProtocolManager();
            this.transactionManager = this.theSwitch.getTransactionManager();
            this.invocationManager = this.theSwitch.getInvocationManager();
            this.namingManager = this.theSwitch.getNamingManager();
            this.userTx = (UserTransaction)new InitialContext().lookup("java:comp/UserTransaction");
            this.theSwitch.setDescriptorFor(this, this.ejbDescriptor);
            this.ejbClass = loader.loadClass(this.ejbDescriptor.getEjbClassName());
            String ejbObjectName = String.valueOf(this.ejbClass.getName()) + "_EJBObjectImpl";
            this.ejbObjectClass = loader.loadClass(ejbObjectName);
            this.homeIntf = loader.loadClass(this.ejbDescriptor.getHomeClassName());
            this.remoteClass = loader.loadClass(this.ejbDescriptor.getRemoteClassName());
            this.ejbPassivateMethod = this.ejbClass.getMethod("ejbPassivate", null);
            this.ejbActivateMethod = this.ejbClass.getMethod("ejbActivate", null);
            if (this.ejbDescriptor.getType().equals(EjbEntityDescriptor.TYPE)) {
                this.isSession = false;
            } else {
                this.isSession = true;
                EjbSessionDescriptor sd = (EjbSessionDescriptor)this.ejbDescriptor;
                this.isStatelessSession = sd.isStateless();
                this.isBeanManagedTran = sd.getTransactionType().equals("Bean");
            }
            this.initializeMethodTable();
            this.setupEnvironment();
        }
        catch (Exception ex2) {
            void ejbObjectName;
            Log.err.println(ex2);
            throw ejbObjectName;
        }
    }

    public abstract void activateEJB(Object var1, Object var2) throws RemoteException;

    abstract void afterBegin(EJBContextImpl var1) throws RemoteException;

    abstract void afterCompletion(EJBContextImpl var1, int var2);

    abstract void beforeCompletion(EJBContextImpl var1) throws RemoteException;

    private Throwable checkExceptionBeanMgTx(EJBContextImpl context, Throwable exception, int status) throws Exception {
        Throwable newException = exception;
        if (exception != null && exception instanceof PreInvokeException) {
            newException = ((PreInvokeException)exception).exception;
        } else if (status == 6) {
            newException = this.checkExceptionNoTx(context, exception);
        } else if (this.isSession && !this.isStatelessSession) {
            if (!this.isSystemUncheckedException(exception)) {
                this.transactionManager.suspend();
            } else {
                try {
                    this.forceDestroyBean(context);
                }
                finally {
                    Object var6_5 = null;
                    this.transactionManager.rollback();
                }
                newException = this.processSystemException(exception);
            }
        } else {
            try {
                this.forceDestroyBean(context);
            }
            finally {
                Object var6_7 = null;
                this.transactionManager.rollback();
            }
            newException = new RemoteException("Stateless SessionBean method returned without completing transaction");
            Log.err.println(newException);
        }
        return newException;
    }

    private Throwable checkExceptionClientTx(EJBContextImpl context, Throwable exception) throws Exception {
        if (exception instanceof PreInvokeException) {
            return ((PreInvokeException)exception).exception;
        }
        Throwable newException = exception;
        if (this.isSystemUncheckedException(exception)) {
            try {
                this.forceDestroyBean(context);
            }
            finally {
                Object var5_4 = null;
                this.transactionManager.setRollbackOnly();
            }
            newException = new TransactionRolledbackException();
        }
        return newException;
    }

    private Throwable checkExceptionNoTx(EJBContextImpl context, Throwable exception) throws Exception {
        if (exception instanceof PreInvokeException) {
            return ((PreInvokeException)exception).exception;
        }
        Throwable newException = exception;
        if (this.isSystemUncheckedException(exception)) {
            newException = this.processSystemException(exception);
            this.forceDestroyBean(context);
        }
        return newException;
    }

    private void checkUnfinishedTx(Transaction prevTx, Invocation inv) throws RemoteException {
        try {
            if (!this.isStatelessSession && prevTx != null && prevTx.getStatus() != 6) {
                throw new InvalidTransactionException();
            }
        }
        catch (SystemException ex2) {
            throw new RemoteException("", ex2);
        }
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    private Throwable completeNewTx(EJBContextImpl context, Throwable exception) throws Exception {
        Throwable newException;
        block13: {
            newException = exception;
            if (exception instanceof PreInvokeException) {
                newException = ((PreInvokeException)exception).exception;
            }
            if (context.getTransaction() == null) {
                return newException;
            }
            if (this.isSession && !this.isStatelessSession) {
                ((SessionContextImpl)context).setTxCompleting(true);
            }
            if (newException != null && this.isSystemUncheckedException(newException)) {
                try {
                    this.forceDestroyBean(context);
                }
                finally {
                    Object var5_4 = null;
                    this.transactionManager.rollback();
                }
                newException = this.processSystemException(newException);
            } else {
                try {
                    int status = this.transactionManager.getStatus();
                    if (status == 1) {
                        this.transactionManager.rollback();
                        break block13;
                    }
                    this.transactionManager.commit();
                }
                catch (RollbackException ex2) {
                    newException = new RemoteException("Transaction aborted (possibly due to transaction time out).", ex2);
                }
                catch (Exception ex3) {
                    newException = new RemoteException("Unable to complete container-managed transaction.", ex3);
                }
            }
        }
        return newException;
    }

    protected abstract EJBObject createEJBObject() throws RemoteException, CreateException;

    public final Object deserializeObject(byte[] data) throws Exception {
        if (data == null) {
            return null;
        }
        final ByteArrayInputStream bis = new ByteArrayInputStream(data);
        ObjectInputStream ois = null;
        try {
            ois = (ObjectInputStream)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    return new EJBObjectInputStream(bis, loader);
                }
            });
        }
        catch (PrivilegedActionException ex2) {
            throw (IOException)ex2.getException();
        }
        return ois.readObject();
    }

    public final void doAfterBegin(ComponentInvocation ci2) throws RemoteException {
        Invocation inv = (Invocation)ci2;
        try {
            EJBContextImpl sc = (EJBContextImpl)inv.context;
            Transaction tx = this.transactionManager.getTransaction();
            sc.setTransaction(tx);
            this.transactionManager.registerSynchronization(new SyncImpl(sc, tx));
        }
        catch (SystemException ex2) {
            throw new RemoteException("", ex2);
        }
        catch (RollbackException ex3) {
            throw new RemoteException("", ex3);
        }
        catch (IllegalStateException ex4) {
            throw new RemoteException("", ex4);
        }
    }

    private int findTxAttr(Method method) throws RemoteException {
        int txAttr = -1;
        if (this.isBeanManagedTran) {
            return 1;
        }
        ContainerTransaction ct2 = this.ejbDescriptor.getContainerTransactionFor(method);
        if (ct2 != null) {
            String attr = ct2.getTransactionAttribute();
            if (attr.equals(ContainerTransaction.NOT_SUPPORTED)) {
                txAttr = 0;
            } else if (attr.equals(ContainerTransaction.SUPPORTS)) {
                txAttr = 3;
            } else if (attr.equals(ContainerTransaction.REQUIRED)) {
                txAttr = 2;
            } else if (attr.equals(ContainerTransaction.REQUIRES_NEW)) {
                txAttr = 4;
            } else if (attr.equals(ContainerTransaction.MANDATORY)) {
                txAttr = 5;
            } else if (attr.equals(ContainerTransaction.NEVER)) {
                txAttr = 6;
            }
        }
        if (txAttr == -1) {
            throw new RemoteException("Transaction Attribute not found for method " + method);
        }
        return txAttr;
    }

    abstract void forceDestroyBean(EJBContextImpl var1) throws RemoteException;

    public final ClassLoader getClassLoader() {
        return this.loader;
    }

    public final int getContainerId() {
        return this.contId;
    }

    protected abstract ComponentContext getContext(Invocation var1) throws RemoteException;

    public final EJBHome getEJBHome() {
        return this.ejbHome;
    }

    public final EJBHome getEJBHomeStub() {
        return this.ejbHomeStub;
    }

    public final EJBMetaData getEJBMetaData() {
        return this.metadata;
    }

    public abstract EJBObject getEJBObject(byte[] var1) throws RemoteException;

    public final EjbDescriptor getEjbDescriptor() {
        return this.ejbDescriptor;
    }

    final Properties getEnvironmentProperties() {
        return this.envProps;
    }

    public final SecurityManager getSecurityManager() {
        return this.securityManager;
    }

    final int getTxAttr(Method method) throws RemoteException {
        Integer i2 = (Integer)this.methodTable.get(method);
        if (i2 != null) {
            return i2;
        }
        throw new RemoteException("Transaction Attribute not found for method " + method);
    }

    final UserTransaction getUserTransaction() {
        if (this.isSession && this.isBeanManagedTran) {
            return this.userTx;
        }
        throw new IllegalStateException("ERROR: only SessionBeans with bean-managed transactions can obtain UserTransaction");
    }

    private void initializeMethodTable() throws Exception {
        this.methodTable = new Hashtable();
        Method[] methods = this.remoteClass.getMethods();
        Integer attr = null;
        int i2 = 0;
        while (i2 < methods.length) {
            Method method = methods[i2];
            attr = new Integer(this.findTxAttr(method));
            this.methodTable.put(method, attr);
            ++i2;
        }
        methods = this.homeIntf.getMethods();
        int i3 = 0;
        while (i3 < methods.length) {
            Method method = methods[i3];
            String name = method.getName();
            if (name.equals("create") || name.equals("remove") || name.startsWith("find")) {
                attr = new Integer(this.findTxAttr(method));
                this.methodTable.put(method, attr);
            }
            ++i3;
        }
    }

    final boolean isBeanManagedTx() {
        return this.isBeanManagedTran;
    }

    final boolean isBusinessMethod(Method method) {
        Class<?> methodClass = method.getDeclaringClass();
        return methodClass != this.homeIntf && methodClass != (class$javax$ejb$EJBObject != null ? class$javax$ejb$EJBObject : (class$javax$ejb$EJBObject = BaseContainer.class$("javax.ejb.EJBObject")));
    }

    private boolean isSystemUncheckedException(Throwable exception) {
        return exception != null && (exception instanceof RuntimeException || exception instanceof Error || exception instanceof RemoteException);
    }

    public abstract boolean passivateEJB(ComponentContext var1);

    public void postCreate(Invocation inv, Object primaryKey) throws RemoteException, CreateException {
        throw new RemoteException("Internal error");
    }

    public Object postFind(Invocation inv, Object primaryKeys, Object[] findParams) throws RemoteException, FinderException {
        throw new RemoteException("Internal error");
    }

    public final void postInvoke(Invocation inv) throws RemoteException {
        if (inv.exception != null && !(inv.exception instanceof PreInvokeException)) {
            Log.err.println(inv.exception);
        }
        if (inv.ejb != null) {
            this.invocationManager.postInvoke(inv);
            try {
                this.postInvokeTx(inv);
            }
            catch (Throwable ex2) {
                inv.exception = ex2 instanceof RemoteException ? (RemoteException)ex2 : new RemoteException("Unknown error: ", ex2);
            }
            this.releaseContext(inv);
        }
        if (inv.exception != null) {
            if (inv.exception instanceof PreInvokeException) {
                inv.exception = ((PreInvokeException)inv.exception).exception;
            }
            inv.exception = this.protocolMgr.mapException(inv.exception);
            if (this.isSystemUncheckedException(inv.exception)) {
                Log.err.println(inv.exception);
            }
        }
    }

    public final void postInvokeTx(Invocation inv) throws RemoteException {
        Method method = inv.method;
        Throwable exception = inv.exception;
        if (this.isSession && !this.isBusinessMethod(method)) {
            if (inv.clientTx != null) {
                try {
                    this.transactionManager.resume(inv.clientTx);
                }
                catch (Exception ex2) {
                    throw new RemoteException("", ex2);
                }
            }
            if (exception != null && exception instanceof PreInvokeException) {
                inv.exception = ((PreInvokeException)exception).exception;
            }
            return;
        }
        EJBContextImpl context = (EJBContextImpl)inv.context;
        try {
            int status = this.transactionManager.getStatus();
            int txAttr = this.getTxAttr(method);
            EnterpriseBean ejb = context.getEJB();
            Throwable newException = exception;
            switch (txAttr) {
                case 1: {
                    newException = this.checkExceptionBeanMgTx(context, exception, status);
                    if (inv.clientTx == null) break;
                    this.transactionManager.resume(inv.clientTx);
                    break;
                }
                case 0: 
                case 6: {
                    newException = this.checkExceptionNoTx(context, exception);
                    if (inv.clientTx == null) break;
                    this.transactionManager.resume(inv.clientTx);
                    break;
                }
                case 5: {
                    newException = this.checkExceptionClientTx(context, exception);
                    break;
                }
                case 2: {
                    if (inv.clientTx == null) {
                        newException = this.completeNewTx(context, exception);
                        break;
                    }
                    newException = this.checkExceptionClientTx(context, exception);
                    break;
                }
                case 4: {
                    newException = this.completeNewTx(context, exception);
                    if (inv.clientTx == null) break;
                    this.transactionManager.resume(inv.clientTx);
                    break;
                }
                case 3: {
                    if (status != 6) {
                        newException = this.checkExceptionClientTx(context, exception);
                        break;
                    }
                    newException = this.checkExceptionNoTx(context, exception);
                    break;
                }
            }
            inv.exception = newException;
        }
        catch (Exception ex3) {
            Log.err.println(ex3);
            throw new RemoteException("Unknown exception: ", ex3);
        }
    }

    public final void preInvoke(Invocation inv) throws RemoteException {
        try {
            ComponentContext ctx;
            if (!this.securityManager.authorize(inv)) {
                throw new RemoteException("Client not authorized for this invocation.");
            }
            inv.context = ctx = this.getContext(inv);
            inv.ejb = ctx.getEJB();
            inv.instance = inv.ejb;
            inv.container = this;
            this.invocationManager.preInvoke(inv);
            this.preInvokeTx(inv);
        }
        catch (Throwable ex2) {
            Log.err.println(ex2);
            RemoteException rex = ex2 instanceof RemoteException ? (RemoteException)ex2 : new RemoteException("Unknown exception: ", ex2);
            throw new PreInvokeException(rex);
        }
    }

    public final void preInvokeTx(Invocation inv) throws RemoteException {
        Method method = inv.method;
        int status = 5;
        try {
            status = this.transactionManager.getStatus();
        }
        catch (SystemException ex2) {
            throw new RemoteException("", ex2);
        }
        if (this.isSession && !this.isBusinessMethod(method)) {
            if (status != 6) {
                try {
                    inv.clientTx = this.transactionManager.suspend();
                }
                catch (SystemException ex3) {
                    throw new RemoteException("", ex3);
                }
            }
            return;
        }
        int txAttr = this.getTxAttr(method);
        EJBContextImpl context = (EJBContextImpl)inv.context;
        EnterpriseBean ejb = context.getEJB();
        try {
            Transaction prevTx = context.getTransaction();
            switch (txAttr) {
                case 1: {
                    if (status != 6) {
                        inv.clientTx = this.transactionManager.suspend();
                    }
                    if (!this.isStatelessSession && prevTx != null && prevTx.getStatus() != 6) {
                        this.transactionManager.resume(prevTx);
                        this.transactionManager.enlistComponentResources();
                    }
                    break;
                }
                case 0: {
                    if (status != 6) {
                        inv.clientTx = this.transactionManager.suspend();
                    }
                    this.checkUnfinishedTx(prevTx, inv);
                    break;
                }
                case 5: {
                    if (status == 6) {
                        throw new TransactionRequiredException();
                    }
                    this.useClientTx(prevTx, inv);
                    break;
                }
                case 2: {
                    if (status == 6) {
                        inv.clientTx = null;
                        this.startNewTx(prevTx, inv);
                    } else {
                        inv.clientTx = this.transactionManager.getTransaction();
                        this.useClientTx(prevTx, inv);
                    }
                    break;
                }
                case 4: {
                    if (status != 6) {
                        inv.clientTx = this.transactionManager.suspend();
                    }
                    this.startNewTx(prevTx, inv);
                    break;
                }
                case 3: {
                    if (status != 6) {
                        this.useClientTx(prevTx, inv);
                    } else {
                        this.checkUnfinishedTx(prevTx, inv);
                    }
                    break;
                }
                case 6: {
                    if (status != 6) {
                        throw new RemoteException("EJB cannot be invoked in global transaction");
                    }
                    this.checkUnfinishedTx(prevTx, inv);
                    break;
                }
                default: {
                    throw new RemoteException("Bad transaction attribute");
                }
            }
        }
        catch (Exception ex4) {
            Log.err.println(ex4);
            if (ex4 instanceof RemoteException) {
                throw (RemoteException)ex4;
            }
            throw new RemoteException("", ex4);
        }
    }

    private Throwable processSystemException(Throwable sysEx) {
        if (sysEx instanceof RemoteException) {
            return sysEx;
        }
        RemoteException newException = sysEx instanceof NoSuchEntityException ? new NoSuchObjectException("NoSuchEntityException thrown by EJB method.") : new RemoteException("Unknown Exception/Error thrown by EJB method.", sysEx);
        return newException;
    }

    protected abstract void releaseContext(Invocation var1) throws RemoteException;

    abstract void removeBean(Invocation var1) throws RemoteException, RemoveException;

    abstract void removeByPrimaryKey(Object var1) throws RemoteException, RemoveException;

    public final byte[] serializeObject(Object obj) throws IOException {
        final ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ObjectOutputStream oos = null;
        try {
            oos = (ObjectOutputStream)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    return new EJBObjectOutputStream(bos);
                }
            });
        }
        catch (PrivilegedActionException ex2) {
            throw (IOException)ex2.getException();
        }
        oos.writeObject(obj);
        oos.flush();
        byte[] data = bos.toByteArray();
        oos.close();
        bos.close();
        return data;
    }

    public final void setContainerId(int id) {
        this.contId = id;
    }

    /*
     * WARNING - void declaration
     */
    void setEJBHome(EJBHome ejbHome) throws Exception {
        try {
            this.ejbHome = ejbHome;
            byte[] byArray = new byte[4];
            byArray[0] = -1;
            byte[] instanceKey = byArray;
            Object stub = this.protocolMgr.createReference(ejbHome, this, instanceKey);
            this.ejbHomeStub = (EJBHome)PortableRemoteObject.narrow(stub, this.homeIntf);
            this.namingManager.publishObject(this.ejbDescriptor.getJndiName(), (Object)this.ejbHomeStub, true);
            Class<?> primaryKeyClass = null;
            if (!this.isSession) {
                EjbEntityDescriptor ed2 = (EjbEntityDescriptor)this.ejbDescriptor;
                primaryKeyClass = this.loader.loadClass(ed2.getPrimaryKeyClassName());
            }
            this.metadata = new EJBMetaDataImpl(this.ejbHomeStub, this.homeIntf, this.remoteClass, primaryKeyClass, this.isSession, this.isStatelessSession);
        }
        catch (Exception ex2) {
            void instanceKey;
            Log.err.println(ex2);
            throw instanceKey;
        }
    }

    public final void setSecurityManager(SecurityManager sm) {
        this.securityManager = sm;
    }

    private void setupEnvironment() throws NamingException {
        this.namingManager.bindObjects(this.ejbDescriptor);
        Set env = this.ejbDescriptor.getEnvironmentProperties();
        SafeProperties safeProps = new SafeProperties();
        safeProps.copy(env);
        this.envProps = safeProps;
    }

    private void startNewTx(Transaction prevTx, Invocation inv) throws Exception {
        this.checkUnfinishedTx(prevTx, inv);
        this.transactionManager.begin();
        EJBContextImpl context = (EJBContextImpl)inv.context;
        Transaction tx = this.transactionManager.getTransaction();
        context.setTransaction(tx);
        this.transactionManager.enlistComponentResources();
        SyncImpl sync = new SyncImpl(context, tx);
        this.transactionManager.registerSynchronization(sync);
        this.afterBegin(context);
    }

    public void undeploy() {
        this.theSwitch.removeDescriptorFor(this);
        this.securityManager.destroy();
        this.ejbDescriptor = null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void useClientTx(Transaction prevTx, Invocation inv) throws RemoteException {
        Transaction clientTx;
        int status = -1;
        int prevStatus = -1;
        try {
            clientTx = this.transactionManager.getTransaction();
            status = clientTx.getStatus();
            if (prevTx != null) {
                prevStatus = prevTx.getStatus();
            }
        }
        catch (Exception ex2) {
            try {
                this.transactionManager.setRollbackOnly();
                throw new TransactionRolledbackException(ex2.toString());
            }
            catch (Exception exception) {}
            throw new TransactionRolledbackException(ex2.toString());
        }
        if (status == 1 || status == 4 || status == 9) {
            throw new TransactionRolledbackException("Transaction aborted");
        }
        if (prevTx == null || prevStatus == 6) {
            EJBContextImpl context = (EJBContextImpl)inv.context;
            context.setTransaction(clientTx);
            try {
                this.transactionManager.enlistComponentResources();
                if (this.isStatelessSession) return;
                SyncImpl sync = new SyncImpl(context, clientTx);
                this.transactionManager.registerSynchronization(sync);
                this.afterBegin(context);
                return;
            }
            catch (Exception ex3) {
                try {
                    this.transactionManager.setRollbackOnly();
                    throw new TransactionRolledbackException(ex3.toString());
                }
                catch (Exception exception) {}
                throw new TransactionRolledbackException(ex3.toString());
            }
        }
        if (!prevTx.equals(clientTx)) {
            if (!this.isSession) return;
            throw new InvalidTransactionException("EJB is already associated with an incomplete transaction");
        }
        this.transactionManager.enlistComponentResources();
    }
}

