/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ejb.containers;

import com.sun.ejb.Invocation;
import com.sun.ejb.containers.EJBContextImpl;
import com.sun.ejb.containers.EntityContainer;
import com.sun.ejb.containers.EntityContextImpl;
import com.sun.ejb.sqlgen.CMPFields;
import com.sun.ejb.sqlgen.SQLGenerator;
import com.sun.ejb.sqlgen.SQLTypeMapper;
import com.sun.enterprise.ComponentInvocation;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.EjbEntityDescriptor;
import com.sun.enterprise.deployment.MethodDescriptor;
import com.sun.enterprise.deployment.ResourceReferenceDescriptor;
import com.sun.enterprise.log.Log;
import com.sun.enterprise.resource.ResourcePrincipal;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Vector;
import javax.ejb.CreateException;
import javax.ejb.DuplicateKeyException;
import javax.ejb.EntityBean;
import javax.ejb.FinderException;
import javax.ejb.NoSuchEntityException;
import javax.ejb.ObjectNotFoundException;
import javax.ejb.RemoveException;
import javax.naming.InitialContext;
import javax.sql.DataSource;

public final class CMPEntityContainer
extends EntityContainer {
    private SQLTypeMapper typeMapper;
    private SQLGenerator sqlGenerator;
    private DataSource dataSource;
    private String dbUserName;
    private String dbPasswd;
    boolean primKeyIsField = false;
    private Class primaryKeyClass;
    private Field[] pkeyFields;
    private Field[] ejbPkeyFields;
    private Field[] contMgFields;
    private Field[] contMgNoPkeyFields;
    private int[] pkeyFieldTypes;
    private int[] contMgFieldTypes;
    private int[] contMgNoPkeyFieldTypes;
    private String createTableQuery;
    private String deleteTableQuery;
    private String ejbLoadQuery;
    private String ejbStoreQuery;
    private String ejbCreateQuery;
    private String ejbRemoveQuery;
    private String ejbFindByPrimaryKeyQuery;
    private EjbEntityDescriptor entityDescriptor;
    static /* synthetic */ Class class$java$util$Collection;
    static /* synthetic */ Class class$java$util$Enumeration;

    protected CMPEntityContainer(EjbDescriptor desc, ClassLoader loader) throws Exception {
        super(desc, loader);
        Object var10_12;
        EjbEntityDescriptor dd2 = this.entityDescriptor = (EjbEntityDescriptor)desc;
        ResourceReferenceDescriptor rrd = dd2.getResourceReference();
        if (rrd == null) {
            throw new RemoteException("ERROR: No database resource reference for EntityBeans with container-managed persistence");
        }
        String dbName = rrd.getJndiName();
        ResourcePrincipal rp = rrd.getResourcePrincipal();
        this.dbUserName = rp.getName();
        this.dbPasswd = rp.getPassword();
        this.createTableQuery = dd2.getTableCreateSqlStatement();
        this.deleteTableQuery = dd2.getTableRemoveSqlStatement();
        Iterator it = dd2.getAllSqlStatementedMethods().iterator();
        while (it.hasNext()) {
            MethodDescriptor md = (MethodDescriptor)it.next();
            String methodName = md.getName();
            String query = dd2.getSqlStatementFor(md);
            if (query == null || query.equals("")) {
                throw new RuntimeException("No SQL statement for method " + md);
            }
            if (methodName.equals("ejbCreate")) {
                this.ejbCreateQuery = query;
                continue;
            }
            if (methodName.equals("ejbRemove")) {
                this.ejbRemoveQuery = query;
                continue;
            }
            if (methodName.equals("ejbStore")) {
                this.ejbStoreQuery = query;
                continue;
            }
            if (methodName.equals("ejbLoad")) {
                this.ejbLoadQuery = query;
                continue;
            }
            if (!methodName.equals("findByPrimaryKey")) continue;
            this.ejbFindByPrimaryKeyQuery = query;
        }
        try {
            CMPFields fieldInfo = new CMPFields(dd2, loader);
            this.pkeyFields = fieldInfo.pkeyFields;
            this.contMgFields = fieldInfo.contMgFields;
            this.contMgNoPkeyFields = fieldInfo.contMgNoPkeyFields;
            this.ejbPkeyFields = fieldInfo.ejbPkeyFields;
            this.primKeyIsField = fieldInfo.primKeyIsField;
        }
        catch (Exception ex2) {
            throw new RemoteException("Error obtaining CMP/primary key fields", ex2);
        }
        ComponentInvocation ci2 = new ComponentInvocation(null, this);
        this.invocationManager.preInvoke(ci2);
        try {
            Connection dbCon;
            block16: {
                InitialContext ctx = new InitialContext();
                this.dataSource = (DataSource)ctx.lookup(dbName);
                this.typeMapper = new SQLTypeMapper();
                this.pkeyFieldTypes = new int[this.pkeyFields.length];
                int i2 = 0;
                while (i2 < this.pkeyFields.length) {
                    this.pkeyFieldTypes[i2] = this.typeMapper.getJDBCTypeFor(this.pkeyFields[i2].getType());
                    ++i2;
                }
                this.contMgFieldTypes = new int[this.contMgFields.length];
                int i3 = 0;
                while (i3 < this.contMgFields.length) {
                    this.contMgFieldTypes[i3] = this.typeMapper.getJDBCTypeFor(this.contMgFields[i3].getType());
                    ++i3;
                }
                this.contMgNoPkeyFieldTypes = new int[this.contMgNoPkeyFields.length];
                int i4 = 0;
                while (i4 < this.contMgNoPkeyFields.length) {
                    this.contMgNoPkeyFieldTypes[i4] = this.typeMapper.getJDBCTypeFor(this.contMgNoPkeyFields[i4].getType());
                    ++i4;
                }
                dbCon = this.dataSource.getConnection(this.dbUserName, this.dbPasswd);
                try {
                    if (!this.entityDescriptor.getCreateTableOnDeployment()) break block16;
                    this.createTable(dbCon);
                }
                catch (Throwable throwable) {
                    Object var17_19 = null;
                    dbCon.close();
                    throw throwable;
                }
            }
            Object var17_18 = null;
            dbCon.close();
            var10_12 = null;
        }
        catch (Throwable throwable) {
            var10_12 = null;
            this.invocationManager.postInvoke(ci2);
            throw throwable;
        }
        this.invocationManager.postInvoke(ci2);
    }

    protected void callEJBLoad(EntityBean ejb, EJBContextImpl context) throws RemoteException {
        try {
            this.loadRow(ejb, ((EntityContextImpl)context).getPrimaryKey());
        }
        catch (Exception ex2) {
            if (ex2 instanceof NoSuchEntityException) {
                throw (NoSuchEntityException)ex2;
            }
            throw new RemoteException("ERROR from database SELECT ", ex2);
        }
        ejb.ejbLoad();
    }

    protected void callEJBRemove(EntityBean ejb, EJBContextImpl context) throws RemoteException, RemoveException {
        ejb.ejbRemove();
        try {
            this.removeRow(((EntityContextImpl)context).getPrimaryKey());
        }
        catch (Exception ex2) {
            throw new RemoteException("ERROR in database DELETE", ex2);
        }
    }

    protected void callEJBStore(EntityBean ejb, EJBContextImpl context) throws RemoteException {
        ejb.ejbStore();
        try {
            this.storeRow(ejb, ((EntityContextImpl)context).getPrimaryKey());
        }
        catch (Exception ex2) {
            throw new RemoteException("ERROR in database UPDATE ", ex2);
        }
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    private void copyFieldFromDB(ResultSet result, int param, Field field, Object obj, int type) throws SQLException {
        boolean isPrimitive = field.getType().isPrimitive();
        try {
            switch (type) {
                case 4: {
                    if (isPrimitive) {
                        field.setInt(obj, result.getInt(param));
                    } else {
                        int i2 = result.getInt(param);
                        if (result.wasNull()) {
                            field.set(obj, null);
                        } else {
                            field.set(obj, new Integer(i2));
                        }
                    }
                    break;
                }
                case -7: {
                    if (isPrimitive) {
                        field.setBoolean(obj, result.getBoolean(param));
                    } else {
                        boolean b10 = result.getBoolean(param);
                        if (result.wasNull()) {
                            field.set(obj, null);
                        } else {
                            field.set(obj, new Boolean(b10));
                        }
                    }
                    break;
                }
                case -6: {
                    if (isPrimitive) {
                        field.setByte(obj, result.getByte(param));
                    } else {
                        byte b11 = result.getByte(param);
                        if (result.wasNull()) {
                            field.set(obj, null);
                        } else {
                            field.set(obj, new Byte(b11));
                        }
                    }
                    break;
                }
                case 1: {
                    if (isPrimitive) {
                        field.setChar(obj, result.getString(param).charAt(0));
                    } else {
                        String s2 = result.getString(param);
                        if (s2 == null) {
                            field.set(obj, null);
                        } else {
                            field.set(obj, new Character(s2.charAt(0)));
                        }
                    }
                    break;
                }
                case 5: {
                    if (isPrimitive) {
                        field.setShort(obj, result.getShort(param));
                    } else {
                        short s3 = result.getShort(param);
                        if (result.wasNull()) {
                            field.set(obj, null);
                        } else {
                            field.set(obj, new Short(s3));
                        }
                    }
                    break;
                }
                case -5: {
                    if (isPrimitive) {
                        field.setLong(obj, result.getLong(param));
                    } else {
                        long l2 = result.getLong(param);
                        if (result.wasNull()) {
                            field.set(obj, null);
                        } else {
                            field.set(obj, new Long(l2));
                        }
                    }
                    break;
                }
                case 7: {
                    if (isPrimitive) {
                        field.setFloat(obj, result.getFloat(param));
                    } else {
                        float f2 = result.getFloat(param);
                        if (result.wasNull()) {
                            field.set(obj, null);
                        } else {
                            field.set(obj, new Float(f2));
                        }
                    }
                    break;
                }
                case 8: {
                    if (isPrimitive) {
                        field.setDouble(obj, result.getDouble(param));
                    } else {
                        double d10 = result.getDouble(param);
                        if (result.wasNull()) {
                            field.set(obj, null);
                        } else {
                            field.set(obj, new Double(d10));
                        }
                    }
                    break;
                }
                case -4: {
                    field.set(obj, result.getBytes(param));
                    break;
                }
                case 12: {
                    field.set(obj, result.getString(param));
                    break;
                }
                case 2: {
                    field.set(obj, result.getBigDecimal(param));
                    break;
                }
                case 91: {
                    field.set(obj, result.getDate(param));
                    break;
                }
                case 92: {
                    field.set(obj, result.getTime(param));
                    break;
                }
                case 93: {
                    field.set(obj, result.getTimestamp(param));
                    break;
                }
                case 2000: {
                    Object value;
                    try {
                        value = this.deserializeObject(result.getBytes(param));
                    }
                    catch (Exception ex2) {
                        throw new RuntimeException("Unable to deserialize field: " + ex2);
                    }
                    field.set(obj, value);
                    break;
                }
                default: {
                    throw new RuntimeException("Unsupported JDBC type: " + type);
                }
            }
        }
        catch (IllegalAccessException ex3) {
            throw new RuntimeException("Field not accessible: " + ex3);
        }
    }

    private void copyFieldToDB(PreparedStatement stmt, int param, Field field, Object obj, int type) throws SQLException {
        Object value = null;
        try {
            switch (type) {
                case 1: {
                    value = field.get(obj);
                    if (value == null) {
                        stmt.setNull(param, type);
                    } else {
                        stmt.setString(param, ((Character)value).toString());
                    }
                    break;
                }
                case -7: 
                case -6: 
                case -5: 
                case 4: 
                case 5: 
                case 7: 
                case 8: {
                    value = field.get(obj);
                    if (value == null) {
                        stmt.setNull(param, type);
                    } else {
                        stmt.setObject(param, value);
                    }
                    break;
                }
                case -4: {
                    value = field.get(obj);
                    if (value == null) {
                        stmt.setNull(param, type);
                    } else {
                        stmt.setBytes(param, (byte[])value);
                    }
                    break;
                }
                case 12: {
                    value = field.get(obj);
                    if (value == null) {
                        stmt.setNull(param, type);
                    } else {
                        stmt.setString(param, (String)value);
                    }
                    break;
                }
                case 2: {
                    value = field.get(obj);
                    if (value == null) {
                        stmt.setNull(param, type);
                    } else {
                        stmt.setBigDecimal(param, (BigDecimal)value);
                    }
                    break;
                }
                case 91: {
                    value = field.get(obj);
                    if (value == null) {
                        stmt.setNull(param, type);
                    } else {
                        stmt.setDate(param, (Date)value);
                    }
                    break;
                }
                case 92: {
                    value = field.get(obj);
                    if (value == null) {
                        stmt.setNull(param, type);
                    } else {
                        stmt.setTime(param, (Time)value);
                    }
                    break;
                }
                case 93: {
                    value = field.get(obj);
                    if (value == null) {
                        stmt.setNull(param, type);
                    } else {
                        stmt.setTimestamp(param, (Timestamp)value);
                    }
                    break;
                }
                case 2000: {
                    byte[] buf;
                    value = field.get(obj);
                    if (value == null) {
                        stmt.setNull(param, -4);
                        break;
                    }
                    try {
                        buf = this.serializeObject(value);
                    }
                    catch (Exception ex2) {
                        throw new RuntimeException("Unable to serialize container-managed field." + ex2);
                    }
                    stmt.setBytes(param, buf);
                    break;
                }
                default: {
                    throw new RuntimeException("Unsupported JDBC type: " + type);
                }
            }
        }
        catch (IllegalAccessException ex3) {
            throw new RuntimeException("Field not accessible: " + ex3);
        }
    }

    private void copyObjToDB(PreparedStatement stmt, int param, Object obj, int type) throws SQLException {
        switch (type) {
            case 1: {
                if (obj == null) {
                    stmt.setNull(param, type);
                    break;
                }
                stmt.setString(param, ((Character)obj).toString());
                break;
            }
            case -7: 
            case -6: 
            case -5: 
            case 4: 
            case 5: 
            case 7: 
            case 8: {
                if (obj == null) {
                    stmt.setNull(param, type);
                    break;
                }
                stmt.setObject(param, obj);
                break;
            }
            case -4: {
                if (obj == null) {
                    stmt.setNull(param, type);
                    break;
                }
                stmt.setBytes(param, (byte[])obj);
                break;
            }
            case 12: {
                if (obj == null) {
                    stmt.setNull(param, type);
                    break;
                }
                stmt.setString(param, (String)obj);
                break;
            }
            case 2: {
                if (obj == null) {
                    stmt.setNull(param, type);
                    break;
                }
                stmt.setBigDecimal(param, (BigDecimal)obj);
                break;
            }
            case 91: {
                if (obj == null) {
                    stmt.setNull(param, type);
                    break;
                }
                stmt.setDate(param, (Date)obj);
                break;
            }
            case 92: {
                if (obj == null) {
                    stmt.setNull(param, type);
                    break;
                }
                stmt.setTime(param, (Time)obj);
                break;
            }
            case 93: {
                if (obj == null) {
                    stmt.setNull(param, type);
                    break;
                }
                stmt.setTimestamp(param, (Timestamp)obj);
                break;
            }
            case 2000: {
                byte[] buf;
                if (obj == null) {
                    stmt.setNull(param, -4);
                    break;
                }
                try {
                    buf = this.serializeObject(obj);
                }
                catch (Exception ex2) {
                    throw new RuntimeException("Unable to serialize container-managed field." + ex2);
                }
                stmt.setBytes(param, buf);
                break;
            }
            default: {
                throw new RuntimeException("Unsupported JDBC type: " + type);
            }
        }
    }

    private void createRow(EntityBean ejb, Object pkey) throws Exception {
        Connection dbCon = this.dataSource.getConnection(this.dbUserName, this.dbPasswd);
        PreparedStatement stmt = dbCon.prepareStatement(this.ejbCreateQuery);
        try {
            int i2 = 0;
            while (i2 < this.contMgFields.length) {
                this.copyFieldToDB(stmt, i2 + 1, this.contMgFields[i2], ejb, this.contMgFieldTypes[i2]);
                ++i2;
            }
            try {
                int rc = stmt.executeUpdate();
                if (rc != 1) {
                    throw new RemoteException("ERROR in createRow!! resultCount = " + rc);
                }
            }
            catch (Exception ex2) {
                stmt.close();
                stmt = dbCon.prepareStatement(this.ejbFindByPrimaryKeyQuery);
                if (this.pKeyExists(pkey, stmt)) {
                    throw new DuplicateKeyException("Duplicate primary key");
                }
                throw ex2;
            }
            Object var6_8 = null;
        }
        catch (Throwable throwable) {
            Object var6_9 = null;
            stmt.close();
            dbCon.close();
            throw throwable;
        }
        stmt.close();
        dbCon.close();
    }

    private void createTable(Connection dbCon) throws Exception {
        Statement stmt = dbCon.createStatement();
        try {
            try {
                stmt.executeUpdate(this.createTableQuery);
            }
            catch (SQLException ex2) {
                Log.err.println(ex2);
            }
            Object var4_4 = null;
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            stmt.close();
            throw throwable;
        }
        stmt.close();
    }

    private void deleteTable() throws Exception {
        Connection dbCon = this.dataSource.getConnection(this.dbUserName, this.dbPasswd);
        Statement stmt = dbCon.createStatement();
        try {
            stmt.executeUpdate(this.deleteTableQuery);
        }
        finally {
            Object var4_3 = null;
            stmt.close();
            dbCon.close();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Object doFind(Method method, Object[] findParams) throws Exception {
        Object object;
        Connection dbCon = this.dataSource.getConnection(this.dbUserName, this.dbPasswd);
        try {
            PreparedStatement stmt;
            Object pkey;
            if (method.getName().equals("findByPrimaryKey")) {
                pkey = findParams[0];
                stmt = dbCon.prepareStatement(this.ejbFindByPrimaryKeyQuery);
                if (!this.pKeyExists(pkey, stmt)) {
                    throw new ObjectNotFoundException("No database row found for primary key");
                }
            } else {
                String query = this.entityDescriptor.getSqlStatementFor(method);
                if (query == null) throw new RemoteException("No SQL statement for " + method);
                if (query.equals("")) {
                    throw new RemoteException("No SQL statement for " + method);
                }
                Vector<Object> params = new Vector<Object>();
                int numparams = 0;
                int fromIndex = 0;
                while (true) {
                    String paramnum;
                    int nextQuestion;
                    if ((nextQuestion = query.indexOf(63, fromIndex)) == -1) break;
                    if (Character.isWhitespace(query.charAt(nextQuestion + 1))) {
                        throw new RuntimeException("Bad SQL query for method " + method);
                    }
                    if (query.length() == nextQuestion + 2 || Character.isWhitespace(query.charAt(nextQuestion + 2))) {
                        paramnum = query.substring(nextQuestion + 1, nextQuestion + 2);
                    } else {
                        if (query.length() != nextQuestion + 3) {
                            if (!Character.isWhitespace(query.charAt(nextQuestion + 3))) throw new RuntimeException("Bad SQL query for method " + method);
                        }
                        paramnum = query.substring(nextQuestion + 1, nextQuestion + 3);
                    }
                    int paramIndex = Integer.parseInt(paramnum) - 1;
                    if (paramIndex < 0) throw new RuntimeException("Bad parameter number " + paramnum + " in SQL query for method " + method);
                    if (paramIndex >= findParams.length) {
                        throw new RuntimeException("Bad parameter number " + paramnum + " in SQL query for method " + method);
                    }
                    Object param = findParams[paramIndex];
                    params.add(param);
                    ++numparams;
                    query = String.valueOf(query.substring(0, nextQuestion + 1)) + query.substring(nextQuestion + 1 + paramnum.length());
                    fromIndex = nextQuestion + 1;
                }
                PreparedStatement stmt2 = dbCon.prepareStatement(query);
                int i2 = 0;
                while (true) {
                    if (i2 >= numparams) break;
                    Class<?> paramClass = findParams[i2].getClass();
                    int type = this.typeMapper.getJDBCTypeFor(paramClass);
                    this.copyObjToDB(stmt2, i2 + 1, params.elementAt(i2), type);
                    ++i2;
                }
                ResultSet result = stmt2.executeQuery();
                Vector pkeys = new Vector();
                while (true) {
                    Object pkey2;
                    if (!result.next()) {
                        stmt2.close();
                    }
                    if (!this.primKeyIsField) {
                        pkey2 = this.primaryKeyClass.newInstance();
                        int i3 = 0;
                        while (i3 < this.pkeyFields.length) {
                            this.copyFieldFromDB(result, i3 + 1, this.pkeyFields[i3], pkey2, this.pkeyFieldTypes[i3]);
                            ++i3;
                        }
                    } else {
                        pkey2 = this.getObjFromDB(result, this.pkeyFieldTypes[0]);
                    }
                    pkeys.add(pkey2);
                }
                if (method.getReturnType() == (class$java$util$Collection != null ? class$java$util$Collection : (class$java$util$Collection = CMPEntityContainer.class$("java.util.Collection")))) {
                    Vector vector = pkeys;
                    Object var6_13 = null;
                    dbCon.close();
                    return vector;
                }
                if (method.getReturnType() == (class$java$util$Enumeration != null ? class$java$util$Enumeration : (class$java$util$Enumeration = CMPEntityContainer.class$("java.util.Enumeration")))) {
                    Enumeration enumeration = pkeys.elements();
                    Object var6_14 = null;
                    dbCon.close();
                    return enumeration;
                }
                if (method.getReturnType() != this.primaryKeyClass) throw new RuntimeException("Invalid return type for finder");
                if (pkeys.size() == 0) {
                    throw new ObjectNotFoundException("No database row found for finder " + method);
                }
                if (pkeys.size() != 1) throw new RuntimeException("More than one row returned by SQL query for single-object finder " + method);
                Object e10 = pkeys.elementAt(0);
                Object var6_15 = null;
                dbCon.close();
                return e10;
            }
            stmt.close();
            object = pkey;
            Object var6_12 = null;
        }
        catch (Throwable throwable) {
            Object var6_16 = null;
            dbCon.close();
            throw throwable;
        }
        dbCon.close();
        return object;
    }

    private Object getObjFromDB(ResultSet result, int type) throws SQLException {
        Object obj;
        switch (type) {
            case 4: {
                obj = new Integer(result.getInt(1));
                break;
            }
            case -7: {
                obj = new Boolean(result.getBoolean(1));
                break;
            }
            case -6: {
                obj = new Byte(result.getByte(1));
                break;
            }
            case 1: {
                obj = new Character(result.getString(1).charAt(0));
                break;
            }
            case 5: {
                obj = new Short(result.getShort(1));
                break;
            }
            case -5: {
                obj = new Long(result.getLong(1));
                break;
            }
            case 7: {
                obj = new Float(result.getFloat(1));
                break;
            }
            case 8: {
                obj = new Double(result.getDouble(1));
                break;
            }
            case -4: {
                obj = result.getBytes(1);
                break;
            }
            case 12: {
                obj = result.getString(1);
                break;
            }
            case 2: {
                obj = result.getBigDecimal(1);
                break;
            }
            case 91: {
                obj = result.getDate(1);
                break;
            }
            case 92: {
                obj = result.getTime(1);
                break;
            }
            case 93: {
                obj = result.getTimestamp(1);
                break;
            }
            case 2000: {
                try {
                    obj = this.deserializeObject(result.getBytes(1));
                    break;
                }
                catch (Exception ex2) {
                    throw new RuntimeException("Unable to deserialize object." + ex2);
                }
            }
            default: {
                throw new RuntimeException("Unsupported JDBC type: " + type);
            }
        }
        return obj;
    }

    private void loadRow(EntityBean ejb, Object primaryKey) throws Exception {
        PreparedStatement stmt;
        Connection dbCon;
        block9: {
            dbCon = this.dataSource.getConnection(this.dbUserName, this.dbPasswd);
            stmt = dbCon.prepareStatement(this.ejbLoadQuery);
            try {
                if (this.primKeyIsField) {
                    this.copyObjToDB(stmt, 1, primaryKey, this.pkeyFieldTypes[0]);
                } else {
                    int i2 = 0;
                    while (i2 < this.pkeyFields.length) {
                        this.copyFieldToDB(stmt, i2 + 1, this.pkeyFields[i2], primaryKey, this.pkeyFieldTypes[i2]);
                        ++i2;
                    }
                }
                ResultSet result = stmt.executeQuery();
                if (!result.next()) {
                    throw new NoSuchEntityException("ERROR in SQL SELECT: No database row for EJB");
                }
                int i3 = 0;
                while (i3 < this.contMgNoPkeyFields.length) {
                    this.copyFieldFromDB(result, i3 + 1, this.contMgNoPkeyFields[i3], ejb, this.contMgNoPkeyFieldTypes[i3]);
                    ++i3;
                }
                if (this.primKeyIsField) {
                    this.ejbPkeyFields[0].set(ejb, primaryKey);
                    break block9;
                }
                int i4 = 0;
                while (i4 < this.pkeyFields.length) {
                    this.ejbPkeyFields[i4].set(ejb, this.pkeyFields[i4].get(primaryKey));
                    ++i4;
                }
            }
            catch (Throwable throwable) {
                Object var6_10 = null;
                stmt.close();
                dbCon.close();
                throw throwable;
            }
        }
        Object var6_9 = null;
        stmt.close();
        dbCon.close();
    }

    private boolean pKeyExists(Object pkey, PreparedStatement stmt) throws Exception {
        if (this.primKeyIsField) {
            this.copyObjToDB(stmt, 1, pkey, this.pkeyFieldTypes[0]);
        } else {
            int i2 = 0;
            while (i2 < this.pkeyFields.length) {
                this.copyFieldToDB(stmt, i2 + 1, this.pkeyFields[i2], pkey, this.pkeyFieldTypes[i2]);
                ++i2;
            }
        }
        ResultSet result = stmt.executeQuery();
        return result.next();
    }

    public void postCreate(Invocation inv, Object primaryKey) throws RemoteException, CreateException {
        Object pkey;
        try {
            if (this.primKeyIsField) {
                pkey = this.ejbPkeyFields[0].get(inv.ejb);
            } else {
                pkey = this.primaryKeyClass.newInstance();
                int i2 = 0;
                while (i2 < this.pkeyFields.length) {
                    this.pkeyFields[i2].set(pkey, this.ejbPkeyFields[i2].get(inv.ejb));
                    ++i2;
                }
            }
        }
        catch (Exception ex2) {
            throw new RemoteException("Unable to initialize primary key", ex2);
        }
        try {
            this.createRow((EntityBean)inv.ejb, pkey);
        }
        catch (Exception ex3) {
            if (ex3 instanceof CreateException) {
                throw (CreateException)ex3;
            }
            throw new CreateException("ERROR in database INSERT " + ex3);
        }
        super.postCreate(inv, pkey);
    }

    public Object postFind(Invocation inv, Object primaryKeys, Object[] findParams) throws RemoteException, FinderException {
        try {
            primaryKeys = this.doFind(inv.method, findParams);
        }
        catch (Exception ex2) {
            if (ex2 instanceof FinderException) {
                throw (FinderException)ex2;
            }
            throw new FinderException("ERROR in database SELECT for find" + ex2);
        }
        return super.postFind(inv, primaryKeys, findParams);
    }

    protected void preCreate(Invocation inv, EntityContextImpl context) throws RemoteException {
        EntityBean ejb = (EntityBean)context.getEJB();
        int i2 = 0;
        while (i2 < this.contMgFields.length) {
            block14: {
                Field f2 = this.contMgFields[i2];
                Class<?> type = f2.getType();
                try {
                    if (type.isPrimitive()) {
                        switch (this.contMgFieldTypes[i2]) {
                            case -7: {
                                f2.setBoolean(ejb, false);
                                break block14;
                            }
                            case -6: {
                                f2.setByte(ejb, (byte)0);
                                break block14;
                            }
                            case 5: {
                                f2.setShort(ejb, (short)0);
                                break block14;
                            }
                            case 1: {
                                f2.setChar(ejb, '\u0000');
                                break block14;
                            }
                            case 4: {
                                f2.setInt(ejb, 0);
                                break block14;
                            }
                            case -5: {
                                f2.setLong(ejb, 0L);
                                break block14;
                            }
                            case 7: {
                                f2.setFloat(ejb, 0.0f);
                                break block14;
                            }
                            case 8: {
                                f2.setDouble(ejb, 0.0);
                                break block14;
                            }
                            default: {
                                throw new RemoteException("ERROR initializing EJB field " + f2);
                            }
                        }
                    }
                    f2.set(ejb, null);
                }
                catch (IllegalAccessException ex2) {
                    throw new RemoteException("ERROR initializing EJB field ", ex2);
                }
            }
            ++i2;
        }
    }

    private void removeRow(Object pkey) throws Exception {
        Connection dbCon = this.dataSource.getConnection(this.dbUserName, this.dbPasswd);
        PreparedStatement stmt = dbCon.prepareStatement(this.ejbRemoveQuery);
        try {
            if (this.primKeyIsField) {
                this.copyObjToDB(stmt, 1, pkey, this.pkeyFieldTypes[0]);
            } else {
                int i2 = 0;
                while (i2 < this.pkeyFields.length) {
                    this.copyFieldToDB(stmt, i2 + 1, this.pkeyFields[i2], pkey, this.pkeyFieldTypes[i2]);
                    ++i2;
                }
            }
            int rc = stmt.executeUpdate();
            if (rc != 1) {
                throw new RemoteException("ERROR in removeRow!! resultCount = " + rc);
            }
            Object var5_5 = null;
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            stmt.close();
            dbCon.close();
            throw throwable;
        }
        stmt.close();
        dbCon.close();
    }

    private void storeRow(EntityBean ejb, Object pkey) throws Exception {
        if (this.contMgNoPkeyFields.length == 0) {
            return;
        }
        Connection dbCon = this.dataSource.getConnection(this.dbUserName, this.dbPasswd);
        PreparedStatement stmt = dbCon.prepareStatement(this.ejbStoreQuery);
        try {
            int param = 1;
            int i2 = 0;
            while (i2 < this.contMgNoPkeyFields.length) {
                this.copyFieldToDB(stmt, param++, this.contMgNoPkeyFields[i2], ejb, this.contMgNoPkeyFieldTypes[i2]);
                ++i2;
            }
            if (this.primKeyIsField) {
                this.copyObjToDB(stmt, param++, pkey, this.pkeyFieldTypes[0]);
            } else {
                int i3 = 0;
                while (i3 < this.pkeyFields.length) {
                    this.copyFieldToDB(stmt, param++, this.pkeyFields[i3], pkey, this.pkeyFieldTypes[i3]);
                    ++i3;
                }
            }
            int rc = stmt.executeUpdate();
            if (rc != 1) {
                throw new RemoteException("ERROR in storeRow!! resultCount = " + rc);
            }
            Object var6_8 = null;
        }
        catch (Throwable throwable) {
            Object var6_9 = null;
            stmt.close();
            dbCon.close();
            throw throwable;
        }
        stmt.close();
        dbCon.close();
    }

    public void undeploy() {
        if (this.entityDescriptor.getDeleteTableOnUndeployment()) {
            ComponentInvocation ci2 = new ComponentInvocation(null, this);
            this.invocationManager.preInvoke(ci2);
            try {
                try {
                    this.deleteTable();
                }
                catch (Exception ex2) {
                    Log.err.println(ex2);
                }
                Object var3_3 = null;
            }
            catch (Throwable throwable) {
                Object var3_4 = null;
                this.invocationManager.postInvoke(ci2);
                throw throwable;
            }
            this.invocationManager.postInvoke(ci2);
        }
        super.undeploy();
    }
}

