/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ejb.containers;

import com.sun.ejb.EJBStore;
import com.sun.ejb.Recycler;
import com.sun.ejb.containers.EJBContextImpl;
import com.sun.ejb.containers.StatefulSessionContainer;
import com.sun.ejb.containers.TimeoutThread;
import com.sun.enterprise.ServerConfiguration;
import java.util.Enumeration;
import java.util.Vector;

public final class RecyclerImpl
implements Recycler {
    private static final int DEFAULT_PASSIVATION_THRESHOLD = 10000000;
    private final boolean debug = false;
    EJBStore statefulSessionStore;
    EJBStore entityStore;
    private boolean inRecycle = false;
    private long threshold;

    public RecyclerImpl() {
        new TimeoutThread(this).start();
        ServerConfiguration config = ServerConfiguration.getConfiguration();
        String s2 = config.getProperty("passivation.threshold.memory");
        this.threshold = s2 != null ? Long.parseLong(s2) : 10000000L;
    }

    private void internalRecycle() {
        Runtime runtime = Runtime.getRuntime();
        long free = runtime.freeMemory();
        long total = runtime.totalMemory();
        if (total - free < this.threshold) {
            return;
        }
        this.internalRemoveTimedoutSessionEJBs();
        this.passivateEJBs(this.statefulSessionStore);
        this.passivateEJBs(this.entityStore);
        System.gc();
    }

    private void internalRemoveTimedoutSessionEJBs() {
        int currentTime = (int)(System.currentTimeMillis() / 1000L);
        Enumeration keys = this.statefulSessionStore.listActiveEJBKeys();
        while (keys.hasMoreElements()) {
            try {
                Object key = keys.nextElement();
                EJBContextImpl ctx = (EJBContextImpl)this.statefulSessionStore.lookupEJB(key, null);
                StatefulSessionContainer container = (StatefulSessionContainer)ctx.getContainer();
                int timeout = container.getTimeout();
                int lastUsage = (int)(ctx.getLastTimeUsed() / 1000L);
                if (timeout <= 0 || currentTime - lastUsage <= timeout) continue;
                EJBContextImpl eJBContextImpl = ctx;
                synchronized (eJBContextImpl) {
                    if (ctx.getState() != 3) {
                        container.timeoutBean(ctx);
                    }
                }
            }
            catch (Exception exception) {}
        }
    }

    private void passivateEJBs(EJBStore store) {
        Vector passivateList = new Vector();
        Enumeration keys = store.listActiveEJBKeys();
        long totlife = 0L;
        int count = 0;
        while (keys.hasMoreElements()) {
            Object key = keys.nextElement();
            EJBContextImpl ctx = (EJBContextImpl)store.lookupEJB(key, null);
            totlife += ctx.getLastTimeUsed();
            ++count;
        }
        long averageTime = (long)((double)totlife / (double)count);
        keys = store.listActiveEJBKeys();
        while (keys.hasMoreElements()) {
            Object key = keys.nextElement();
            EJBContextImpl ctx = (EJBContextImpl)store.lookupEJB(key, null);
            if (ctx.getLastTimeUsed() > averageTime) continue;
            passivateList.addElement(key);
        }
        store.passivateEJBs(passivateList.elements());
    }

    public void recycle() {
        RecyclerImpl recyclerImpl = this;
        synchronized (recyclerImpl) {
            if (this.inRecycle) {
                Object var2_3 = null;
                return;
            }
            this.inRecycle = true;
        }
        try {
            this.internalRecycle();
        }
        finally {
            Object var2_4 = null;
            this.inRecycle = false;
        }
    }

    void removeTimedoutSessionEJBs() {
        RecyclerImpl recyclerImpl = this;
        synchronized (recyclerImpl) {
            if (this.inRecycle) {
                Object var2_3 = null;
                return;
            }
            this.inRecycle = true;
        }
        try {
            this.internalRemoveTimedoutSessionEJBs();
        }
        finally {
            Object var2_4 = null;
            this.inRecycle = false;
        }
    }
}

