/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ejb.containers;

import com.sun.ejb.ComponentContext;
import com.sun.ejb.EJBStore;
import com.sun.ejb.Invocation;
import com.sun.ejb.containers.BaseContainer;
import com.sun.ejb.containers.EJBContextImpl;
import com.sun.ejb.containers.SessionContextImpl;
import com.sun.ejb.containers.StatefulSessionEJBObjectImpl;
import com.sun.enterprise.ComponentInvocation;
import com.sun.enterprise.ServerConfiguration;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.log.Log;
import java.rmi.NoSuchObjectException;
import java.rmi.RemoteException;
import javax.ejb.CreateException;
import javax.ejb.EJBObject;
import javax.ejb.EnterpriseBean;
import javax.ejb.RemoveException;
import javax.ejb.SessionBean;
import javax.ejb.SessionSynchronization;
import javax.rmi.PortableRemoteObject;
import javax.transaction.SystemException;
import javax.transaction.Transaction;

public final class StatefulSessionContainer
extends BaseContainer {
    static final int PASSIVE = 1;
    static final int READY = 2;
    static final int INVOKING = 3;
    static final int INCOMPLETE_TX = 4;
    static final int DESTROYED = 5;
    private int timeout;
    private EJBStore statefulBeanStore;

    protected StatefulSessionContainer(EjbDescriptor desc, ClassLoader loader) throws Exception {
        super(desc, loader);
        ServerConfiguration config = ServerConfiguration.getConfiguration();
        String tim = config.getProperty("sessionbean.timeout");
        this.timeout = tim == null || tim.equals("") || tim.equals("0") ? 0 : Integer.parseInt(tim);
    }

    public void activateEJB(Object ctx, Object key) throws RemoteException {
        SessionContextImpl context = (SessionContextImpl)ctx;
        SessionBean ejb = (SessionBean)context.getEJB();
        ComponentInvocation ci2 = new ComponentInvocation(ejb, this);
        this.invocationManager.preInvoke(ci2);
        try {
            try {
                context.setLastTimeUsed(System.currentTimeMillis());
                context.setContainer(this);
                context.setState(2);
                byte[] instanceKey = (byte[])key;
                context.setInstanceKey(instanceKey);
                this.createEJBObject(context, instanceKey);
                ejb.ejbActivate();
            }
            catch (Exception exception) {
                throw new RemoteException("Unable to activate EJB");
            }
            Object var7_7 = null;
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            this.invocationManager.postInvoke(ci2);
            throw throwable;
        }
        this.invocationManager.postInvoke(ci2);
    }

    void afterBegin(EJBContextImpl context) throws RemoteException {
        if (this.isBeanManagedTran) {
            return;
        }
        EnterpriseBean ejb = context.getEJB();
        if (ejb instanceof SessionSynchronization) {
            SessionSynchronization sync = (SessionSynchronization)((Object)ejb);
            try {
                sync.afterBegin();
            }
            catch (Exception ex2) {
                this.forceDestroyBean(context);
                throw new RemoteException("Error during afterBegin, EJB instance discarded", ex2);
            }
        }
    }

    void afterCompletion(EJBContextImpl context, int status) {
        if (context.getState() == 5) {
            return;
        }
        SessionContextImpl sc = (SessionContextImpl)context;
        EnterpriseBean ejb = sc.getEJB();
        boolean committed = status == 3;
        sc.setTransaction(null);
        if (!this.isBeanManagedTran && ejb instanceof SessionSynchronization) {
            if (sc.getState() == 3 && !sc.isTxCompleting()) {
                sc.setAfterCompletionDelayed(true);
                sc.setCompletedTxStatus(committed);
                return;
            }
            try {
                this.callEjbAfterCompletion(sc, committed);
            }
            catch (RemoteException remoteException) {
                return;
            }
        }
        sc.setState(2);
    }

    void beforeCompletion(EJBContextImpl context) throws RemoteException {
        if (this.isBeanManagedTran) {
            return;
        }
        EnterpriseBean ejb = context.getEJB();
        if (!(ejb instanceof SessionSynchronization)) {
            return;
        }
        ComponentInvocation ci2 = new ComponentInvocation(ejb, this);
        this.invocationManager.preInvoke(ci2);
        try {
            try {
                this.transactionManager.enlistComponentResources();
                ((SessionSynchronization)((Object)ejb)).beforeCompletion();
            }
            catch (Exception ex2) {
                try {
                    this.forceDestroyBean(context);
                }
                catch (Exception exception) {}
                throw new RemoteException("Error during beforeCompletion, EJB instance discarded", ex2);
            }
            Object var5_5 = null;
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            this.invocationManager.postInvoke(ci2);
            throw throwable;
        }
        this.invocationManager.postInvoke(ci2);
    }

    private void callEjbAfterCompletion(SessionContextImpl context, boolean status) throws RemoteException {
        EnterpriseBean ejb = context.getEJB();
        ComponentInvocation ci2 = new ComponentInvocation(ejb, this);
        this.invocationManager.preInvoke(ci2);
        try {
            try {
                ((SessionSynchronization)((Object)ejb)).afterCompletion(status);
            }
            catch (RemoteException ex2) {
                try {
                    this.forceDestroyBean(context);
                }
                catch (Exception exception) {}
                throw ex2;
            }
            Object var6_6 = null;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            this.invocationManager.postInvoke(ci2);
            throw throwable;
        }
        this.invocationManager.postInvoke(ci2);
        context.setAfterCompletionDelayed(false);
        context.setTxCompleting(false);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public EJBObject createEJBObject() throws RemoteException, CreateException {
        StatefulSessionEJBObjectImpl statefulSessionEJBObjectImpl;
        ComponentInvocation ci2 = null;
        try {
            try {
                SessionBean ejb = (SessionBean)this.ejbClass.newInstance();
                SessionContextImpl context = new SessionContextImpl(ejb, this);
                ci2 = new ComponentInvocation(ejb, this);
                this.invocationManager.preInvoke(ci2);
                ejb.setSessionContext(context);
                context.setLastTimeUsed(System.currentTimeMillis());
                byte[] instanceKey = (byte[])this.statefulBeanStore.storeEJB(context, this);
                context.setInstanceKey(instanceKey);
                StatefulSessionEJBObjectImpl ejbo = this.createEJBObject(context, instanceKey);
                context.setState(2);
                statefulSessionEJBObjectImpl = ejbo;
                Object var4_8 = null;
                if (ci2 == null) return statefulSessionEJBObjectImpl;
            }
            catch (Exception ex2) {
                Log.err.println(ex2);
                if (!(ex2 instanceof RemoteException)) throw new CreateException("ERROR creating stateful SessionBean: " + ex2);
                throw (RemoteException)ex2;
            }
        }
        catch (Throwable throwable) {
            Object var4_9 = null;
            if (ci2 == null) throw throwable;
            this.invocationManager.postInvoke(ci2);
            throw throwable;
        }
        this.invocationManager.postInvoke(ci2);
        return statefulSessionEJBObjectImpl;
    }

    private StatefulSessionEJBObjectImpl createEJBObject(SessionContextImpl context, byte[] instanceKey) throws Exception {
        StatefulSessionEJBObjectImpl ejbo = (StatefulSessionEJBObjectImpl)this.ejbObjectClass.newInstance();
        ejbo.setContainer(this);
        context.setEJBObjectImpl(ejbo);
        ejbo.setContext(context);
        ejbo.setInstanceKey(context.getInstanceKey());
        Object stub = this.protocolMgr.createReference(ejbo, this, instanceKey);
        EJBObject ejbStub = (EJBObject)PortableRemoteObject.narrow(stub, this.remoteClass);
        context.setEJBStub(ejbStub);
        ejbo.setStub(ejbStub);
        return ejbo;
    }

    void forceDestroyBean(EJBContextImpl ctx) throws RemoteException {
        SessionContextImpl sc;
        SessionContextImpl sessionContextImpl = sc = (SessionContextImpl)ctx;
        synchronized (sessionContextImpl) {
            if (sc.getState() == 5) {
                Object var4_4 = null;
                return;
            }
            sc.setState(5);
            Transaction prevTx = sc.getTransaction();
            try {
                if (prevTx != null && prevTx.getStatus() != 6) {
                    prevTx.setRollbackOnly();
                }
            }
            catch (SystemException ex2) {
                throw new RemoteException("", ex2);
            }
            catch (IllegalStateException ex3) {
                throw new RemoteException("", ex3);
            }
            byte[] instanceKey = sc.getInstanceKey();
            this.statefulBeanStore.deleteEJB(instanceKey, this);
            StatefulSessionEJBObjectImpl ejbo = (StatefulSessionEJBObjectImpl)sc.getEJBObjectImpl();
            ejbo.clearContext();
            sc.setEJBObjectImpl(null);
            this.protocolMgr.destroyReference(ejbo, this, instanceKey);
            this.transactionManager.componentDestroyed(sc.getEJB());
        }
    }

    public ComponentContext getContext(Invocation inv) throws RemoteException {
        StatefulSessionEJBObjectImpl ejbo = (StatefulSessionEJBObjectImpl)inv.ejbObject;
        SessionContextImpl sc = ejbo.getContext();
        byte[] key = ejbo.getInstanceKey();
        if (sc == null || sc.getState() == 5 || sc.getState() == 1) {
            sc = (SessionContextImpl)this.statefulBeanStore.lookupEJB(key, this);
        }
        if (sc == null || sc.getState() == 5) {
            throw new NoSuchObjectException("The EJB does not exist.");
        }
        SessionContextImpl sessionContextImpl = sc;
        synchronized (sessionContextImpl) {
            if (sc.getState() == 5) {
                throw new NoSuchObjectException("The EJB does not exist.");
            }
            if (sc.getState() == 3) {
                throw new RemoteException("SessionBean is executing another request");
            }
            if (sc.getState() == 1) {
                sc = (SessionContextImpl)this.statefulBeanStore.lookupEJB(sc.getInstanceKey(), this);
            }
            sc.setState(3);
        }
        sc.setLastTimeUsed(System.currentTimeMillis());
        inv.context = sc;
        return sc;
    }

    public EJBObject getEJBObject(byte[] instanceKey) throws RemoteException {
        SessionContextImpl sc = (SessionContextImpl)this.statefulBeanStore.lookupEJB(instanceKey, this);
        if (sc == null || sc.getEJBObjectImpl() == null) {
            throw new NoSuchObjectException("The EJB does not exist.");
        }
        return sc.getEJBObjectImpl();
    }

    int getTimeout() {
        return this.timeout;
    }

    public boolean passivateEJB(ComponentContext context) {
        SessionContextImpl sc = (SessionContextImpl)context;
        SessionBean ejb = (SessionBean)sc.getEJB();
        ComponentInvocation ci2 = new ComponentInvocation(ejb, this);
        this.invocationManager.preInvoke(ci2);
        boolean success = false;
        SessionContextImpl sessionContextImpl = sc;
        synchronized (sessionContextImpl) {
            try {
                try {
                    if (sc.getState() == 2) {
                        sc.setState(1);
                        ejb.ejbPassivate();
                        StatefulSessionEJBObjectImpl ejbo = (StatefulSessionEJBObjectImpl)sc.getEJBObjectImpl();
                        ejbo.clearContext();
                        this.protocolMgr.destroyReference(ejbo, this, sc.getInstanceKey());
                        success = true;
                    }
                }
                catch (Exception exception) {
                    try {
                        this.forceDestroyBean(sc);
                    }
                    catch (Exception exception2) {}
                    boolean bl2 = false;
                    Object var10_9 = null;
                    this.invocationManager.postInvoke(ci2);
                    Object var8_12 = null;
                    return bl2;
                }
                Object var10_10 = null;
            }
            catch (Throwable throwable) {
                Object var10_11 = null;
                this.invocationManager.postInvoke(ci2);
                throw throwable;
            }
            this.invocationManager.postInvoke(ci2);
        }
        return success;
    }

    public void releaseContext(Invocation inv) throws RemoteException {
        SessionContextImpl sc = (SessionContextImpl)inv.context;
        if (sc.getState() == 5) {
            return;
        }
        Transaction tx = sc.getTransaction();
        try {
            if (tx == null || tx.getStatus() == 6) {
                if (sc.getState() != 2) {
                    sc.setState(2);
                    if (sc.isAfterCompletionDelayed()) {
                        this.callEjbAfterCompletion(sc, sc.getCompletedTxStatus());
                    }
                }
            } else {
                sc.setState(4);
            }
        }
        catch (SystemException ex2) {
            throw new RemoteException("", ex2);
        }
    }

    public void removeBean(Invocation inv) throws RemoteException, RemoveException {
        try {
            SessionContextImpl sc = (SessionContextImpl)inv.context;
            Transaction tc = sc.getTransaction();
            if (tc != null && tc.getStatus() != 6) {
                throw new RemoveException("Cannot remove EJB: transaction in progress");
            }
            SessionBean sb = (SessionBean)sc.getEJB();
            sb.ejbRemove();
            this.forceDestroyBean(sc);
        }
        catch (RemoteException ex2) {
            Log.err.println(ex2);
            throw ex2;
        }
        catch (RemoveException ex3) {
            Log.err.println(ex3);
            throw ex3;
        }
        catch (SystemException ex4) {
            Log.err.println(ex4);
            throw new RemoteException("", ex4);
        }
    }

    public void removeByPrimaryKey(Object primaryKey) throws RemoteException, RemoveException {
        throw new RemoveException("Invalid remove operation.");
    }

    void setStatefulEJBStore(EJBStore s2) {
        this.statefulBeanStore = s2;
    }

    void timeoutBean(EJBContextImpl ctx) throws RemoteException {
        SessionBean sb = (SessionBean)ctx.getEJB();
        sb.ejbRemove();
        this.forceDestroyBean(ctx);
    }
}

