/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.activation;

import com.sun.enterprise.activation.CommandHandler;
import com.sun.enterprise.activation.Help;
import com.sun.enterprise.activation.ListActiveServers;
import com.sun.enterprise.activation.ListServers;
import com.sun.enterprise.activation.Quit;
import com.sun.enterprise.activation.ShutdownServer;
import com.sun.enterprise.activation.StartServer;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.util.ORBManager;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.StringTokenizer;
import java.util.Vector;

public class ServerTool {
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(class$com$sun$enterprise$activation$ServerTool != null ? class$com$sun$enterprise$activation$ServerTool : (class$com$sun$enterprise$activation$ServerTool = ServerTool.class$("com.sun.enterprise.activation.ServerTool")));
    static final String helpCommand = "help";
    static final String toolName = "servertool";
    static final String commandArg = "-cmd";
    static final String repositoryName = "AppRepository";
    private static final boolean debug = false;
    static Vector handlers = new Vector();
    static int maxNameLen;
    static /* synthetic */ Class class$com$sun$enterprise$activation$ServerTool;

    static {
        handlers.addElement(new ListServers());
        handlers.addElement(new ListActiveServers());
        handlers.addElement(new ShutdownServer());
        handlers.addElement(new StartServer());
        handlers.addElement(new Help());
        handlers.addElement(new Quit());
        maxNameLen = 0;
        int i2 = 0;
        while (i2 < handlers.size()) {
            CommandHandler handler = (CommandHandler)handlers.elementAt(i2);
            int cmdNameLen = handler.getCommandName().length();
            if (cmdNameLen > maxNameLen) {
                maxNameLen = cmdNameLen;
            }
            ++i2;
        }
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    void executeCommand(String[] cmd) {
        if (cmd[0].equals(helpCommand)) {
            if (cmd.length == 1) {
                this.printAvailableCommands();
            } else {
                int i2 = 0;
                while (i2 < handlers.size()) {
                    CommandHandler handler = (CommandHandler)handlers.elementAt(i2);
                    if (handler.getCommandName().equals(cmd[1])) {
                        System.out.print("\n" + localStrings.getLocalString("servertool.usage", "usage:"));
                        handler.printCommandHelp(System.out, false);
                    }
                    ++i2;
                }
            }
            return;
        }
        int i3 = 0;
        while (i3 < handlers.size()) {
            CommandHandler handler = (CommandHandler)handlers.elementAt(i3);
            if (handler.getCommandName().equals(cmd[0])) {
                String[] cmdArgs = new String[cmd.length - 1];
                int j2 = 0;
                while (j2 < cmdArgs.length) {
                    cmdArgs[j2] = cmd[j2 + 1];
                    ++j2;
                }
                try {
                    System.out.println();
                    boolean result = handler.processCommand(cmdArgs, System.out);
                    if (result) {
                        System.out.print("\n" + localStrings.getLocalString("servertool.usage", "usage:"));
                        handler.printCommandHelp(System.out, false);
                    }
                    System.out.println();
                }
                catch (Exception exception) {}
                return;
            }
            ++i3;
        }
        this.printAvailableCommands();
    }

    public static void main(String[] args) {
        ServerTool tool = new ServerTool();
        tool.run(args);
    }

    void printAvailableCommands() {
        System.out.println();
        System.out.println("\t" + localStrings.getLocalString("servertool.available_commands", "Available Commands:"));
        System.out.println("\t-------------------");
        int i2 = 0;
        while (i2 < handlers.size()) {
            CommandHandler handler = (CommandHandler)handlers.elementAt(i2);
            System.out.print("\t" + handler.getCommandName());
            int j2 = handler.getCommandName().length();
            while (j2 < maxNameLen) {
                System.out.print(" ");
                ++j2;
            }
            System.out.print(" - ");
            handler.printCommandHelp(System.out, true);
            ++i2;
        }
        System.out.println();
    }

    String[] readCommand(BufferedReader in) {
        System.out.print("servertool > ");
        try {
            StringTokenizer st;
            int i2 = 0;
            String[] cmd = null;
            String cmdLine = in.readLine();
            if (cmdLine != null && (st = new StringTokenizer(cmdLine)).countTokens() != 0) {
                cmd = new String[st.countTokens()];
                while (st.hasMoreTokens()) {
                    cmd[i2++] = st.nextToken();
                }
            }
            return cmd;
        }
        catch (Exception ex2) {
            ex2.printStackTrace();
            return null;
        }
    }

    void run(String[] args) {
        String[] cmd = null;
        int i2 = 0;
        while (i2 < args.length) {
            if (args[i2].equals(commandArg)) {
                int cmdLen = args.length - i2 - 1;
                cmd = new String[cmdLen];
                int j2 = 0;
                while (j2 < cmdLen) {
                    cmd[j2] = args[++i2];
                    ++j2;
                }
                break;
            }
            ++i2;
        }
        ORBManager.init(args, null);
        if (cmd == null) {
            BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
            System.out.println();
            System.out.println(localStrings.getLocalString("servertool.welcome", "Welcome to the J2EE Server Tool"));
            System.out.println(localStrings.getLocalString("servertool.enter_commands", "please enter commands at the prompt"));
            System.out.println();
            while (true) {
                if ((cmd = this.readCommand(in)) != null) {
                    this.executeCommand(cmd);
                    continue;
                }
                this.printAvailableCommands();
            }
        }
        this.executeCommand(cmd);
    }
}

