/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment;

import com.sun.enterprise.deployment.ApplicationArchivist;
import com.sun.enterprise.deployment.ApplicationClientDescriptor;
import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.EjbBundleDescriptor;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.EjbReferenceDescriptor;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.security.acl.Role;
import com.sun.enterprise.security.acl.RoleMapper;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.util.NotificationEvent;
import com.sun.enterprise.util.NotificationListener;
import java.io.File;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;

public class Application
extends Descriptor
implements NotificationListener {
    private transient ApplicationArchivist applicationArchivist;
    private Set ejbBundleDescriptors = new HashSet();
    private Set webBundleDescriptors = new HashSet();
    private Set applicationClientDescriptors = new HashSet();
    private boolean isDirty;
    private RoleMapper roleMapper;
    private String serverName;
    private Set roles;
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(class$com$sun$enterprise$deployment$Application != null ? class$com$sun$enterprise$deployment$Application : (class$com$sun$enterprise$deployment$Application = Application.class$("com.sun.enterprise.deployment.Application")));
    static /* synthetic */ Class class$com$sun$enterprise$deployment$Application;

    public Application(String name, File jar) {
        super(name, localStrings.getLocalString("enterprise.deployment.application.description", "Application description"));
        this.applicationArchivist = new ApplicationArchivist(jar, this);
    }

    public void addApplication(Application application) {
        Iterator itr = application.getEjbBundleDescriptors().iterator();
        while (itr.hasNext()) {
            EjbBundleDescriptor ejbBundleDescriptor = (EjbBundleDescriptor)itr.next();
            this.addEjbBundleDescriptor(ejbBundleDescriptor);
        }
        Iterator itr2 = application.getWebBundleDescriptors().iterator();
        while (itr2.hasNext()) {
            WebBundleDescriptor webBundleDescriptor = (WebBundleDescriptor)itr2.next();
            this.addWebBundleDescriptor(webBundleDescriptor);
        }
        Iterator itr3 = application.getApplicationClientDescriptors().iterator();
        while (itr3.hasNext()) {
            ApplicationClientDescriptor acd = (ApplicationClientDescriptor)itr3.next();
            this.addApplicationClientDescriptor(acd);
        }
    }

    public void addApplicationClientDescriptor(ApplicationClientDescriptor applicationClientDescriptor) {
        this.getApplicationClientDescriptors().add(applicationClientDescriptor);
        applicationClientDescriptor.addNotificationListener(this);
        applicationClientDescriptor.setApplication(this);
        this.changed(true);
    }

    public void addEjbBundleDescriptor(EjbBundleDescriptor ejbBundleDescriptor) {
        this.getEjbBundleDescriptors().add(ejbBundleDescriptor);
        ejbBundleDescriptor.addNotificationListener(this);
        ejbBundleDescriptor.setApplication(this);
        this.changed(true);
    }

    public void addEjbJarFile(File ejbJarFile, Set libraryFiles) throws Exception {
        this.applicationArchivist.addEjbJar(ejbJarFile, libraryFiles);
        this.changed(true);
    }

    public void addRole(Role role) {
        this.getRoles().add(role);
        this.changed();
    }

    public void addWebBundleDescriptor(WebBundleDescriptor webBundleDescriptor) {
        webBundleDescriptor.addNotificationListener(this);
        webBundleDescriptor.setApplication(this);
        this.getWebBundleDescriptors().add(webBundleDescriptor);
        this.changed(true);
    }

    public void addWebJarFile(File ejbJarFile) throws Exception {
        this.applicationArchivist.addWebJar(ejbJarFile);
        this.changed(true);
    }

    public void changed() {
        NotificationEvent ne = new NotificationEvent(this, Descriptor.DESCRIPTOR_CHANGED, this);
        Vector listenersClone = null;
        Vector vector = this.listeners;
        synchronized (vector) {
            listenersClone = (Vector)this.listeners.clone();
        }
        Enumeration e10 = listenersClone.elements();
        while (e10.hasMoreElements()) {
            NotificationListener nl = (NotificationListener)e10.nextElement();
            nl.notification(ne);
        }
    }

    public void changed(boolean dirtyChange) {
        if (dirtyChange) {
            this.isDirty = true;
        }
        super.changed();
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    public void doneOpening() {
        this.isDirty = false;
        this.changed(false);
    }

    void doneSaving() {
        this.isDirty = false;
        this.changed(false);
    }

    public ApplicationArchivist getApplicationArchivist() {
        return this.applicationArchivist;
    }

    public ApplicationClientDescriptor getApplicationClientByName(String name) {
        Iterator itr = this.getApplicationClientDescriptors().iterator();
        while (itr.hasNext()) {
            ApplicationClientDescriptor next = (ApplicationClientDescriptor)itr.next();
            if (!next.getName().equals(name)) continue;
            return next;
        }
        throw new IllegalArgumentException(localStrings.getLocalString("enterprise.deployment.exceptionapphasnoappclientname", "This application has no application clients of name {0}", new Object[]{name}));
    }

    public Set getApplicationClientDescriptors() {
        if (this.applicationClientDescriptors == null) {
            this.applicationClientDescriptors = new HashSet();
        }
        return this.applicationClientDescriptors;
    }

    public Set getArchivableDescriptors() {
        HashSet archivableDescriptors = new HashSet();
        archivableDescriptors.addAll(this.getEjbBundleDescriptors());
        archivableDescriptors.addAll(this.getWebBundleDescriptors());
        archivableDescriptors.addAll(this.getApplicationClientDescriptors());
        return archivableDescriptors;
    }

    public Set getEjbBundleDescriptors() {
        if (this.ejbBundleDescriptors == null) {
            this.ejbBundleDescriptors = new HashSet();
        }
        return this.ejbBundleDescriptors;
    }

    public EjbDescriptor getEjbByName(String ejbName) {
        Object ejbDescriptor = null;
        Iterator itr = this.getEjbBundleDescriptors().iterator();
        while (itr.hasNext()) {
            EjbBundleDescriptor ejbBundleDescriptor = (EjbBundleDescriptor)itr.next();
            if (!ejbBundleDescriptor.hasEjbByName(ejbName)) continue;
            return ejbBundleDescriptor.getEjbByName(ejbName);
        }
        throw new IllegalArgumentException(localStrings.getLocalString("enterprise.deployment.exceptionapphasnobeannamed", "This application has no beans of name {0}", new Object[]{ejbName}));
    }

    public int getEjbComponentCount() {
        int count = 0;
        Iterator itr = this.getEjbBundleDescriptors().iterator();
        while (itr.hasNext()) {
            EjbBundleDescriptor ejbd = (EjbBundleDescriptor)itr.next();
            count += ejbd.getEjbs().size();
        }
        return count;
    }

    public Vector getEjbDescriptors() {
        Vector ejbDescriptors = new Vector();
        Iterator itr = this.getEjbBundleDescriptors().iterator();
        while (itr.hasNext()) {
            EjbBundleDescriptor ejbBundleDescriptor = (EjbBundleDescriptor)itr.next();
            ejbDescriptors.addAll(ejbBundleDescriptor.getEjbs());
        }
        return ejbDescriptors;
    }

    public Vector getEjbReferenceDescriptors() {
        Vector ejbReferenceDescriptors = new Vector();
        Iterator itr = this.getNamedDescriptors().iterator();
        while (itr.hasNext()) {
            Object next = itr.next();
            if (!(next instanceof EjbReferenceDescriptor)) continue;
            ejbReferenceDescriptors.addElement(next);
        }
        return ejbReferenceDescriptors;
    }

    public Set getJndiNameEnvironments() {
        HashSet jndiNameEnvironments = new HashSet();
        jndiNameEnvironments.addAll(this.getWebBundleDescriptors());
        jndiNameEnvironments.addAll(this.getApplicationClientDescriptors());
        jndiNameEnvironments.addAll(this.getEjbDescriptors());
        return jndiNameEnvironments;
    }

    public Set getNamedDescriptors() {
        HashSet namedDescriptors = new HashSet();
        Iterator itr = this.getEjbBundleDescriptors().iterator();
        while (itr.hasNext()) {
            EjbBundleDescriptor ejbBundleDescriptor = (EjbBundleDescriptor)itr.next();
            namedDescriptors.addAll(ejbBundleDescriptor.getNamedDescriptors());
        }
        Iterator itr2 = this.getWebBundleDescriptors().iterator();
        while (itr2.hasNext()) {
            WebBundleDescriptor webBundleDescriptor = (WebBundleDescriptor)itr2.next();
            namedDescriptors.addAll(webBundleDescriptor.getNamedDescriptors());
        }
        Iterator itr3 = this.getApplicationClientDescriptors().iterator();
        while (itr3.hasNext()) {
            ApplicationClientDescriptor applicationClientDescriptor = (ApplicationClientDescriptor)itr3.next();
            namedDescriptors.addAll(applicationClientDescriptor.getNamedDescriptors());
        }
        return namedDescriptors;
    }

    public Vector getNamedReferencePairs() {
        Vector pairs = new Vector();
        Iterator itr = this.getEjbBundleDescriptors().iterator();
        while (itr.hasNext()) {
            EjbBundleDescriptor ejbBundleDescriptor = (EjbBundleDescriptor)itr.next();
            pairs.addAll(ejbBundleDescriptor.getNamedReferencePairs());
        }
        Iterator itr2 = this.getWebBundleDescriptors().iterator();
        while (itr2.hasNext()) {
            WebBundleDescriptor webBundleDescriptor = (WebBundleDescriptor)itr2.next();
            pairs.addAll(webBundleDescriptor.getNamedReferencePairs());
        }
        Iterator itr3 = this.getApplicationClientDescriptors().iterator();
        while (itr3.hasNext()) {
            ApplicationClientDescriptor applicationClientDescriptor = (ApplicationClientDescriptor)itr3.next();
            pairs.addAll(applicationClientDescriptor.getNamedReferencePairs());
        }
        return pairs;
    }

    public Set getResourceReferenceDescriptors() {
        HashSet resourceReferences = new HashSet();
        Iterator itr = this.getEjbBundleDescriptors().iterator();
        while (itr.hasNext()) {
            EjbBundleDescriptor ejbd = (EjbBundleDescriptor)itr.next();
            resourceReferences.addAll(ejbd.getResourceReferenceDescriptors());
        }
        return resourceReferences;
    }

    public RoleMapper getRoleMapper() {
        if (this.roleMapper == null) {
            this.roleMapper = RoleMapper.getRoleMapper(this.getName());
        }
        return this.roleMapper;
    }

    public Set getRoles() {
        this.roles = new HashSet();
        Iterator itr = this.getWebBundleDescriptors().iterator();
        while (itr.hasNext()) {
            WebBundleDescriptor wbd = (WebBundleDescriptor)itr.next();
            this.roles.addAll(wbd.getRoles());
        }
        Iterator itr2 = this.getEjbBundleDescriptors().iterator();
        while (itr2.hasNext()) {
            EjbBundleDescriptor ejbd = (EjbBundleDescriptor)itr2.next();
            this.roles.addAll(ejbd.getRoles());
        }
        return this.roles;
    }

    public String getServerName() {
        if (this.serverName == null) {
            this.serverName = "";
        }
        return this.serverName;
    }

    public WebBundleDescriptor getWebBundleDescriptorByName(String name) {
        Iterator itr = this.getWebBundleDescriptors().iterator();
        while (itr.hasNext()) {
            WebBundleDescriptor next = (WebBundleDescriptor)itr.next();
            if (!next.getName().equals(name)) continue;
            return next;
        }
        throw new IllegalArgumentException(localStrings.getLocalString("enterprise.deployment.exceptionapphasnowebappname", "This application has no web app of name {0}", new Object[]{name}));
    }

    public Set getWebBundleDescriptors() {
        if (this.webBundleDescriptors == null) {
            this.webBundleDescriptors = new HashSet();
        }
        return this.webBundleDescriptors;
    }

    public int getWebComponentCount() {
        int count = 0;
        Iterator itr = this.getWebBundleDescriptors().iterator();
        while (itr.hasNext()) {
            WebBundleDescriptor wbd = (WebBundleDescriptor)itr.next();
            count += wbd.getWebDescriptors().size();
        }
        return count;
    }

    public boolean hasEjbByName(String ejbName) {
        Object ejbDescriptor = null;
        Iterator itr = this.getEjbBundleDescriptors().iterator();
        while (itr.hasNext()) {
            EjbBundleDescriptor ejbBundleDescriptor = (EjbBundleDescriptor)itr.next();
            if (!ejbBundleDescriptor.hasEjbByName(ejbName)) continue;
            return true;
        }
        return false;
    }

    public boolean hasRuntimeInformation() {
        return true;
    }

    public boolean isDirty() {
        return this.isDirty;
    }

    public void notification(NotificationEvent ne) {
        this.changed(true);
    }

    public void removeApplicationClientDescriptor(ApplicationClientDescriptor applicationClientDescriptor) {
        this.getApplicationClientDescriptors().remove(applicationClientDescriptor);
        applicationClientDescriptor.removeNotificationListener(this);
        applicationClientDescriptor.setApplication(null);
        this.changed(true);
    }

    public void removeEjbBundleDescriptor(EjbBundleDescriptor ejbBundleDescriptor) {
        this.getEjbBundleDescriptors().remove(ejbBundleDescriptor);
        ejbBundleDescriptor.removeNotificationListener(this);
        ejbBundleDescriptor.setApplication(null);
        this.changed(true);
    }

    private void removeRole(Role role) {
        this.getRoles().remove(role);
        this.changed();
    }

    public void removeWebBundleDescriptor(WebBundleDescriptor webBundleDescriptor) {
        webBundleDescriptor.removeNotificationListener(this);
        webBundleDescriptor.setApplication(null);
        this.getWebBundleDescriptors().remove(webBundleDescriptor);
        this.changed(true);
    }

    void setApplicationArchivist(ApplicationArchivist applicationArchivist) {
        this.applicationArchivist = applicationArchivist;
    }

    public void setName(String name) {
        name = name.replace('/', '-');
        name = name.replace('\\', '-');
        this.getRoleMapper().setName(name);
        super.setName(name);
    }

    public void setRoleMapper(RoleMapper roleMapper) {
        this.roleMapper = roleMapper;
        this.changed(true);
    }

    public void setServerName(String serverName) {
        this.serverName = serverName;
        this.changed();
    }

    public String toString() {
        String s2 = "Application";
        s2 = String.valueOf(s2) + "\n name " + this.getName();
        s2 = String.valueOf(s2) + "\n smallIcon " + super.getSmallIconUri();
        s2 = String.valueOf(s2) + "\n archivist " + this.getApplicationArchivist();
        s2 = String.valueOf(s2) + "\n EjbBundles: \n" + this.getEjbBundleDescriptors();
        s2 = String.valueOf(s2) + "\n WebBundleDescriptors " + this.getWebBundleDescriptors();
        s2 = String.valueOf(s2) + "\n applicationClientDescriptors " + this.getApplicationClientDescriptors();
        s2 = String.valueOf(s2) + "\n serverName " + this.serverName;
        s2 = String.valueOf(s2) + "\n roles " + this.roles;
        s2 = String.valueOf(s2) + "\n RoleMapper " + this.getRoleMapper();
        return s2;
    }
}

