/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment;

import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.ApplicationClientArchivist;
import com.sun.enterprise.deployment.ApplicationClientDescriptor;
import com.sun.enterprise.deployment.ArchiveException;
import com.sun.enterprise.deployment.Archivist;
import com.sun.enterprise.deployment.BundleDescriptor;
import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.EjbBundleArchivist;
import com.sun.enterprise.deployment.EjbBundleDescriptor;
import com.sun.enterprise.deployment.WebBundleArchivist;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.deployment.xml.ApplicationNode;
import com.sun.enterprise.deployment.xml.EjbBundleNode;
import com.sun.enterprise.deployment.xml.RuntimeDescriptorNode;
import com.sun.enterprise.util.FileClassLoader;
import com.sun.enterprise.util.FileUtil;
import com.sun.enterprise.util.JarClassLoader;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipOutputStream;

public class ApplicationArchivist
extends Archivist {
    public static final String DEPLOYMENT_DESCRIPTOR_ENTRY = "META-INF/application.xml";
    public static final String RI_SPECIFIC_DESCRIPTOR_ENTRY = "META-INF/sun-j2ee-ri.xml";
    private File applicationFile = null;
    private ClassLoader classLoader;
    private Application application;
    private static boolean makeClassLoadable = false;
    private static boolean saveApplicationClientRuntime = true;
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(class$com$sun$enterprise$deployment$ApplicationArchivist != null ? class$com$sun$enterprise$deployment$ApplicationArchivist : (class$com$sun$enterprise$deployment$ApplicationArchivist = ApplicationArchivist.class$("com.sun.enterprise.deployment.ApplicationArchivist")));
    static /* synthetic */ Class class$com$sun$enterprise$deployment$ApplicationArchivist;

    ApplicationArchivist(File applicationFile, Application application) {
        this.applicationFile = applicationFile;
        this.application = application;
    }

    public void add16Icon(BundleDescriptor container, Descriptor component, File iconFile) throws IOException {
        this.addIcon(container, component, iconFile, true);
    }

    public void add16Icon(File iconFile) throws IOException {
        this.addIcon(iconFile, true);
    }

    public void add32Icon(BundleDescriptor container, Descriptor component, File iconFile) throws IOException {
        this.addIcon(container, component, iconFile, false);
    }

    public void add32Icon(File iconFile) throws IOException {
        this.addIcon(iconFile, false);
    }

    public ApplicationClientDescriptor addApplicationClientJar(File appClientJarFile, Set libraryJars) throws IOException, ArchiveException {
        return this.addApplicationClientJar(appClientJarFile, libraryJars, null);
    }

    public ApplicationClientDescriptor addApplicationClientJar(File appClientJarFile, Set libraryJars, String externalDescriptorEntry) throws IOException, ArchiveException {
        ApplicationClientDescriptor descriptor = ApplicationClientArchivist.open(appClientJarFile);
        String acArchiveName = super.getUniqueEntryNameFor(this.getApplicationFile(), appClientJarFile.getName());
        ApplicationClientArchivist acArchivist = (ApplicationClientArchivist)descriptor.getArchivist();
        acArchivist.setArchiveUri(acArchiveName);
        if (externalDescriptorEntry != null && !"".equals(externalDescriptorEntry)) {
            acArchivist.setExternalDescriptorArchiveUri(externalDescriptorEntry);
        }
        if (!libraryJars.isEmpty()) {
            Hashtable libraryJarMap = this.createLibraryJarHashtable(libraryJars);
            libraryJarMap = super.addFiles(libraryJarMap, this.getApplicationFile());
            Enumeration e10 = libraryJarMap.keys();
            while (e10.hasMoreElements()) {
                Object key = e10.nextElement();
                String libUri = (String)libraryJarMap.get(key);
                acArchivist.addManfiestClasspath(libUri);
            }
            acArchivist.save(acArchivist.getApplicationClientJarFile(), true);
        }
        File scratchFile = Archivist.createTempFile(this.getApplicationDirectory());
        JarFile applicationJar = new JarFile(this.getApplicationFile());
        FileOutputStream fos = new FileOutputStream(scratchFile);
        ZipOutputStream outZipStream = new ZipOutputStream(fos);
        Vector<String> entriesNotToAdd = new Vector<String>();
        entriesNotToAdd.addElement(DEPLOYMENT_DESCRIPTOR_ENTRY);
        entriesNotToAdd.addElement("META-INF/MANIFEST.MF");
        entriesNotToAdd.addElement(RI_SPECIFIC_DESCRIPTOR_ENTRY);
        Archivist.addJarToOutput(outZipStream, applicationJar, entriesNotToAdd);
        FileInputStream fis = new FileInputStream(appClientJarFile);
        ZipEntry acJarEntry = new ZipEntry(acArchiveName);
        outZipStream.putNextEntry(acJarEntry);
        Archivist.copy(fis, outZipStream);
        fis.close();
        applicationJar.close();
        this.getApplicationFile().delete();
        Manifest manifest = new Manifest();
        ApplicationArchivist.writeManifest(manifest, outZipStream);
        this.application.addApplicationClientDescriptor(descriptor);
        this.writeApplicationDeploymentInfo(outZipStream, true);
        outZipStream.close();
        fos.close();
        if (!scratchFile.renameTo(this.getApplicationFile())) {
            System.out.println(localStrings.getLocalString("enterprise.deployment.errorrenamingjar", "Error renaming JAR"));
            this.setClassLoader(null);
        }
        this.application.changed();
        return descriptor;
    }

    public void addApplicationJar(File applicationJarFile) throws IOException, ArchiveException {
        Application applicationToAdd = ApplicationArchivist.open(applicationJarFile);
        File scratchFile = Archivist.createTempFile(this.getApplicationDirectory());
        FileOutputStream fos = new FileOutputStream(scratchFile);
        ZipOutputStream outZipStream = new ZipOutputStream(fos);
        Vector<String> entriesNotToAdd = new Vector<String>();
        entriesNotToAdd.addElement(DEPLOYMENT_DESCRIPTOR_ENTRY);
        entriesNotToAdd.addElement("META-INF/MANIFEST.MF");
        entriesNotToAdd.addElement(RI_SPECIFIC_DESCRIPTOR_ENTRY);
        JarFile thisJar = new JarFile(this.getApplicationFile());
        Archivist.addJarToOutput(outZipStream, thisJar, entriesNotToAdd);
        thisJar.close();
        JarFile thatJar = new JarFile(applicationJarFile);
        Archivist.addJarToOutput(outZipStream, thatJar, entriesNotToAdd);
        thatJar.close();
        this.application.addApplication(applicationToAdd);
        Manifest manifest = new Manifest();
        ApplicationArchivist.writeManifest(manifest, outZipStream);
        this.writeApplicationDeploymentInfo(outZipStream, true);
        outZipStream.close();
        fos.close();
        this.getApplicationFile().delete();
        if (!scratchFile.renameTo(this.getApplicationFile())) {
            System.out.println(localStrings.getLocalString("enterprise.deployment.errorrenamingjarfiletoappfile", "Error renaming JAR {0} to {1}", new Object[]{scratchFile, this.getApplicationFile()}));
        }
        this.setClassLoader(null);
        this.application.changed();
    }

    public EjbBundleDescriptor addEjbJar(File ejbJarFile, Set libraryJars) throws IOException, ArchiveException {
        return this.addEjbJar(ejbJarFile, libraryJars, null);
    }

    public EjbBundleDescriptor addEjbJar(File ejbJarFile, Set libraryJars, String externalDescriptorEntryName) throws IOException, ArchiveException {
        EjbBundleDescriptor ejbBundleDescriptor = EjbBundleArchivist.open(ejbJarFile);
        String ejbJarEntryName = super.getUniqueEntryNameFor(this.getApplicationFile(), ejbJarFile.getName());
        EjbBundleArchivist ejbArchivist = (EjbBundleArchivist)ejbBundleDescriptor.getArchivist();
        ejbArchivist.setArchiveUri(ejbJarEntryName);
        if (!libraryJars.isEmpty()) {
            Hashtable libraryJarMap = this.createLibraryJarHashtable(libraryJars);
            libraryJarMap = super.addFiles(libraryJarMap, this.getApplicationFile());
            Enumeration e10 = libraryJarMap.keys();
            while (e10.hasMoreElements()) {
                Object key = e10.nextElement();
                String libUri = (String)libraryJarMap.get(key);
                ejbArchivist.addManfiestClasspath(libUri);
            }
            ejbArchivist.save(ejbArchivist.getEjbJarFile());
        }
        if (externalDescriptorEntryName != null && !"".equals(externalDescriptorEntryName)) {
            ejbArchivist.setExternalDescriptorArchiveUri(externalDescriptorEntryName);
        }
        File scratchFile = Archivist.createTempFile(this.getApplicationDirectory());
        JarFile applicationJar = new JarFile(this.getApplicationFile());
        FileOutputStream fos = new FileOutputStream(scratchFile);
        ZipOutputStream outZipStream = new ZipOutputStream(fos);
        Vector<String> entriesNotToAdd = new Vector<String>();
        entriesNotToAdd.addElement(DEPLOYMENT_DESCRIPTOR_ENTRY);
        entriesNotToAdd.addElement("META-INF/MANIFEST.MF");
        entriesNotToAdd.addElement(RI_SPECIFIC_DESCRIPTOR_ENTRY);
        Archivist.addJarToOutput(outZipStream, applicationJar, entriesNotToAdd);
        FileInputStream fis = new FileInputStream(ejbJarFile);
        ZipEntry ejbJarEntry = new ZipEntry(ejbJarEntryName);
        outZipStream.putNextEntry(ejbJarEntry);
        Archivist.copy(fis, outZipStream);
        fis.close();
        applicationJar.close();
        this.getApplicationFile().delete();
        Manifest manifest = new Manifest();
        ApplicationArchivist.writeManifest(manifest, outZipStream);
        this.application.addEjbBundleDescriptor(ejbBundleDescriptor);
        this.writeApplicationDeploymentInfo(outZipStream, true);
        outZipStream.close();
        fos.close();
        this.getApplicationFile().delete();
        this.setClassLoader(null);
        if (!scratchFile.renameTo(this.getApplicationFile())) {
            System.out.println(localStrings.getLocalString("enterprise.deployment.errorrenamingjar", "Error renaming JAR"));
        }
        this.application.changed();
        return ejbBundleDescriptor;
    }

    public void addEjbJarToEjbJar(File ejbJarFileToAdd, Set libraryJars, EjbBundleDescriptor ejbBundleDescriptor) throws IOException, ArchiveException {
        if (ejbBundleDescriptor.getApplication() != this.application) {
            System.out.println(libraryJars);
            throw new ArchiveException(localStrings.getLocalString("enterprise.deployment.exceptioncannotaddtoejebjar", "cannot add to an ejb JAR not container in this application"));
        }
        File ejbTarget = File.createTempFile("ejbjar", "ejbjar");
        this.extractBundleToFile(ejbBundleDescriptor, ejbTarget);
        EjbBundleDescriptor copyOfTarget = EjbBundleArchivist.open(ejbTarget);
        EjbBundleArchivist copyArchivist = (EjbBundleArchivist)copyOfTarget.getArchivist();
        copyArchivist.addEjbJar(ejbJarFileToAdd);
        copyArchivist.save(ejbTarget);
        this.removeBundleDescriptor(ejbBundleDescriptor);
        this.addEjbJar(ejbTarget, libraryJars);
        ejbTarget.delete();
        this.save(this.getApplicationFile(), true);
        this.application.changed();
    }

    private void addIcon(BundleDescriptor container, Descriptor component, File iconFile, boolean small) throws IOException {
        try {
            File bundleFile = File.createTempFile("bundle", "bundle");
            String bundleEntryName = container.getArchivist().getArchiveUri();
            this.extractBundleToFile(container, bundleFile);
            String trialEntryName = iconFile.getName();
            Vector otherEntries = this.getEntryNamesFrom(bundleFile);
            String oldEntryName = "";
            if (small) {
                otherEntries.removeElement(component.getSmallIconUri());
                oldEntryName = component.getSmallIconUri();
            } else {
                otherEntries.removeElement(component.getLargeIconUri());
                oldEntryName = component.getLargeIconUri();
            }
            String entryName = Descriptor.createUniqueNameAmongst(trialEntryName, otherEntries);
            this.replaceEntry(bundleFile, oldEntryName, entryName, iconFile);
            this.replaceEntry(this.getApplicationFile(), bundleEntryName, bundleEntryName, bundleFile);
            if (small) {
                component.setSmallIconUri(entryName);
            } else {
                component.setLargeIconUri(entryName);
            }
            this.save(this.getApplicationFile(), true);
        }
        catch (Throwable throwable) {
            System.out.println("There was an error adding the icon");
        }
    }

    private void addIcon(File iconFile, boolean small) throws IOException {
        Vector names = this.getEntryNamesFrom(this.getApplicationFile());
        Hashtable<File, String> ht = new Hashtable<File, String>();
        String iconName = Descriptor.createUniqueNameAmongst(iconFile.getName(), names);
        ht.put(iconFile, iconName);
        String existingIcon = null;
        existingIcon = small ? this.application.getSmallIconUri() : this.application.getLargeIconUri();
        if (!"".equals(existingIcon)) {
            HashSet<String> entries = new HashSet<String>();
            entries.add(existingIcon);
            super.removeEntries(entries, this.getApplicationFile());
        }
        super.addFiles(ht, this.getApplicationFile());
        if (small) {
            this.application.setSmallIconUri(iconName);
        } else {
            this.application.setLargeIconUri(iconName);
        }
    }

    public void addLibraryJar(File jarFile) throws IOException {
        Hashtable ht = new Hashtable();
        ht.put(jarFile, "library/" + jarFile.getName());
        ht = super.addFiles(ht, this.getApplicationFile());
        String libraryEntryName = (String)ht.get(ht.keys().nextElement());
        HashSet allJarBundleDescriptors = new HashSet();
        allJarBundleDescriptors.addAll(this.application.getEjbBundleDescriptors());
        allJarBundleDescriptors.addAll(this.application.getApplicationClientDescriptors());
        Iterator itr = allJarBundleDescriptors.iterator();
        while (itr.hasNext()) {
            BundleDescriptor next = (BundleDescriptor)itr.next();
            next.getArchivist().addManfiestClasspath(libraryEntryName);
        }
        this.save(this.getApplicationFile(), true);
    }

    public void addWebJar(File webJarFile) throws IOException, ArchiveException {
        this.addWebJar(webJarFile, null);
    }

    public void addWebJar(File webJarFile, String externalDescriptorEntryName) throws IOException, ArchiveException {
        WebBundleDescriptor webBundleDescriptor = WebBundleArchivist.open(webJarFile);
        String webJarEntryName = super.getUniqueEntryNameFor(this.getApplicationFile(), webJarFile.getName());
        Archivist webArchivist = webBundleDescriptor.getArchivist();
        webArchivist.setArchiveUri(webJarEntryName);
        if (externalDescriptorEntryName != null && !"".equals(externalDescriptorEntryName)) {
            webArchivist.setExternalDescriptorArchiveUri(externalDescriptorEntryName);
        }
        File scratchFile = Archivist.createTempFile(this.getApplicationDirectory());
        JarFile applicationJar = new JarFile(this.getApplicationFile());
        FileOutputStream fos = new FileOutputStream(scratchFile);
        ZipOutputStream outZipStream = new ZipOutputStream(fos);
        Vector<String> entriesNotToAdd = new Vector<String>();
        entriesNotToAdd.addElement(DEPLOYMENT_DESCRIPTOR_ENTRY);
        entriesNotToAdd.addElement("META-INF/MANIFEST.MF");
        entriesNotToAdd.addElement(RI_SPECIFIC_DESCRIPTOR_ENTRY);
        Archivist.addJarToOutput(outZipStream, applicationJar, entriesNotToAdd);
        FileInputStream fis = new FileInputStream(webJarFile);
        ZipEntry webJarEntry = new ZipEntry(webJarEntryName);
        outZipStream.putNextEntry(webJarEntry);
        Archivist.copy(fis, outZipStream);
        fis.close();
        applicationJar.close();
        this.getApplicationFile().delete();
        Manifest manifest = new Manifest();
        ApplicationArchivist.writeManifest(manifest, outZipStream);
        this.application.addWebBundleDescriptor(webBundleDescriptor);
        this.writeApplicationDeploymentInfo(outZipStream, true);
        outZipStream.close();
        fos.close();
        this.getApplicationFile().delete();
        if (!scratchFile.renameTo(this.getApplicationFile())) {
            System.out.println(localStrings.getLocalString("enterprise.deployment.errorrenamingjar", "Error renaming JAR"));
            this.setClassLoader(null);
        }
        this.application.changed();
    }

    public void addWebJarToWebJar(File webJarFileToAdd, WebBundleDescriptor webBundleDescriptor) throws IOException, ArchiveException {
        if (webBundleDescriptor.getApplication() != this.application) {
            throw new ArchiveException("cannot add to an web WAR not contained in this application");
        }
        File webTarget = File.createTempFile("war", "war");
        this.extractBundleToFile(webBundleDescriptor, webTarget);
        WebBundleDescriptor copyOfTarget = WebBundleArchivist.open(webTarget);
        WebBundleArchivist copyArchivist = (WebBundleArchivist)copyOfTarget.getArchivist();
        copyArchivist.addWebJar(webJarFileToAdd);
        copyArchivist.save(webTarget);
        this.removeBundleDescriptor(webBundleDescriptor);
        this.addWebJar(webTarget);
        webTarget.delete();
        this.save(this.getApplicationFile(), true);
        this.application.changed();
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    public Manifest createApplicationManifest() {
        Manifest m2 = new Manifest();
        return m2;
    }

    private Hashtable createLibraryJarHashtable(Set libraryJars) {
        Hashtable<File, String> ht = new Hashtable<File, String>();
        Iterator itr = libraryJars.iterator();
        while (itr.hasNext()) {
            File next = (File)itr.next();
            ht.put(next, "library/" + next.getName());
        }
        return ht;
    }

    private void extractApplicationClientJar(ApplicationClientDescriptor descriptor, File filename) throws IOException {
        this.extractBundleToFile(descriptor, filename);
    }

    public void extractBundleToFile(BundleDescriptor descriptor, File filename) throws IOException {
        Archivist archivist = descriptor.getArchivist();
        JarFile applicationJar = new JarFile(this.getApplicationFile());
        ApplicationArchivist.extractJar(archivist.getArchiveUri(), applicationJar, filename);
        applicationJar.close();
    }

    String extractClassloadableSubJarsTo(File directory, String classesSubdirectory, JarClassLoader jcl) throws IOException {
        JarFile jar = new JarFile(this.getApplicationFile());
        File base = new File(directory, classesSubdirectory);
        HashSet<String> classLoadableEntries = new HashSet<String>();
        Iterator itr = this.application.getEjbBundleDescriptors().iterator();
        while (itr.hasNext()) {
            EjbBundleDescriptor ejbBundleDescriptor = (EjbBundleDescriptor)itr.next();
            Archivist archivist = ejbBundleDescriptor.getArchivist();
            Iterator itrr = archivist.getManifestClasspaths().iterator();
            while (itrr.hasNext()) {
                String next = (String)itrr.next();
                classLoadableEntries.add(next);
            }
            String entryName = archivist.getArchiveUri();
            classLoadableEntries.add(entryName);
        }
        Iterator itr2 = classLoadableEntries.iterator();
        while (itr2.hasNext()) {
            String entryName = (String)itr2.next();
            String filename = entryName.replace('/', File.separatorChar);
            File extractedJar = new File(directory, filename);
            extractedJar.deleteOnExit();
            ApplicationArchivist.extractJar(entryName, jar, extractedJar);
            Archivist.extractJarFile(extractedJar, base);
            jcl.addJar(base.getAbsolutePath());
        }
        jar.close();
        return base.getAbsolutePath();
    }

    private void extractEjbJar(EjbBundleDescriptor ejbBundleDescriptor, File filename) throws IOException {
        this.extractBundleToFile(ejbBundleDescriptor, filename);
    }

    private static void extractJar(String archiveUri, JarFile applicationJar, File filename) throws IOException {
        String fullFilename = filename.getAbsolutePath();
        String parent = new File(fullFilename).getParent();
        new File(parent).mkdirs();
        ZipEntry ejbBundleEntry = applicationJar.getEntry(archiveUri);
        if (ejbBundleEntry == null) {
            throw new IOException(localStrings.getLocalString("enterprise.deployment.exceptionarchiveurinotfoundinappjar", "{0} not found in {1}", new Object[]{archiveUri, applicationJar.getName()}));
        }
        InputStream is = applicationJar.getInputStream(ejbBundleEntry);
        FileOutputStream fos = new FileOutputStream(filename);
        Archivist.copy(is, fos);
        is.close();
        fos.close();
    }

    private void extractWebJar(WebBundleDescriptor webBundleDescriptor, File filename) throws IOException {
        this.extractBundleToFile(webBundleDescriptor, filename);
    }

    private File getApplicationDirectory() {
        return Archivist.getDirectory(this.getApplicationFile());
    }

    public File getApplicationFile() {
        return this.applicationFile;
    }

    public ClassLoader getClassLoader() {
        if (this.classLoader == null) {
            try {
                JarClassLoader jcl = new JarClassLoader();
                if (makeClassLoadable) {
                    jcl.addJar(this.getApplicationFile().toString());
                    this.classLoader = jcl;
                } else {
                    File classesDir = new File(FileUtil.getTempDirectory(), this.application.getName());
                    String dir = this.extractClassloadableSubJarsTo(classesDir, "ejbJars", jcl);
                    this.classLoader = new FileClassLoader(dir);
                }
            }
            catch (Exception e10) {
                e10.printStackTrace();
                throw new RuntimeException(localStrings.getLocalString("enterprise.deployment.exceptionclassloadercouldnotbemade", "Class loader could not be made"));
            }
        }
        return this.classLoader;
    }

    public Set getLibraryJarUris() {
        HashSet libraryJarUris = new HashSet();
        Iterator itr = this.application.getEjbBundleDescriptors().iterator();
        while (itr.hasNext()) {
            EjbBundleDescriptor bd2 = (EjbBundleDescriptor)itr.next();
            libraryJarUris.addAll(bd2.getArchivist().getManifestClasspaths());
        }
        Iterator itr2 = this.application.getApplicationClientDescriptors().iterator();
        while (itr2.hasNext()) {
            ApplicationClientDescriptor acd = (ApplicationClientDescriptor)itr2.next();
            libraryJarUris.addAll(acd.getArchivist().getManifestClasspaths());
        }
        return libraryJarUris;
    }

    public static boolean isApplication(File jarFile) throws IOException {
        Archivist.checkExists(jarFile);
        JarFile jar = new JarFile(jarFile);
        ZipEntry ze = jar.getEntry(DEPLOYMENT_DESCRIPTOR_ENTRY);
        boolean isApplication = ze != null;
        jar.close();
        return isApplication;
    }

    public static Application open(File jarFile) throws IOException, ArchiveException {
        if (!jarFile.exists()) {
            throw new IOException(localStrings.getLocalString("enterprise.deployment.exceptionjarfiledoesn'texist", "{0} does not exist", new Object[]{jarFile}));
        }
        JarFile jar = new JarFile(jarFile);
        ZipEntry deploymentEntry = jar.getEntry(DEPLOYMENT_DESCRIPTOR_ENTRY);
        if (deploymentEntry != null) {
            InputStream fis = jar.getInputStream(deploymentEntry);
            ApplicationNode node = ApplicationNode.read(fis);
            fis.close();
            Application application = node.getApplication(null);
            ApplicationArchivist applicationArchivist = new ApplicationArchivist(jarFile, application);
            application.setApplicationArchivist(applicationArchivist);
            Enumeration e10 = node.getEjbBundleArchiveMap().keys();
            while (e10.hasMoreElements()) {
                String archiveEntryName = (String)e10.nextElement();
                String alternativeDescriptorEntryName = (String)node.getEjbBundleArchiveMap().get(archiveEntryName);
                File temp = Archivist.getEjbTemp(Archivist.getDirectory(jarFile));
                ApplicationArchivist.extractJar(archiveEntryName, jar, temp);
                EjbBundleDescriptor ejbBundleDescriptor = null;
                if ("".equals(alternativeDescriptorEntryName)) {
                    ejbBundleDescriptor = EjbBundleArchivist.open(temp);
                } else {
                    ejbBundleDescriptor = EjbBundleArchivist.open(temp, alternativeDescriptorEntryName, jar);
                    ejbBundleDescriptor.getArchivist().setExternalDescriptorArchiveUri(alternativeDescriptorEntryName);
                }
                temp.delete();
                ejbBundleDescriptor.getArchivist().setArchiveUri(archiveEntryName);
                application.addEjbBundleDescriptor(ejbBundleDescriptor);
            }
            Enumeration e11 = node.getWebBundleArchiveMap().keys();
            while (e11.hasMoreElements()) {
                String archiveEntryName = (String)e11.nextElement();
                String alternativeDescriptorEntryName = (String)node.getWebBundleArchiveMap().get(archiveEntryName);
                File temp = Archivist.getWebTemp(Archivist.getDirectory(jarFile));
                ApplicationArchivist.extractJar(archiveEntryName, jar, temp);
                WebBundleDescriptor webBundleDescriptor = null;
                if ("".equals(alternativeDescriptorEntryName)) {
                    webBundleDescriptor = WebBundleArchivist.open(temp);
                } else {
                    webBundleDescriptor = WebBundleArchivist.open(temp, alternativeDescriptorEntryName, jar);
                    webBundleDescriptor.getArchivist().setExternalDescriptorArchiveUri(alternativeDescriptorEntryName);
                }
                temp.delete();
                webBundleDescriptor.getArchivist().setArchiveUri(archiveEntryName);
                String contextRoot = node.getContextRootFor(archiveEntryName);
                webBundleDescriptor.setContextRoot(contextRoot);
                application.addWebBundleDescriptor(webBundleDescriptor);
            }
            Enumeration e12 = node.getApplicationClientDescriptorArchiveMap().keys();
            while (e12.hasMoreElements()) {
                String archiveEntryName = (String)e12.nextElement();
                String alternativeDescriptorEntryName = (String)node.getApplicationClientDescriptorArchiveMap().get(archiveEntryName);
                File temp = Archivist.getApplicationClientTemp(Archivist.getDirectory(jarFile));
                ApplicationArchivist.extractJar(archiveEntryName, jar, temp);
                ApplicationClientDescriptor applicationClientDescriptor = null;
                if ("".equals(alternativeDescriptorEntryName)) {
                    applicationClientDescriptor = ApplicationClientArchivist.open(temp);
                } else {
                    applicationClientDescriptor = ApplicationClientArchivist.open(temp, alternativeDescriptorEntryName, jar);
                    applicationClientDescriptor.getArchivist().setExternalDescriptorArchiveUri(alternativeDescriptorEntryName);
                }
                temp.delete();
                applicationClientDescriptor.getArchivist().setArchiveUri(archiveEntryName);
                application.addApplicationClientDescriptor(applicationClientDescriptor);
            }
            ZipEntry runtimeDescriptorEntry = jar.getEntry(RI_SPECIFIC_DESCRIPTOR_ENTRY);
            if (runtimeDescriptorEntry != null) {
                fis = jar.getInputStream(runtimeDescriptorEntry);
                RuntimeDescriptorNode rdn = RuntimeDescriptorNode.read(fis);
                fis.close();
                rdn.updateRuntimeInformation(application);
            }
            ApplicationNode.resolveInterJarEjbReferences(application);
            jar.close();
            return application;
        }
        jar.close();
        throw new IOException(localStrings.getLocalString("enterprise.deployment.exceptionnodeploymentinfofound", "No deployment info found - invalid format"));
    }

    public static Application readApplicationFromXmlFiles(String xmlFilename) throws IOException, ArchiveException {
        FileInputStream fis = new FileInputStream(new File(xmlFilename));
        ApplicationNode applicationNode = ApplicationNode.read(fis);
        Application application = applicationNode.getApplication(null);
        fis.close();
        Enumeration e10 = applicationNode.getEjbBundleArchiveMap().keys();
        while (e10.hasMoreElements()) {
            String ejbBundleFilename = (String)e10.nextElement();
            fis = new FileInputStream(new File(ejbBundleFilename));
            EjbBundleNode ejbBundleNode = EjbBundleNode.read(fis);
            EjbBundleDescriptor bundleDescriptor = ejbBundleNode.getDescriptor();
            application.addEjbBundleDescriptor(bundleDescriptor);
            fis.close();
        }
        return application;
    }

    public void removeBundleDescriptor(BundleDescriptor bundleDescriptor) throws IOException {
        Archivist archivist = bundleDescriptor.getArchivist();
        String entryName = archivist.getArchiveUri();
        if (bundleDescriptor instanceof EjbBundleDescriptor) {
            this.application.removeEjbBundleDescriptor((EjbBundleDescriptor)bundleDescriptor);
        } else if (bundleDescriptor instanceof WebBundleDescriptor) {
            this.application.removeWebBundleDescriptor((WebBundleDescriptor)bundleDescriptor);
        } else if (bundleDescriptor instanceof ApplicationClientDescriptor) {
            this.application.removeApplicationClientDescriptor((ApplicationClientDescriptor)bundleDescriptor);
        } else {
            throw new RuntimeException(localStrings.getLocalString("enterprise.deployment.exceptionbundledescriptorunknowntype", "{0} is an unknown type for removing", new Object[]{bundleDescriptor}));
        }
        File scratchFile = Archivist.createTempFile(this.getApplicationDirectory());
        JarFile applicationJar = new JarFile(this.getApplicationFile());
        FileOutputStream fos = new FileOutputStream(scratchFile);
        ZipOutputStream outZipStream = new ZipOutputStream(fos);
        Vector<String> entriesNotToAdd = new Vector<String>();
        entriesNotToAdd.addElement(DEPLOYMENT_DESCRIPTOR_ENTRY);
        entriesNotToAdd.addElement("META-INF/MANIFEST.MF");
        entriesNotToAdd.addElement(RI_SPECIFIC_DESCRIPTOR_ENTRY);
        entriesNotToAdd.addElement(entryName);
        Archivist.addJarToOutput(outZipStream, applicationJar, entriesNotToAdd);
        applicationJar.close();
        this.getApplicationFile().delete();
        Manifest manifest = new Manifest();
        ApplicationArchivist.writeManifest(manifest, outZipStream);
        this.writeApplicationDeploymentInfo(outZipStream, true);
        outZipStream.close();
        fos.close();
        this.getApplicationFile().delete();
        if (!scratchFile.renameTo(this.getApplicationFile())) {
            System.out.println(localStrings.getLocalString("enterprise.deployment.errorrenamingjar", "Error renaming JAR"));
            this.setClassLoader(null);
        }
        this.application.changed();
    }

    private void replaceEntry(File archive, String oldEntryName, String entryName, File entryContents) throws IOException {
        JarFile jf = new JarFile(archive);
        File tmpFile = Archivist.createTempFile(Archivist.getDirectory(archive));
        ZipOutputStream zos = new ZipOutputStream(new FileOutputStream(tmpFile));
        ZipEntry ze = new ZipEntry(entryName);
        zos.putNextEntry(ze);
        FileInputStream fis = new FileInputStream(entryContents);
        Archivist.copy(fis, zos);
        zos.closeEntry();
        fis.close();
        Vector<String> notToAdd = new Vector<String>();
        notToAdd.add(oldEntryName);
        Archivist.addJarToOutput(zos, jf, notToAdd);
        archive.delete();
        zos.close();
        boolean b10 = tmpFile.renameTo(archive);
        if (!b10) {
            throw new IOException("Renaming " + tmpFile + " to " + archive + " failed");
        }
    }

    public void save(File destinationFile, boolean saveRuntimeInfo) throws IOException {
        File tmpFile = Archivist.createTempFile(Archivist.getDirectory(destinationFile));
        ZipOutputStream zos = new ZipOutputStream(new FileOutputStream(tmpFile));
        JarFile existingApplicationJar = null;
        if (this.getApplicationFile().exists()) {
            File temp;
            existingApplicationJar = new JarFile(this.getApplicationFile());
            Iterator itr = this.application.getEjbBundleDescriptors().iterator();
            while (itr.hasNext()) {
                EjbBundleDescriptor ejbBundleDescriptor = (EjbBundleDescriptor)itr.next();
                EjbBundleArchivist oldArchivist = (EjbBundleArchivist)ejbBundleDescriptor.getArchivist();
                File temp2 = Archivist.getEjbTemp(this.getApplicationDirectory());
                String ejbBundleEntryName = ejbBundleDescriptor.getArchivist().getArchiveUri();
                ApplicationArchivist.extractJar(ejbBundleEntryName, existingApplicationJar, temp2);
                EjbBundleArchivist archivist = new EjbBundleArchivist(temp2.toString(), ejbBundleDescriptor, oldArchivist.getManifestClasspaths());
                ejbBundleDescriptor.setApplication(null);
                if (oldArchivist.hasExternalDescriptor()) {
                    archivist.save(temp2, oldArchivist.getExternalDescriptorArchiveUri(), zos);
                } else {
                    archivist.save(temp2);
                }
                ejbBundleDescriptor.setArchivist(oldArchivist);
                ejbBundleDescriptor.setApplication(this.application);
                FileInputStream ejbJarInput = new FileInputStream(temp2);
                zos.putNextEntry(new ZipEntry(ejbBundleEntryName));
                Archivist.copy(ejbJarInput, zos);
                zos.closeEntry();
                ((InputStream)ejbJarInput).close();
                if (makeClassLoadable) {
                    System.out.println(localStrings.getLocalString("enterprise.deployment.classsave", "Class loadable save"));
                    Vector<String> ejbEntryNamesToSkip = new Vector<String>();
                    ejbEntryNamesToSkip.addElement("META-INF/MANIFEST.MF");
                    ejbEntryNamesToSkip.addElement(EjbBundleArchivist.DEPLOYMENT_DESCRIPTOR_ENTRY);
                    Archivist.addJarToOutput(zos, new JarFile(temp2), ejbEntryNamesToSkip);
                    String ejbClientJarUri = ejbBundleDescriptor.getEjbClientJarUri();
                    if (!"".equals(ejbClientJarUri)) {
                        JarFile ejbJar = new JarFile(temp2);
                        ZipEntry clientJarEntry = ejbJar.getEntry(ejbClientJarUri);
                        if (clientJarEntry != null) {
                            InputStream clientIs = ejbJar.getInputStream(clientJarEntry);
                            File clientJarTemp = Archivist.getEjbTemp(this.getApplicationDirectory());
                            FileOutputStream clientFos = new FileOutputStream(clientJarTemp);
                            Archivist.copy(clientIs, clientFos);
                            clientFos.close();
                            clientIs.close();
                            Vector<String> clientEntryNamesToSkip = new Vector<String>();
                            clientEntryNamesToSkip.addElement("META-INF/MANIFEST.MF");
                            clientEntryNamesToSkip.addElement(EjbBundleArchivist.DEPLOYMENT_DESCRIPTOR_ENTRY);
                            Archivist.addJarToOutput(zos, new JarFile(clientJarTemp), clientEntryNamesToSkip);
                            clientJarTemp.delete();
                        } else {
                            System.out.println(localStrings.getLocalString("enterprise.deployment.noclientjarentry", "Warning: {0} not found as a client jar entry.", new Object[]{ejbClientJarUri}));
                        }
                        ejbJar.close();
                    }
                }
                temp2.delete();
            }
            Iterator itr2 = this.application.getWebBundleDescriptors().iterator();
            while (itr2.hasNext()) {
                WebBundleDescriptor webBundleDescriptor = (WebBundleDescriptor)itr2.next();
                WebBundleArchivist oldArchivist = (WebBundleArchivist)webBundleDescriptor.getArchivist();
                String webBundleArchiveName = webBundleDescriptor.getArchivist().getArchiveUri();
                temp = Archivist.getWebTemp(this.getApplicationDirectory());
                ApplicationArchivist.extractJar(webBundleArchiveName, existingApplicationJar, temp);
                WebBundleArchivist archivist = new WebBundleArchivist(temp.toString(), webBundleDescriptor);
                if (oldArchivist.hasExternalDescriptor()) {
                    archivist.save(temp, oldArchivist.getExternalDescriptorArchiveUri(), zos);
                } else {
                    archivist.save(temp);
                }
                webBundleDescriptor.setArchivist(oldArchivist);
                FileInputStream webJarInput = new FileInputStream(temp);
                zos.putNextEntry(new ZipEntry(webBundleArchiveName));
                Archivist.copy(webJarInput, zos);
                zos.closeEntry();
                ((InputStream)webJarInput).close();
                temp.delete();
            }
            Iterator itr3 = this.application.getApplicationClientDescriptors().iterator();
            while (itr3.hasNext()) {
                ApplicationClientDescriptor appClientDescriptor = (ApplicationClientDescriptor)itr3.next();
                ApplicationClientArchivist oldArchivist = (ApplicationClientArchivist)appClientDescriptor.getArchivist();
                String appClientArchiveName = appClientDescriptor.getArchivist().getArchiveUri();
                File temp3 = Archivist.getApplicationClientTemp(this.getApplicationDirectory());
                ApplicationArchivist.extractJar(appClientArchiveName, existingApplicationJar, temp3);
                ApplicationClientArchivist archivist = new ApplicationClientArchivist(temp3.toString(), appClientDescriptor, oldArchivist.getManifestClasspaths());
                if (oldArchivist.hasExternalDescriptor()) {
                    archivist.save(temp3, saveApplicationClientRuntime, oldArchivist.getExternalDescriptorArchiveUri(), zos);
                } else {
                    archivist.save(temp3, saveApplicationClientRuntime);
                }
                appClientDescriptor.setArchivist(oldArchivist);
                FileInputStream appClientJarInput = new FileInputStream(temp3);
                zos.putNextEntry(new ZipEntry(appClientArchiveName));
                Archivist.copy(appClientJarInput, zos);
                zos.closeEntry();
                ((InputStream)appClientJarInput).close();
                if (makeClassLoadable) {
                    System.out.println(localStrings.getLocalString("enterprise.deployment.classsave", "Class loadable save"));
                    Vector<String> appClientEntryNamesToSkip = new Vector<String>();
                    appClientEntryNamesToSkip.addElement("META-INF/MANIFEST.MF");
                    appClientEntryNamesToSkip.addElement("META-INF/application-client.xml");
                    appClientEntryNamesToSkip.addElement(RI_SPECIFIC_DESCRIPTOR_ENTRY);
                    Archivist.addJarToOutput(zos, new JarFile(temp3), appClientEntryNamesToSkip);
                }
                temp3.delete();
            }
            Iterator itr4 = this.getLibraryJarUris().iterator();
            while (itr4.hasNext()) {
                String nextlibraryUri = (String)itr4.next();
                temp = Archivist.getLibraryTemp(this.getApplicationDirectory());
                ApplicationArchivist.extractJar(nextlibraryUri, existingApplicationJar, temp);
                FileInputStream libJarInput = new FileInputStream(temp);
                zos.putNextEntry(new ZipEntry(nextlibraryUri));
                Archivist.copy(libJarInput, zos);
                zos.closeEntry();
                ((InputStream)libJarInput).close();
                if (makeClassLoadable) {
                    Vector<String> libraryJarFileNamesToSkip = new Vector<String>();
                    libraryJarFileNamesToSkip.addElement("META-INF/MANIFEST.MF");
                    Archivist.addJarToOutput(zos, new JarFile(temp), libraryJarFileNamesToSkip);
                }
                temp.delete();
            }
            if (!"".equals(this.application.getSmallIconUri())) {
                ApplicationArchivist.saveEntry(this.application.getSmallIconUri(), zos, existingApplicationJar);
            }
            if (!"".equals(this.application.getLargeIconUri())) {
                ApplicationArchivist.saveEntry(this.application.getLargeIconUri(), zos, existingApplicationJar);
            }
        }
        Manifest applicationManifest = this.createApplicationManifest();
        ApplicationArchivist.writeManifest(applicationManifest, zos);
        this.writeApplicationDeploymentInfo(zos, saveRuntimeInfo);
        zos.close();
        if (existingApplicationJar != null) {
            existingApplicationJar.close();
        }
        destinationFile.delete();
        boolean renamed = tmpFile.renameTo(destinationFile);
        if (!renamed) {
            throw new IOException(localStrings.getLocalString("enterprise.deployment.exceptionerrorsavingjar", "Error saving JAR"));
        }
        this.setApplicationFile(destinationFile);
        this.setClassLoader(null);
        this.application.doneSaving();
    }

    private static void saveEntry(String entryName, ZipOutputStream zos, JarFile existingApplicationJar) throws IOException {
        ZipEntry ze = new ZipEntry(entryName);
        InputStream is = existingApplicationJar.getInputStream(ze);
        if (is != null) {
            try {
                zos.putNextEntry(new ZipEntry(ze.getName()));
                Archivist.copy(is, zos);
                zos.closeEntry();
            }
            catch (ZipException zipException) {}
        } else {
            System.out.println(localStrings.getLocalString("enterprise.deployment.errorsavingentry", "Error saving entry {0}", new Object[]{entryName}));
        }
    }

    public void setApplicationFile(File applicationFile) {
        this.applicationFile = applicationFile;
        this.setClassLoader(null);
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public static void setMakeClassLoadable(boolean b10) {
        makeClassLoadable = b10;
    }

    public String toString() {
        return "ApplicationArchivist " + this.applicationFile;
    }

    public void writeApplicationDeploymentInfo(ZipOutputStream zos, boolean saveRuntimeInfo) throws IOException {
        Archivist.writeDocumentToJar(ApplicationNode.getDocument(this.application), DEPLOYMENT_DESCRIPTOR_ENTRY, zos);
        if (saveRuntimeInfo && this.application.hasRuntimeInformation()) {
            Archivist.writeDocumentToJar(RuntimeDescriptorNode.getDocument(this.application), RI_SPECIFIC_DESCRIPTOR_ENTRY, zos);
        }
    }

    public static void writeManifest(Manifest manifest, ZipOutputStream zos) throws IOException {
        ZipEntry manifestEntry = new ZipEntry("META-INF/MANIFEST.MF");
        manifestEntry.setTime(System.currentTimeMillis());
        zos.putNextEntry(manifestEntry);
        manifest.write(zos);
        zos.closeEntry();
    }
}

