/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment;

import com.sun.enterprise.deployment.ApplicationClientArchivist;
import com.sun.enterprise.deployment.Archivist;
import com.sun.enterprise.deployment.BundleDescriptor;
import com.sun.enterprise.deployment.EjbReferenceDescriptor;
import com.sun.enterprise.deployment.EnvironmentProperty;
import com.sun.enterprise.deployment.NamedDescriptor;
import com.sun.enterprise.deployment.OrderedSet;
import com.sun.enterprise.deployment.ResourceReferenceDescriptor;
import com.sun.enterprise.deployment.WritableJndiNameEnvironment;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;

public class ApplicationClientDescriptor
extends BundleDescriptor
implements WritableJndiNameEnvironment {
    private Set environmentProperties;
    private Set ejbReferences;
    private Set resourceReferences;
    private String mainClassName;
    private transient ApplicationClientArchivist archivist = null;
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(class$com$sun$enterprise$deployment$ApplicationClientDescriptor != null ? class$com$sun$enterprise$deployment$ApplicationClientDescriptor : (class$com$sun$enterprise$deployment$ApplicationClientDescriptor = ApplicationClientDescriptor.class$("com.sun.enterprise.deployment.ApplicationClientDescriptor")));
    static /* synthetic */ Class class$com$sun$enterprise$deployment$ApplicationClientDescriptor;

    public void addEjbReferenceDescriptor(EjbReferenceDescriptor ejbReference) {
        this.getEjbReferenceDescriptors().add(ejbReference);
        this.changed();
    }

    public void addEnvironmentProperty(EnvironmentProperty environmentProperty) {
        this.getEnvironmentProperties().add(environmentProperty);
        this.changed();
    }

    public void addResourceReferenceDescriptor(ResourceReferenceDescriptor resourceReference) {
        this.getResourceReferenceDescriptors().add(resourceReference);
        this.changed();
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    protected Archivist getDefaultArchivist() {
        return new ApplicationClientArchivist("", this);
    }

    public EjbReferenceDescriptor getEjbReferenceByName(String name) {
        Iterator itr = this.getEjbReferenceDescriptors().iterator();
        while (itr.hasNext()) {
            EjbReferenceDescriptor ejr = (EjbReferenceDescriptor)itr.next();
            if (!ejr.getName().equals(name)) continue;
            return ejr;
        }
        throw new IllegalArgumentException("This application client has no ejb refernce by the name " + name);
    }

    public Set getEjbReferenceDescriptors() {
        if (this.ejbReferences == null) {
            this.ejbReferences = new OrderedSet();
        }
        this.ejbReferences = new OrderedSet((Collection)this.ejbReferences);
        return this.ejbReferences;
    }

    public Set getEnvironmentProperties() {
        if (this.environmentProperties == null) {
            this.environmentProperties = new OrderedSet();
        }
        this.environmentProperties = new OrderedSet((Collection)this.environmentProperties);
        return this.environmentProperties;
    }

    public String getMainClassName() {
        if (this.mainClassName == null) {
            this.mainClassName = "";
        }
        return this.mainClassName;
    }

    public Set getNamedDescriptors() {
        return super.getNamedDescriptorsFrom(this);
    }

    public Vector getNamedReferencePairs() {
        return super.getNamedReferencePairsFrom(this);
    }

    public ResourceReferenceDescriptor getResourceReferenceByName(String name) {
        Iterator itr = this.getResourceReferenceDescriptors().iterator();
        while (itr.hasNext()) {
            ResourceReferenceDescriptor rr = (ResourceReferenceDescriptor)itr.next();
            if (!rr.getName().equals(name)) continue;
            return rr;
        }
        throw new IllegalArgumentException(localStrings.getLocalString("enterprise.deployment.exceptionappclienthasnoejbrefname", "This application client has no ejb refernce by the name {0}", new Object[]{name}));
    }

    public Set getResourceReferenceDescriptors() {
        if (this.resourceReferences == null) {
            this.resourceReferences = new OrderedSet();
        }
        this.resourceReferences = new OrderedSet((Collection)this.resourceReferences);
        return this.resourceReferences;
    }

    public boolean hasRuntimeInformation() {
        Iterator itr = this.getNamedDescriptors().iterator();
        while (itr.hasNext()) {
            NamedDescriptor next = (NamedDescriptor)itr.next();
            if ("".equals(next.getJndiName())) continue;
            return true;
        }
        return false;
    }

    public void removeEjbReferenceDescriptor(EjbReferenceDescriptor ejbReference) {
        this.getEjbReferenceDescriptors().remove(ejbReference);
        this.changed();
    }

    public void removeEnvironmentProperty(EnvironmentProperty environmentProperty) {
        this.getEnvironmentProperties().remove(environmentProperty);
        this.changed();
    }

    public void removeResourceReferenceDescriptor(ResourceReferenceDescriptor resourceReference) {
        this.getResourceReferenceDescriptors().remove(resourceReference);
        this.changed();
    }

    public void setMainClassName(String mainClassName) {
        this.mainClassName = mainClassName;
        this.changed();
    }

    public String toString() {
        String s2 = "Application Client Descriptor";
        s2 = String.valueOf(s2) + "\n " + super.toString();
        s2 = String.valueOf(s2) + "\n environmentProperties " + this.environmentProperties;
        s2 = String.valueOf(s2) + "\n ejbReferences " + this.ejbReferences;
        s2 = String.valueOf(s2) + "\n resourceReferences " + this.resourceReferences;
        s2 = String.valueOf(s2) + "\n mainClassName " + this.mainClassName;
        return s2;
    }
}

