/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment;

import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.xml.XMLUtils;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.xml.tree.XmlDocument;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;

public abstract class Archivist {
    public static String MANIFEST_VERSION_VALUE = "1.0";
    private static String TMPFILENAME = "scratch";
    private static String EJB_TMP_FILENAME = "ejb_temp";
    private static String WEB_TMP_FILENAME = "web_temp";
    private static String APP_CLIENT_TMP_FILENAME = "app-client-temp";
    private static String LIB_TMP_FILENAME = "lib-temp";
    private String externalDescriptorArchiveUri = null;
    protected String archiveUri = "";
    protected Set manifestClasspath;
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(class$com$sun$enterprise$deployment$Archivist != null ? class$com$sun$enterprise$deployment$Archivist : (class$com$sun$enterprise$deployment$Archivist = Archivist.class$("com.sun.enterprise.deployment.Archivist")));
    static /* synthetic */ Class class$com$sun$enterprise$deployment$Archivist;

    public Hashtable addFiles(Hashtable fileToEntryNameMap, File jarFile) throws IOException {
        File scratchFile = Archivist.createTempFile(Archivist.getDirectory(jarFile));
        FileOutputStream fos = new FileOutputStream(scratchFile);
        ZipOutputStream zos = new ZipOutputStream(fos);
        Hashtable<File, String> actual = new Hashtable<File, String>();
        Vector names = this.getEntryNamesFrom(jarFile);
        JarFile jar = new JarFile(jarFile);
        Archivist.addJarToOutput(zos, jar, new Vector());
        Enumeration e10 = fileToEntryNameMap.keys();
        while (e10.hasMoreElements()) {
            File nextFile = (File)e10.nextElement();
            String trialEntryName = (String)fileToEntryNameMap.get(nextFile);
            String entryName = Descriptor.createUniqueNameAmongst(trialEntryName, names);
            actual.put(nextFile, entryName);
            FileInputStream fis = new FileInputStream(nextFile);
            zos.putNextEntry(new JarEntry(entryName));
            Archivist.copy(fis, zos);
            zos.closeEntry();
            fis.close();
        }
        zos.close();
        jar.close();
        jarFile.delete();
        if (!scratchFile.renameTo(jarFile)) {
            throw new IOException(localStrings.getLocalString("enterprise.deployment.exceptionerrornamingjartofile", "Error renaming JAR [0} to {1}", new Object[]{scratchFile, jarFile}));
        }
        return actual;
    }

    public static void addJarToOutput(ZipOutputStream zos, JarFile jarFileToAdd, Vector entryNamesToSkip) throws IOException {
        Enumeration<JarEntry> e10 = jarFileToAdd.entries();
        while (e10.hasMoreElements()) {
            ZipEntry nextEntry = e10.nextElement();
            if (entryNamesToSkip.contains(nextEntry.getName())) continue;
            InputStream is = jarFileToAdd.getInputStream(nextEntry);
            try {
                zos.putNextEntry(new ZipEntry(nextEntry));
                Archivist.copy(is, zos);
                zos.closeEntry();
            }
            catch (ZipException zipException) {}
        }
        jarFileToAdd.close();
    }

    public void addManfiestClasspath(String uri) {
        this.getManifestClasspaths().add(uri);
    }

    static void checkExists(File f2) throws IOException {
        if (!f2.exists()) {
            throw new IOException(localStrings.getLocalString("enterprise.deployment.exceptionfiledoesnotexist", "{0} does not exist", new Object[]{f2}));
        }
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    public static void copy(InputStream is, OutputStream os) throws IOException {
        byte[] buf = new byte[1024];
        int len = 0;
        while (len != -1) {
            try {
                len = is.read(buf, 0, buf.length);
            }
            catch (EOFException eOFException) {
                break;
            }
            if (len == -1) continue;
            os.write(buf, 0, len);
        }
        is.close();
    }

    public Manifest createManifest() {
        Manifest manifest = new Manifest();
        manifest.getMainAttributes().put(Attributes.Name.MANIFEST_VERSION, MANIFEST_VERSION_VALUE);
        if (!this.getManifestClasspaths().isEmpty()) {
            String classpathString = "";
            Iterator itr = this.getManifestClasspaths().iterator();
            while (itr.hasNext()) {
                String next = (String)itr.next();
                classpathString = String.valueOf(classpathString) + next;
                if (!itr.hasNext()) continue;
                classpathString = String.valueOf(classpathString) + " ";
            }
            manifest.getMainAttributes().put(Attributes.Name.CLASS_PATH, classpathString);
        }
        return manifest;
    }

    static File createTempFile(File directory) {
        File f2 = null;
        try {
            f2 = File.createTempFile(TMPFILENAME, "jar", directory);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        f2.deleteOnExit();
        return f2;
    }

    static void dump(Manifest m2) {
        try {
            m2.write(System.out);
        }
        catch (Throwable t2) {
            t2.printStackTrace();
        }
    }

    public static void extractJarFile(File jarFile, File directory) throws IOException {
        JarFile jar = new JarFile(jarFile);
        Enumeration<JarEntry> e10 = jar.entries();
        while (e10.hasMoreElements()) {
            ZipEntry entry = e10.nextElement();
            String filename = entry.getName().replace('/', File.separatorChar);
            File file = new File(directory.getAbsolutePath(), filename);
            file.deleteOnExit();
            if (entry.isDirectory()) continue;
            InputStream is = jar.getInputStream(new ZipEntry(entry));
            boolean mkdirs = true;
            if (!file.getParentFile().exists()) {
                mkdirs = file.getParentFile().mkdirs();
            }
            if (!mkdirs) {
                throw new IOException(localStrings.getLocalString("enterprise.deployment.exceptionunpackingarchivefailed", "Unpacking archive failed: could not make parent file for {0}", new Object[]{file}));
            }
            FileOutputStream fos = new FileOutputStream(file);
            Archivist.copy(is, fos);
            fos.close();
            is.close();
        }
        jar.close();
    }

    static File getApplicationClientTemp(File directory) {
        File f2 = null;
        try {
            f2 = File.createTempFile(APP_CLIENT_TMP_FILENAME, "jar", directory);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        f2.deleteOnExit();
        return f2;
    }

    public String getArchiveUri() {
        return this.archiveUri;
    }

    static File getDirectory(File f2) {
        String filename = f2.getAbsolutePath();
        return new File(new File(filename).getParent());
    }

    static File getEjbTemp(File directory) {
        File f2 = null;
        try {
            f2 = File.createTempFile(EJB_TMP_FILENAME, "jar", directory);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        return f2;
    }

    protected Vector getEntryNamesFrom(File archive) throws IOException {
        ZipFile zipFile = new ZipFile(archive);
        Vector<String> names = new Vector<String>();
        Enumeration<? extends ZipEntry> e10 = zipFile.entries();
        while (e10.hasMoreElements()) {
            ZipEntry ze = e10.nextElement();
            names.addElement(ze.getName());
        }
        zipFile.close();
        return names;
    }

    public String getExternalDescriptorArchiveUri() {
        return this.externalDescriptorArchiveUri;
    }

    static File getLibraryTemp(File directory) {
        File f2 = null;
        try {
            f2 = File.createTempFile(LIB_TMP_FILENAME, "jar", directory);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        f2.deleteOnExit();
        return f2;
    }

    public Set getManifestClasspaths() {
        if (this.manifestClasspath == null) {
            this.manifestClasspath = new HashSet();
        }
        return this.manifestClasspath;
    }

    protected String getUniqueEntryNameFor(File archive, String trialName) throws IOException {
        return Descriptor.createUniqueNameAmongst(trialName, this.getEntryNamesFrom(archive));
    }

    static File getWebTemp(File directory) {
        File f2 = null;
        try {
            f2 = File.createTempFile(WEB_TMP_FILENAME, "war", directory);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        f2.deleteOnExit();
        return f2;
    }

    public boolean hasExternalDescriptor() {
        return this.externalDescriptorArchiveUri != null;
    }

    public void removeEntries(Set entryNames, File jarFile) throws IOException {
        Vector toRemove = new Vector(entryNames);
        File scratchFile = Archivist.createTempFile(Archivist.getDirectory(jarFile));
        FileOutputStream fos = new FileOutputStream(scratchFile);
        ZipOutputStream zos = new ZipOutputStream(fos);
        JarFile jar = new JarFile(jarFile);
        Archivist.addJarToOutput(zos, jar, toRemove);
        zos.close();
        jar.close();
        if (!scratchFile.renameTo(jarFile)) {
            throw new IOException(localStrings.getLocalString("enterprise.deployment.exceptionerrornamingjartofile", "Error renaming JAR [0} to {1}", new Object[]{scratchFile, jarFile}));
        }
    }

    public void removeManifestClasspath(String uri) {
        this.getManifestClasspaths().remove(uri);
    }

    public void setArchiveUri(String archiveUri) {
        this.archiveUri = archiveUri;
    }

    public void setExternalDescriptorArchiveUri(String externalDescriptorArchiveUri) {
        this.externalDescriptorArchiveUri = externalDescriptorArchiveUri;
    }

    public void setManifestClasspaths(Manifest manifest) {
        Attributes mainAttributes = manifest.getMainAttributes();
        Iterator<Object> itr = mainAttributes.keySet().iterator();
        while (itr.hasNext()) {
            Attributes.Name next = (Attributes.Name)itr.next();
            if (!next.equals(Attributes.Name.CLASS_PATH)) continue;
            String classpathString = (String)mainAttributes.get(next);
            StringTokenizer st = new StringTokenizer(classpathString, " ");
            while (st.hasMoreTokens()) {
                String mc = st.nextToken();
                this.getManifestClasspaths().add(mc);
            }
        }
    }

    protected static void writeDocumentToJar(XmlDocument document, String entryName, ZipOutputStream zos) throws IOException {
        StringWriter sw = new StringWriter();
        XMLUtils.writeDocument(document, sw);
        byte[] deploymentInfo = sw.toString().getBytes();
        ZipEntry ze = new ZipEntry(entryName);
        ze.setTime(System.currentTimeMillis());
        zos.putNextEntry(ze);
        zos.write(deploymentInfo, 0, deploymentInfo.length);
        zos.closeEntry();
    }

    public static void writeManifest(Manifest manifest, ZipOutputStream zos) throws IOException {
        ZipEntry manifestEntry = new ZipEntry("META-INF/MANIFEST.MF");
        manifestEntry.setTime(System.currentTimeMillis());
        zos.putNextEntry(manifestEntry);
        manifest.write(zos);
        zos.closeEntry();
    }
}

