/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment;

import com.sun.enterprise.deployment.Archivist;
import com.sun.enterprise.deployment.BundleDescriptor;
import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.EjbBundleArchivist;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.NamedReferencePair;
import com.sun.enterprise.deployment.RoleReference;
import com.sun.enterprise.security.acl.Role;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;

public class EjbBundleDescriptor
extends BundleDescriptor {
    private Set ejbs = new HashSet();
    private String ejbClientJarUri;
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(class$com$sun$enterprise$deployment$EjbBundleDescriptor != null ? class$com$sun$enterprise$deployment$EjbBundleDescriptor : (class$com$sun$enterprise$deployment$EjbBundleDescriptor = EjbBundleDescriptor.class$("com.sun.enterprise.deployment.EjbBundleDescriptor")));
    static /* synthetic */ Class class$com$sun$enterprise$deployment$EjbBundleDescriptor;

    public void addEjb(EjbDescriptor ejbDescriptor) {
        ejbDescriptor.setEjbBundleDescriptor(this);
        this.getEjbs().add(ejbDescriptor);
        super.changed();
    }

    void addEjbBundleDescriptor(EjbBundleDescriptor ejbBundleDescriptor) {
        super.addBundleDescriptor(ejbBundleDescriptor);
        this.getEjbs().addAll(ejbBundleDescriptor.getEjbs());
        this.changed();
    }

    public boolean areResourceReferencesValid() {
        Iterator itr = this.getEjbs().iterator();
        while (itr.hasNext()) {
            EjbDescriptor ejbDescriptor = (EjbDescriptor)itr.next();
            Iterator roleRefs = ejbDescriptor.getRoleReferences().iterator();
            while (roleRefs.hasNext()) {
                RoleReference roleReference = (RoleReference)roleRefs.next();
                Role referredRole = roleReference.getRole();
                if (referredRole.getName().equals("") || super.getRoles().contains(referredRole)) continue;
                System.out.println(localStrings.getLocalString("enterprise.deployment.badrolereference", "Warning: Bad role reference to {0}", new Object[]{referredRole}));
                System.out.println(this.getRoles());
                return false;
            }
        }
        return true;
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    private void doMethodDescriptorConversions() throws Exception {
        Iterator itr = this.getEjbs().iterator();
        while (itr.hasNext()) {
            EjbDescriptor ejbDescriptor = (EjbDescriptor)itr.next();
            ejbDescriptor.doMethodDescriptorConversions();
        }
    }

    protected Archivist getDefaultArchivist() {
        return new EjbBundleArchivist("", this);
    }

    public EjbDescriptor getEjbByName(String name) {
        Iterator itr = this.getEjbs().iterator();
        while (itr.hasNext()) {
            Descriptor next = (Descriptor)itr.next();
            if (!next.getName().equals(name)) continue;
            return (EjbDescriptor)next;
        }
        throw new IllegalArgumentException(localStrings.getLocalString("enterprise.deployment.exceptionbeanbundle", "Referencing error: this bundle has no bean of name: [0}", new Object[]{name}));
    }

    public String getEjbClientJarUri() {
        if (this.ejbClientJarUri == null) {
            this.ejbClientJarUri = "";
        }
        return this.ejbClientJarUri;
    }

    public Set getEjbs() {
        if (this.ejbs == null) {
            this.ejbs = new HashSet();
        }
        return this.ejbs;
    }

    public String getName() {
        if ("".equals(super.getName())) {
            super.setName("Ejb1");
        }
        return super.getName();
    }

    public Set getNamedDescriptors() {
        HashSet<EjbDescriptor> namedDescriptors = new HashSet<EjbDescriptor>();
        Iterator ejbs = this.getEjbs().iterator();
        while (ejbs.hasNext()) {
            EjbDescriptor ejbDescriptor = (EjbDescriptor)ejbs.next();
            namedDescriptors.add(ejbDescriptor);
            namedDescriptors.addAll(super.getNamedDescriptorsFrom(ejbDescriptor));
        }
        return namedDescriptors;
    }

    public Vector getNamedReferencePairs() {
        Vector<NamedReferencePair> pairs = new Vector<NamedReferencePair>();
        Iterator ejbs = this.getEjbs().iterator();
        while (ejbs.hasNext()) {
            EjbDescriptor ejbDescriptor = (EjbDescriptor)ejbs.next();
            pairs.add(new NamedReferencePair(ejbDescriptor, ejbDescriptor));
            pairs.addAll(super.getNamedReferencePairsFrom(ejbDescriptor));
        }
        return pairs;
    }

    public Set getResourceReferenceDescriptors() {
        HashSet resourceReferences = new HashSet();
        Iterator itr = this.getEjbs().iterator();
        while (itr.hasNext()) {
            EjbDescriptor ejbDescriptor = (EjbDescriptor)itr.next();
            resourceReferences.addAll(ejbDescriptor.getResourceReferenceDescriptors());
        }
        return resourceReferences;
    }

    public boolean hasAssemblyInformation() {
        return !this.getRoles().isEmpty() || this.hasPermissionedRoles() || this.hasContainerTransactions();
    }

    public boolean hasContainerTransactions() {
        Iterator itr = this.getEjbs().iterator();
        while (itr.hasNext()) {
            EjbDescriptor nextEjbDescriptor = (EjbDescriptor)itr.next();
            if (nextEjbDescriptor.getMethodContainerTransactions().isEmpty()) continue;
            return true;
        }
        return false;
    }

    public boolean hasEjbByName(String name) {
        Iterator itr = this.getEjbs().iterator();
        while (itr.hasNext()) {
            Descriptor next = (Descriptor)itr.next();
            if (!next.getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    public boolean hasEjbReferences() {
        Iterator itr = this.getEjbs().iterator();
        while (itr.hasNext()) {
            EjbDescriptor nextEjbDescriptor = (EjbDescriptor)itr.next();
            if (nextEjbDescriptor.getEjbReferenceDescriptors().isEmpty()) continue;
            return true;
        }
        return false;
    }

    public boolean hasPermissionedRoles() {
        Iterator itr = this.getEjbs().iterator();
        while (itr.hasNext()) {
            EjbDescriptor nextEjbDescriptor = (EjbDescriptor)itr.next();
            if (nextEjbDescriptor.getPermissionedMethodsByRole().isEmpty()) continue;
            return true;
        }
        return false;
    }

    public void removeEjb(EjbDescriptor ejbDescriptor) {
        ejbDescriptor.setEjbBundleDescriptor(null);
        this.getEjbs().remove(ejbDescriptor);
        super.changed();
    }

    public void removeRole(Role role) {
        if (super.getRoles().contains(role)) {
            Iterator itr = this.getEjbs().iterator();
            while (itr.hasNext()) {
                EjbDescriptor ejbDescriptor = (EjbDescriptor)itr.next();
                ejbDescriptor.removeRole(role);
            }
            super.removeRole(role);
        }
    }

    public void setEjbClientJarUri(String ejbClientJarUri) {
        this.ejbClientJarUri = ejbClientJarUri;
        this.changed();
    }

    public String toString() {
        String s2 = "EjbBundleDescriptor";
        s2 = String.valueOf(s2) + "\n archivist " + super.getArchivist();
        s2 = String.valueOf(s2) + "\n roles " + this.getRoles();
        s2 = String.valueOf(s2) + "\nclient JAR " + this.getEjbClientJarUri();
        Iterator itr = this.getEjbs().iterator();
        while (itr.hasNext()) {
            s2 = String.valueOf(s2) + "\n------------\n";
            s2 = String.valueOf(s2) + itr.next();
            s2 = String.valueOf(s2) + "\n------------";
        }
        return s2;
    }
}

