/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment;

import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.ContainerTransaction;
import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.EjbAbstractDescriptor;
import com.sun.enterprise.deployment.EjbBundleArchivist;
import com.sun.enterprise.deployment.EjbBundleDescriptor;
import com.sun.enterprise.deployment.EjbReferenceDescriptor;
import com.sun.enterprise.deployment.EnvironmentProperty;
import com.sun.enterprise.deployment.FieldDescriptor;
import com.sun.enterprise.deployment.MethodDescriptor;
import com.sun.enterprise.deployment.OrderedSet;
import com.sun.enterprise.deployment.ResourceReferenceDescriptor;
import com.sun.enterprise.deployment.RoleReference;
import com.sun.enterprise.deployment.WritableJndiNameEnvironment;
import com.sun.enterprise.security.acl.Role;
import com.sun.enterprise.util.BeanMethodCalculator;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;

public abstract class EjbDescriptor
extends EjbAbstractDescriptor
implements WritableJndiNameEnvironment {
    public static String BEAN_TRANSACTION_TYPE = "Bean";
    public static String CONTAINER_TRANSACTION_TYPE = "Container";
    protected String transactionType = null;
    private Hashtable methodContainerTransactions = null;
    private ContainerTransaction containerTransaction = null;
    private Hashtable permissionedMethodsByRole = null;
    private Set environmentProperties;
    private Set ejbReferences = new HashSet();
    private Set resourceReferences = new HashSet();
    private Set roleReferences = new HashSet();
    private EjbBundleDescriptor bundleDescriptor;
    private String ejbClassName;
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(class$com$sun$enterprise$deployment$EjbDescriptor != null ? class$com$sun$enterprise$deployment$EjbDescriptor : (class$com$sun$enterprise$deployment$EjbDescriptor = EjbDescriptor.class$("com.sun.enterprise.deployment.EjbDescriptor")));
    static /* synthetic */ Class class$com$sun$enterprise$deployment$EjbDescriptor;

    public EjbDescriptor() {
    }

    public EjbDescriptor(EjbDescriptor other) {
        super(other);
        this.transactionType = other.transactionType;
        this.methodContainerTransactions = new Hashtable(other.getMethodContainerTransactions());
        this.permissionedMethodsByRole = new Hashtable(other.getPermissionedMethodsByRole());
        this.getEnvironmentProperties().addAll(other.getEnvironmentProperties());
        this.getEjbReferenceDescriptors().addAll(other.getEjbReferenceDescriptors());
        this.getResourceReferenceDescriptors().addAll(other.getResourceReferenceDescriptors());
        this.getRoleReferences().addAll(other.getRoleReferences());
        this.transactionType = other.transactionType;
        this.ejbClassName = other.ejbClassName;
    }

    public EjbDescriptor(String name, String homeClassName, String remoteClassName, String ejbClassName) {
        super(name, homeClassName, remoteClassName);
        this.ejbClassName = ejbClassName;
    }

    private boolean _setContainerTransactionFor(MethodDescriptor methodDescriptor, ContainerTransaction containerTransaction) {
        ContainerTransaction oldValue = this.getContainerTransactionFor(methodDescriptor);
        if (oldValue == null || oldValue != null && !oldValue.equals(containerTransaction)) {
            if (this.getTransactionType().equals(BEAN_TRANSACTION_TYPE)) {
                throw new IllegalArgumentException(localStrings.getLocalString("enterprise.deployment.exceptiontxattrbtnotspecifiedinbeanwithtxtype", "Method level transaction attributes may not be specified on a bean with transaction type {0}", new Object[]{BEAN_TRANSACTION_TYPE}));
            }
            this.getMethodContainerTransactions().put(methodDescriptor, containerTransaction);
            return true;
        }
        return false;
    }

    public void addEjbReferenceDescriptor(EjbReferenceDescriptor ejbReference) {
        this.getEjbReferenceDescriptors().add(ejbReference);
        this.changed();
    }

    public void addEnvironmentProperty(EnvironmentProperty environmentProperty) {
        if (this.getEnvironmentProperties().contains(environmentProperty)) {
            this.replaceEnvironmentProperty(environmentProperty, environmentProperty);
        } else {
            this.getEnvironmentProperties().add(environmentProperty);
        }
        this.changed();
    }

    public void addPermissionedRoleFor(Role role, MethodDescriptor md) {
        if (this.getEjbBundleDescriptor() == null) {
            throw new IllegalArgumentException(localStrings.getLocalString("enterprise.deployment.exceptioncannotaddrolesdescriptor", "Cannot add roles when the descriptor is not part of a bundle"));
        }
        if (this.getEjbBundleDescriptor().getRoles().contains(role)) {
            if (this.getPermissionedMethodsByRole().containsKey(role)) {
                Set alreadyPermissionedMethodsForThisRole = (Set)this.getPermissionedMethodsByRole().get(role);
                alreadyPermissionedMethodsForThisRole.add(md);
                this.getPermissionedMethodsByRole().put(role, alreadyPermissionedMethodsForThisRole);
            } else {
                HashSet<MethodDescriptor> permissionedMethodsForThisRole = new HashSet<MethodDescriptor>();
                permissionedMethodsForThisRole.add(md);
                this.getPermissionedMethodsByRole().put(role, permissionedMethodsForThisRole);
            }
        } else {
            throw new IllegalArgumentException(localStrings.getLocalString("enterprise.deployment.exceptioncannotaddrolesbundle", "Cannot add roles when the bundle does not have them"));
        }
        this.changed();
    }

    public void addResourceReferenceDescriptor(ResourceReferenceDescriptor resourceReference) {
        this.getResourceReferenceDescriptors().add(resourceReference);
        this.changed();
    }

    public void addRoleReference(RoleReference roleReference) {
        this.getRoleReferences().add(roleReference);
        this.changed();
    }

    public void changed() {
        if (this.getEjbBundleDescriptor() != null) {
            this.getEjbBundleDescriptor().changed();
        } else {
            super.changed();
        }
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    private void convertMethodContainerTransactions() {
        Hashtable transactions = this.getMethodContainerTransactions();
        Hashtable<MethodDescriptor, ContainerTransaction> convertedTransactions = new Hashtable<MethodDescriptor, ContainerTransaction>();
        Set transactionMethods = this.getTransactionMethodDescriptors();
        Enumeration e10 = transactions.keys();
        while (e10.hasMoreElements()) {
            MethodDescriptor md = (MethodDescriptor)e10.nextElement();
            ContainerTransaction ct2 = (ContainerTransaction)transactions.get(md);
            Enumeration mds = md.doStyleConversion(this, transactionMethods).elements();
            while (mds.hasMoreElements()) {
                MethodDescriptor next = (MethodDescriptor)mds.nextElement();
                convertedTransactions.put(next, new ContainerTransaction(ct2));
            }
        }
        this.methodContainerTransactions = convertedTransactions;
    }

    private void convertMethodPermissions() {
        Hashtable permissionedMethods = this.getPermissionedMethodsByRole();
        Set allMethods = this.getMethodDescriptors();
        Enumeration e10 = permissionedMethods.keys();
        while (e10.hasMoreElements()) {
            Role nextRole = (Role)e10.nextElement();
            HashSet permissionedMethodsForRole = (HashSet)permissionedMethods.get(nextRole);
            if (permissionedMethodsForRole == null) continue;
            HashSet convertedPermissionedMethods = new HashSet();
            Iterator itr = permissionedMethodsForRole.iterator();
            while (itr.hasNext()) {
                MethodDescriptor md = (MethodDescriptor)itr.next();
                convertedPermissionedMethods.addAll(md.doStyleConversion(this, allMethods));
            }
            permissionedMethods.put(nextRole, convertedPermissionedMethods);
        }
    }

    void doMethodDescriptorConversions() throws Exception {
        Hashtable transactions = this.getMethodContainerTransactions();
        Hashtable<MethodDescriptor, ContainerTransaction> convertedTransactions = new Hashtable<MethodDescriptor, ContainerTransaction>();
        Set transactionMethods = this.getTransactionMethodDescriptors();
        Enumeration e10 = transactions.keys();
        while (e10.hasMoreElements()) {
            MethodDescriptor md = (MethodDescriptor)e10.nextElement();
            ContainerTransaction ct2 = (ContainerTransaction)transactions.get(md);
            Enumeration mds = md.doStyleConversion(this, transactionMethods).elements();
            while (mds.hasMoreElements()) {
                MethodDescriptor next = (MethodDescriptor)mds.nextElement();
                convertedTransactions.put(next, new ContainerTransaction(ct2));
            }
        }
        this.setMethodContainerTransactions(convertedTransactions);
        Hashtable permissionedMethods = this.getPermissionedMethodsByRole();
        Set allMethods = this.getMethodDescriptors();
        Enumeration e11 = permissionedMethods.keys();
        while (e11.hasMoreElements()) {
            Role nextRole = (Role)e11.nextElement();
            HashSet permissionedMethodsForRole = (HashSet)permissionedMethods.get(nextRole);
            if (permissionedMethodsForRole == null) continue;
            HashSet convertedPermissionedMethods = new HashSet();
            Iterator itr = permissionedMethodsForRole.iterator();
            while (itr.hasNext()) {
                MethodDescriptor md = (MethodDescriptor)itr.next();
                convertedPermissionedMethods.addAll(md.doStyleConversion(this, allMethods));
            }
            permissionedMethods.put(nextRole, convertedPermissionedMethods);
        }
    }

    Set getAllMethodDescriptors() {
        HashSet<Object> allMethodDescriptors = new HashSet<Object>();
        Enumeration e10 = this.getMethodContainerTransactions().keys();
        while (e10.hasMoreElements()) {
            allMethodDescriptors.add(e10.nextElement());
        }
        Enumeration e11 = this.getPermissionedMethodsByRole().keys();
        while (e11.hasMoreElements()) {
            Role nextRole = (Role)e11.nextElement();
            Set permissionedMethods = (Set)this.getPermissionedMethodsByRole().get(nextRole);
            Iterator itr = permissionedMethods.iterator();
            while (itr.hasNext()) {
                allMethodDescriptors.add(itr.next());
            }
        }
        return allMethodDescriptors;
    }

    public Application getApplication() {
        if (this.getEjbBundleDescriptor() != null) {
            return this.getEjbBundleDescriptor().getApplication();
        }
        return null;
    }

    public ContainerTransaction getContainerTransaction() {
        Vector transactionalMethods = new Vector(this.getTransactionMethodDescriptors());
        MethodDescriptor md = (MethodDescriptor)transactionalMethods.firstElement();
        if (md != null) {
            ContainerTransaction first = this.getContainerTransactionFor(md);
            Enumeration e10 = transactionalMethods.elements();
            while (e10.hasMoreElements()) {
                MethodDescriptor next = (MethodDescriptor)e10.nextElement();
                ContainerTransaction nextCt = this.getContainerTransactionFor(next);
                if (nextCt == null || nextCt.equals(first)) continue;
                return null;
            }
            return first;
        }
        return null;
    }

    public ContainerTransaction getContainerTransactionFor(MethodDescriptor methodDescriptor) {
        ContainerTransaction containerTransaction = null;
        if (this.needToConvertMethodContainerTransactions()) {
            this.convertMethodContainerTransactions();
        }
        if ((containerTransaction = (ContainerTransaction)this.getMethodContainerTransactions().get(methodDescriptor)) == null) {
            containerTransaction = Descriptor.isBoundsChecking() ? new ContainerTransaction(ContainerTransaction.NOT_SUPPORTED, "") : null;
        }
        return containerTransaction;
    }

    public ContainerTransaction getContainerTransactionFor(Method method) {
        MethodDescriptor md = new MethodDescriptor(method, this, ((EjbBundleArchivist)this.getEjbBundleDescriptor().getArchivist()).getClassLoader());
        return this.getContainerTransactionFor(md);
    }

    public EjbBundleDescriptor getEjbBundleDescriptor() {
        return this.bundleDescriptor;
    }

    public String getEjbClassName() {
        return this.ejbClassName;
    }

    public EjbReferenceDescriptor getEjbReferenceByName(String name) {
        Iterator itr = this.getEjbReferenceDescriptors().iterator();
        while (itr.hasNext()) {
            EjbReferenceDescriptor er2 = (EjbReferenceDescriptor)itr.next();
            if (!er2.getName().equals(name)) continue;
            return er2;
        }
        throw new IllegalArgumentException(localStrings.getLocalString("enterprise.deployment.exceptionbeanhasnoejbrefbyname", "This bean has no ejb reference by the name of [0}", new Object[]{name}));
    }

    public Set getEjbReferenceDescriptors() {
        if (this.ejbReferences == null) {
            this.ejbReferences = new OrderedSet();
        }
        this.ejbReferences = new OrderedSet((Collection)this.ejbReferences);
        return this.ejbReferences;
    }

    public Set getEnvironmentProperties() {
        if (this.environmentProperties == null) {
            this.environmentProperties = new OrderedSet();
        }
        this.environmentProperties = new OrderedSet((Collection)this.environmentProperties);
        return this.environmentProperties;
    }

    public EnvironmentProperty getEnvironmentPropertyByName(String name) {
        Iterator itr = this.getEnvironmentProperties().iterator();
        while (itr.hasNext()) {
            EnvironmentProperty ev2 = (EnvironmentProperty)itr.next();
            if (!ev2.getName().equals(name)) continue;
            return ev2;
        }
        throw new IllegalArgumentException(localStrings.getLocalString("enterprise.deployment.exceptionbeanhasnoenvpropertybyname", "This bean has no environment property by the name of {0}", new Object[]{name}));
    }

    public Field getFieldFor(FieldDescriptor fieldDescriptor) {
        return this.getFieldForName(fieldDescriptor.getName());
    }

    public Field getFieldForName(String fieldName) {
        Class<?> ejb = null;
        try {
            ClassLoader cl2 = this.getApplication().getApplicationArchivist().getClassLoader();
            ejb = cl2.loadClass(this.getEjbClassName());
        }
        catch (Throwable throwable) {
            System.out.println(localStrings.getLocalString("enterprise.deployment.errorloadingejbclassingetfieldname", "error loading the ejb class in getFieldForName on EjbDescriptor {0}", new Object[]{this.getApplication().getApplicationArchivist().getClassLoader()}));
            return null;
        }
        Field[] fields = ejb.getFields();
        int i2 = 0;
        while (i2 < fields.length) {
            Field nextField = fields[i2];
            if (nextField.getName().equals(fieldName)) {
                return nextField;
            }
            ++i2;
        }
        return null;
    }

    public Vector getFields() {
        Vector<Field> fieldsVector = new Vector<Field>();
        Class<?> ejb = null;
        try {
            ClassLoader cl2 = ((EjbBundleArchivist)this.getEjbBundleDescriptor().getArchivist()).getClassLoader();
            ejb = cl2.loadClass(this.getEjbClassName());
        }
        catch (Throwable throwable) {
            System.out.println(localStrings.getLocalString("enterprise.deployment.errorloadingejbclass", "error loading the ejb class {0} in getFields on EjbDescriptor {1}", new Object[]{this.getEjbClassName(), this.getApplication().getApplicationArchivist().getClassLoader()}));
            return fieldsVector;
        }
        Field[] fields = ejb.getFields();
        int i2 = 0;
        while (i2 < fields.length) {
            fieldsVector.addElement(fields[i2]);
            ++i2;
        }
        return fieldsVector;
    }

    public Hashtable getMethodContainerTransactions() {
        if (this.methodContainerTransactions == null) {
            this.methodContainerTransactions = new Hashtable();
        }
        return this.methodContainerTransactions;
    }

    public Set getMethodDescriptors() {
        HashSet<MethodDescriptor> s2 = new HashSet<MethodDescriptor>();
        ClassLoader classLoader = ((EjbBundleArchivist)this.getEjbBundleDescriptor().getArchivist()).getClassLoader();
        Enumeration e10 = this.getMethods(classLoader).elements();
        while (e10.hasMoreElements()) {
            s2.add(new MethodDescriptor((Method)e10.nextElement(), this, classLoader));
        }
        return s2;
    }

    public Method getMethodFor(MethodDescriptor methodDescriptor, ClassLoader classLoader) {
        return this.getMethodForName(methodDescriptor.getName(), classLoader);
    }

    private Method getMethodForName(String methodName, ClassLoader classLoader) {
        Enumeration e10 = this.getMethods(classLoader).elements();
        while (e10.hasMoreElements()) {
            Method m2 = (Method)e10.nextElement();
            if (!m2.getName().equals(methodName)) continue;
            return m2;
        }
        return null;
    }

    public Vector getMethods() {
        return this.getMethods(((EjbBundleArchivist)this.getEjbBundleDescriptor().getArchivist()).getClassLoader());
    }

    public Vector getMethods(ClassLoader classLoader) {
        Class<?> beanHome = null;
        Class<?> beanRemote = null;
        try {
            beanHome = classLoader.loadClass(this.getHomeClassName());
            beanRemote = classLoader.loadClass(this.getRemoteClassName());
        }
        catch (Throwable t2) {
            System.out.println(localStrings.getLocalString("enterprise.deployment.errorloadingclass", "Error loading class {0}", new Object[]{"(EjbDesciptor.getMethods())"}));
            throw new RuntimeException(t2.getMessage());
        }
        return BeanMethodCalculator.getMethodsFor(beanHome, beanRemote);
    }

    public Hashtable getPermissionedMethodsByRole() {
        if (this.permissionedMethodsByRole == null) {
            this.permissionedMethodsByRole = new Hashtable();
        }
        return this.permissionedMethodsByRole;
    }

    public Set getPermissionedRoles() {
        HashSet allPermissionedRoles = new HashSet();
        Enumeration e10 = this.getPermissionedMethodsByRole().keys();
        while (e10.hasMoreElements()) {
            allPermissionedRoles.add(e10.nextElement());
        }
        return allPermissionedRoles;
    }

    public Set getPermissionedRolesFor(MethodDescriptor methodDescriptor) {
        if (this.needToConvertMethodPermissions()) {
            this.convertMethodPermissions();
        }
        HashSet<Role> permissionedRolesForMethod = new HashSet<Role>();
        Enumeration e10 = this.getPermissionedMethodsByRole().keys();
        while (e10.hasMoreElements()) {
            Role nextRole = (Role)e10.nextElement();
            Set permissionedMethods = (Set)this.getPermissionedMethodsByRole().get(nextRole);
            Iterator itr = permissionedMethods.iterator();
            while (itr.hasNext()) {
                MethodDescriptor md = (MethodDescriptor)itr.next();
                if (!md.equals(methodDescriptor)) continue;
                permissionedRolesForMethod.add(nextRole);
            }
        }
        return permissionedRolesForMethod;
    }

    public Set getPermissionedRolesForMethod(Method method) {
        return this.getPermissionedRolesFor(new MethodDescriptor(method, this, ((EjbBundleArchivist)this.getEjbBundleDescriptor().getArchivist()).getClassLoader()));
    }

    public ResourceReferenceDescriptor getResourceReferenceByName(String name) {
        Iterator itr = this.getResourceReferenceDescriptors().iterator();
        while (itr.hasNext()) {
            ResourceReferenceDescriptor next = (ResourceReferenceDescriptor)itr.next();
            if (!next.getName().equals(name)) continue;
            return next;
        }
        throw new IllegalArgumentException(localStrings.getLocalString("enterprise.deployment.exceptionbeanhasnoresourcerefbyname", "This bean has no resource reference by the name of {0}", new Object[]{name}));
    }

    public Set getResourceReferenceDescriptors() {
        if (this.resourceReferences == null) {
            this.resourceReferences = new OrderedSet();
        }
        this.resourceReferences = new OrderedSet((Collection)this.resourceReferences);
        return this.resourceReferences;
    }

    public Set getResourceReferenceDescriptors(boolean resolved) {
        HashSet<ResourceReferenceDescriptor> toReturn = new HashSet<ResourceReferenceDescriptor>();
        Iterator itr = this.getResourceReferenceDescriptors().iterator();
        while (itr.hasNext()) {
            ResourceReferenceDescriptor next = (ResourceReferenceDescriptor)itr.next();
            if (next.isResolved() != resolved) continue;
            toReturn.add(next);
        }
        return toReturn;
    }

    public RoleReference getRoleReferenceByName(String roleReferenceName) {
        Iterator itr = this.getRoleReferences().iterator();
        while (itr.hasNext()) {
            RoleReference nextRR = (RoleReference)itr.next();
            if (!nextRR.getName().equals(roleReferenceName)) continue;
            return nextRR;
        }
        return null;
    }

    public Set getRoleReferences() {
        if (this.roleReferences == null) {
            this.roleReferences = new HashSet();
        }
        this.roleReferences = new HashSet(this.roleReferences);
        return this.roleReferences;
    }

    public Set getTransactionMethodDescriptors() {
        HashSet<MethodDescriptor> s2 = new HashSet<MethodDescriptor>();
        ClassLoader classLoader = ((EjbBundleArchivist)this.getEjbBundleDescriptor().getArchivist()).getClassLoader();
        Enumeration e10 = this.getTransactionMethods(classLoader).elements();
        while (e10.hasMoreElements()) {
            Method m2 = (Method)e10.nextElement();
            s2.add(new MethodDescriptor(m2, this, classLoader));
        }
        return s2;
    }

    private Vector getTransactionMethods(ClassLoader classLoader) {
        Class<?> beanHome = null;
        Class<?> beanRemote = null;
        try {
            beanHome = classLoader.loadClass(this.getHomeClassName());
            beanRemote = classLoader.loadClass(this.getRemoteClassName());
        }
        catch (Throwable t2) {
            System.out.println(localStrings.getLocalString("enterprise.deployment.errorloadingclass", "Error loading class {0}", new Object[]{"(EjbDesciptor.getMethods())"}));
            throw new RuntimeException(t2.getMessage());
        }
        return BeanMethodCalculator.getTransactionalMethodsFor(this, beanHome, beanRemote);
    }

    public String getTransactionType() {
        if (this.transactionType == null) {
            this.transactionType = BEAN_TRANSACTION_TYPE;
        }
        return this.transactionType;
    }

    public boolean hasResolvedResourceReferences() {
        if (!this.getResourceReferenceDescriptors().isEmpty()) {
            return false;
        }
        Iterator itr = this.getResourceReferenceDescriptors().iterator();
        while (itr.hasNext()) {
            ResourceReferenceDescriptor resourceReference = (ResourceReferenceDescriptor)itr.next();
            if (!resourceReference.isResolved()) continue;
            return true;
        }
        return false;
    }

    private boolean needToConvertMethodContainerTransactions() {
        if (this.getEjbBundleDescriptor() != null) {
            Enumeration e10 = this.getMethodContainerTransactions().keys();
            while (e10.hasMoreElements()) {
                MethodDescriptor md = (MethodDescriptor)e10.nextElement();
                if (md.isExact()) continue;
                return true;
            }
        }
        return false;
    }

    private boolean needToConvertMethodPermissions() {
        Enumeration e10 = this.getPermissionedMethodsByRole().keys();
        while (e10.hasMoreElements()) {
            Role next = (Role)e10.nextElement();
            Iterator itr = ((Set)this.getPermissionedMethodsByRole().get(next)).iterator();
            while (itr.hasNext()) {
                MethodDescriptor md = (MethodDescriptor)itr.next();
                if (md.isExact()) continue;
                return true;
            }
        }
        return false;
    }

    public void removeEjbReferenceDescriptor(EjbReferenceDescriptor ejbReference) {
        this.getEjbReferenceDescriptors().remove(ejbReference);
        this.changed();
    }

    public void removeEnvironmentProperty(EnvironmentProperty environmentProperty) {
        this.getEnvironmentProperties().remove(environmentProperty);
        this.changed();
    }

    public void removePermissionedRoleFor(Role role, MethodDescriptor md) {
        if (this.getEjbBundleDescriptor() == null) {
            throw new IllegalArgumentException(localStrings.getLocalString("enterprise.deployment.exceptioncanotaddrolesdescriptor", "Cannot add roles when the descriptor is not part of a bundle"));
        }
        if (this.getEjbBundleDescriptor().getRoles().contains(role)) {
            if (this.getPermissionedMethodsByRole().containsKey(role)) {
                Set alreadyPermissionedMethodsForThisRole = (Set)this.getPermissionedMethodsByRole().get(role);
                alreadyPermissionedMethodsForThisRole.remove(md);
                this.getPermissionedMethodsByRole().put(role, alreadyPermissionedMethodsForThisRole);
            }
        } else {
            throw new IllegalArgumentException(localStrings.getLocalString("enterprise.deployment.exceptioncannotaddrolesbndledoesnothave", "Cannot add roles when the bundle does not have them"));
        }
        this.changed();
    }

    public void removeResourceReferenceDescriptor(ResourceReferenceDescriptor resourceReference) {
        this.getResourceReferenceDescriptors().remove(resourceReference);
        this.changed();
    }

    void removeRole(Role role) {
        this.getPermissionedMethodsByRole().remove(role);
        HashSet roleReferences = new HashSet(this.getRoleReferences());
        Iterator itr = roleReferences.iterator();
        while (itr.hasNext()) {
            RoleReference roleReference = (RoleReference)itr.next();
            if (!roleReference.getRole().equals(role)) continue;
            roleReference.setValue("");
        }
    }

    public void removeRoleReference(RoleReference roleReference) {
        this.getRoleReferences().remove(roleReference);
        this.changed();
    }

    public void replaceEnvironmentProperty(EnvironmentProperty oldOne, EnvironmentProperty newOne) {
        this.getEnvironmentProperties().remove(oldOne);
        this.getEnvironmentProperties().add(newOne);
        this.changed();
    }

    public void setContainerTransactionFor(MethodDescriptor methodDescriptor, ContainerTransaction containerTransaction) {
        if (this._setContainerTransactionFor(methodDescriptor, containerTransaction)) {
            this.changed();
        }
    }

    public void setContainerTransactionFor(Method method, ContainerTransaction containerTransaction) {
        this.setContainerTransactionFor(new MethodDescriptor(method), containerTransaction);
    }

    void setEjbBundleDescriptor(EjbBundleDescriptor bundleDescriptor) {
        this.bundleDescriptor = bundleDescriptor;
    }

    public void setEjbClassName(String ejbClassName) {
        this.ejbClassName = ejbClassName;
    }

    public void setMethodContainerTransactions(Hashtable methodContainerTransactions) {
        boolean wasThereAChange = false;
        if (methodContainerTransactions == null || methodContainerTransactions.isEmpty()) {
            this.methodContainerTransactions = null;
            wasThereAChange = true;
        } else {
            Enumeration e10 = methodContainerTransactions.keys();
            while (e10.hasMoreElements()) {
                ContainerTransaction containerTransaction;
                MethodDescriptor methodDescriptor = (MethodDescriptor)e10.nextElement();
                if (!this._setContainerTransactionFor(methodDescriptor, containerTransaction = (ContainerTransaction)methodContainerTransactions.get(methodDescriptor))) continue;
                wasThereAChange = true;
            }
        }
        if (wasThereAChange) {
            this.changed();
        }
    }

    public void setPermissionedMethodsFor(Role role, Set methodDescriptors) {
        if (this.getEjbBundleDescriptor() == null) {
            throw new IllegalArgumentException(localStrings.getLocalString("enterprise.deployment.exceptioncannottsetpermissionuntilinbundle", "Can't set permissions until I am in a bundle"));
        }
        if (!this.getEjbBundleDescriptor().getRoles().contains(role)) {
            throw new IllegalArgumentException(localStrings.getLocalString("enterprise.deployment.exceptionrolenotinbundle", "{0} is not known to the bundle", new Object[]{role}));
        }
        this.getPermissionedMethodsByRole().put(role, methodDescriptors);
        this.changed();
    }

    public abstract void setTransactionType(String var1);

    public String toString() {
        String s2 = super.toString();
        s2 = String.valueOf(s2) + "\n ejbClassName " + this.ejbClassName;
        s2 = String.valueOf(s2) + "\n containerTransaction " + this.containerTransaction;
        s2 = String.valueOf(s2) + "\n transactionType " + this.transactionType;
        s2 = String.valueOf(s2) + "\n methodContainerTransactions " + this.getMethodContainerTransactions();
        s2 = String.valueOf(s2) + "\n environmentProperties " + this.environmentProperties;
        s2 = String.valueOf(s2) + "\n ejbReferences " + this.ejbReferences;
        s2 = String.valueOf(s2) + "\n resourceReferences " + this.resourceReferences;
        s2 = String.valueOf(s2) + "\n roleReferences " + this.roleReferences;
        Enumeration e10 = this.getPermissionedMethodsByRole().keys();
        while (e10.hasMoreElements()) {
            Role nextRole = (Role)e10.nextElement();
            s2 = String.valueOf(s2) + "\n role->method: " + nextRole + " -> " + this.getPermissionedMethodsByRole().get(nextRole);
        }
        return s2;
    }
}

