/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment;

import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.EjbBundleArchivist;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;

public class MethodDescriptor
extends Descriptor {
    public static String EJB_HOME = "Home";
    public static String EJB_REMOTE = "Remote";
    public static String EJB_BEAN = "Bean";
    public static String ALL_OF_NAME = "AllOfName";
    public static String ALL_EJB_METHODS = "*";
    private String[] parameterClassNames = null;
    private String className = "";
    private String ejbClassSymbol;
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(class$com$sun$enterprise$deployment$MethodDescriptor != null ? class$com$sun$enterprise$deployment$MethodDescriptor : (class$com$sun$enterprise$deployment$MethodDescriptor = MethodDescriptor.class$("com.sun.enterprise.deployment.MethodDescriptor")));
    static /* synthetic */ Class class$com$sun$enterprise$deployment$MethodDescriptor;

    public MethodDescriptor(String name, String description, String ejbClassSymbol) {
        super(name, description);
        this.parameterClassNames = null;
        this.setEjbClassSymbol(ejbClassSymbol);
    }

    public MethodDescriptor(String name, String description, String[] parameterClassNames, String ejbClassSymbol) {
        super(name, description);
        if (name == null) {
            super.setName("");
        }
        this.parameterClassNames = parameterClassNames;
        this.setEjbClassSymbol(ejbClassSymbol);
    }

    MethodDescriptor(Method method) {
        super(method.getName(), "");
        Class<?> methodClass = method.getClass();
        Method[] methods = methodClass.getMethods();
        int numberOfMethodsWithTheSameName = 0;
        int i2 = 0;
        while (i2 < methods.length) {
            if (methods[i2].getName().equals(method.getName())) {
                ++numberOfMethodsWithTheSameName;
            }
            ++i2;
        }
        this.parameterClassNames = this.getParameterClassNamesFor(method);
        this.className = method.getDeclaringClass().getName();
    }

    public MethodDescriptor(Method method, EjbDescriptor ejbDescriptor, ClassLoader classloader) {
        this(method);
        this.processEjbSymbol(method, ejbDescriptor, classloader);
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    Vector doStyleConversion(EjbDescriptor ejbDescriptor, Set allMethods) {
        Vector<MethodDescriptor> v2 = new Vector<MethodDescriptor>();
        if (this.getName().equals(ALL_EJB_METHODS)) {
            Iterator itr = allMethods.iterator();
            while (itr.hasNext()) {
                MethodDescriptor next = (MethodDescriptor)itr.next();
                next.isExact();
                next.setDescription(this.getDescription());
                if (this.getEjbClassSymbol().equals("")) {
                    v2.addElement(next);
                    continue;
                }
                if (!this.getEjbClassSymbol().equals(next.getEjbClassSymbol())) continue;
                v2.addElement(next);
            }
        } else if (this.getParameterClassNames() == null) {
            v2.addAll(this.getMethodDescriptorsOfName(this.getName(), allMethods));
        } else if (this.getEjbClassSymbol().equals("")) {
            v2.addAll(this.getMethodDescriptorsOfNameAndParameters(this.getName(), this.getParameterClassNames(), allMethods));
        } else {
            v2.addElement(this);
        }
        return v2;
    }

    public boolean equals(Object other) {
        MethodDescriptor otherMethodDescriptor;
        return other != null && other instanceof MethodDescriptor && (otherMethodDescriptor = (MethodDescriptor)other).getName().equals(this.getName()) && this.stringArrayEquals(otherMethodDescriptor.getParameterClassNames(), this.getParameterClassNames()) && this.getEjbClassSymbol().equals(otherMethodDescriptor.getEjbClassSymbol());
    }

    String getClassName(EjbDescriptor ejbDescriptor, ClassLoader classloader) throws Exception {
        if (!"".equals(this.className)) {
            return this.className;
        }
        try {
            Class<?> bean = null;
            Class<?> home = classloader.loadClass(ejbDescriptor.getHomeClassName());
            Class<?> remote = classloader.loadClass(ejbDescriptor.getRemoteClassName());
            bean = classloader.loadClass(ejbDescriptor.getEjbClassName());
            Method[] methods = home.getMethods();
            int i2 = 0;
            while (i2 < methods.length) {
                if (new MethodDescriptor(methods[i2], ejbDescriptor, classloader).equals(this)) {
                    this.className = methods[i2].getDeclaringClass().getName();
                    return this.className;
                }
                ++i2;
            }
            methods = remote.getMethods();
            int i3 = 0;
            while (i3 < methods.length) {
                if (new MethodDescriptor(methods[i3], ejbDescriptor, classloader).equals(this)) {
                    this.className = methods[i3].getDeclaringClass().getName();
                    return this.className;
                }
                ++i3;
            }
            methods = bean.getMethods();
            int i4 = 0;
            while (i4 < methods.length) {
                if (new MethodDescriptor(methods[i4], ejbDescriptor, classloader).equals(this)) {
                    this.className = methods[i4].getDeclaringClass().getName();
                    return this.className;
                }
                ++i4;
            }
            throw new RuntimeException(localStrings.getLocalString("enterprise.deployment.exceptionejbdescriptormethod", "{0} \n does not have a method {1}", new Object[]{ejbDescriptor, this}));
        }
        catch (Throwable t2) {
            t2.printStackTrace();
            System.out.println(classloader);
            if (Descriptor.isBoundsChecking()) {
                throw new Exception(localStrings.getLocalString("enterprise.deployment.exceptionmatchingmethoddescriptor", "{0} \n does not have a method {1}", new Object[]{ejbDescriptor, this}));
            }
            return "";
        }
    }

    public String getEjbClassSymbol() {
        if (this.ejbClassSymbol == null) {
            this.ejbClassSymbol = "";
        }
        return this.ejbClassSymbol;
    }

    public String getFormattedString() {
        return String.valueOf(this.getName()) + this.getPrettyParameterString();
    }

    private Set getMethodDescriptorsOfName(String name, Set methodDescriptors) {
        HashSet<MethodDescriptor> set = new HashSet<MethodDescriptor>();
        Iterator itr = methodDescriptors.iterator();
        while (itr.hasNext()) {
            MethodDescriptor next = (MethodDescriptor)itr.next();
            if (!name.equals(next.getName())) continue;
            next.isExact();
            if (this.getEjbClassSymbol().equals("")) {
                set.add(next);
                continue;
            }
            if (!this.getEjbClassSymbol().equals(next.getEjbClassSymbol())) continue;
            set.add(next);
        }
        return set;
    }

    private Set getMethodDescriptorsOfNameAndParameters(String name, String[] parameterArray, Set methodDescriptors) {
        HashSet<MethodDescriptor> methods = new HashSet<MethodDescriptor>();
        Iterator itr = this.getMethodDescriptorsOfName(name, methodDescriptors).iterator();
        while (itr.hasNext()) {
            MethodDescriptor next = (MethodDescriptor)itr.next();
            if (!this.stringArrayEquals(parameterArray, next.getParameterClassNames())) continue;
            next.isExact();
            methods.add(next);
        }
        return methods;
    }

    public String[] getParameterClassNames() {
        return this.parameterClassNames;
    }

    private String[] getParameterClassNamesFor(Method method) {
        Class<?>[] classes = method.getParameterTypes();
        String[] classNames = new String[classes.length];
        int i2 = 0;
        while (i2 < classes.length) {
            classNames[i2] = classes[i2].getName();
            ++i2;
        }
        return classNames;
    }

    private String getParameterStringFor(Method method) {
        return "";
    }

    public String getPrettyParameterString() {
        String prettyParameterString = "(";
        if (this.parameterClassNames != null) {
            int i2 = 0;
            while (i2 < this.parameterClassNames.length) {
                int j2 = i2 + 1;
                prettyParameterString = i2 > 0 ? String.valueOf(prettyParameterString) + ", " + this.parameterClassNames[i2] + " parameter" + j2 : String.valueOf(prettyParameterString) + this.parameterClassNames[i2] + " parameter" + j2;
                ++i2;
            }
        } else {
            prettyParameterString = "unspecified";
        }
        prettyParameterString = String.valueOf(prettyParameterString) + ")";
        return prettyParameterString;
    }

    public int hashCode() {
        return this.getPrettyParameterString().hashCode() + this.getName().hashCode();
    }

    public boolean isEquivalent(Method method) {
        return this.equals(new MethodDescriptor(method));
    }

    public boolean isExact() {
        boolean isExactName = this.getName().equals(ALL_EJB_METHODS) ^ true;
        boolean hasMethodIntf = "".equals(this.getEjbClassSymbol()) ^ true;
        boolean hasParamsListed = this.getParameterClassNames() != null;
        return isExactName && hasMethodIntf && hasParamsListed;
    }

    void processEjbSymbol(Method method, EjbDescriptor ejbDescriptor, ClassLoader classloader) {
        block7: {
            try {
                Class<?> bean;
                Class<?> remote;
                Class<?> home;
                Class<?> declaringClass = null;
                String declaringClassname = method.getDeclaringClass().getName();
                if (classloader != null) {
                    home = classloader.loadClass(ejbDescriptor.getHomeClassName());
                    remote = classloader.loadClass(ejbDescriptor.getRemoteClassName());
                    bean = classloader.loadClass(ejbDescriptor.getEjbClassName());
                    declaringClass = classloader.loadClass(declaringClassname);
                } else {
                    ClassLoader cl2 = ((EjbBundleArchivist)ejbDescriptor.getEjbBundleDescriptor().getArchivist()).getClassLoader();
                    home = cl2.loadClass(ejbDescriptor.getHomeClassName());
                    remote = cl2.loadClass(ejbDescriptor.getRemoteClassName());
                    bean = cl2.loadClass(ejbDescriptor.getEjbClassName());
                    declaringClass = classloader.loadClass(declaringClassname);
                }
                if (declaringClass.isAssignableFrom(home)) {
                    this.ejbClassSymbol = EJB_HOME;
                    break block7;
                }
                if (declaringClass.isAssignableFrom(remote)) {
                    this.ejbClassSymbol = EJB_REMOTE;
                    break block7;
                }
                if (declaringClass.isAssignableFrom(bean)) {
                    this.ejbClassSymbol = EJB_BEAN;
                    break block7;
                }
                System.out.println("method class = " + declaringClass);
                System.out.println("home class = " + home);
                System.out.println("remote class = " + remote);
                System.out.println("bean class = " + bean);
                throw new IllegalArgumentException();
            }
            catch (Throwable t2) {
                t2.printStackTrace();
                throw new IllegalArgumentException(localStrings.getLocalString("enterprise.deployment.exceptionmethodnotfound", "{0} not found in {1}", new Object[]{method, ejbDescriptor}));
            }
        }
    }

    public void setEjbClassSymbol(String ejbClassSymbol) {
        this.ejbClassSymbol = ejbClassSymbol;
    }

    private boolean stringArrayEquals(String[] s1, String[] s2) {
        if (s1 == null && s2 == null) {
            return true;
        }
        if (s1 == null && s2 != null) {
            return false;
        }
        if (s2 == null && s1 != null) {
            return false;
        }
        if (s1.length == s2.length) {
            int i2 = 0;
            while (i2 < s1.length) {
                if (!s1[i2].equals(s2[i2])) {
                    return false;
                }
                ++i2;
            }
            return true;
        }
        return false;
    }

    public String toString() {
        return "\nMethod Descriptor: name: " + this.getName() + " params: " + this.getPrettyParameterString() + " intf: " + this.ejbClassSymbol;
    }
}

