/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment;

import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.EnvironmentProperty;
import com.sun.enterprise.deployment.MailConfiguration;
import com.sun.enterprise.deployment.NamedDescriptor;
import com.sun.enterprise.resource.ResourcePrincipal;
import org.apache.tomcat.deployment.ResourceReference;

public class ResourceReferenceDescriptor
extends EnvironmentProperty
implements NamedDescriptor,
ResourceReference {
    public static String APPLICATION_AUTHORIZATION = "Application";
    public static String CONTAINER_AUTHORIZATION = "Container";
    private String type;
    private ResourcePrincipal resourcePrincipal = null;
    private MailConfiguration mailConfiguration;
    private String authorization;

    public ResourceReferenceDescriptor() {
    }

    public ResourceReferenceDescriptor(String name, String description, String type) {
        super(name, "", description);
        this.type = type;
    }

    public boolean equals(Object object) {
        if (object instanceof ResourceReference) {
            ResourceReference resourceReference = (ResourceReference)object;
            return resourceReference.getName().equals(this.getName());
        }
        return false;
    }

    public String getAuthorization() {
        if (this.authorization == null) {
            this.authorization = APPLICATION_AUTHORIZATION;
        }
        return this.authorization;
    }

    public String getJndiName() {
        return super.getValue();
    }

    public MailConfiguration getMailConfiguration() {
        return this.mailConfiguration;
    }

    public ResourcePrincipal getResourcePrincipal() {
        return this.resourcePrincipal;
    }

    public String getType() {
        return this.type;
    }

    public boolean isContainerAuthorization() {
        return this.getAuthorization().equals(CONTAINER_AUTHORIZATION);
    }

    public boolean isMailResource() {
        return this.getMailConfiguration() != null;
    }

    public boolean isResolved() {
        return true;
    }

    public void setAuthorization(String authorization) {
        Descriptor.isBoundsChecking();
        this.authorization = authorization;
    }

    public void setJndiName(String jndiName) {
        super.setValue(jndiName);
    }

    public void setMailConfiguration(MailConfiguration mailConfiguration) {
        this.mailConfiguration = mailConfiguration;
    }

    public void setResourcePrincipal(ResourcePrincipal resourcePrincipal) {
        this.resourcePrincipal = resourcePrincipal;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String toString() {
        String toString = "Res-Ref-Env-Property: " + super.getName() + "@" + this.getType() + "@" + super.getDescription();
        if (this.isResolved()) {
            toString = String.valueOf(toString) + " resolved as: jndi: " + this.getJndiName() + "@res principal: " + this.getResourcePrincipal() + "@mail: " + this.getMailConfiguration();
        }
        return toString;
    }
}

