/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.xml;

import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.ApplicationClientDescriptor;
import com.sun.enterprise.deployment.Archivist;
import com.sun.enterprise.deployment.BundleDescriptor;
import com.sun.enterprise.deployment.EjbBundleDescriptor;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.EjbReferenceDescriptor;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.deployment.xml.ContentTransformationException;
import com.sun.enterprise.deployment.xml.DescriptorNodeUtils;
import com.sun.enterprise.deployment.xml.ParseException;
import com.sun.enterprise.deployment.xml.RuntimeDescriptorNode;
import com.sun.enterprise.deployment.xml.XMLUtils;
import com.sun.enterprise.security.acl.Role;
import com.sun.enterprise.util.DescriptorGenerator;
import com.sun.xml.tree.ElementNode;
import com.sun.xml.tree.XmlDocument;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.StringWriter;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class ApplicationNode
extends ElementNode {
    public static String PUBLIC_DTD_ID = "-//Sun Microsystems, Inc.//DTD J2EE Application 1.2//EN";
    public static String SYSTEM_ID = "http://java.sun.com/j2ee/dtds/application_1_2.dtd";
    private Hashtable contextRootMap = new Hashtable();
    private Hashtable ejbBundleArchiveMap = new Hashtable();
    private Hashtable webBundleArchiveMap = new Hashtable();
    private Hashtable applicationClientDescriptorArchiveMap = new Hashtable();
    static /* synthetic */ Class class$com$sun$enterprise$deployment$xml$ApplicationNode;
    static /* synthetic */ Class class$com$sun$enterprise$deployment$xml$RuntimeDescriptorNode;

    public ApplicationNode() {
        this.setTag("application");
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    public Application getApplication(ClassLoader classLoader) throws ContentTransformationException {
        try {
            Application application = new Application("", new File(""));
            DescriptorNodeUtils.setDescriptorAttributes(this, application, DescriptorNodeUtils.APP_STYLE);
            Enumeration e10 = XMLUtils.getNodesUnder((Node)this, "module");
            while (e10.hasMoreElements()) {
                ElementNode moduleNode = (ElementNode)e10.nextElement();
                String externalDDUri = "";
                if (XMLUtils.getFirstNodeUnder(moduleNode, "alt-dd") != null) {
                    externalDDUri = XMLUtils.getTextFor(moduleNode, "alt-dd");
                }
                if (XMLUtils.hasNodesUnder(moduleNode, "web")) {
                    ElementNode webNode = XMLUtils.getFirstNodeUnder(moduleNode, "web");
                    String webArchiveUri = XMLUtils.getTextFor(webNode, "web-uri");
                    String contextRoot = XMLUtils.getTextFor(webNode, "context-root");
                    this.contextRootMap.put(webArchiveUri, contextRoot);
                    this.webBundleArchiveMap.put(webArchiveUri, externalDDUri);
                }
                if (XMLUtils.hasNodesUnder(moduleNode, "ejb")) {
                    ElementNode ejbNode = XMLUtils.getFirstNodeUnder(moduleNode, "ejb");
                    String ejbArchiveUri = XMLUtils.getTextFor(moduleNode, "ejb");
                    this.ejbBundleArchiveMap.put(ejbArchiveUri, externalDDUri);
                }
                if (!XMLUtils.hasNodesUnder(moduleNode, "java")) continue;
                ElementNode acNode = XMLUtils.getFirstNodeUnder(moduleNode, "java");
                String acArchiveUri = XMLUtils.getTextFor(moduleNode, "java");
                this.applicationClientDescriptorArchiveMap.put(acArchiveUri, externalDDUri);
            }
            Enumeration e11 = XMLUtils.getNodesUnder((Node)this, "security-role");
            while (e11.hasMoreElements()) {
                ElementNode next = (ElementNode)e11.nextElement();
                Role r2 = new Role(XMLUtils.getTextFor(next, "role-name"));
                if (XMLUtils.hasNodesUnder(next, "description")) {
                    r2.setDescription(XMLUtils.getTextFor(next, "description"));
                }
                application.addRole(r2);
            }
            return application;
        }
        catch (IllegalArgumentException iae) {
            iae.printStackTrace();
            throw new ContentTransformationException(iae.getMessage(), this.toString());
        }
    }

    public Hashtable getApplicationClientDescriptorArchiveMap() {
        return this.applicationClientDescriptorArchiveMap;
    }

    public String getContextRootFor(String entryName) {
        if (this.contextRootMap.get(entryName) != null) {
            return (String)this.contextRootMap.get(entryName);
        }
        throw new RuntimeException("Cannot find context root for web bundle with entry " + entryName + " in this ear");
    }

    public static XmlDocument getDocument(Application application) {
        XmlDocument document = new XmlDocument();
        document.setDoctype(PUBLIC_DTD_ID, SYSTEM_ID, null);
        ApplicationNode n2 = new ApplicationNode();
        document.appendChild(n2);
        n2.setDescriptor(application);
        return document;
    }

    public Hashtable getEjbBundleArchiveMap() {
        return this.ejbBundleArchiveMap;
    }

    public Hashtable getWebBundleArchiveMap() {
        return this.webBundleArchiveMap;
    }

    public static void main(String[] args) {
        try {
            ApplicationNode.write();
            ApplicationNode.read();
        }
        catch (Throwable t2) {
            t2.printStackTrace();
        }
    }

    private static void read() throws Throwable {
        Vector applicationNodes = ApplicationNode.readApplicationNodes(new FileInputStream(new File("application.xml")));
        ApplicationNode an2 = (ApplicationNode)applicationNodes.elementAt(0);
        Application a = an2.getApplication(null);
        System.out.println(a);
        System.out.println("wrote out to xml then read back an application");
    }

    public static ApplicationNode read(InputStream is) throws ParseException {
        Vector nodes = ApplicationNode.readApplicationNodes(is);
        if (nodes.size() > 0) {
            return (ApplicationNode)nodes.elementAt(0);
        }
        throw new ParseException("No application nodes were found");
    }

    public static Vector readApplicationNodes(InputStream is) throws ParseException {
        try {
            Hashtable<String, String> nodeToClass = new Hashtable<String, String>();
            nodeToClass.put(RuntimeDescriptorNode.RUNTIME_TAG, "com.sun.enterprise.deployment.xml.RuntimeDescriptorNode");
            nodeToClass.put("application", "com.sun.enterprise.deployment.xml.ApplicationNode");
            Vector applicationNodes = XMLUtils.getNodesByType(class$com$sun$enterprise$deployment$xml$ApplicationNode != null ? class$com$sun$enterprise$deployment$xml$ApplicationNode : (class$com$sun$enterprise$deployment$xml$ApplicationNode = ApplicationNode.class$("com.sun.enterprise.deployment.xml.ApplicationNode")), nodeToClass, is);
            return applicationNodes;
        }
        catch (SAXException se) {
            throw new ParseException(se);
        }
        catch (Throwable t2) {
            throw new ParseException(t2.getMessage());
        }
    }

    public static RuntimeDescriptorNode readRtdn(InputStream is) {
        try {
            Hashtable<String, String> nodeToClass = new Hashtable<String, String>();
            nodeToClass.put(RuntimeDescriptorNode.RUNTIME_TAG, "com.sun.enterprise.util.xml.RuntimeDescriptorNode");
            Vector rtNodes = XMLUtils.getNodesByType(class$com$sun$enterprise$deployment$xml$RuntimeDescriptorNode != null ? class$com$sun$enterprise$deployment$xml$RuntimeDescriptorNode : (class$com$sun$enterprise$deployment$xml$RuntimeDescriptorNode = ApplicationNode.class$("com.sun.enterprise.deployment.xml.RuntimeDescriptorNode")), nodeToClass, is);
            return (RuntimeDescriptorNode)rtNodes.elementAt(0);
        }
        catch (Throwable t2) {
            t2.printStackTrace();
            return null;
        }
    }

    public static void resolveInterJarEjbReferences(Application application) {
        Enumeration e10 = application.getEjbReferenceDescriptors().elements();
        while (e10.hasMoreElements()) {
            EjbReferenceDescriptor next = (EjbReferenceDescriptor)e10.nextElement();
            if (!EjbReferenceDescriptor.INTERNAL_UNRESOLVED_STATE.equals(next.getState()) || !application.hasEjbByName(next.getLinkName())) continue;
            EjbDescriptor ejbReferee = application.getEjbByName(next.getLinkName());
            next.setEjbDescriptor(ejbReferee);
        }
    }

    public void setDescriptor(Application application) {
        if (this.getOwnerDocument() == null) {
            throw new IllegalArgumentException("Cannot set the descriptor unless this node has been added to a document");
        }
        XMLUtils factory = new XMLUtils(this.getOwnerDocument());
        DescriptorNodeUtils.appendDescriptorAttributes(factory, application, this, DescriptorNodeUtils.APP_STYLE);
        Iterator itr = application.getArchivableDescriptors().iterator();
        while (itr.hasNext()) {
            BundleDescriptor next = (BundleDescriptor)itr.next();
            Archivist nextArchivist = next.getArchivist();
            ElementNode moduleNode = factory.getNode("module");
            this.appendChild(moduleNode);
            if (nextArchivist.hasExternalDescriptor()) {
                moduleNode.appendChild(factory.getTextNode("alt-dd", nextArchivist.getExternalDescriptorArchiveUri()));
            }
            if (next instanceof WebBundleDescriptor) {
                ElementNode webNode = factory.getNode("web");
                moduleNode.appendChild(webNode);
                webNode.appendChild(factory.getTextNode("web-uri", next.getArchivist().getArchiveUri()));
                webNode.appendChild(factory.getTextNode("context-root", ((WebBundleDescriptor)next).getContextRoot()));
                continue;
            }
            if (next instanceof EjbBundleDescriptor) {
                ElementNode ejbNode = factory.getTextNode("ejb", next.getArchivist().getArchiveUri());
                moduleNode.appendChild(ejbNode);
                continue;
            }
            if (!(next instanceof ApplicationClientDescriptor)) continue;
            ElementNode acNode = factory.getTextNode("java", next.getArchivist().getArchiveUri());
            moduleNode.appendChild(acNode);
        }
        Iterator itr2 = application.getRoles().iterator();
        while (itr2.hasNext()) {
            Role next = (Role)itr2.next();
            ElementNode srNode = factory.getNode("security-role");
            this.appendChild(srNode);
            if (!"".equals(next.getDescription())) {
                srNode.appendChild(factory.getTextNode("description", next.getDescription()));
            }
            srNode.appendChild(factory.getTextNode("role-name", next.getName()));
        }
    }

    private static void write() throws Throwable {
        XmlDocument document = ApplicationNode.getDocument(DescriptorGenerator.getDefaultApplication());
        XMLUtils.writeDocumentToFile(document, new File("application.xml"));
        StringWriter sw = new StringWriter();
        XMLUtils.writeDocument(document, sw);
        System.out.println(sw.toString());
    }
}

