/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.xml;

import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.EjbAbstractDescriptor;
import com.sun.enterprise.deployment.EjbReferenceDescriptor;
import com.sun.enterprise.deployment.EnvironmentProperty;
import com.sun.enterprise.deployment.ResourceReferenceDescriptor;
import com.sun.enterprise.deployment.WritableJndiNameEnvironment;
import com.sun.enterprise.deployment.xml.XMLUtils;
import com.sun.xml.tree.ElementNode;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Vector;
import org.w3c.dom.Node;

public class DescriptorNodeUtils {
    static String EJB_STYLE = "EJB_STYLE";
    static String WEB_STYLE = "WEB_STYLE";
    static String SERVLET_STYLE = "SERVLET_STYLE";
    static String APP_STYLE = "APP_STYLE";
    static String APP_CLIENT_STYLE = "APP_CLIENT_STYLE";

    public static void appendDescriptorAttributes(XMLUtils factory, Descriptor descriptor, ElementNode elementNode, String style) {
        DescriptorNodeUtils.appendDescriptorAttributes(factory, descriptor, elementNode, style, null);
    }

    public static void appendDescriptorAttributes(XMLUtils factory, Descriptor descriptor, ElementNode elementNode, String style, ElementNode extraNodeForWeb) {
        ElementNode descriptionNode = null;
        ElementNode displayNameNode = null;
        ElementNode iconNode = null;
        ElementNode smallIconNode = null;
        ElementNode largeIconNode = null;
        Vector<ElementNode> iconNodes = new Vector<ElementNode>();
        if (!"".equals(descriptor.getDescription())) {
            descriptionNode = factory.getTextNode("description", descriptor.getDescription());
        }
        if (!"".equals(descriptor.getName())) {
            displayNameNode = factory.getTextNode("display-name", descriptor.getName());
        }
        iconNode = factory.getNode("icon");
        if (!"".equals(descriptor.getLargeIconUri())) {
            largeIconNode = factory.getTextNode("large-icon", descriptor.getLargeIconUri());
        }
        if (!"".equals(descriptor.getSmallIconUri())) {
            smallIconNode = factory.getTextNode("small-icon", descriptor.getSmallIconUri());
        }
        if (EJB_STYLE.equals(style)) {
            if (smallIconNode != null) {
                iconNodes.addElement(smallIconNode);
            }
            if (largeIconNode != null) {
                iconNodes.addElement(largeIconNode);
            }
        } else if (smallIconNode != null || largeIconNode != null) {
            iconNodes.addElement(iconNode);
            if (smallIconNode != null) {
                iconNode.appendChild(smallIconNode);
            }
            if (largeIconNode != null) {
                iconNode.appendChild(largeIconNode);
            }
        }
        if (EJB_STYLE.equals(style)) {
            if (descriptionNode != null) {
                elementNode.appendChild(descriptionNode);
            }
            if (displayNameNode != null) {
                elementNode.appendChild(displayNameNode);
            }
            Enumeration e10 = iconNodes.elements();
            while (e10.hasMoreElements()) {
                elementNode.appendChild((ElementNode)e10.nextElement());
            }
        } else {
            Enumeration e11 = iconNodes.elements();
            while (e11.hasMoreElements()) {
                elementNode.appendChild((ElementNode)e11.nextElement());
            }
            if (SERVLET_STYLE.equals(style)) {
                elementNode.appendChild(extraNodeForWeb);
            }
            if (displayNameNode != null) {
                elementNode.appendChild(displayNameNode);
            }
            if (descriptionNode != null) {
                elementNode.appendChild(descriptionNode);
            }
        }
    }

    public static void appendEjbReferences(XMLUtils factory, WritableJndiNameEnvironment descriptor, ElementNode elementNode) {
        Iterator itr = descriptor.getEjbReferenceDescriptors().iterator();
        while (itr.hasNext()) {
            EjbReferenceDescriptor nextEjbReference = (EjbReferenceDescriptor)itr.next();
            ElementNode ejbReferenceNode = factory.getNode("ejb-ref");
            elementNode.appendChild(ejbReferenceNode);
            if (!"".equals(nextEjbReference.getDescription())) {
                ejbReferenceNode.appendChild(factory.getTextNode("description", nextEjbReference.getDescription()));
            }
            ejbReferenceNode.appendChild(factory.getTextNode("ejb-ref-name", nextEjbReference.getName()));
            ejbReferenceNode.appendChild(factory.getTextNode("ejb-ref-type", nextEjbReference.getEjbDescriptor().getType()));
            ejbReferenceNode.appendChild(factory.getTextNode("home", nextEjbReference.getEjbDescriptor().getHomeClassName()));
            ejbReferenceNode.appendChild(factory.getTextNode("remote", nextEjbReference.getEjbDescriptor().getRemoteClassName()));
            if (!nextEjbReference.isLinked()) continue;
            ejbReferenceNode.appendChild(factory.getTextNode("ejb-link", nextEjbReference.getLinkName()));
        }
    }

    public static void appendEnvironmentProperties(XMLUtils factory, WritableJndiNameEnvironment descriptor, ElementNode elementNode) {
        Iterator itr = descriptor.getEnvironmentProperties().iterator();
        while (itr.hasNext()) {
            EnvironmentProperty nextEnvironmentProperty = (EnvironmentProperty)itr.next();
            ElementNode environmentPropertyNode = factory.getNode("env-entry");
            elementNode.appendChild(environmentPropertyNode);
            if (!nextEnvironmentProperty.getDescription().equals("")) {
                environmentPropertyNode.appendChild(factory.getTextNode("description", nextEnvironmentProperty.getDescription()));
            }
            environmentPropertyNode.appendChild(factory.getTextNode("env-entry-name", nextEnvironmentProperty.getName()));
            environmentPropertyNode.appendChild(factory.getTextNode("env-entry-type", nextEnvironmentProperty.getValueType().getName()));
            if (nextEnvironmentProperty.getValue().equals("")) continue;
            environmentPropertyNode.appendChild(factory.getTextNode("env-entry-value", nextEnvironmentProperty.getValue()));
        }
    }

    public static void appendResourceReferences(XMLUtils factory, WritableJndiNameEnvironment descriptor, ElementNode elementNode) {
        Iterator itr = descriptor.getResourceReferenceDescriptors().iterator();
        while (itr.hasNext()) {
            ResourceReferenceDescriptor nextResourceReference = (ResourceReferenceDescriptor)itr.next();
            ElementNode resourceReferenceNode = factory.getNode("resource-ref");
            elementNode.appendChild(resourceReferenceNode);
            if (!nextResourceReference.getDescription().equals("")) {
                resourceReferenceNode.appendChild(factory.getTextNode("description", nextResourceReference.getDescription()));
            }
            resourceReferenceNode.appendChild(factory.getTextNode("res-ref-name", nextResourceReference.getName()));
            resourceReferenceNode.appendChild(factory.getTextNode("res-type", nextResourceReference.getType()));
            resourceReferenceNode.appendChild(factory.getTextNode("res-auth", nextResourceReference.getAuthorization()));
        }
    }

    public static void checkEjbReference(EjbAbstractDescriptor refereeBean, String referenceType, String homeClassName, String remoteClassName, String ejbRefereeName) {
        if (Descriptor.isBoundsChecking()) {
            if (!refereeBean.getType().equals(referenceType)) {
                throw new IllegalArgumentException(String.valueOf(refereeBean.getName()) + " says it links to an ejb called " + ejbRefereeName + " of type " + referenceType + " but no bean of this name and type can be found in this ejb-jar.");
            }
            if (!refereeBean.getHomeClassName().equals(homeClassName)) {
                throw new IllegalArgumentException(String.valueOf(refereeBean.getName()) + " says it links to an ejb called " + ejbRefereeName + " of home class " + homeClassName + " but no bean with this home classname and type can be found in this ejb-jar.");
            }
            if (!refereeBean.getRemoteClassName().equals(remoteClassName)) {
                throw new IllegalArgumentException(String.valueOf(refereeBean.getName()) + " says it links to an ejb called " + ejbRefereeName + " of remote class " + remoteClassName + " but no bean with this remote classname and type can be found in this ejb-jar.");
            }
        }
    }

    public static void setDescriptorAttributes(ElementNode elementNode, Descriptor descriptor, String style) {
        if (XMLUtils.hasImmediateElementChildFor(elementNode, "description")) {
            descriptor.setDescription(XMLUtils.getTextFor(elementNode, "description"));
        }
        if (XMLUtils.hasImmediateElementChildFor(elementNode, "display-name")) {
            descriptor.setName(XMLUtils.getTextFor(elementNode, "display-name"));
        }
        ElementNode iconHolderNode = null;
        iconHolderNode = EJB_STYLE.equals(style) ? elementNode : XMLUtils.getFirstNodeUnder(elementNode, "icon");
        if (iconHolderNode != null) {
            if (XMLUtils.hasImmediateElementChildFor(iconHolderNode, "large-icon")) {
                descriptor.setLargeIconUri(XMLUtils.getTextFor(elementNode, "large-icon"));
            }
            if (XMLUtils.hasImmediateElementChildFor(iconHolderNode, "small-icon")) {
                descriptor.setSmallIconUri(XMLUtils.getTextFor(elementNode, "small-icon"));
            }
        }
    }

    public static void setEnvironmentProperties(ElementNode elementNode, WritableJndiNameEnvironment descriptor) {
        Enumeration e10 = XMLUtils.getNodesUnder((Node)elementNode, "env-entry");
        while (e10.hasMoreElements()) {
            ElementNode nextEnvironmentPropertyNode = (ElementNode)e10.nextElement();
            String optionalDescription = "";
            if (XMLUtils.hasNodesUnder(nextEnvironmentPropertyNode, "description")) {
                optionalDescription = XMLUtils.getTextFor(nextEnvironmentPropertyNode, "description");
            }
            String value = "";
            if (XMLUtils.hasNodesUnder(nextEnvironmentPropertyNode, "env-entry-value")) {
                value = XMLUtils.getTextFor(nextEnvironmentPropertyNode, "env-entry-value");
            }
            String type = XMLUtils.getTextFor(nextEnvironmentPropertyNode, "env-entry-type");
            EnvironmentProperty environmentProperty = new EnvironmentProperty(XMLUtils.getTextFor(nextEnvironmentPropertyNode, "env-entry-name"), value, optionalDescription, type);
            descriptor.addEnvironmentProperty(environmentProperty);
        }
    }

    public static void setResourceReferences(ElementNode elementNode, WritableJndiNameEnvironment descriptor) {
        Enumeration e10 = XMLUtils.getNodesUnder((Node)elementNode, "resource-ref");
        while (e10.hasMoreElements()) {
            ElementNode nextResourceNode = (ElementNode)e10.nextElement();
            String optionalDescription = "";
            if (XMLUtils.hasNodesUnder(nextResourceNode, "description")) {
                optionalDescription = XMLUtils.getTextFor(nextResourceNode, "description");
            }
            String resourceReferenceName = XMLUtils.getTextFor(nextResourceNode, "res-ref-name");
            ResourceReferenceDescriptor resourceReference = new ResourceReferenceDescriptor(resourceReferenceName, optionalDescription, XMLUtils.getTextFor(nextResourceNode, "res-type"));
            resourceReference.setAuthorization(XMLUtils.getTextFor(nextResourceNode, "res-auth"));
            descriptor.addResourceReferenceDescriptor(resourceReference);
        }
    }
}

