/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.distributedtx;

import com.sun.ejb.Container;
import com.sun.enterprise.ComponentInvocation;
import com.sun.enterprise.InvocationManager;
import com.sun.enterprise.J2EETransactionManager;
import com.sun.enterprise.Switch;
import com.sun.enterprise.log.Log;
import java.io.Serializable;
import java.rmi.RemoteException;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.UserTransaction;

public class UserTransactionImpl
implements UserTransaction,
Serializable {
    private static final boolean debug = false;
    private transient J2EETransactionManager transactionManager;
    private transient InvocationManager invocationManager;
    private transient boolean initialized;
    private transient UserTransaction userTx;
    private transient int transactionTimeout;

    public UserTransactionImpl() {
        this.init();
    }

    public void begin() throws NotSupportedException, SystemException {
        if (!this.initialized) {
            this.init();
        }
        if (this.userTx != null) {
            this.userTx.begin();
            return;
        }
        this.transactionManager.begin(this.transactionTimeout);
        ComponentInvocation inv = this.invocationManager.getCurrentInvocation();
        try {
            if (inv.container instanceof Container) {
                ((Container)inv.container).doAfterBegin(inv);
            }
            inv.setTransaction(this.transactionManager.getTransaction());
            this.transactionManager.enlistComponentResources();
        }
        catch (RemoteException ex2) {
            Log.err.println(ex2);
            throw new SystemException();
        }
    }

    public void commit() throws RollbackException, HeuristicMixedException, HeuristicRollbackException, SecurityException, IllegalStateException, SystemException {
        if (!this.initialized) {
            this.init();
        }
        if (this.userTx != null) {
            this.userTx.commit();
            return;
        }
        try {
            try {
                this.transactionManager.delistComponentResources();
                this.transactionManager.commit();
            }
            catch (RemoteException ex2) {
                Log.err.println(ex2);
                throw new SystemException();
            }
            Object var2_4 = null;
        }
        catch (Throwable throwable) {
            Object var2_5 = null;
            ComponentInvocation inv = this.invocationManager.getCurrentInvocation();
            inv.setTransaction(null);
            throw throwable;
        }
        ComponentInvocation inv = this.invocationManager.getCurrentInvocation();
        inv.setTransaction(null);
    }

    public int getStatus() throws SystemException {
        if (!this.initialized) {
            this.init();
        }
        if (this.userTx != null) {
            return this.userTx.getStatus();
        }
        return this.transactionManager.getStatus();
    }

    private void init() {
        this.initialized = true;
        Switch theSwitch = Switch.getSwitch();
        this.transactionManager = theSwitch.getTransactionManager();
        this.invocationManager = theSwitch.getInvocationManager();
        if (this.transactionManager == null) {
            this.userTx = new com.sun.jts.jta.UserTransactionImpl();
        }
    }

    public void rollback() throws IllegalStateException, SecurityException, SystemException {
        if (!this.initialized) {
            this.init();
        }
        if (this.userTx != null) {
            this.userTx.rollback();
            return;
        }
        try {
            try {
                this.transactionManager.delistComponentResources();
                this.transactionManager.rollback();
            }
            catch (RemoteException ex2) {
                Log.err.println(ex2);
                throw new SystemException();
            }
            Object var2_4 = null;
        }
        catch (Throwable throwable) {
            Object var2_5 = null;
            ComponentInvocation inv = this.invocationManager.getCurrentInvocation();
            inv.setTransaction(null);
            throw throwable;
        }
        ComponentInvocation inv = this.invocationManager.getCurrentInvocation();
        inv.setTransaction(null);
    }

    public void setRollbackOnly() throws IllegalStateException, SystemException {
        if (!this.initialized) {
            this.init();
        }
        if (this.userTx != null) {
            this.userTx.setRollbackOnly();
            return;
        }
        this.transactionManager.setRollbackOnly();
    }

    public void setTransactionTimeout(int seconds) throws SystemException {
        if (!this.initialized) {
            this.init();
        }
        if (this.userTx != null) {
            this.userTx.setTransactionTimeout(seconds);
            return;
        }
        if (seconds < 0) {
            seconds = 0;
        }
        this.transactionTimeout = seconds;
    }
}

