/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.log;

import com.sun.enterprise.log.LogNotFoundException;
import com.sun.enterprise.log.RemoteFileReader;
import com.sun.enterprise.security.auth.RemoteObject;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.rmi.RemoteException;

public class RemoteFileReaderImpl
extends RemoteObject
implements RemoteFileReader {
    private String name;
    private RandomAccessFile raf;

    public RemoteFileReaderImpl(String name) throws RemoteException {
        this.name = new String(name);
        this.exportObject(this);
    }

    public void close() throws RemoteException, IOException {
        this.raf.close();
    }

    public long getFilePointer() throws RemoteException, IOException {
        return this.raf.getFilePointer();
    }

    public String getName() throws RemoteException {
        return this.name;
    }

    public long length() throws RemoteException, IOException {
        return this.raf.length();
    }

    public void open() throws RemoteException, LogNotFoundException {
        try {
            this.raf = new RandomAccessFile(this.name, "r");
        }
        catch (FileNotFoundException e10) {
            e10.printStackTrace(System.out);
            throw new LogNotFoundException(this.name);
        }
        catch (Exception e11) {
            e11.printStackTrace(System.out);
            throw new RemoteException();
        }
    }

    public byte[] read(int noOfBytesToRead) throws RemoteException, IOException {
        byte[] buff = new byte[noOfBytesToRead];
        this.raf.read(buff);
        return buff;
    }

    public String readLine() throws RemoteException, IOException {
        return this.raf.readLine();
    }

    public String readLine(int noOfLines) throws RemoteException, IOException {
        StringBuffer buff = new StringBuffer();
        int i2 = 0;
        while (i2 < noOfLines) {
            String tmp = new String();
            tmp = null;
            tmp = this.readLine();
            if (tmp == null) break;
            buff.append(tmp);
            buff.append("\n");
            ++i2;
        }
        return buff.toString();
    }

    public void seek(long position) throws RemoteException, IOException {
        this.raf.seek(position);
    }
}

