/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.naming;

import com.sun.enterprise.naming.NameClassPairEnumeration;
import com.sun.enterprise.naming.SerialNameParser;
import com.sun.jndi.cosnaming.CNCtx;
import java.rmi.Remote;
import java.util.Hashtable;
import java.util.Vector;
import javax.naming.CompositeName;
import javax.naming.Context;
import javax.naming.InvalidNameException;
import javax.naming.Name;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NameClassPair;
import javax.naming.NameNotFoundException;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.OperationNotSupportedException;
import javax.naming.spi.NamingManager;
import org.omg.CORBA.Object;

public class EJBCtx
implements Context {
    private static final boolean debug = false;
    private Context dsContext;
    private Context cosContext;
    private Hashtable myEnv;
    static NameParser myParser = new SerialNameParser();

    EJBCtx(Hashtable env) throws NamingException {
        this.myEnv = env != null ? (Hashtable)env.clone() : null;
        try {
            this.myEnv.put("java.naming.factory.initial", "com.sun.jndi.cosnaming.CNCtxFactory");
            this.cosContext = NamingManager.getInitialContext(this.myEnv);
            this.myEnv.put("java.naming.factory.initial", "com.sun.enterprise.naming.SerialInitContextFactory");
            this.dsContext = NamingManager.getInitialContext(this.myEnv);
        }
        catch (Exception e10) {
            throw new NamingException("Error accessing repository: " + e10.getMessage());
        }
    }

    public java.lang.Object addToEnvironment(String propName, java.lang.Object propVal) throws NamingException {
        if (this.myEnv == null) {
            this.myEnv = new Hashtable(5, 0.75f);
        }
        return this.myEnv.put(propName, propVal);
    }

    public void bind(String name, java.lang.Object obj) throws NamingException {
        if (name.length() == 0) {
            throw new InvalidNameException("Name is empty");
        }
        if (this.isCORBAObjectOrContext(obj)) {
            try {
                this.dsContext.lookup(name);
                throw new NameAlreadyBoundException();
            }
            catch (NameNotFoundException nameNotFoundException) {
                this.cosContext.bind(name, obj);
            }
        } else {
            try {
                this.cosContext.lookup(name);
                throw new NameAlreadyBoundException();
            }
            catch (NameNotFoundException nameNotFoundException) {
                this.dsContext.bind(name, obj);
            }
        }
    }

    public void bind(Name name, java.lang.Object obj) throws NamingException {
        if (name.size() == 0) {
            throw new InvalidNameException("Name is empty");
        }
        if (this.isCORBAObjectOrContext(obj)) {
            try {
                this.dsContext.lookup(name);
                throw new NameAlreadyBoundException();
            }
            catch (NameNotFoundException nameNotFoundException) {
                this.cosContext.bind(name, obj);
            }
        } else {
            try {
                this.cosContext.lookup(name);
                throw new NameAlreadyBoundException();
            }
            catch (NameNotFoundException nameNotFoundException) {
                this.dsContext.bind(name, obj);
            }
        }
    }

    public void close() throws NamingException {
        this.myEnv = null;
    }

    public String composeName(String name, String prefix) throws NamingException {
        Name result = this.composeName(new CompositeName(name), new CompositeName(prefix));
        return result.toString();
    }

    public Name composeName(Name name, Name prefix) throws NamingException {
        Name result = (Name)prefix.clone();
        result.addAll(name);
        return result;
    }

    public Context createSubcontext(String name) throws NamingException {
        return this.cosContext.createSubcontext(name);
    }

    public Context createSubcontext(Name name) throws NamingException {
        return this.cosContext.createSubcontext(name);
    }

    public void destroySubcontext(String name) throws NamingException {
        Context ic = (Context)this.lookup(name);
        if (ic instanceof CNCtx) {
            this.cosContext.destroySubcontext(name);
        } else {
            this.dsContext.destroySubcontext(name);
        }
    }

    public void destroySubcontext(Name name) throws NamingException {
        Context ic = (Context)this.lookup(name);
        if (ic instanceof CNCtx) {
            this.cosContext.destroySubcontext(name);
        } else {
            this.dsContext.destroySubcontext(name);
        }
    }

    public Hashtable getEnvironment() throws NamingException {
        if (this.myEnv == null) {
            this.myEnv = new Hashtable(3, 0.75f);
        }
        return this.myEnv;
    }

    public String getNameInNamespace() throws NamingException {
        throw new OperationNotSupportedException("Context.getNameInNamespace() not implemented");
    }

    public NameParser getNameParser(String name) throws NamingException {
        return myParser;
    }

    public NameParser getNameParser(Name name) throws NamingException {
        return this.getNameParser(name.toString());
    }

    private boolean isCORBAObjectOrContext(java.lang.Object obj) {
        return obj instanceof Remote || obj instanceof Object || obj instanceof Context;
    }

    public NamingEnumeration list(String name) throws NamingException {
        Vector<NameClassPair> v2 = new Vector<NameClassPair>();
        try {
            NamingEnumeration ne = this.dsContext.list(name);
            while (ne.hasMoreElements()) {
                v2.addElement((NameClassPair)ne.nextElement());
            }
        }
        catch (NameNotFoundException nameNotFoundException) {}
        NamingEnumeration ne1 = this.cosContext.list(name);
        while (ne1.hasMoreElements()) {
            v2.addElement((NameClassPair)ne1.nextElement());
        }
        return new NameClassPairEnumeration(v2);
    }

    public NamingEnumeration list(Name name) throws NamingException {
        return this.list(name.toString());
    }

    public NamingEnumeration listBindings(String name) throws NamingException {
        Vector<NameClassPair> v2 = new Vector<NameClassPair>();
        try {
            NamingEnumeration ne = this.dsContext.listBindings(name);
            while (ne.hasMoreElements()) {
                v2.addElement((NameClassPair)ne.nextElement());
            }
        }
        catch (NameNotFoundException nameNotFoundException) {}
        NamingEnumeration ne1 = this.cosContext.listBindings(name);
        while (ne1.hasMoreElements()) {
            v2.addElement((NameClassPair)ne1.nextElement());
        }
        return new NameClassPairEnumeration(v2);
    }

    public NamingEnumeration listBindings(Name name) throws NamingException {
        return this.listBindings(name.toString());
    }

    public java.lang.Object lookup(String name) throws NamingException {
        java.lang.Object obj = null;
        if (name == null || name.length() == 0) {
            return this;
        }
        try {
            obj = this.dsContext.lookup(name);
        }
        catch (NameNotFoundException nameNotFoundException) {
            obj = this.cosContext.lookup(name);
        }
        if (obj == null) {
            throw new NameNotFoundException("Lookup of name " + name + " failed.");
        }
        return obj;
    }

    public java.lang.Object lookup(Name name) throws NamingException {
        if (name == null || name.size() == 0) {
            return this;
        }
        try {
            return this.dsContext.lookup(name);
        }
        catch (NameNotFoundException nameNotFoundException) {
            return this.cosContext.lookup(name);
        }
    }

    public java.lang.Object lookupLink(String name) throws NamingException {
        return this.lookup(name);
    }

    public java.lang.Object lookupLink(Name name) throws NamingException {
        return this.lookup(name);
    }

    public void rebind(String name, java.lang.Object obj) throws NamingException {
        if (name == null || name.length() == 0) {
            throw new InvalidNameException("Name is empty");
        }
        if (this.isCORBAObjectOrContext(obj)) {
            try {
                this.dsContext.unbind(name);
            }
            catch (NameNotFoundException nameNotFoundException) {}
            this.cosContext.rebind(name, obj);
        } else {
            try {
                this.cosContext.unbind(name);
            }
            catch (NameNotFoundException nameNotFoundException) {}
            this.dsContext.rebind(name, obj);
        }
    }

    public void rebind(Name name, java.lang.Object obj) throws NamingException {
        if (name.size() == 0) {
            throw new InvalidNameException("Name is empty");
        }
        if (this.isCORBAObjectOrContext(obj)) {
            try {
                this.dsContext.unbind(name);
            }
            catch (NameNotFoundException nameNotFoundException) {}
            this.cosContext.rebind(name, obj);
        } else {
            try {
                this.cosContext.unbind(name);
            }
            catch (NameNotFoundException nameNotFoundException) {}
            this.dsContext.rebind(name, obj);
        }
    }

    public java.lang.Object removeFromEnvironment(String propName) throws NamingException {
        if (this.myEnv == null) {
            return null;
        }
        return this.myEnv.remove(propName);
    }

    public void rename(String oldName, String newName) throws NamingException {
        if (oldName.length() == 0 || newName.length() == 0) {
            throw new InvalidNameException("One or both names empty");
        }
        java.lang.Object obj = this.lookup(oldName);
        this.bind(newName, obj);
        this.unbind(oldName);
    }

    public void rename(Name oldName, Name newName) throws NamingException {
        if (oldName.size() == 0 || newName.size() == 0) {
            throw new InvalidNameException("One or both names empty");
        }
        java.lang.Object obj = this.lookup(oldName);
        this.bind(newName, obj);
        this.unbind(oldName);
    }

    public void unbind(String name) throws NamingException {
        if (name == null || name.length() == 0) {
            throw new InvalidNameException("Name is empty");
        }
        try {
            this.dsContext.unbind(name);
        }
        catch (NameNotFoundException nameNotFoundException) {}
        try {
            this.cosContext.unbind(name);
        }
        catch (NameNotFoundException nameNotFoundException) {}
    }

    public void unbind(Name name) throws NamingException {
        if (name == null || name.size() == 0) {
            throw new InvalidNameException("Name is empty");
        }
        try {
            this.dsContext.unbind(name);
        }
        catch (NameNotFoundException nameNotFoundException) {}
        try {
            this.cosContext.unbind(name);
        }
        catch (NameNotFoundException nameNotFoundException) {}
    }
}

