/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.naming;

import com.sun.enterprise.ComponentInvocation;
import com.sun.enterprise.InvocationException;
import com.sun.enterprise.InvocationManager;
import com.sun.enterprise.NamingManager;
import com.sun.enterprise.Switch;
import com.sun.enterprise.deployment.ApplicationClientDescriptor;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.EjbReferenceDescriptor;
import com.sun.enterprise.deployment.EnvironmentProperty;
import com.sun.enterprise.deployment.JndiNameEnvironment;
import com.sun.enterprise.deployment.ResourceReferenceDescriptor;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.rmi.Remote;
import java.util.Hashtable;
import java.util.Iterator;
import javax.naming.CompositeName;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.InvalidNameException;
import javax.naming.Name;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import org.omg.CORBA.Object;

public class NamingManagerImpl
implements NamingManager {
    public static final String SERIALOBJECT_FACTORY = "com.sun.enterprise.naming.factory.SerialObjectFactory";
    public static final String IIOPOBJECT_FACTORY = "com.sun.enterprise.naming.factory.IIOPObjectFactory";
    public static final String MAIL_COMPONENT_FACTORY = "com.sun.enterprise.naming.factory.MailSessionObjectFactory";
    public static final String JAVA_COMP_STRING = "java:comp/env/";
    public static final boolean debug = false;
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(class$com$sun$enterprise$naming$NamingManagerImpl != null ? class$com$sun$enterprise$naming$NamingManagerImpl : (class$com$sun$enterprise$naming$NamingManagerImpl = NamingManagerImpl.class$("com.sun.enterprise.naming.NamingManagerImpl")));
    private InitialContext initialContext;
    private InitialContext serialContext;
    private InitialContext cosContext;
    private InvocationManager im;
    private String componentId = null;
    private Switch theSwitch = null;
    static /* synthetic */ Class class$com$sun$enterprise$naming$NamingManagerImpl;

    public NamingManagerImpl() throws NamingException {
        this.initialContext = new InitialContext();
        this.init();
        this.theSwitch = Switch.getSwitch();
        this.im = this.theSwitch.getInvocationManager();
    }

    public NamingManagerImpl(InitialContext ic) throws NamingException {
        this.initialContext = ic;
        this.init();
        this.theSwitch = Switch.getSwitch();
        this.im = this.theSwitch.getInvocationManager();
    }

    public void bindObjects(JndiNameEnvironment env) throws NamingException {
        String logicalJndiName;
        this.componentId = this.getIdFromDescriptor(env);
        Iterator itr = env.getEnvironmentProperties().iterator();
        while (itr.hasNext()) {
            EnvironmentProperty next = (EnvironmentProperty)itr.next();
            String logicalName = next.getName();
            String value = next.getValue();
            java.lang.Object valueObject = next.getValueObject();
            logicalJndiName = JAVA_COMP_STRING + logicalName;
            System.out.println(localStrings.getLocalString("naming.bind", "Binding name:{0}", new java.lang.Object[]{logicalJndiName}));
            this.initialContext.rebind(logicalJndiName, valueObject);
        }
        Iterator itr2 = env.getEjbReferenceDescriptors().iterator();
        while (itr2.hasNext()) {
            EjbReferenceDescriptor next = (EjbReferenceDescriptor)itr2.next();
            String logicalEjbRef = next.getName();
            String logicalJndiName2 = JAVA_COMP_STRING + logicalEjbRef;
            System.out.println(localStrings.getLocalString("naming.bind", "Binding name:{0}", new java.lang.Object[]{logicalJndiName2}));
            String otherBeanJndi = next.getValue();
            if (otherBeanJndi == null || otherBeanJndi.equals("")) {
                throw new InvalidNameException("Real JNDI name cannot be empty for " + logicalEjbRef);
            }
            Reference obj = new Reference("reference", new StringRefAddr("url", otherBeanJndi), IIOPOBJECT_FACTORY, null);
            this.initialContext.rebind(logicalJndiName2, (java.lang.Object)obj);
        }
        Iterator itr3 = env.getResourceReferenceDescriptors().iterator();
        while (itr3.hasNext()) {
            ResourceReferenceDescriptor next = (ResourceReferenceDescriptor)itr3.next();
            String logicalResRef = next.getName();
            logicalJndiName = JAVA_COMP_STRING + logicalResRef;
            System.out.println(localStrings.getLocalString("naming.bind", "Binding name:{0}", new java.lang.Object[]{logicalJndiName}));
            String resJndi = next.getValue();
            if (resJndi == null || resJndi.equals("")) {
                throw new InvalidNameException("Real JNDI name cannot be empty for " + logicalResRef);
            }
            java.lang.Object obj = null;
            if (next.isMailResource()) {
                obj = next.getMailConfiguration();
                this.initialContext.rebind(logicalResRef, obj);
                obj = new Reference(obj.getClass().toString(), new StringRefAddr("url", logicalResRef), MAIL_COMPONENT_FACTORY, null);
            } else {
                try {
                    obj = this.initialContext.lookup(resJndi);
                }
                catch (NamingException namingException) {
                    throw new InvalidNameException("JNDI name '" + resJndi + "' for resource reference '" + logicalResRef + "' is not valid");
                }
                obj = new Reference(obj.getClass().toString(), new StringRefAddr("url", resJndi), SERIALOBJECT_FACTORY, null);
            }
            this.initialContext.rebind(logicalJndiName, obj);
        }
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    public String getComponentId() {
        String id = null;
        try {
            ComponentInvocation ci2 = this.im.getCurrentInvocation();
            java.lang.Object containerContext = ci2.getContainerContext();
            if (containerContext != null) {
                JndiNameEnvironment desc = (JndiNameEnvironment)this.theSwitch.getDescriptorFor(containerContext);
                id = this.getIdFromDescriptor(desc);
            } else {
                id = this.componentId;
            }
        }
        catch (InvocationException invocationException) {
            id = this.componentId;
        }
        return id;
    }

    private String getIdFromDescriptor(JndiNameEnvironment env) {
        String id = null;
        if (env instanceof EjbDescriptor) {
            EjbDescriptor ejbEnv = (EjbDescriptor)env;
            id = String.valueOf(ejbEnv.getApplication().getName()) + "/" + ejbEnv.getEjbClassName() + "/" + ejbEnv.getJndiName();
        } else if (env instanceof WebBundleDescriptor) {
            WebBundleDescriptor webEnv = (WebBundleDescriptor)env;
            id = String.valueOf(webEnv.getApplication().getName()) + "/" + webEnv.getContextRoot();
        } else if (env instanceof ApplicationClientDescriptor) {
            ApplicationClientDescriptor appEnv = (ApplicationClientDescriptor)env;
            id = "client/" + appEnv.getName() + "/" + appEnv.getMainClassName();
        }
        return id;
    }

    public Context getInitialContext() {
        return this.initialContext;
    }

    private void init() throws NamingException {
        Hashtable<String, String> myEnv = new Hashtable<String, String>();
        myEnv.put("java.naming.factory.initial", "com.sun.jndi.cosnaming.CNCtxFactory");
        this.cosContext = new InitialContext(myEnv);
        myEnv.put("java.naming.factory.initial", "com.sun.enterprise.naming.SerialInitContextFactory");
        this.serialContext = new InitialContext(myEnv);
    }

    private boolean isCORBAObjectOrContext(java.lang.Object obj) {
        return obj instanceof Remote || obj instanceof Object || obj instanceof Context;
    }

    public void publishObject(String name, java.lang.Object obj, boolean rebind) throws NamingException {
        CompositeName nameobj = new CompositeName(name);
        this.publishObject(nameobj, obj, rebind);
    }

    public void publishObject(Name name, java.lang.Object obj, boolean rebind) throws NamingException {
        String subctxname;
        int len = name.size();
        Context ctx = this.initialContext;
        boolean flagContextCreated = false;
        boolean flagSerial = false;
        if (this.isCORBAObjectOrContext(obj)) {
            ctx = this.cosContext;
            flagSerial = false;
        } else {
            ctx = this.serialContext;
            flagSerial = true;
        }
        int i2 = 0;
        while (i2 < len - 1) {
            Context subctx;
            block17: {
                flagContextCreated = false;
                subctxname = name.get(i2);
                subctx = null;
                try {
                    java.lang.Object ob = ctx.lookup(subctxname);
                    if (ob instanceof Context) {
                        subctx = (Context)ob;
                        break block17;
                    }
                    throw new NameAlreadyBoundException(subctxname);
                }
                catch (NameNotFoundException nameNotFoundException) {
                    subctx = ctx.createSubcontext(subctxname);
                    flagContextCreated = true;
                }
                catch (NameAlreadyBoundException nameAlreadyBoundException) {
                    return;
                }
                catch (Exception e10) {
                    e10.printStackTrace();
                }
            }
            if (subctx == null) {
                subctx = ctx.createSubcontext(subctxname);
                flagContextCreated = true;
            }
            ctx = subctx;
            ++i2;
        }
        try {
            if (!flagContextCreated && flagSerial) {
                subctxname = name.get(len - 1);
                try {
                    java.lang.Object ob = ctx.lookup(name.get(len - 1));
                    if (ob instanceof Context && !(obj instanceof Context)) {
                        throw new NameAlreadyBoundException(subctxname);
                    }
                }
                catch (NameNotFoundException nameNotFoundException) {}
            }
            if (rebind) {
                this.initialContext.rebind(name, obj);
            } else {
                this.initialContext.bind(name, obj);
            }
        }
        catch (Exception e11) {
            e11.printStackTrace();
        }
    }

    public void setInitialContext(Context ic) {
        this.initialContext = (InitialContext)ic;
    }

    public void unbindObjects(JndiNameEnvironment env) throws NamingException {
        String logicalJndiName;
        this.componentId = this.getIdFromDescriptor(env);
        Iterator itr = env.getEnvironmentProperties().iterator();
        while (itr.hasNext()) {
            EnvironmentProperty next = (EnvironmentProperty)itr.next();
            String logicalName = next.getName();
            String value = next.getValue();
            logicalJndiName = JAVA_COMP_STRING + logicalName;
            System.out.println(localStrings.getLocalString("naming.unbind", "Unbinding:{0}", new java.lang.Object[]{logicalJndiName}));
            this.initialContext.unbind(logicalJndiName);
        }
        Iterator itr2 = env.getEjbReferenceDescriptors().iterator();
        while (itr2.hasNext()) {
            EjbReferenceDescriptor next = (EjbReferenceDescriptor)itr2.next();
            String logicalEjbRef = next.getName();
            logicalJndiName = JAVA_COMP_STRING + logicalEjbRef;
            System.out.println(localStrings.getLocalString("naming.unbind", "Unbinding:{0}", new java.lang.Object[]{logicalJndiName}));
            this.initialContext.unbind(logicalJndiName);
        }
        Iterator itr3 = env.getResourceReferenceDescriptors().iterator();
        while (itr3.hasNext()) {
            ResourceReferenceDescriptor next = (ResourceReferenceDescriptor)itr3.next();
            String logicalResRef = next.getName();
            String logicalJndiName2 = JAVA_COMP_STRING + logicalResRef;
            System.out.println(localStrings.getLocalString("naming.unbind", "Unbinding:{0}", new java.lang.Object[]{logicalJndiName2}));
            this.initialContext.unbind(logicalJndiName2);
        }
    }
}

