/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.resource;

import com.sun.enterprise.Switch;
import com.sun.enterprise.resource.JdbcXAConnection;
import com.sun.enterprise.resource.PoolManager;
import com.sun.enterprise.resource.ResourceAllocator;
import com.sun.enterprise.resource.ResourceException;
import com.sun.enterprise.resource.ResourceHandle;
import com.sun.enterprise.resource.ResourcePrincipal;
import com.sun.enterprise.resource.ResourceSpec;
import java.security.Principal;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import javax.naming.Context;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.XAConnection;
import javax.sql.XADataSource;
import javax.transaction.xa.XAResource;

public class JdbcConnectionAllocator
implements ResourceAllocator {
    private static final String JDBC10_CON = "java.sql.Connection";
    private PoolManager poolMgr;
    private boolean jdbc20;
    private Context ic;

    public JdbcConnectionAllocator(PoolManager poolMgr, boolean jdbc20) {
        this.poolMgr = poolMgr;
        this.jdbc20 = jdbc20;
        this.ic = Switch.getSwitch().getNamingManager().getInitialContext();
    }

    public void closeUserConnection(ResourceHandle resource) throws ResourceException {
        try {
            String resourceType = resource.getResourceSpec().getResourceType();
            if (resourceType.equals(JDBC10_CON)) {
                return;
            }
            Connection con = (Connection)resource.getUserConnection();
            con.close();
        }
        catch (SQLException ex2) {
            throw new ResourceException(ex2);
        }
    }

    public ResourceHandle createResource(ResourceSpec spec, Principal prin) throws ResourceException {
        try {
            String jndiName = spec.getResourceFactory();
            String resourceType = spec.getResourceType();
            ResourcePrincipal resPrin = (ResourcePrincipal)prin;
            String user = resPrin.getName();
            String password = resPrin.getPassword();
            ResourceHandle resource = null;
            if (resourceType.equals(JDBC10_CON)) {
                Connection con = DriverManager.getConnection(spec.getResourceFactory(), user, password);
                con.setAutoCommit(false);
                resource = this.poolMgr.createResourceHandle(con, spec, this, prin);
            } else if (!this.jdbc20) {
                ResourceSpec newspec = new ResourceSpec(spec.getResourceFactory(), JDBC10_CON);
                JdbcXAConnection xacon = new JdbcXAConnection(newspec, user, password, this.poolMgr);
                resource = this.poolMgr.createResourceHandle(xacon, spec, this, prin);
                ConnectionListenerImpl l2 = new ConnectionListenerImpl(resource);
                xacon.addConnectionEventListener(l2);
            } else {
                XADataSource ds2 = (XADataSource)this.ic.lookup(jndiName);
                XAConnection con = ds2.getXAConnection(user, password);
                resource = this.poolMgr.createResourceHandle(con, spec, this, prin);
                ConnectionListenerImpl l3 = new ConnectionListenerImpl(resource);
                con.addConnectionEventListener(l3);
            }
            return resource;
        }
        catch (Exception ex2) {
            if (ex2 instanceof ResourceException) {
                throw (ResourceException)ex2;
            }
            throw new ResourceException(ex2);
        }
    }

    public void destroyResource(ResourceHandle resource) throws ResourceException {
        try {
            this.closeUserConnection(resource);
        }
        catch (Exception exception) {}
        try {
            String resourceType = resource.getResourceSpec().getResourceType();
            if (resourceType.equals(JDBC10_CON)) {
                Connection con = (Connection)resource.getResource();
                con.close();
            } else {
                XAConnection xacon = (XAConnection)resource.getResource();
                xacon.close();
            }
        }
        catch (SQLException ex2) {
            throw new ResourceException(ex2);
        }
    }

    public void fillInResourceObjects(ResourceHandle resource) throws ResourceException {
        try {
            String resourceType = resource.getResourceSpec().getResourceType();
            if (resourceType.equals(JDBC10_CON)) {
                return;
            }
            XAConnection xacon = (XAConnection)resource.getResource();
            Connection con = xacon.getConnection();
            XAResource xares = xacon.getXAResource();
            resource.fillInResourceObjects(con, xares);
        }
        catch (SQLException ex2) {
            throw new ResourceException(ex2);
        }
    }

    class ConnectionListenerImpl
    implements ConnectionEventListener {
        private ResourceHandle resource;

        public ConnectionListenerImpl(ResourceHandle resource) {
            this.resource = resource;
        }

        public void connectionClosed(ConnectionEvent evt) {
            JdbcConnectionAllocator.this.poolMgr.resourceClosed(this.resource);
        }

        public void connectionErrorOccurred(ConnectionEvent evt) {
            XAConnection con = (XAConnection)evt.getSource();
            con.removeConnectionEventListener(this);
            JdbcConnectionAllocator.this.poolMgr.resourceErrorOccurred(this.resource);
            try {
                con.close();
            }
            catch (SQLException sQLException) {}
        }
    }
}

