/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.application;

import com.sun.ejb.Invocation;
import com.sun.enterprise.SecurityManager;
import com.sun.enterprise.ServerConfiguration;
import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.security.SecurityContext;
import com.sun.enterprise.security.acl.AccessControlEntryImpl;
import com.sun.enterprise.security.acl.AccessControlList;
import com.sun.enterprise.security.acl.AccessControlListImpl;
import com.sun.enterprise.security.acl.EJBResource;
import com.sun.enterprise.security.acl.ResourceAccessManager;
import com.sun.enterprise.security.acl.ResourceGuard;
import com.sun.enterprise.security.acl.Role;
import com.sun.enterprise.security.acl.RoleMapper;
import com.sun.enterprise.security.application.AuditLog;
import com.sun.enterprise.security.application.Authorizer;
import com.sun.enterprise.security.application.AuthorizerImpl;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.lang.reflect.Method;
import java.security.Principal;
import java.util.Enumeration;
import java.util.Iterator;

public final class EJBSecurityManager
implements SecurityManager {
    private static final boolean debug = false;
    private ResourceAccessManager ram = null;
    private EjbDescriptor deploymentDescriptor = null;
    private ClassLoader loader = null;
    private Authorizer authorizer = null;
    private ServerConfiguration config = null;
    private static AuditLog audit = new AuditLog();
    private boolean loggingOn = false;
    private static final String AUDIT_ON = "auth.audit";
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(class$com$sun$enterprise$security$application$EJBSecurityManager != null ? class$com$sun$enterprise$security$application$EJBSecurityManager : (class$com$sun$enterprise$security$application$EJBSecurityManager = EJBSecurityManager.class$("com.sun.enterprise.security.application.EJBSecurityManager")));
    static /* synthetic */ Class class$com$sun$enterprise$security$application$EJBSecurityManager;

    public EJBSecurityManager(ClassLoader loader, EjbDescriptor ejbDescriptor) {
        this.loader = loader;
        this.deploymentDescriptor = ejbDescriptor;
        if (this.deploymentDescriptor == null) {
            throw new IllegalArgumentException("Illegal Deployment Descriptor Information.");
        }
        this.config = ServerConfiguration.getConfiguration();
        String val = this.config.getProperty(AUDIT_ON);
        if (val.trim().equals("true")) {
            this.loggingOn = true;
        }
        this.authorizer = new AuthorizerImpl();
        this.ram = ResourceAccessManager.getDefault();
        this.initialize();
    }

    public void audit(Invocation inv) {
        if (this.loggingOn) {
            audit.log(inv, "Audit");
        }
    }

    public boolean authorize(Invocation inv) {
        boolean ret = this.authorizer.authorize(this.getAppName(), inv);
        if (this.loggingOn) {
            audit.log(inv, ret ? localStrings.getLocalString("enterprise.security.successful", "Successful.") : localStrings.getLocalString("enterprise.security.failed", "Failed."));
            if (!ret) {
                audit.flush();
            }
        }
        return ret;
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    public void destroy() {
        String appName = this.getAppName();
        RoleMapper.removeRoleMapper(appName);
        Enumeration ejbmethods = this.deploymentDescriptor.getMethods(this.loader).elements();
        while (ejbmethods.hasMoreElements()) {
            Method mthd = (Method)ejbmethods.nextElement();
            EJBResource r2 = new EJBResource(appName, mthd);
            this.ram.unprotect(r2);
        }
        this.deploymentDescriptor = null;
    }

    private AccessControlList getAccessControlList(EjbDescriptor ejbdes, Method m2) {
        AccessControlListImpl acl = null;
        Iterator roles = ejbdes.getPermissionedRolesForMethod(m2).iterator();
        if (roles.hasNext()) {
            acl = new AccessControlListImpl();
        } else {
            acl = new AccessControlListImpl();
            acl.addEntry(new AccessControlEntryImpl(RoleMapper.getDefaultRole()));
        }
        while (roles.hasNext()) {
            Role nextRole = (Role)roles.next();
            AccessControlEntryImpl ace = new AccessControlEntryImpl(nextRole);
            acl.addEntry(ace);
        }
        return acl;
    }

    private String getAppName() {
        String appname = "default";
        Application app = this.deploymentDescriptor.getApplication();
        if (app != null) {
            appname = app.getName();
        }
        return appname;
    }

    public static AuditLog getAuditLog() {
        return audit;
    }

    public Principal getCallerPrincipal() {
        SecurityContext sc = this.getSecurityContext();
        if (sc != null) {
            return sc.getCallerPrincipal();
        }
        throw new IllegalStateException("Bad or improper security context.");
    }

    private SecurityContext getSecurityContext() {
        return SecurityContext.getCurrent();
    }

    private void initialize() {
        String appName = this.getAppName();
        EjbDescriptor des = this.deploymentDescriptor;
        RoleMapper.setRoleMapper(appName, des.getApplication().getRoleMapper());
        Enumeration ejbmethods = des.getMethods(this.loader).elements();
        while (ejbmethods.hasMoreElements()) {
            Method mthd = (Method)ejbmethods.nextElement();
            EJBResource r2 = new EJBResource(appName, mthd);
            AccessControlList mthdAcl = this.getAccessControlList(des, mthd);
            if (mthdAcl == null) continue;
            ResourceGuard rg = new ResourceGuard(mthdAcl);
            this.ram.protect(r2, rg);
        }
    }

    public boolean isCallerInRole(String role) {
        return this.authorizer.isCallerInRole(this.getAppName(), role);
    }
}

