/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.auth.realm.certificate;

import com.sun.enterprise.security.auth.realm.BadRealmException;
import com.sun.enterprise.security.auth.realm.NoSuchUserException;
import com.sun.enterprise.security.auth.realm.User;
import com.sun.enterprise.security.auth.realm.certificate.CertificateRealm;
import com.sun.enterprise.security.auth.realm.certificate.CertificateUser;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import java.util.Vector;

final class CertificateStore {
    private CertificateRealm realm;
    private File file;
    private char[] password = "abc123".toCharArray();
    private KeyStore kstore;
    private CertificateFactory cfactory;

    public CertificateStore(CertificateRealm realm, String fileName) throws BadRealmException {
        try {
            this.realm = realm;
            this.file = new File(fileName);
            this.kstore = KeyStore.getInstance("JKS");
            this.cfactory = CertificateFactory.getInstance("X509");
            this.read();
        }
        catch (Exception e10) {
            throw new BadRealmException(e10.getMessage());
        }
    }

    synchronized void addUser(String user, byte[] cert) throws BadRealmException {
        ByteArrayInputStream istream = new ByteArrayInputStream(cert);
        try {
            Certificate certificate = this.cfactory.generateCertificate(istream);
            this.kstore.setCertificateEntry(user, certificate);
            this.rewrite();
        }
        catch (Exception e10) {
            e10.printStackTrace();
            throw new BadRealmException(e10.getMessage());
        }
    }

    private String getPrincipalName(X509Certificate cert) {
        String subject = cert.getSubjectDN().getName();
        int start = subject.indexOf("CN=") + 3;
        int end = subject.indexOf(",", start);
        return subject.substring(start, end);
    }

    synchronized User getUser(String alias) throws NoSuchUserException {
        try {
            int end;
            int start;
            if (!this.kstore.containsAlias(alias)) {
                throw new NoSuchUserException(alias);
            }
            Certificate cert = this.kstore.getCertificate(alias);
            String subject = ((X509Certificate)cert).getSubjectDN().getName();
            String username = subject.substring(start = subject.indexOf("CN=") + 3, end = subject.indexOf(",", start));
            if (!alias.equals(username.trim())) {
                throw new NoSuchUserException(alias);
            }
            return new CertificateUser(this.realm, alias, cert);
        }
        catch (KeyStoreException kse) {
            throw new NoSuchUserException(kse.getMessage());
        }
    }

    synchronized Enumeration getUsers() {
        Vector<String> users = new Vector<String>();
        try {
            try {
                Enumeration<String> e10 = this.kstore.aliases();
                while (e10.hasMoreElements()) {
                    String uname = this.getPrincipalName((X509Certificate)this.kstore.getCertificate(e10.nextElement()));
                    users.addElement(uname);
                }
            }
            catch (Exception exception) {}
        }
        catch (Throwable throwable) {}
        return users.elements();
    }

    void read() throws IOException {
        FileInputStream fis = null;
        try {
            try {
                fis = new FileInputStream(this.file);
            }
            catch (Exception exception) {
            }
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            try {
                this.kstore.load(fis, this.password);
            }
            catch (Exception exception) {}
            if (fis != null) {
                fis.close();
            }
            throw throwable;
        }
        try {
            this.kstore.load(fis, this.password);
        }
        catch (Exception exception) {}
        if (fis != null) {
            fis.close();
        }
    }

    synchronized void removeUser(String user) throws BadRealmException {
        try {
            this.kstore.deleteEntry(user);
            this.rewrite();
        }
        catch (Exception e10) {
            throw new BadRealmException(e10.getMessage());
        }
    }

    private void rewrite() throws IOException {
        FileOutputStream fos = null;
        try {
            try {
                fos = new FileOutputStream(this.file);
            }
            catch (Exception e10) {
                e10.printStackTrace();
            }
            Object var3_3 = null;
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            try {
                this.kstore.store(fos, this.password);
            }
            catch (Exception exception) {}
            if (fos != null) {
                fos.close();
            }
            throw throwable;
        }
        try {
            this.kstore.store(fos, this.password);
        }
        catch (Exception exception) {}
        if (fos != null) {
            fos.close();
        }
    }
}

