/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.server;

import com.sun.ejb.containers.ContainerFactoryImpl;
import com.sun.enterprise.J2EESecurityManager;
import com.sun.enterprise.J2EETransactionManager;
import com.sun.enterprise.ProtocolManager;
import com.sun.enterprise.Switch;
import com.sun.enterprise.activation.Activator;
import com.sun.enterprise.distributedtx.J2EETransactionManagerImpl;
import com.sun.enterprise.iiop.POAProtocolMgr;
import com.sun.enterprise.log.Log;
import com.sun.enterprise.log.LogUtil;
import com.sun.enterprise.naming.NamingManagerImpl;
import com.sun.enterprise.resource.PoolManager;
import com.sun.enterprise.server.ServerCallback;
import com.sun.enterprise.tools.deployment.backend.JarManagerImpl;
import com.sun.enterprise.util.FileUtil;
import com.sun.enterprise.util.InvocationManagerImpl;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.util.ORBManager;
import com.sun.enterprise.util.Utility;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Hashtable;
import java.util.Properties;
import javax.naming.InitialContext;
import javax.rmi.CORBA.Tie;
import javax.rmi.CORBA.Util;
import javax.rmi.PortableRemoteObject;
import org.omg.CORBA.ORB;
import org.omg.PortableServer.POA;

public final class EJBServer {
    public static boolean debug = false;
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(class$com$sun$enterprise$server$EJBServer != null ? class$com$sun$enterprise$server$EJBServer : (class$com$sun$enterprise$server$EJBServer = EJBServer.class$("com.sun.enterprise.server.EJBServer")));
    public static final String EJB_DAEMON_PORT = "com.sun.enterprise.activation.EJBDaemonPort";
    public static final String EJB_SERVER_PORT = "com.sun.enterprise.activation.EJBServerPort";
    public static final String EJB_SERVER_ID = "com.sun.enterprise.activation.EJBServerId";
    public static final String EJB_ACTIVATIONDB_DIR = "com.sun.enterprise.activation.DbDir";
    public static final String EJB_APPNAME = "com.sun.enterprise.appname";
    public static final String EJB_HOME = "com.sun.enterprise.home";
    public static final String EJB_SERVER_CLASS = "com.sun.enterprise.server.EJBServer";
    public static final String EJB_RECOVERABLE = "distributed.transaction.recovery";
    public static final String JTS_SERVERID = "com.sun.jts.persistentServerId";
    public static POA transientPOA = null;
    public static POA persistentPOA = null;
    private int daemonPort = 1049;
    private boolean daemonPortInitialized = false;
    private boolean persistentPortInitialized = false;
    private int persistentServerId = 0;
    boolean persistentServerIdInitialized = false;
    private String persistentServerName = null;
    private int persistentServerPort;
    private boolean serverIsDaemonActivated = false;
    private ServerCallback serverCallback = null;
    private ORB orb = null;
    private JarManagerImpl jarManager = null;
    private InitialContext initialContext;
    private Properties defaultProperties;
    private ProtocolManager protocolMgr = null;
    static /* synthetic */ Class class$com$sun$enterprise$server$EJBServer;
    static /* synthetic */ Class class$com$sun$enterprise$activation$Activator;

    public EJBServer(ORB orb) {
        System.setSecurityManager(new J2EESecurityManager());
        this.orb = orb;
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    private void createServerCallback() {
        String ejbdPortStr = System.getProperty(EJB_DAEMON_PORT);
        if (ejbdPortStr != null) {
            this.daemonPort = Integer.parseInt(ejbdPortStr);
            this.protocolMgr.setDaemonPort(this.daemonPort);
            this.serverIsDaemonActivated = true;
            this.daemonPortInitialized = true;
        }
        if (this.serverIsDaemonActivated) {
            this.serverCallback = new ServerCallback(this);
            try {
                PortableRemoteObject.exportObject(this.serverCallback);
                Tie servantsTie = Util.getTie(this.serverCallback);
                servantsTie.orb(this.orb);
            }
            catch (Exception ex2) {
                Log.err.println(ex2);
                if (debug) {
                    ex2.printStackTrace();
                }
                throw new RuntimeException("Unable to create a callback object.");
            }
        }
    }

    public JarManagerImpl getEJBJarManager() {
        return this.jarManager;
    }

    int getListenerPort() {
        return this.protocolMgr.getListenerPort();
    }

    public int getPersistentServerId() {
        if (this.persistentServerIdInitialized) {
            return this.persistentServerId;
        }
        throw new RuntimeException("Persistent Server Id not initialized");
    }

    public boolean getPersistentServerIdInitialized() {
        return this.persistentServerIdInitialized;
    }

    public int getPersistentServerPort() {
        if (this.daemonPortInitialized) {
            return this.daemonPort;
        }
        if (this.persistentPortInitialized) {
            return this.persistentServerPort;
        }
        throw new RuntimeException("Persistent ServerPort not initialized");
    }

    public void init(String[] args) throws Exception {
        Switch sw = Switch.getSwitch();
        if (this.initialContext == null) {
            this.initialContext = (InitialContext)sw.getNamingManager().getInitialContext();
        }
        if (this.protocolMgr == null) {
            this.protocolMgr = sw.getProtocolManager();
        }
        this.protocolMgr.setEJBServer(this);
        this.jarManager = new JarManagerImpl(false);
        String recoverableStr = this.defaultProperties.getProperty(EJB_RECOVERABLE);
        boolean recoverable = "true".equals(recoverableStr);
        if (recoverable) {
            System.err.println(localStrings.getLocalString("ejbserver.recovery", "Perform recovery of XAResources..."));
            J2EETransactionManager tm = sw.getTransactionManager();
            PoolManager poolMgr = tm.getPoolManager();
            poolMgr.recoverJdbcXAResources();
        }
        ContainerFactoryImpl cf2 = new ContainerFactoryImpl();
        sw.setContainerFactory(cf2);
        this.setPersistentServerInfo();
    }

    public static void initJTSProperties(boolean recoverable, boolean lateRegistration, Properties props) {
        if (!lateRegistration) {
            ((Hashtable)props).put("com.sun.corba.ee.CosTransactions.ORBJTSClass", "com.sun.jts.CosTransactions.DefaultTransactionService");
        }
        if (recoverable) {
            String serverId;
            if (debug) {
                System.err.println("Recoverable J2EE Server");
            }
            if ((serverId = System.getProperty(EJB_SERVER_ID)) == null) {
                serverId = "0";
            }
            ((Hashtable)props).put(JTS_SERVERID, serverId);
            ((Hashtable)props).put("com.sun.jts.ManualRecovery", "true");
            String hostname = "";
            try {
                InetAddress ia = InetAddress.getLocalHost();
                hostname = ia.getHostName();
            }
            catch (UnknownHostException unknownHostException) {
                hostname = "localhost";
            }
            String logdir = FileUtil.getAbsolutePath("logs/" + hostname + "/jts");
            if (debug) {
                System.err.println("JTS log directory: " + logdir);
                System.err.println("Server id " + serverId);
            }
            new File(logdir).mkdirs();
            ((Hashtable)props).put("com.sun.jts.logDirectory", logdir);
        }
    }

    private static void initializeLogs() throws Exception {
        String serverId = System.getProperty(EJB_SERVER_ID, "0");
        String appname = System.getProperty(EJB_APPNAME);
        if (appname == null || appname.equals("")) {
            appname = serverId;
        }
        File dir = LogUtil.getLogDirectory(appname, "ejb");
        LogUtil.initDefaultLogFiles(dir);
    }

    public static void main(String[] args) {
        try {
            Utility.checkJVMVersion();
            EJBServer.initializeLogs();
            Properties defaultProperties = new Properties();
            String propsFile = String.valueOf(System.getProperty(EJB_HOME)) + File.separator + "config" + File.separator + "default.properties";
            FileInputStream fis = new FileInputStream(propsFile);
            defaultProperties.load(fis);
            Properties props = new Properties();
            String recoverableStr = defaultProperties.getProperty(EJB_RECOVERABLE);
            boolean recoverable = "true".equals(recoverableStr);
            EJBServer.initJTSProperties(recoverable, false, props);
            ORBManager.init(args, props);
            ORB orb = ORBManager.getORB();
            EJBServer server = new EJBServer(orb);
            server.setDefaultProperties(defaultProperties);
            server.run(args);
        }
        catch (Exception ex2) {
            Log.err.println(ex2);
            if (debug) {
                ex2.printStackTrace();
            }
            System.exit(1);
        }
    }

    private void replyToActivator(String[] params) {
        if (this.serverIsDaemonActivated) {
            try {
                Object objRef = this.initialContext.lookup("ServerActivator");
                Activator activator = (Activator)PortableRemoteObject.narrow(objRef, class$com$sun$enterprise$activation$Activator != null ? class$com$sun$enterprise$activation$Activator : (class$com$sun$enterprise$activation$Activator = EJBServer.class$("com.sun.enterprise.activation.Activator")));
                activator.active(this.serverCallback, this.getPersistentServerId());
            }
            catch (Exception ex2) {
                Log.err.println(ex2);
                if (debug) {
                    ex2.printStackTrace();
                }
                throw new RuntimeException("Unable to register with Activator");
            }
        }
    }

    private void run(String[] args) throws Exception {
        Object sync;
        Switch sw = Switch.getSwitch();
        this.protocolMgr = new POAProtocolMgr(this.orb);
        sw.setProtocolManager(this.protocolMgr);
        InvocationManagerImpl invMgr = new InvocationManagerImpl();
        sw.setInvocationManager(invMgr);
        J2EETransactionManagerImpl tm = new J2EETransactionManagerImpl();
        sw.setTransactionManager(tm);
        this.initialContext = new InitialContext();
        NamingManagerImpl nm = new NamingManagerImpl(this.initialContext);
        sw.setNamingManager(nm);
        this.init(args);
        this.createServerCallback();
        int i2 = 0;
        while (i2 < args.length) {
            this.jarManager.loadJar(args[i2]);
            ++i2;
        }
        this.replyToActivator(args);
        System.out.println(localStrings.getLocalString("ejbserver.wait", "waiting for invocations ... "));
        Object object = sync = new Object();
        synchronized (object) {
            sync.wait();
        }
    }

    void setDefaultProperties(Properties props) {
        this.defaultProperties = props;
    }

    public void setPersistentServerId(int id) {
        this.persistentServerId = id;
        this.persistentServerIdInitialized = true;
        this.protocolMgr.setPersistentServerId(id);
    }

    private void setPersistentServerInfo() {
        String persServerIdStr;
        String serverPortStr = System.getProperty(EJB_SERVER_PORT);
        if (serverPortStr != null) {
            this.setPersistentServerPort(Integer.parseInt(serverPortStr));
        }
        if ((persServerIdStr = System.getProperty(EJB_SERVER_ID)) != null) {
            this.setPersistentServerId(Integer.parseInt(persServerIdStr));
        }
    }

    public void setPersistentServerPort(int sp) {
        if (this.persistentPortInitialized) {
            throw new RuntimeException("Persistent ServerPort already set");
        }
        this.protocolMgr.setPersistentServerPort(sp);
        this.persistentServerPort = sp;
        this.persistentPortInitialized = true;
    }

    private static void setStreams() throws Exception {
        String logDirName = String.valueOf(System.getProperty(EJB_ACTIVATIONDB_DIR)) + System.getProperty("file.separator") + "logs" + System.getProperty("file.separator");
        File logDir = new File(logDirName);
        String server = System.getProperty(EJB_SERVER_ID);
        String appname = System.getProperty(EJB_APPNAME);
        if (appname == null || appname.equals("")) {
            appname = server;
        }
        FileOutputStream foutStream = new FileOutputStream(new File(String.valueOf(logDirName) + appname + ".out"));
        FileOutputStream ferrStream = new FileOutputStream(new File(String.valueOf(logDirName) + appname + ".err"));
        PrintStream pSout = new PrintStream(foutStream, true);
        PrintStream pSerr = new PrintStream(ferrStream, true);
        System.setOut(pSout);
        System.setErr(pSerr);
    }

    void shutdown() {
        Log.flushAll();
        this.orb.shutdown(false);
    }
}

