/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.deployment.main;

import com.sun.ejb.sqlgen.DBInfo;
import com.sun.enterprise.tools.deployment.backend.BufferedRemoteByteArray;
import com.sun.enterprise.tools.deployment.backend.BufferedRemoteByteArrayImpl;
import com.sun.enterprise.tools.deployment.backend.DeploymentSession;
import com.sun.enterprise.tools.deployment.backend.DeploymentSessionImpl;
import com.sun.enterprise.tools.deployment.backend.JarInstaller;
import com.sun.enterprise.tools.deployment.main.ServerException;
import com.sun.enterprise.tools.deployment.main.ServerListener;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.util.NotificationEvent;
import com.sun.enterprise.util.NotificationListener;
import com.sun.enterprise.util.ORBManager;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.rmi.RemoteException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.rmi.CORBA.Tie;
import javax.rmi.CORBA.Util;
import javax.rmi.PortableRemoteObject;
import org.omg.CORBA.ORB;

public class ServerManager {
    public static String NOTIFICATION_TYPE = "ServerManager";
    public static String SERVER_ADDED = "addServer";
    public static String SERVER_REMOVED = "removeServer";
    public static String SERVER_SELECTED = "setCurrentServer";
    private static String LOCAL_SERVER = "local";
    public static String LOCAL_HOST = "localhost";
    private static String SERVERS_FILENAME = "servers";
    private File preferencesDirectory;
    private Vector listeners = new Vector();
    private Hashtable serverNameToListenerMap = new Hashtable();
    private String currentServer;
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(class$com$sun$enterprise$tools$deployment$main$ServerManager != null ? class$com$sun$enterprise$tools$deployment$main$ServerManager : (class$com$sun$enterprise$tools$deployment$main$ServerManager = ServerManager.class$("com.sun.enterprise.tools.deployment.main.ServerManager")));
    static /* synthetic */ Class class$com$sun$enterprise$tools$deployment$main$ServerManager;
    static /* synthetic */ Class class$com$sun$enterprise$tools$deployment$backend$JarInstaller;
    static /* synthetic */ Class class$com$sun$ejb$sqlgen$DBInfo;

    public ServerManager(File preferencesDirectory) {
        this.preferencesDirectory = preferencesDirectory;
    }

    public void addNotificationListener(NotificationListener nl) {
        this.listeners.addElement(nl);
        this.changed();
    }

    public void addServer(String serverName) throws ServerException {
        JarInstaller jarInstaller = this.getJarInstaller(serverName);
        if (!this.serverNameToListenerMap.containsKey(serverName)) {
            ServerListener serverListener = null;
            try {
                serverListener = this.createServerListener(serverName);
                jarInstaller.addRemoteNotificationListener(serverListener);
            }
            catch (Exception exception) {
                System.out.println(localStrings.getLocalString("enterprise.tools.deployment.main.errorgettingserverlistener", "Error getting server listener"));
            }
            this.serverNameToListenerMap.put(serverName, serverListener);
        }
        this.setCurrentServer(serverName);
        this.changed(SERVER_ADDED, serverName);
    }

    protected void changed() {
        Vector listenersClone = null;
        Vector vector = this.listeners;
        synchronized (vector) {
            listenersClone = (Vector)this.listeners.clone();
        }
        Enumeration e10 = listenersClone.elements();
        while (e10.hasMoreElements()) {
            NotificationListener nl = (NotificationListener)e10.nextElement();
            nl.notification(new NotificationEvent(this, NOTIFICATION_TYPE));
        }
    }

    protected void changed(String type, String name) {
        Vector listenersClone = null;
        Vector vector = this.listeners;
        synchronized (vector) {
            listenersClone = (Vector)this.listeners.clone();
        }
        NotificationEvent event = new NotificationEvent(this, type, "name", name);
        Enumeration e10 = listenersClone.elements();
        while (e10.hasMoreElements()) {
            NotificationListener nl = (NotificationListener)e10.nextElement();
            nl.notification(event);
        }
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    public BufferedRemoteByteArray createBufferedByteArray(String serverName, byte[] bytes) throws ServerException {
        try {
            BufferedRemoteByteArrayImpl buffer = new BufferedRemoteByteArrayImpl(bytes);
            PortableRemoteObject.exportObject(buffer);
            Tie servantsTie = Util.getTie(buffer);
            servantsTie.orb(this.getOrb(serverName));
            return buffer;
        }
        catch (Throwable throwable) {
            throw new ServerException(localStrings.getLocalString("enterprise.tools.deployment.main.couldnotgetorbforserver", "Couldn't get orb for ({0}) {1}", new Object[]{"createBufferedByteArray", serverName}));
        }
    }

    public DeploymentSession createDeploymentSession(String serverName) throws Exception {
        try {
            DeploymentSessionImpl ds2 = new DeploymentSessionImpl();
            PortableRemoteObject.exportObject(ds2);
            Tie servantsTie = Util.getTie(ds2);
            servantsTie.orb(this.getOrb(serverName));
            return ds2;
        }
        catch (Throwable throwable) {
            throw new ServerException(localStrings.getLocalString("enterprise.tools.deployment.main.couldnotgetorbforserver", "Couldn't get orb for ({0}) {1}", new Object[]{"createDeploymentSession", serverName}));
        }
    }

    private ServerListener createServerListener(String serverName) throws Exception {
        try {
            ServerListener listener = new ServerListener(this);
            PortableRemoteObject.exportObject(listener);
            Tie servantsTie = Util.getTie(listener);
            servantsTie.orb(this.getOrb(serverName));
            return listener;
        }
        catch (Throwable throwable) {
            throw new ServerException(localStrings.getLocalString("enterprise.tools.deployment.main.couldnotgetorbforserver", "Couldn't get orb for ({0}) {1}", new Object[]{"createCallBack", serverName}));
        }
    }

    public Vector getApplicationNames() throws ServerException {
        Vector v2 = null;
        String serverName = this.getCurrentServer();
        if (serverName == null) {
            return v2;
        }
        JarInstaller installer = this.getJarInstaller(serverName);
        if (installer != null) {
            try {
                v2 = installer.getApplicationNames();
            }
            catch (RemoteException re) {
                throw new ServerException(localStrings.getLocalString("enterprise.tools.deployment.main.errorgettingappnamefromserverwithreason", "Error obtaining application names from {0} \n reason {1}", new Object[]{serverName, re.getMessage()}));
            }
        }
        return v2;
    }

    public String getCurrentServer() {
        if (this.currentServer != null && this.serverNameToListenerMap.containsKey(this.currentServer)) {
            return this.currentServer;
        }
        return null;
    }

    public DBInfo getDBInfo(String serverName) throws ServerException {
        try {
            Context initialContext = this.getIC(serverName);
            Object objref = initialContext.lookup("DatabaseInformation");
            Object o2 = PortableRemoteObject.narrow(objref, class$com$sun$ejb$sqlgen$DBInfo != null ? class$com$sun$ejb$sqlgen$DBInfo : (class$com$sun$ejb$sqlgen$DBInfo = ServerManager.class$("com.sun.ejb.sqlgen.DBInfo")));
            DBInfo info = (DBInfo)o2;
            return info;
        }
        catch (Throwable throwable) {
            throw new ServerException(localStrings.getLocalString("enterprise.tools.deployment.main.couldnotgetdbinfofromserver", "Could not get db info from the J2EE server {0}", new Object[]{serverName}));
        }
    }

    protected Context getIC(String serverName) throws Exception {
        ORB orb = this.getOrb(serverName);
        Hashtable<String, ORB> env = new Hashtable<String, ORB>();
        env.put("java.naming.corba.orb", orb);
        InitialContext ic = new InitialContext(env);
        return ic;
    }

    private JarInstaller getJarInstaller(String serverName) throws ServerException {
        try {
            Context initialContext = this.getIC(serverName);
            Object objref = initialContext.lookup("JarInstaller");
            Object o2 = PortableRemoteObject.narrow(objref, class$com$sun$enterprise$tools$deployment$backend$JarInstaller != null ? class$com$sun$enterprise$tools$deployment$backend$JarInstaller : (class$com$sun$enterprise$tools$deployment$backend$JarInstaller = ServerManager.class$("com.sun.enterprise.tools.deployment.backend.JarInstaller")));
            JarInstaller installer = (JarInstaller)o2;
            return installer;
        }
        catch (Throwable throwable) {
            throw new ServerException(localStrings.getLocalString("enterprise.tools.deployment.main.couldnotconnecttoserver", "Couldn't connect to {0}", new Object[]{serverName}));
        }
    }

    private ORB getOrb(String hostName) throws ServerException {
        String hostNameToUse = hostName;
        if (LOCAL_SERVER.equals(hostName)) {
            hostNameToUse = LOCAL_HOST;
        }
        return ORBManager.getORBForHost(hostNameToUse);
    }

    public JarInstaller getServerForName(String serverName) throws ServerException {
        return this.getJarInstaller(serverName);
    }

    public Vector getServerNames() {
        Vector v2 = new Vector();
        Enumeration e10 = this.serverNameToListenerMap.keys();
        while (e10.hasMoreElements()) {
            v2.addElement(e10.nextElement());
        }
        return v2;
    }

    public boolean isInstalled(String applicationName, String serverName) throws ServerException {
        JarInstaller installer = this.getJarInstaller(serverName);
        if (installer != null) {
            try {
                Vector applicationNames = installer.getApplicationNames();
                int i2 = 0;
                while (i2 < applicationNames.size()) {
                    if (applicationName.equals(applicationNames.elementAt(i2))) {
                        return true;
                    }
                    ++i2;
                }
            }
            catch (Throwable throwable) {
                throw new ServerException(localStrings.getLocalString("enterprise.tools.deployment.main.couldnotapplicationlistfromserver", "Couldn't get application list from {0}", new Object[]{serverName}));
            }
        }
        return false;
    }

    private String printList() {
        String s2 = "Server Manager ";
        Enumeration e10 = this.getServerNames().elements();
        while (e10.hasMoreElements()) {
            s2 = String.valueOf(s2) + "\n\t" + e10.nextElement();
        }
        return s2;
    }

    public void removeNotificationListener(NotificationListener nl) {
        this.listeners.removeElement(nl);
        this.changed();
    }

    public void removeServer(String hostName) {
        if (this.serverNameToListenerMap.containsKey(hostName)) {
            ServerListener serverListener = (ServerListener)this.serverNameToListenerMap.get(hostName);
            try {
                try {
                    this.serverNameToListenerMap.remove(hostName);
                    if (this.getCurrentServer() != null && this.getCurrentServer().equals(hostName)) {
                        this.currentServer = null;
                    }
                    this.changed(SERVER_REMOVED, hostName);
                    JarInstaller jarInstaller = this.getJarInstaller(hostName);
                    jarInstaller.removeRemoteNotificationListener(serverListener);
                }
                catch (Exception exception) {
                }
                Object var4_4 = null;
            }
            catch (Throwable throwable) {
                Object var4_5 = null;
                ORBManager.removeORBForHost(hostName);
                throw throwable;
            }
            ORBManager.removeORBForHost(hostName);
        }
    }

    public Hashtable restoreFromUserHome() throws IOException {
        Hashtable badServerNamesToExceptions = new Hashtable();
        File serversFile = new File(this.preferencesDirectory, SERVERS_FILENAME);
        if (serversFile.exists()) {
            FileInputStream fis = new FileInputStream(serversFile);
            Properties servers = new Properties();
            servers.load(fis);
            fis.close();
            Enumeration<?> e10 = servers.propertyNames();
            while (e10.hasMoreElements()) {
                String serverName = (String)e10.nextElement();
                try {
                    this.addServer(serverName);
                }
                catch (Throwable ex2) {
                    badServerNamesToExceptions.put(badServerNamesToExceptions, ex2);
                }
            }
        }
        return badServerNamesToExceptions;
    }

    public void saveToUserHome() throws IOException {
        this.preferencesDirectory.mkdirs();
        File serversFile = new File(this.preferencesDirectory, SERVERS_FILENAME);
        FileOutputStream fos = new FileOutputStream(serversFile);
        Properties serversP = new Properties();
        Enumeration e10 = this.getServerNames().elements();
        while (e10.hasMoreElements()) {
            String nextServer = (String)e10.nextElement();
            ((Hashtable)serversP).put(nextServer, nextServer);
        }
        serversP.store(fos, "J2EE Servers");
    }

    public void setCurrentServer(String serverName) {
        this.currentServer = serverName;
        String notificationString = "";
        if (serverName != null) {
            notificationString = serverName;
        }
        this.changed(SERVER_SELECTED, notificationString);
    }

    public String toString() {
        return "ServerManager";
    }

    public void uninstall(String applicationName, String serverName) throws ServerException {
        JarInstaller installer = this.getJarInstaller(serverName);
        try {
            installer.undeployApplication(applicationName);
        }
        catch (Throwable throwable) {
            throw new ServerException(localStrings.getLocalString("enterprise.tools.deployment.main.erroruninstallingapplicationfromserver", "Error uninstalling {0} from {1}", new Object[]{applicationName, serverName}));
        }
    }
}

