/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.deployment.ui;

import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.security.PrincipalImpl;
import com.sun.enterprise.security.acl.Group;
import com.sun.enterprise.security.acl.Role;
import com.sun.enterprise.security.acl.RoleMapper;
import com.sun.enterprise.tools.deployment.main.ServerManager;
import com.sun.enterprise.tools.deployment.ui.Inspector;
import com.sun.enterprise.tools.deployment.ui.InspectorTable;
import com.sun.enterprise.tools.deployment.ui.UsersDialog;
import com.sun.enterprise.tools.deployment.ui.UsersTable;
import com.sun.enterprise.tools.deployment.ui.UsersTableModel;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import javax.help.CSH;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;

public class AppSecurityInspector
extends JPanel
implements Inspector {
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(class$com$sun$enterprise$tools$deployment$ui$AppSecurityInspector != null ? class$com$sun$enterprise$tools$deployment$ui$AppSecurityInspector : (class$com$sun$enterprise$tools$deployment$ui$AppSecurityInspector = AppSecurityInspector.class$("com.sun.enterprise.tools.deployment.ui.AppSecurityInspector")));
    Application application;
    RoleNamesTableModel roleNamesTableModel;
    RoleNamesTable roleNamesTable;
    UsersTableModel usersTableModel;
    UsersTable usersTable;
    UsersTableModel userGroupsTableModel;
    UsersTable userGroupsTable;
    UsersDialog usersDialog;
    GridBagConstraints c = new GridBagConstraints();
    private ServerManager serverManager;
    private static String helpSetMapID = "AISecurity";
    static /* synthetic */ Class class$com$sun$enterprise$tools$deployment$ui$AppSecurityInspector;

    public AppSecurityInspector(ServerManager serverManager) {
        this.serverManager = serverManager;
        CSH.setHelpIDString((Component)this, (String)helpSetMapID);
        try {
            Class<?> cls = Class.forName("javax.swing.JFrame");
            JFrame frame = (JFrame)SwingUtilities.getAncestorOfClass(cls, this);
            this.usersDialog = new UsersDialog((Frame)frame, false);
            CSH.setHelpIDString((Component)this.usersDialog, (String)"AIAddUser");
            this.usersDialog.setServerManager(serverManager);
            this.usersDialog.addComponentListener(new ComponentAdapter(){

                public void componentHidden(ComponentEvent we) {
                    String selectedUser = AppSecurityInspector.this.usersDialog.getSelectedUser();
                    String selectedGroup = AppSecurityInspector.this.usersDialog.getSelectedGroup();
                    if (selectedUser != null) {
                        AppSecurityInspector.this.usersTableModel.addUser(selectedUser);
                        AppSecurityInspector.this.addUserToRoleMapper(selectedUser);
                    }
                    if (selectedGroup != null) {
                        AppSecurityInspector.this.userGroupsTableModel.addUser(selectedGroup);
                        AppSecurityInspector.this.addGroupToRoleMapper(selectedGroup);
                    }
                }
            });
            this.usersDialog.pack();
        }
        catch (ClassNotFoundException classNotFoundException) {}
        GridBagLayout gb1 = new GridBagLayout();
        this.setLayout(gb1);
        this.c.fill = 1;
        this.c.weightx = 0.5;
        JLabel roleNamesLabel = new JLabel(localStrings.getLocalString("appsecurityinspector.role_names_label", "Role names referenced:"));
        this.c.gridx = 0;
        this.c.gridy = 0;
        this.c.gridwidth = 1;
        this.c.gridheight = 1;
        this.c.weightx = 0.0;
        this.c.weighty = 0.0;
        this.c.insets = new Insets(5, 5, 0, 5);
        this.c.fill = 1;
        gb1.setConstraints(roleNamesLabel, this.c);
        this.add(roleNamesLabel);
        this.roleNamesTableModel = new RoleNamesTableModel();
        this.roleNamesTable = new RoleNamesTable(this.roleNamesTableModel);
        JScrollPane roleNamesPane = new JScrollPane(this.roleNamesTable);
        this.roleNamesTable.setSelectionMode(0);
        this.roleNamesTable.setAutoResizeMode(4);
        ListSelectionModel roleNamesSelectionModel = this.roleNamesTable.getSelectionModel();
        roleNamesSelectionModel.addListSelectionListener(new RoleNamesSelectionListener());
        JScrollPane roleNamesTablePane = new JScrollPane(this.roleNamesTable);
        roleNamesTablePane.setPreferredSize(new Dimension(300, 400));
        this.c.gridx = 0;
        this.c.gridy = 1;
        this.c.gridwidth = 1;
        this.c.gridheight = 1;
        this.c.weightx = 0.5;
        this.c.weighty = 0.5;
        this.c.insets = new Insets(5, 5, 5, 5);
        this.c.fill = 1;
        gb1.setConstraints(roleNamesTablePane, this.c);
        this.add(roleNamesTablePane);
        JLabel usersLabel = new JLabel(localStrings.getLocalString("appsecurityinspector.users_label", "Users in role:"));
        this.c.gridx = 1;
        this.c.gridy = 0;
        this.c.gridwidth = 1;
        this.c.gridheight = 1;
        this.c.weightx = 0.0;
        this.c.weighty = 0.0;
        this.c.insets = new Insets(5, 5, 0, 5);
        this.c.fill = 1;
        gb1.setConstraints(usersLabel, this.c);
        this.add(usersLabel);
        this.usersTableModel = new UsersTableModel(UsersTableModel.usersColumnNames);
        this.usersTable = new UsersTable(this.usersTableModel);
        JScrollPane usersTablePane = new JScrollPane(this.usersTable);
        this.usersTable.setSelectionMode(0);
        this.usersTable.setAutoResizeMode(4);
        ListSelectionModel usersSelectionModel = this.usersTable.getSelectionModel();
        usersSelectionModel.addListSelectionListener(new UserSelectionListener());
        usersTablePane.setPreferredSize(new Dimension(200, 200));
        this.c.gridx = 1;
        this.c.gridy = 1;
        this.c.gridwidth = 1;
        this.c.gridheight = 1;
        this.c.weightx = 0.5;
        this.c.weighty = 0.5;
        this.c.insets = new Insets(5, 5, 5, 5);
        this.c.fill = 1;
        gb1.setConstraints(usersTablePane, this.c);
        this.add(usersTablePane);
        this.userGroupsTableModel = new UsersTableModel(UsersTableModel.userGroupsColumnNames);
        this.userGroupsTable = new UsersTable(this.userGroupsTableModel);
        JScrollPane userGroupsTablePane = new JScrollPane(this.userGroupsTable);
        this.userGroupsTable.setSelectionMode(0);
        this.userGroupsTable.setAutoResizeMode(4);
        ListSelectionModel userGroupsSelectionModel = this.userGroupsTable.getSelectionModel();
        userGroupsSelectionModel.addListSelectionListener(new UserSelectionListener());
        userGroupsTablePane.setPreferredSize(new Dimension(200, 200));
        this.c.gridx = 1;
        this.c.gridy = 2;
        this.c.gridwidth = 1;
        this.c.gridheight = 1;
        this.c.weightx = 0.5;
        this.c.weighty = 0.5;
        this.c.insets = new Insets(5, 5, 5, 5);
        this.c.fill = 1;
        gb1.setConstraints(userGroupsTablePane, this.c);
        this.add(userGroupsTablePane);
        JPanel roleNamesButtonPanel = new JPanel();
        roleNamesButtonPanel.setLayout(new GridLayout(1, 2, 5, 5));
        this.c.gridx = 0;
        this.c.gridy = 3;
        this.c.gridwidth = 2;
        this.c.gridheight = 1;
        this.c.weightx = 0.0;
        this.c.weighty = 0.0;
        this.c.insets = new Insets(5, 5, 5, 5);
        this.c.fill = 0;
        this.c.anchor = 13;
        gb1.setConstraints(roleNamesButtonPanel, this.c);
        this.add(roleNamesButtonPanel);
        this.c.fill = 1;
        this.c.anchor = 10;
        String addSecConstPBText = localStrings.getLocalString("appsecurityinspector.add_sec_const_pb", "Add");
        JButton addSecConstPB = new JButton(addSecConstPBText);
        roleNamesButtonPanel.add(addSecConstPB);
        addSecConstPB.setMnemonic('A');
        addSecConstPB.setActionCommand("Add");
        addSecConstPB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e10) {
                AppSecurityInspector.this.addUserAction();
            }
        });
        String delSecConstPBString = localStrings.getLocalString("appsecurityinspector.del_sec_const_pb", "Delete...");
        JButton delSecConstPB = new JButton(delSecConstPBString);
        roleNamesButtonPanel.add(delSecConstPB);
        delSecConstPB.setMnemonic('D');
        delSecConstPB.setActionCommand("Delete");
        delSecConstPB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e10) {
                AppSecurityInspector.this.deleteUserAction();
            }
        });
    }

    private void addGroupToRoleMapper(String selectedUser) {
        RoleMapper roleMapper = this.application.getRoleMapper();
        Role role = new Role(this.roleNamesTableModel.get(this.roleNamesTable.getSelectedRow()));
        roleMapper.assignRole(new Group(selectedUser), role);
    }

    private void addUserAction() {
        if (this.serverManager.getCurrentServer() == null) {
            JOptionPane.showMessageDialog(this, localStrings.getLocalString("appsecurityinspector.must_connect", "You must connect to the J2EE server before mapping users."));
            return;
        }
        if (this.roleNamesTable.getSelectedRow() < 0) {
            JOptionPane.showMessageDialog(this, localStrings.getLocalString("appsecurityinspector.must_select_role", "You must select a role before attempting to add users."));
            return;
        }
        if (this.usersDialog != null) {
            this.usersDialog.setLocationRelativeTo(this.usersDialog.getOwner());
            this.usersDialog.setVisible(true);
        }
    }

    private void addUserToRoleMapper(String selectedUser) {
        RoleMapper roleMapper = this.application.getRoleMapper();
        Role role = new Role(this.roleNamesTableModel.get(this.roleNamesTable.getSelectedRow()));
        roleMapper.assignRole(new PrincipalImpl(selectedUser), role);
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    private void deleteUserAction() {
        try {
            Class<?> cls = Class.forName("javax.swing.JFrame");
            JFrame frame = (JFrame)SwingUtilities.getAncestorOfClass(cls, this);
            UsersTableModel usersModel = (UsersTableModel)this.usersTable.getModel();
            UsersTableModel groupsModel = (UsersTableModel)this.userGroupsTable.getModel();
            int usersIndex = this.usersTable.getSelectedRow();
            int groupsIndex = this.userGroupsTable.getSelectedRow();
            if (usersIndex >= 0 || groupsIndex >= 0) {
                int n2 = JOptionPane.showConfirmDialog(frame, localStrings.getLocalString("appsecurityinspector.sure_delete_user", "Are you sure you want to delete selected user?"), localStrings.getLocalString("appsecurityinspector.delete_user", "Delete user"), 0);
                if (n2 == 0) {
                    RoleMapper roleMapper = this.application.getRoleMapper();
                    Role role = new Role(this.roleNamesTableModel.get(this.roleNamesTable.getSelectedRow()));
                    if (usersIndex >= 0) {
                        String user = usersModel.getUserAt(usersIndex);
                        roleMapper.unassignPrincipalFromRole(role, new PrincipalImpl(user));
                        usersModel.removeRowAt(usersIndex);
                    }
                    if (groupsIndex >= 0) {
                        String group = groupsModel.getUserAt(groupsIndex);
                        roleMapper.unassignPrincipalFromRole(role, new Group(group));
                        groupsModel.removeRowAt(groupsIndex);
                    }
                }
            } else {
                JOptionPane.showMessageDialog(frame, localStrings.getLocalString("appsecurityinspector.must_select_user", "You must first select a user from list"));
            }
        }
        catch (ClassNotFoundException classNotFoundException) {}
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame();
        AppSecurityInspector myPanel = new AppSecurityInspector(null);
        frame.getContentPane().add((Component)myPanel, "Center");
        ((Component)frame).setSize(myPanel.getPreferredSize());
        ((Component)frame).setVisible(true);
    }

    private void refresh() {
        if (this.application == null) {
            return;
        }
        this.roleNamesTableModel = new RoleNamesTableModel();
        Iterator itr = this.application.getRoles().iterator();
        while (itr.hasNext()) {
            Role nextRole = (Role)itr.next();
            this.roleNamesTableModel.add(nextRole.getName());
        }
        this.roleNamesTable.setModel(this.roleNamesTableModel);
        this.roleNamesTable.sizeColumnsToFit(0);
    }

    public void setObject(Object object) {
        if (object instanceof Application) {
            this.application = (Application)object;
            this.refresh();
        }
    }

    private void showUsersInRole(String role) {
        PrincipalImpl principal;
        if (this.application == null) {
            return;
        }
        RoleMapper roleMapper = this.application.getRoleMapper();
        ArrayList associatedPrincipals = new ArrayList();
        Enumeration e10 = null;
        e10 = roleMapper.getUsersAssignedTo(new Role(role));
        while (e10.hasMoreElements()) {
            associatedPrincipals.add(e10.nextElement());
        }
        ArrayList associatedGroups = new ArrayList();
        e10 = roleMapper.getGroupsAssignedTo(new Role(role));
        while (e10.hasMoreElements()) {
            associatedGroups.add(e10.nextElement());
        }
        this.usersTableModel = new UsersTableModel(UsersTableModel.usersColumnNames);
        Iterator iter = ((AbstractList)associatedPrincipals).iterator();
        while (iter.hasNext()) {
            principal = (PrincipalImpl)iter.next();
            this.usersTableModel.addUser(principal.getName());
        }
        this.usersTable.setModel(this.usersTableModel);
        this.usersTable.sizeColumnsToFit(0);
        this.userGroupsTableModel = new UsersTableModel(UsersTableModel.userGroupsColumnNames);
        iter = ((AbstractList)associatedGroups).iterator();
        while (iter.hasNext()) {
            principal = (PrincipalImpl)iter.next();
            this.userGroupsTableModel.addUser(principal.getName());
        }
        this.userGroupsTable.setModel(this.userGroupsTableModel);
        this.userGroupsTable.sizeColumnsToFit(0);
    }

    private class RoleNamesTable
    extends InspectorTable {
        public RoleNamesTable(RoleNamesTableModel model) {
            super(model);
            this.setToolTipText(localStrings.getLocalString("appsecurityinspector.role_names_tool_tip", "Table of role names"));
            this.setSelectionMode(0);
        }
    }

    public class RoleNamesTableModel
    extends AbstractTableModel {
        ArrayList roleNames = new ArrayList();
        String[] columnNames = new String[]{AppSecurityInspector.access$4().getLocalString("appsecurityinspector.role_names_table_col_name", "Role Name")};

        public void add(String roleName) {
            this.roleNames.add(roleName);
        }

        public String get(int i2) {
            return (String)this.roleNames.get(i2);
        }

        public int getColumnCount() {
            return this.columnNames.length;
        }

        public String getColumnName(int col) {
            return this.columnNames[col].toString();
        }

        public int getRowCount() {
            return this.roleNames.size();
        }

        public Object getValueAt(int row, int col) {
            return this.roleNames.get(row);
        }

        public boolean isCellEditable(int row, int col) {
            return col >= 1;
        }

        public void setValueAt(Object value, int row, int col) {
            this.roleNames.set(row, value);
        }

        private class UserInfo {
            String name;
            String columnName;
            String type;

            UserInfo() {
            }

            Object getElement(int col) {
                String elem = null;
                switch (col) {
                    case 0: {
                        elem = this.name;
                        break;
                    }
                    case 1: {
                        elem = this.columnName;
                        break;
                    }
                    case 2: {
                        elem = this.type;
                        break;
                    }
                }
                return elem;
            }

            void setElement(int col, Object elem) {
                switch (col) {
                    case 0: {
                        this.name = elem.toString();
                        break;
                    }
                    case 1: {
                        this.columnName = elem.toString();
                        break;
                    }
                    case 2: {
                        this.type = elem.toString();
                        break;
                    }
                }
            }
        }
    }

    class RoleNamesSelectionListener
    implements ListSelectionListener {
        RoleNamesSelectionListener() {
        }

        public void valueChanged(ListSelectionEvent e10) {
            ListSelectionModel sm = (ListSelectionModel)e10.getSource();
            int firstIndex = e10.getFirstIndex();
            int lastIndex = e10.getLastIndex();
            boolean isAdjusting = e10.getValueIsAdjusting();
            if (isAdjusting) {
                return;
            }
            if (!sm.isSelectionEmpty()) {
                int minIndex = sm.getMinSelectionIndex();
                int maxIndex = sm.getMaxSelectionIndex();
                int i2 = minIndex;
                while (i2 <= maxIndex) {
                    if (sm.isSelectedIndex(i2)) {
                        AppSecurityInspector.this.showUsersInRole(AppSecurityInspector.this.roleNamesTableModel.get(i2));
                    }
                    ++i2;
                }
            }
        }
    }

    class UserSelectionListener
    implements ListSelectionListener {
        UserSelectionListener() {
        }

        public void valueChanged(ListSelectionEvent e10) {
            ListSelectionModel sm = (ListSelectionModel)e10.getSource();
            int firstIndex = e10.getFirstIndex();
            int lastIndex = e10.getLastIndex();
            boolean isAdjusting = e10.getValueIsAdjusting();
            if (isAdjusting) {
                return;
            }
            if (!sm.isSelectionEmpty()) {
                int minIndex = sm.getMinSelectionIndex();
                int maxIndex = sm.getMaxSelectionIndex();
                int i2 = minIndex;
                while (i2 <= maxIndex) {
                    sm.isSelectedIndex(i2);
                    ++i2;
                }
            }
        }
    }
}

