/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.deployment.ui;

import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.ApplicationArchivist;
import com.sun.enterprise.tools.deployment.main.ServerManager;
import com.sun.enterprise.tools.deployment.ui.IconChanger;
import com.sun.enterprise.tools.deployment.ui.IconInspector;
import com.sun.enterprise.tools.deployment.ui.Inspector;
import com.sun.enterprise.tools.deployment.ui.UIUtils;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import javax.help.CSH;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class ApplicationGeneralInspector
extends JPanel
implements Inspector,
IconChanger {
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(class$com$sun$enterprise$tools$deployment$ui$ApplicationGeneralInspector != null ? class$com$sun$enterprise$tools$deployment$ui$ApplicationGeneralInspector : (class$com$sun$enterprise$tools$deployment$ui$ApplicationGeneralInspector = ApplicationGeneralInspector.class$("com.sun.enterprise.tools.deployment.ui.ApplicationGeneralInspector")));
    Application descriptor;
    JTextField displayNameText;
    JTextField locationText;
    JList contentsList;
    JTextArea descriptionText;
    IconInspector iconsPanel;
    protected ServerManager serverManager;
    String mode = "DeployerMode";
    GridBagConstraints c = new GridBagConstraints();
    private static String helpSetMapID = "AIGeneral";
    static /* synthetic */ Class class$com$sun$enterprise$tools$deployment$ui$ApplicationGeneralInspector;

    public ApplicationGeneralInspector(ServerManager serverManager) {
        CSH.setHelpIDString((Component)this, (String)helpSetMapID);
        this.serverManager = serverManager;
        this.initializeLayout();
        this.addListeners();
    }

    public void addLargeIcon(File iconFile) {
        try {
            this.descriptor.getApplicationArchivist().add32Icon(iconFile);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    private void addLibJarAction() {
        JFileChooser jfc = UIUtils.getFileChooser();
        jfc.setFileSelectionMode(0);
        int returnValue = jfc.showDialog(this, "Add Library JAR");
        if (returnValue == 0) {
            File libJarFile = jfc.getSelectedFile();
            try {
                this.descriptor.getApplicationArchivist().addLibraryJar(libJarFile);
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
                JOptionPane.showMessageDialog(this, "Error adding library JAR.");
            }
        }
        this.refresh();
    }

    private void addListeners() {
        this.displayNameText.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent fe2) {
                ApplicationGeneralInspector.this.descriptor.setName(ApplicationGeneralInspector.this.displayNameText.getText().trim());
            }
        });
        this.displayNameText.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent ke) {
                if (ke.getKeyCode() == 10) {
                    ApplicationGeneralInspector.this.descriptor.setName(ApplicationGeneralInspector.this.displayNameText.getText());
                }
            }
        });
        this.descriptionText.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent fe2) {
                ApplicationGeneralInspector.this.descriptor.setDescription(ApplicationGeneralInspector.this.descriptionText.getText().trim());
            }
        });
        this.descriptionText.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent ke) {
                if (ke.getKeyCode() == 10) {
                    ApplicationGeneralInspector.this.descriptor.setDescription(ApplicationGeneralInspector.this.descriptionText.getText());
                }
            }
        });
    }

    public void addSmallIcon(File iconFile) {
        try {
            this.descriptor.getApplicationArchivist().add16Icon(iconFile);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    private void initializeLayout() {
        this.setLayout(new BorderLayout());
        JPanel leftPanel = new JPanel();
        GridBagLayout gb = new GridBagLayout();
        leftPanel.setLayout(gb);
        this.c.fill = 1;
        this.c.weightx = 0.5;
        JPanel displayAndLocationPanel = new JPanel();
        GridBagLayout gb1 = new GridBagLayout();
        displayAndLocationPanel.setLayout(gb1);
        this.c.weightx = 0.0;
        this.c.weighty = 0.0;
        this.c.gridx = 0;
        this.c.gridy = 0;
        this.c.gridwidth = 1;
        this.c.gridheight = 1;
        gb.setConstraints(displayAndLocationPanel, this.c);
        leftPanel.add(displayAndLocationPanel);
        JLabel displayNameLabel = new JLabel(localStrings.getLocalString("applicationgeneralinspector.display_name_label", "Display name:"));
        this.c.weightx = 0.0;
        this.c.weighty = 0.0;
        this.c.gridx = 0;
        this.c.gridy = 0;
        this.c.gridwidth = 1;
        this.c.gridheight = 1;
        this.c.insets = new Insets(5, 5, 0, 5);
        gb1.setConstraints(displayNameLabel, this.c);
        displayAndLocationPanel.add(displayNameLabel);
        this.displayNameText = new JTextField();
        this.c.weightx = 0.5;
        this.c.weighty = 0.0;
        this.c.gridx = 0;
        this.c.gridy = 1;
        this.c.gridwidth = 1;
        this.c.gridheight = 1;
        this.c.insets = new Insets(0, 5, 0, 5);
        gb1.setConstraints(this.displayNameText, this.c);
        displayAndLocationPanel.add(this.displayNameText);
        JLabel locationLabel = new JLabel(localStrings.getLocalString("applicationgeneralinspector.location_label", "Location:"));
        this.c.weightx = 0.0;
        this.c.weighty = 0.0;
        this.c.gridx = 0;
        this.c.gridy = 2;
        this.c.gridwidth = 1;
        this.c.gridheight = 1;
        this.c.insets = new Insets(5, 5, 0, 5);
        gb1.setConstraints(locationLabel, this.c);
        displayAndLocationPanel.add(locationLabel);
        this.locationText = new JTextField();
        this.c.weightx = 0.5;
        this.c.weighty = 0.0;
        this.c.gridx = 0;
        this.c.gridy = 3;
        this.c.gridwidth = 1;
        this.c.gridheight = 1;
        this.c.insets = new Insets(0, 5, 0, 5);
        gb1.setConstraints(this.locationText, this.c);
        displayAndLocationPanel.add(this.locationText);
        JLabel contentsLabel = new JLabel(localStrings.getLocalString("applicationgeneralinspector.contents_label", "Contents:"));
        this.c.weightx = 0.0;
        this.c.weighty = 0.0;
        this.c.gridx = 0;
        this.c.gridy = 4;
        this.c.gridwidth = 1;
        this.c.gridheight = 1;
        this.c.insets = new Insets(5, 5, 0, 5);
        gb.setConstraints(contentsLabel, this.c);
        leftPanel.add(contentsLabel);
        this.contentsList = new JList();
        JPanel contentsListPanel = new JPanel();
        contentsListPanel.setLayout(new BorderLayout());
        JScrollPane contentsListPane = new JScrollPane(this.contentsList);
        contentsListPanel.setPreferredSize(new Dimension(300, 300));
        contentsListPanel.add("Center", contentsListPane);
        JPanel btnPanel = new JPanel();
        JButton addLibJarButton = new JButton("Add Library JAR");
        addLibJarButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae2) {
                ApplicationGeneralInspector.this.addLibJarAction();
            }
        });
        btnPanel.add(addLibJarButton);
        contentsListPanel.add("South", btnPanel);
        this.c.weightx = 0.5;
        this.c.weighty = 0.8;
        this.c.gridx = 0;
        this.c.gridy = 5;
        this.c.gridwidth = 1;
        this.c.gridheight = 1;
        this.c.insets = new Insets(0, 5, 0, 5);
        gb.setConstraints(contentsListPanel, this.c);
        leftPanel.add(contentsListPanel);
        JLabel descriptionLabel = new JLabel(localStrings.getLocalString("applicationgeneralinspector.description_label", "Description:"));
        this.c.weightx = 0.0;
        this.c.weighty = 0.0;
        this.c.gridx = 0;
        this.c.gridy = 6;
        this.c.gridwidth = 1;
        this.c.gridheight = 1;
        this.c.insets = new Insets(5, 5, 0, 5);
        gb.setConstraints(descriptionLabel, this.c);
        leftPanel.add(descriptionLabel);
        this.descriptionText = new JTextArea();
        this.descriptionText.setLineWrap(true);
        JScrollPane descriptionTextPane = new JScrollPane(this.descriptionText);
        descriptionTextPane.setPreferredSize(new Dimension(300, 100));
        this.c.weightx = 0.5;
        this.c.weighty = 0.2;
        this.c.gridx = 0;
        this.c.gridy = 7;
        this.c.gridwidth = 1;
        this.c.gridheight = 1;
        this.c.insets = new Insets(0, 5, 5, 5);
        gb.setConstraints(descriptionTextPane, this.c);
        leftPanel.add(descriptionTextPane);
        JPanel rightPanel = new JPanel(new BorderLayout());
        this.iconsPanel = new IconInspector(this);
        this.iconsPanel.setPreferredSize(new Dimension(150, this.iconsPanel.getPreferredSize().height));
        rightPanel.add((Component)this.iconsPanel, "South");
        this.add((Component)leftPanel, "Center");
        this.add((Component)rightPanel, "East");
        this.c.fill = 1;
        this.c.anchor = 10;
        this.contentsList.setBorder(BorderFactory.createLoweredBevelBorder());
        this.locationText.setEnabled(false);
    }

    private void refresh() {
        block4: {
            ApplicationArchivist archivist = this.descriptor.getApplicationArchivist();
            if (archivist != null) {
                this.locationText.setText(archivist.getApplicationFile().toString());
            }
            this.iconsPanel.setObject(this.descriptor);
            this.displayNameText.setText(this.descriptor.getName());
            this.descriptionText.setText(this.descriptor.getDescription());
            if (archivist == null) break block4;
            try {
                JarFile jar = new JarFile(archivist.getApplicationFile());
                DefaultListModel<String> contentsListModel = new DefaultListModel<String>();
                Enumeration<JarEntry> jarEntries = jar.entries();
                while (jarEntries.hasMoreElements()) {
                    ZipEntry entry = jarEntries.nextElement();
                    contentsListModel.addElement(entry.getName());
                }
                this.contentsList.setModel(contentsListModel);
                jar.close();
            }
            catch (Throwable throwable) {}
        }
    }

    public void setObject(Object object) {
        if (object instanceof Application) {
            this.descriptor = (Application)object;
            this.refresh();
        }
    }
}

