/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.deployment.ui;

import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.ApplicationClientDescriptor;
import com.sun.enterprise.deployment.BundleDescriptor;
import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.EjbBundleDescriptor;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.JspDescriptorImpl;
import com.sun.enterprise.deployment.ServletDescriptorImpl;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.deployment.WebComponentDescriptorImpl;
import com.sun.enterprise.tools.deployment.main.ApplicationManager;
import com.sun.enterprise.tools.deployment.ui.ApplicationTreeCellRenderer;
import com.sun.enterprise.tools.deployment.ui.FileDropRecipient;
import com.sun.enterprise.tools.deployment.ui.FileDropTarget;
import com.sun.enterprise.tools.deployment.ui.TreeCombo;
import com.sun.enterprise.tools.deployment.ui.UIUtils;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.util.NotificationEvent;
import com.sun.enterprise.util.NotificationListener;
import java.awt.BorderLayout;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;

public class ApplicationView
extends JPanel
implements NotificationListener {
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(class$com$sun$enterprise$tools$deployment$ui$ApplicationView != null ? class$com$sun$enterprise$tools$deployment$ui$ApplicationView : (class$com$sun$enterprise$tools$deployment$ui$ApplicationView = ApplicationView.class$("com.sun.enterprise.tools.deployment.ui.ApplicationView")));
    public static String ALL = "all";
    public static String APPS_ONLY = "appsOnly";
    public static String APPS_AND_EJB_JARS = "appsAndEjbJars";
    public static String APPS_AND_WARS = "appsAndWars";
    private static String APPLICATIONS_LABEL = localStrings.getLocalString("applicationview.applications_label", "Local Applications");
    private JTree applicationTree;
    private ApplicationManager applicationManager;
    private TreeCombo treeCombo;
    static /* synthetic */ Class class$com$sun$enterprise$tools$deployment$ui$ApplicationView;
    static /* synthetic */ Class class$com$sun$enterprise$deployment$BundleDescriptor;

    public ApplicationView(JTree applicationTree, FileDropRecipient fileDropRecipient) {
        this.applicationTree = applicationTree;
        DefaultMutableTreeNode root = new DefaultMutableTreeNode(localStrings.getLocalString("applicationview.application_tree_root", "Applications"), true);
        DefaultTreeModel treeModel = new DefaultTreeModel(root);
        this.applicationTree.setModel(treeModel);
        this.applicationTree.setCellRenderer(new ApplicationTreeCellRenderer());
        this.applicationTree.setRootVisible(false);
        this.applicationTree.setShowsRootHandles(true);
        this.setLayout(new BorderLayout());
        JPanel mainPanel = UIUtils.createBorderedPanel(APPLICATIONS_LABEL, new BorderLayout());
        mainPanel.add(new JScrollPane(applicationTree));
        this.add(mainPanel);
        this.updateView(null);
    }

    protected DefaultMutableTreeNode buildApplicationNode(Application application) {
        Object e10 = null;
        Object d10 = null;
        Object nextNode = null;
        DescriptorTreeNode applicationNode = new DescriptorTreeNode(application, true);
        Iterator itr = application.getWebBundleDescriptors().iterator();
        while (itr.hasNext()) {
            WebBundleDescriptor wbd = (WebBundleDescriptor)itr.next();
            DescriptorTreeNode webTreeNode = new DescriptorTreeNode(wbd, true);
            applicationNode.add(webTreeNode);
            this.updateWebBundleNode(webTreeNode, wbd);
        }
        Iterator itr2 = application.getEjbBundleDescriptors().iterator();
        while (itr2.hasNext()) {
            EjbBundleDescriptor ejbd = (EjbBundleDescriptor)itr2.next();
            DescriptorTreeNode ejbsTreeNode = new DescriptorTreeNode(ejbd, true);
            applicationNode.add(ejbsTreeNode);
            this.updateEjbBundleNode(ejbsTreeNode, ejbd);
        }
        Iterator itr3 = application.getApplicationClientDescriptors().iterator();
        while (itr3.hasNext()) {
            ApplicationClientDescriptor acd = (ApplicationClientDescriptor)itr3.next();
            DescriptorTreeNode acdTreeNode = new DescriptorTreeNode(acd, true);
            applicationNode.add(acdTreeNode);
        }
        return applicationNode;
    }

    public void buildView(ApplicationManager applicationManager) {
        this.applicationTree.setModel(new DefaultTreeModel(this.createRoot(applicationManager, ALL)));
        TreeSelectionModel selectionModel = this.applicationTree.getSelectionModel();
        selectionModel.setSelectionMode(1);
        this.applicationTree.setSelectionModel(selectionModel);
        this.validate();
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    protected TreeNode createRoot(ApplicationManager applicationManager, String type) {
        DefaultMutableTreeNode root = new DefaultMutableTreeNode(localStrings.getLocalString("applicationview.create_root_root", "Applications"), true);
        DefaultTreeModel treeModel = new DefaultTreeModel(root);
        if (applicationManager != null) {
            Enumeration e10 = applicationManager.getApplications().elements();
            while (e10.hasMoreElements()) {
                Application nextApplication = (Application)e10.nextElement();
                DescriptorTreeNode applicationNode = new DescriptorTreeNode(nextApplication, true);
                this.updateApplicationBranch(applicationNode, nextApplication, type);
                root.add(applicationNode);
            }
        }
        return root;
    }

    private boolean doNodesContainUserObject(Set defaultMutableTreeNodes, Object userObject) {
        return this.findNodeForUserObject(defaultMutableTreeNodes, userObject) != null;
    }

    public void expandApplication(Application application) {
        TreePath tp;
        if (application != null && (tp = this.getTreePathFor(application)) != null) {
            this.applicationTree.expandPath(tp);
        }
    }

    public void expandCurrentApplicationAction() {
    }

    private DefaultMutableTreeNode findNodeForUserObject(Set defaultMutableTreeNodes, Object userObject) {
        Iterator itr = defaultMutableTreeNodes.iterator();
        while (itr.hasNext()) {
            DefaultMutableTreeNode next = (DefaultMutableTreeNode)itr.next();
            if (!userObject.equals(next.getUserObject())) continue;
            return next;
        }
        return null;
    }

    public Application getApplicationFor(TreePath tp) {
        DefaultMutableTreeNode dmtn;
        if (tp.getPathCount() > 1 && (dmtn = (DefaultMutableTreeNode)tp.getPathComponent(1)).getUserObject() instanceof Application) {
            return (Application)dmtn.getUserObject();
        }
        return null;
    }

    private DefaultMutableTreeNode getApplicationNodeFor(Application a) {
        DefaultTreeModel dtm = (DefaultTreeModel)this.applicationTree.getModel();
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)dtm.getRoot();
        Object applicationNode = null;
        Enumeration<TreeNode> e10 = root.children();
        while (e10.hasMoreElements()) {
            DefaultMutableTreeNode tn = (DefaultMutableTreeNode)e10.nextElement();
            if (tn.getUserObject() != a) continue;
            return tn;
        }
        return null;
    }

    private Set getChildUserObjectsAsSet(TreeNode tn) {
        HashSet<Object> s2 = new HashSet<Object>();
        Enumeration<? extends TreeNode> e10 = tn.children();
        while (e10.hasMoreElements()) {
            s2.add(((DefaultMutableTreeNode)e10.nextElement()).getUserObject());
        }
        return s2;
    }

    private DefaultMutableTreeNode getFirstSubNodeFor(DefaultMutableTreeNode tn, Class type) {
        Enumeration<TreeNode> e10 = tn.children();
        while (e10.hasMoreElements()) {
            DefaultMutableTreeNode next = (DefaultMutableTreeNode)e10.nextElement();
            if (!type.isInstance(next.getUserObject())) continue;
            return next;
        }
        return null;
    }

    public static ImageIcon getIconForDescriptor(Object descriptor) {
        ImageIcon icon = null;
        if (descriptor instanceof Application) {
            icon = UIUtils.getImageIconFor(UIUtils.APPLICATION_ICON);
        }
        if (descriptor instanceof EjbBundleDescriptor) {
            icon = UIUtils.getImageIconFor(UIUtils.EJB_BUNDLE_ICON);
        }
        if (descriptor instanceof WebBundleDescriptor) {
            icon = UIUtils.getImageIconFor(UIUtils.WEB_BUNDLE_ICON);
        }
        if (descriptor instanceof EjbDescriptor) {
            icon = UIUtils.getImageIconFor(UIUtils.EJB_ICON);
        }
        if (descriptor instanceof JspDescriptorImpl) {
            icon = UIUtils.getImageIconFor(UIUtils.JSP_ICON);
        }
        if (descriptor instanceof ServletDescriptorImpl) {
            icon = UIUtils.getImageIconFor(UIUtils.SERVLET_ICON);
        }
        if (descriptor instanceof ApplicationClientDescriptor) {
            icon = UIUtils.getImageIconFor(UIUtils.APPLICATION_CLIENT_ICON);
        }
        if (icon == null) {
            icon = UIUtils.getImageIconFor(UIUtils.DEFAULT_ICON);
        }
        return icon;
    }

    public Application getSelectedApplication(Descriptor descriptor) {
        if (descriptor instanceof Application) {
            return (Application)descriptor;
        }
        BundleDescriptor bd2 = null;
        if (descriptor instanceof BundleDescriptor) {
            bd2 = (BundleDescriptor)descriptor;
        } else if (descriptor instanceof EjbDescriptor) {
            bd2 = ((EjbDescriptor)descriptor).getEjbBundleDescriptor();
        } else if (descriptor instanceof WebComponentDescriptorImpl) {
            bd2 = ((WebComponentDescriptorImpl)descriptor).getWebBundleDescriptor();
        }
        if (bd2 != null) {
            return bd2.getApplication();
        }
        return null;
    }

    public Descriptor getSelectedDescriptor() {
        Descriptor descriptor = null;
        TreePath selection = this.applicationTree.getSelectionPath();
        if (selection != null) {
            Object[] elements = selection.getPath();
            DefaultMutableTreeNode tn = (DefaultMutableTreeNode)elements[elements.length - 1];
            descriptor = (Descriptor)tn.getUserObject();
        }
        return descriptor;
    }

    public Descriptor getSelectedSavebleDescriptor() {
        Descriptor d10 = this.getSelectedDescriptor();
        if (d10 instanceof Application || d10 instanceof BundleDescriptor) {
            return d10;
        }
        if (d10 instanceof EjbDescriptor) {
            return ((EjbDescriptor)d10).getEjbBundleDescriptor();
        }
        if (d10 instanceof WebComponentDescriptorImpl) {
            return ((WebComponentDescriptorImpl)d10).getWebBundleDescriptor();
        }
        return null;
    }

    public String getSelectionAsString() {
        String selectionAsString = "";
        TreePath selection = this.applicationTree.getSelectionPath();
        if (selection == null) {
            return "";
        }
        Object[] elements = selection.getPath();
        if (elements.length > 0) {
            int i2 = 1;
            while (i2 < elements.length) {
                selectionAsString = i2 > 1 ? String.valueOf(selectionAsString) + "." + elements[i2] : String.valueOf(String.valueOf(elements[i2]));
                ++i2;
            }
        } else {
            selectionAsString = "";
        }
        return selectionAsString;
    }

    private Set getSubNodesFor(DefaultMutableTreeNode tn, Class type) {
        HashSet<DefaultMutableTreeNode> subNodes = new HashSet<DefaultMutableTreeNode>();
        Enumeration<TreeNode> e10 = tn.children();
        while (e10.hasMoreElements()) {
            DefaultMutableTreeNode next = (DefaultMutableTreeNode)e10.nextElement();
            if (!type.isInstance(next.getUserObject())) continue;
            subNodes.add(next);
        }
        return subNodes;
    }

    public TreeCombo getTreeCombo(String type) {
        DefaultTreeModel dtm;
        if (this.treeCombo == null) {
            dtm = new DefaultTreeModel(new DefaultMutableTreeNode(localStrings.getLocalString("applicationview.tree_combo_node", "Danny")));
            this.treeCombo = new TreeCombo(dtm);
        }
        dtm = new DefaultTreeModel(this.createRoot(this.applicationManager, type));
        this.treeCombo.setModel(dtm);
        return this.treeCombo;
    }

    public TreePath getTreePathFor(Application application) {
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)this.applicationTree.getModel().getRoot();
        Object[] pathArray = new Object[2];
        pathArray[0] = root;
        int i2 = 0;
        while (i2 < root.getChildCount()) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.applicationTree.getModel().getChild(root, i2);
            if (node.getUserObject() == application) {
                pathArray[1] = node;
            }
            ++i2;
        }
        return new TreePath(pathArray);
    }

    private void initializeDnd(FileDropRecipient fileDropRecipient) {
        FileDropTarget dt2 = new FileDropTarget(this.applicationTree, fileDropRecipient);
        this.setDropTarget(dt2);
        dt2.setComponent(this.applicationTree);
    }

    public synchronized void notification(NotificationEvent ne) {
        if (ne.getSource() instanceof ApplicationManager) {
            if (ApplicationManager.LISTENER_ADDED.equals(ne.getType())) {
                if (this.applicationManager == null) {
                    this.buildView((ApplicationManager)ne.getSource());
                    this.applicationManager = (ApplicationManager)ne.getSource();
                    return;
                }
                return;
            }
            this.applicationManager = (ApplicationManager)ne.getSource();
            if (ApplicationManager.APPLICATION_ADDED.equals(ne.getType())) {
                this.updateForAdd((Application)ne.getValue(ApplicationManager.APPLICATION_PROPERTY));
                return;
            }
            if (ApplicationManager.ACTIVE_CHANGED.equals(ne.getType())) {
                this.updateForActive((Application)ne.getValue(ApplicationManager.APPLICATION_PROPERTY));
                return;
            }
            if (ApplicationManager.APPLICATION_REMOVED.equals(ne.getType())) {
                this.updateForRemove((Application)ne.getValue(ApplicationManager.APPLICATION_PROPERTY));
                return;
            }
            if (ApplicationManager.APPLICATION_LIST_CHANGED.equals(ne.getType())) {
                this.buildView((ApplicationManager)ne.getSource());
                return;
            }
            if (Descriptor.DESCRIPTOR_CHANGED.equals(ne.getType())) {
                this.updateForChange((Application)ne.getObjectThatChanged());
                return;
            }
            this.buildView((ApplicationManager)ne.getSource());
            return;
        }
    }

    public String toString() {
        return localStrings.getLocalString("applicationview.application_view_name", "Application view");
    }

    protected void updateApplicationBranch(DefaultMutableTreeNode applicationNode, Application application, String type) {
        Iterator itr;
        Object e10 = null;
        Descriptor d10 = null;
        DescriptorTreeNode nextNode = null;
        applicationNode.removeAllChildren();
        if (APPS_ONLY.equals(type)) {
            return;
        }
        if (!APPS_AND_WARS.equals(type)) {
            itr = application.getEjbBundleDescriptors().iterator();
            while (itr.hasNext()) {
                d10 = (Descriptor)itr.next();
                nextNode = new DescriptorTreeNode(d10, true);
                applicationNode.add(nextNode);
                if (APPS_AND_EJB_JARS.equals(type)) continue;
                Iterator ejbs = ((EjbBundleDescriptor)d10).getEjbs().iterator();
                while (ejbs.hasNext()) {
                    d10 = (Descriptor)ejbs.next();
                    nextNode.add(new DescriptorTreeNode(d10, false));
                }
            }
        }
        if (!APPS_AND_EJB_JARS.equals(type)) {
            itr = application.getWebBundleDescriptors().iterator();
            while (itr.hasNext()) {
                WebBundleDescriptor wbd = (WebBundleDescriptor)itr.next();
                DescriptorTreeNode webTreeNode = new DescriptorTreeNode(wbd, true);
                applicationNode.add(webTreeNode);
                if (APPS_AND_WARS.equals(type)) continue;
                Iterator webComponentItr = null;
                webComponentItr = wbd.getServletDescriptors().iterator();
                while (webComponentItr.hasNext()) {
                    d10 = (Descriptor)webComponentItr.next();
                    nextNode = new DescriptorTreeNode(d10, false);
                    webTreeNode.add(nextNode);
                }
                webComponentItr = wbd.getJspDescriptors().iterator();
                while (webComponentItr.hasNext()) {
                    d10 = (Descriptor)webComponentItr.next();
                    nextNode = new DescriptorTreeNode(d10, false);
                    webTreeNode.add(nextNode);
                }
            }
        }
        if (!APPS_AND_EJB_JARS.equals(type) && !APPS_AND_WARS.equals(type)) {
            itr = application.getApplicationClientDescriptors().iterator();
            while (itr.hasNext()) {
                ApplicationClientDescriptor acd = (ApplicationClientDescriptor)itr.next();
                DescriptorTreeNode acdTreeNode = new DescriptorTreeNode(acd, true);
                applicationNode.add(acdTreeNode);
            }
        }
    }

    protected void updateBundleNode(DefaultMutableTreeNode tn, Set bundleDescriptors) {
        if (tn != null) {
            Vector<DefaultMutableTreeNode> childrenToRemove = new Vector<DefaultMutableTreeNode>();
            Vector<DescriptorTreeNode> childrenToAdd = new Vector<DescriptorTreeNode>();
            Enumeration<TreeNode> e10 = tn.children();
            while (e10.hasMoreElements()) {
                DefaultMutableTreeNode next = (DefaultMutableTreeNode)e10.nextElement();
                if (bundleDescriptors.contains(next.getUserObject())) continue;
                childrenToRemove.addElement(next);
            }
            Iterator itr = bundleDescriptors.iterator();
            while (itr.hasNext()) {
                Descriptor d10 = (Descriptor)itr.next();
                if (this.getChildUserObjectsAsSet(tn).contains(d10)) continue;
                childrenToAdd.addElement(new DescriptorTreeNode(d10, false));
            }
            DefaultTreeModel treeModel = (DefaultTreeModel)this.applicationTree.getModel();
            Enumeration e11 = childrenToRemove.elements();
            while (e11.hasMoreElements()) {
                treeModel.removeNodeFromParent((DefaultMutableTreeNode)e11.nextElement());
            }
            Enumeration e12 = childrenToAdd.elements();
            while (e12.hasMoreElements()) {
                treeModel.insertNodeInto((DefaultMutableTreeNode)e12.nextElement(), tn, 0);
            }
        }
    }

    protected void updateEjbBundleNode(DefaultMutableTreeNode tn, EjbBundleDescriptor ejbd) {
        this.updateBundleNode(tn, ejbd.getEjbs());
    }

    public void updateForActive(Application application) {
    }

    public void updateForAdd(Application a) {
        DefaultMutableTreeNode applicationNode = this.buildApplicationNode(a);
        DefaultTreeModel dtm = (DefaultTreeModel)this.applicationTree.getModel();
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)dtm.getRoot();
        dtm.insertNodeInto(applicationNode, root, root.getChildCount());
        this.applicationTree.expandPath(new TreePath(root));
        TreePath tp = this.getTreePathFor(a);
        this.applicationTree.expandPath(tp);
        this.applicationTree.validate();
    }

    public void updateForChange(Application applicationThatChanged) {
        DefaultTreeModel treeModel = (DefaultTreeModel)this.applicationTree.getModel();
        DefaultMutableTreeNode applicationNode = this.getApplicationNodeFor(applicationThatChanged);
        if (applicationNode == null) {
            return;
        }
        Set bundleDescriptorNodesInTree = this.getSubNodesFor(applicationNode, class$com$sun$enterprise$deployment$BundleDescriptor != null ? class$com$sun$enterprise$deployment$BundleDescriptor : (class$com$sun$enterprise$deployment$BundleDescriptor = ApplicationView.class$("com.sun.enterprise.deployment.BundleDescriptor")));
        HashSet bundleDescriptorsInModel = new HashSet();
        bundleDescriptorsInModel.addAll(applicationThatChanged.getEjbBundleDescriptors());
        bundleDescriptorsInModel.addAll(applicationThatChanged.getWebBundleDescriptors());
        bundleDescriptorsInModel.addAll(applicationThatChanged.getApplicationClientDescriptors());
        Iterator itr = bundleDescriptorNodesInTree.iterator();
        while (itr.hasNext()) {
            DefaultMutableTreeNode inTreeEjbBundleNode = (DefaultMutableTreeNode)itr.next();
            if (bundleDescriptorsInModel.contains(inTreeEjbBundleNode.getUserObject())) continue;
            treeModel.removeNodeFromParent(inTreeEjbBundleNode);
            treeModel.nodeStructureChanged(applicationNode);
        }
        Iterator itr2 = bundleDescriptorsInModel.iterator();
        while (itr2.hasNext()) {
            BundleDescriptor bundleDescriptor = (BundleDescriptor)itr2.next();
            DefaultMutableTreeNode bundleNode = null;
            if (!this.doNodesContainUserObject(bundleDescriptorNodesInTree, bundleDescriptor)) {
                bundleNode = new DescriptorTreeNode(bundleDescriptor, true);
                treeModel.insertNodeInto(bundleNode, applicationNode, 0);
                treeModel.nodeStructureChanged(applicationNode);
            } else {
                bundleNode = this.findNodeForUserObject(bundleDescriptorNodesInTree, bundleDescriptor);
            }
            if (bundleDescriptor instanceof EjbBundleDescriptor) {
                this.updateEjbBundleNode(bundleNode, (EjbBundleDescriptor)bundleDescriptor);
            }
            if (!(bundleDescriptor instanceof WebBundleDescriptor)) continue;
            this.updateWebBundleNode(bundleNode, (WebBundleDescriptor)bundleDescriptor);
        }
        this.applicationTree.repaint();
        this.validate();
    }

    public void updateForRemove(Application a) {
        DefaultTreeModel dtm = (DefaultTreeModel)this.applicationTree.getModel();
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)dtm.getRoot();
        Enumeration<TreeNode> e10 = root.children();
        while (e10.hasMoreElements()) {
            DefaultMutableTreeNode tn = (DefaultMutableTreeNode)e10.nextElement();
            if (tn.getUserObject() != a) continue;
            dtm.removeNodeFromParent(tn);
        }
    }

    public void updateView(ApplicationManager applicationManager) {
        this.buildView(applicationManager);
    }

    protected void updateWebBundleNode(DefaultMutableTreeNode tn, WebBundleDescriptor wbd) {
        HashSet webComponentDescriptors = new HashSet();
        Enumeration ee2 = wbd.getWebComponentDescriptors();
        while (ee2.hasMoreElements()) {
            webComponentDescriptors.add(ee2.nextElement());
        }
        this.updateBundleNode(tn, webComponentDescriptors);
    }

    class DescriptorTreeNode
    extends DefaultMutableTreeNode {
        DescriptorTreeNode(Descriptor descriptor, boolean hasChildren) {
            super(descriptor, hasChildren);
        }

        public String toString() {
            return ((Descriptor)super.getUserObject()).getName();
        }
    }
}

