/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.deployment.ui;

import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.tools.deployment.ui.Inspector;
import com.sun.enterprise.tools.deployment.ui.InspectorTable;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Vector;
import javax.help.CSH;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;

public class ApplicationWebContextInspector
extends JPanel
implements Inspector {
    private static String helpSetMapID = "AIWebContext";
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(class$com$sun$enterprise$tools$deployment$ui$ApplicationWebContextInspector != null ? class$com$sun$enterprise$tools$deployment$ui$ApplicationWebContextInspector : (class$com$sun$enterprise$tools$deployment$ui$ApplicationWebContextInspector = ApplicationWebContextInspector.class$("com.sun.enterprise.tools.deployment.ui.ApplicationWebContextInspector")));
    Application descriptor;
    JPanel pnlWest = new JPanel();
    DefaultTableModel tableModel;
    InspectorTable table;
    WebContextTableModel webContextTableModel;
    WebContextTable webContextTable;
    JScrollPane scrlTable;
    BorderLayout borderLayout1 = new BorderLayout();
    BorderLayout borderLayout2 = new BorderLayout();
    final String[] columnNames = new String[]{localStrings.getLocalString("applicationwebcontextinspector.war_file", ".WAR File"), localStrings.getLocalString("applicationwebcontextinspector.context_root", "Context Root")};
    static /* synthetic */ Class class$com$sun$enterprise$tools$deployment$ui$ApplicationWebContextInspector;

    public ApplicationWebContextInspector() {
        try {
            this.initializeLayout();
        }
        catch (Exception ex2) {
            ex2.printStackTrace();
        }
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    public Application getDescriptor() {
        return this.descriptor;
    }

    private void initializeLayout() throws Exception {
        CSH.setHelpIDString((Component)this, (String)helpSetMapID);
        this.setLayout(this.borderLayout1);
        this.pnlWest.setLayout(this.borderLayout2);
        this.webContextTableModel = new WebContextTableModel(this);
        this.webContextTable = new WebContextTable(this.webContextTableModel);
        this.scrlTable = new JScrollPane(this.webContextTable);
        this.add((Component)this.scrlTable, "Center");
    }

    private void refresh() {
        this.webContextTableModel = new WebContextTableModel(this);
        Enumeration webApps = new Vector(this.descriptor.getWebBundleDescriptors()).elements();
        while (webApps.hasMoreElements()) {
            WebBundleDescriptor webApp = (WebBundleDescriptor)webApps.nextElement();
            this.webContextTableModel.addRow(webApp.getName(), webApp.getContextRoot());
        }
        this.webContextTable.setModel(this.webContextTableModel);
        this.webContextTable.setAutoResizeMode(4);
        this.webContextTable.sizeColumnsToFit(0);
    }

    public void setObject(Object object) {
        if (object instanceof Application) {
            this.descriptor = (Application)object;
            this.refresh();
        }
    }

    private class WebContextTable
    extends InspectorTable {
        int selectedRow = -1;

        public WebContextTable(WebContextTableModel model) {
            super(model);
            this.setToolTipText(localStrings.getLocalString("applicationwebcontextinspector.context_param_tip", "Table of context parameters"));
            this.setSelectionMode(0);
            ListSelectionModel rowSM = this.getSelectionModel();
            rowSM.addListSelectionListener(new ListSelectionListener(this){
                private final /* synthetic */ WebContextTable this$1;
                {
                    this.this$1 = this$1;
                }

                public void valueChanged(ListSelectionEvent e10) {
                    ListSelectionModel lsm = (ListSelectionModel)e10.getSource();
                    if (!lsm.isSelectionEmpty()) {
                        WebContextTable.access$0(this.this$1, lsm.getMinSelectionIndex());
                    } else {
                        WebContextTable.access$0(this.this$1, -1);
                    }
                }
            });
        }

        static /* synthetic */ void access$0(WebContextTable $0, int $1) {
            $0.setSelectedRow($1);
        }

        private void setSelectedRow(int index) {
            Integer oldIndex = new Integer(this.selectedRow);
            this.selectedRow = index;
        }

        void setupColNameColumn() {
            TableColumn colNameColumn = this.getColumnModel().getColumn(1);
            JTextField colNameText = new JTextField();
            colNameColumn.setCellEditor(new DefaultCellEditor(colNameText));
            DefaultTableCellRenderer renderer = new DefaultTableCellRenderer();
            renderer.setToolTipText(localStrings.getLocalString("applicationwebcontextinspector.sport_tip", "Click to edit text"));
            colNameColumn.setCellRenderer(renderer);
        }

        void setupTypeColumn() {
            TableColumn typeColumn = this.getColumnModel().getColumn(2);
            JComboBox typeComboBox = new JComboBox();
            typeColumn.setCellEditor(new DefaultCellEditor(typeComboBox));
            DefaultTableCellRenderer renderer = new DefaultTableCellRenderer();
            renderer.setToolTipText(localStrings.getLocalString("applicationwebcontextinspector.other_sport_tip", "Click to edit text"));
            typeColumn.setCellRenderer(renderer);
        }
    }

    public class WebContextTableModel
    extends AbstractTableModel {
        ArrayList fields = new ArrayList();
        ApplicationWebContextInspector inspector;
        String[] columnNames = new String[]{ApplicationWebContextInspector.access$0().getLocalString("applicationwebcontextinspector.war_file", ".WAR File"), ApplicationWebContextInspector.access$0().getLocalString("applicationwebcontextinspector.context_root", "Context Root")};

        public WebContextTableModel(ApplicationWebContextInspector inspector) {
            this.inspector = inspector;
        }

        public void addRow(String warFile, String contextRoot) {
            FieldInfo field = new FieldInfo();
            field.warFile = warFile;
            field.contextRoot = contextRoot;
            this.fields.add(field);
        }

        public int getColumnCount() {
            return this.columnNames.length;
        }

        public String getColumnName(int col) {
            return this.columnNames[col].toString();
        }

        public int getRowCount() {
            return this.fields.size();
        }

        public Object getValueAt(int row, int col) {
            FieldInfo fieldInfo = (FieldInfo)this.fields.get(row);
            Object value = fieldInfo.getElement(col);
            return value;
        }

        public boolean isCellEditable(int row, int col) {
            return col >= 1;
        }

        public void setValueAt(Object value, int row, int col) {
            FieldInfo fieldInfo = (FieldInfo)this.fields.get(row);
            fieldInfo.setElement(col, value);
            Enumeration webApps = new Vector(this.inspector.getDescriptor().getWebBundleDescriptors()).elements();
            WebBundleDescriptor webApp = null;
            int index = 0;
            while (index <= row) {
                webApp = (WebBundleDescriptor)webApps.nextElement();
                ++index;
            }
            switch (col) {
                case 1: {
                    webApp.setContextRoot((String)fieldInfo.getElement(col));
                    break;
                }
            }
        }

        private class FieldInfo {
            String warFile;
            String contextRoot;

            FieldInfo() {
            }

            Object getElement(int col) {
                String elem = null;
                switch (col) {
                    case 0: {
                        elem = this.warFile;
                        break;
                    }
                    case 1: {
                        elem = this.contextRoot;
                        break;
                    }
                }
                return elem;
            }

            void setElement(int col, Object elem) {
                switch (col) {
                    case 0: {
                        this.warFile = elem.toString();
                        break;
                    }
                    case 1: {
                        this.contextRoot = elem.toString();
                        break;
                    }
                }
            }
        }
    }
}

