/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.deployment.ui;

import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.ApplicationArchivist;
import com.sun.enterprise.deployment.ApplicationClientArchivist;
import com.sun.enterprise.deployment.ApplicationClientDescriptor;
import com.sun.enterprise.deployment.BundleDescriptor;
import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.EjbBundleArchivist;
import com.sun.enterprise.deployment.EjbBundleDescriptor;
import com.sun.enterprise.deployment.WebBundleArchivist;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.tools.deployment.backend.DeploymentSessionImpl;
import com.sun.enterprise.tools.deployment.main.ApplicationManager;
import com.sun.enterprise.tools.deployment.main.DeployTool;
import com.sun.enterprise.tools.deployment.main.Log;
import com.sun.enterprise.tools.deployment.main.ServerException;
import com.sun.enterprise.tools.deployment.main.ServerManager;
import com.sun.enterprise.tools.deployment.ui.AboutDialog;
import com.sun.enterprise.tools.deployment.ui.ApplicationInspector;
import com.sun.enterprise.tools.deployment.ui.ApplicationView;
import com.sun.enterprise.tools.deployment.ui.CopiableInspector;
import com.sun.enterprise.tools.deployment.ui.DeployToolActions;
import com.sun.enterprise.tools.deployment.ui.DeployToolWindow;
import com.sun.enterprise.tools.deployment.ui.DeployToolWindowController;
import com.sun.enterprise.tools.deployment.ui.DeploytoolWindowResizer;
import com.sun.enterprise.tools.deployment.ui.FileDropRecipient;
import com.sun.enterprise.tools.deployment.ui.Inspector;
import com.sun.enterprise.tools.deployment.ui.InspectorManager;
import com.sun.enterprise.tools.deployment.ui.NewAppClientWizard;
import com.sun.enterprise.tools.deployment.ui.NewAppDialog;
import com.sun.enterprise.tools.deployment.ui.NewEjbWizard;
import com.sun.enterprise.tools.deployment.ui.NewWebComponentWizard;
import com.sun.enterprise.tools.deployment.ui.PreDeploymentWizard;
import com.sun.enterprise.tools.deployment.ui.ProgressPanel;
import com.sun.enterprise.tools.deployment.ui.ServerInspector;
import com.sun.enterprise.tools.deployment.ui.ServerView;
import com.sun.enterprise.tools.deployment.ui.TreeCombo;
import com.sun.enterprise.tools.deployment.ui.UIUtils;
import com.sun.enterprise.tools.deployment.ui.descriptor.AppClientInspector;
import com.sun.enterprise.tools.deployment.ui.descriptor.EjbComponentInspector;
import com.sun.enterprise.tools.deployment.ui.descriptor.EjbJarInspector;
import com.sun.enterprise.tools.deployment.ui.descriptor.WebAppInspector;
import com.sun.enterprise.tools.deployment.ui.descriptor.WebComponentInspector;
import com.sun.enterprise.tools.verifier.gui.MainFrame;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.util.NotificationEvent;
import com.sun.enterprise.util.NotificationListener;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Set;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.text.JTextComponent;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;

public class DeployToolWindow
extends JFrame {
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(class$com$sun$enterprise$tools$deployment$ui$DeployToolWindow != null ? class$com$sun$enterprise$tools$deployment$ui$DeployToolWindow : (class$com$sun$enterprise$tools$deployment$ui$DeployToolWindow = DeployToolWindow.class$("com.sun.enterprise.tools.deployment.ui.DeployToolWindow")));
    File clientCodeFile = null;
    private static String TITLE = localStrings.getLocalString("deploytoolwindow.title", "Application Deployment Tool");
    private static String INSPECTING_LABEL = localStrings.getLocalString("deploytoolwindow.inspecting_label", "Inspecting: ");
    private static String ADD_SERVER_LABEL = localStrings.getLocalString("deploytoolwindow.add_server_label", "Please enter the name of the server to add");
    private static String ADD_SERVER_TITLE = localStrings.getLocalString("deploytoolwindow.add_server_title", "Add Server");
    private static String ROLES_PRINCIPALS_LABEL = localStrings.getLocalString("deploytoolwindow.roles_principals_label", "Role Mapping Editor");
    private static String RESOURCE_IDENTITIES_LABEL = localStrings.getLocalString("deploytoolwindow.resource_identities_label", "Resource Identities Inspector");
    DeployToolWindowController controller;
    private InspectorManager applicationInspectorManager;
    private ApplicationView applicationView;
    private JComponent workspacePanel;
    JPanel applicationInspectorPlace = new JPanel();
    JLabel inspectingLabel;
    ServerInspector serverInspector;
    private JFileChooser jfc;
    private File clipboard = new File(localStrings.getLocalString("deploytoolwindow.clipboard", "clipboard"));
    static /* synthetic */ Class class$com$sun$enterprise$tools$deployment$ui$DeployToolWindow;
    static /* synthetic */ Class class$com$sun$enterprise$deployment$Application;
    static /* synthetic */ Class class$com$sun$enterprise$deployment$WebBundleDescriptor;
    static /* synthetic */ Class class$com$sun$enterprise$deployment$JspDescriptorImpl;
    static /* synthetic */ Class class$com$sun$enterprise$deployment$ServletDescriptorImpl;
    static /* synthetic */ Class class$com$sun$enterprise$deployment$EjbBundleDescriptor;
    static /* synthetic */ Class class$com$sun$enterprise$deployment$EjbEntityDescriptor;
    static /* synthetic */ Class class$com$sun$enterprise$deployment$EjbSessionDescriptor;
    static /* synthetic */ Class class$com$sun$enterprise$deployment$ApplicationClientDescriptor;

    public DeployToolWindow(DeployToolWindowController controller) {
        long start = System.currentTimeMillis();
        this.controller = controller;
        this.getApplicationInspectorManager();
        this.doRestorations();
        this.registerForTitleUpdates();
        DeployToolActions actions = new DeployToolActions(this);
        this.setJMenuBar(actions.createMenuBar());
        Rectangle screenRectangle = new Rectangle(new Point(0, 0), Toolkit.getDefaultToolkit().getScreenSize());
        Rectangle centerScreen = UIUtils.getCenterRectangleFrom(screenRectangle, 0.6, 0.7);
        JSplitPane splitPane = this.initializeContents();
        this.getContentPane().add("North", actions.createToolBar());
        ((Component)this).setBounds((int)centerScreen.getX(), (int)centerScreen.getY(), (int)centerScreen.getWidth(), (int)centerScreen.getHeight());
        UIUtils.hideSplashPanel();
        ((Component)this).setVisible(true);
        splitPane.setDividerLocation(this.getBounds().height - 180);
        splitPane.addComponentListener(new DeploytoolWindowResizer(splitPane));
        this.jfc = UIUtils.getFileChooser();
        this.initializeWindowClosing();
    }

    static /* synthetic */ String access$3() {
        return ADD_SERVER_TITLE;
    }

    static /* synthetic */ String access$4() {
        return ADD_SERVER_LABEL;
    }

    private void addApplicationClient(File jarFile, Set libraryJars, Application application) {
        try {
            if (!ApplicationClientArchivist.isApplicationClientJar(jarFile)) {
                JOptionPane.showMessageDialog(this, String.valueOf(jarFile.getName()) + localStrings.getLocalString("deploytoolwindow.not_valid_app_client", " does not appear to be a valid Application Client JAR"));
                return;
            }
            Application app = this.getDeployTool().getApplicationManager().getActiveApplication();
            application.getApplicationArchivist().addApplicationClientJar(jarFile, libraryJars);
            this.getApplicationView().expandApplication(application);
        }
        catch (Exception ioe) {
            this.showErrorAddingDialog();
            ioe.printStackTrace();
        }
    }

    public void addApplicationClientAction() {
        if (this.getDeployTool().getApplicationManager().getActiveApplication() != null) {
            this.jfc.setFileSelectionMode(0);
            int returnValue = this.jfc.showDialog(this, localStrings.getLocalString("deploytoolwindow.select_app_client_jar", "Select Application Client JAR"));
            if (returnValue == 0) {
                File jarFile = this.jfc.getSelectedFile();
                this.addApplicationClient(jarFile, new HashSet(), this.getDeployTool().getApplicationManager().getActiveApplication());
            }
        } else {
            this.selectApplicationDialog();
        }
    }

    private void addEjbJar(File ejbJarFile, Set libraryFiles, Descriptor descriptor) {
        try {
            if (!EjbBundleArchivist.isEjbBundle(ejbJarFile)) {
                JOptionPane.showMessageDialog(this, String.valueOf(ejbJarFile.getName()) + localStrings.getLocalString("deploytoolwindow.not_valid_ejb_jar", " does not appear to be a valid EJB JAR"));
                return;
            }
            if (descriptor != null) {
                if (descriptor instanceof Application) {
                    ((Application)descriptor).addEjbJarFile(ejbJarFile, libraryFiles);
                } else if (descriptor instanceof EjbBundleDescriptor) {
                    EjbBundleDescriptor bd2 = (EjbBundleDescriptor)descriptor;
                    bd2.getApplication().getApplicationArchivist().addEjbJarToEjbJar(ejbJarFile, libraryFiles, bd2);
                } else {
                    JOptionPane.showMessageDialog(this, localStrings.getLocalString("deploytoolwindow.select_app_or_ejb_jar", "Please select either an application or an ejb JAR"));
                }
            }
            this.getApplicationView().expandApplication(this.getApplicationView().getSelectedApplication(descriptor));
        }
        catch (Throwable ioe) {
            this.showErrorAddingDialog();
            ioe.printStackTrace();
        }
    }

    public void addEjbJarAction() {
        if (this.getDeployTool().getApplicationManager().getActiveApplication() != null) {
            this.jfc.setFileSelectionMode(0);
            int returnValue = this.jfc.showDialog(this, localStrings.getLocalString("deploytoolwindow.open_ejb_jar", "Open EJB JAR"));
            if (returnValue == 0) {
                File ejbJarFile = this.jfc.getSelectedFile();
                this.addEjbJar(ejbJarFile, new HashSet(), this.getDeployTool().getApplicationManager().getActiveApplication());
            }
        } else {
            this.selectApplicationDialog();
        }
    }

    public void addServerAction() {
        class AddServerDialog
        extends JDialog {
            JTextField serverNameTextField;
            ServerManager serverManager;
            Frame owner;

            AddServerDialog(Frame owner, ServerManager serverManager) {
                super(owner, true);
                this.serverNameTextField = new JTextField(20);
                super.setTitle(DeployToolWindow.access$3());
                this.owner = owner;
                super.dialogInit();
                this.serverManager = serverManager;
                JButton connectButton = new JButton(DeployToolWindow.access$1().getLocalString("deploytoolwindow.button_connect", "Connect"));
                connectButton.addActionListener(new ActionListener(this){
                    private final /* synthetic */ AddServerDialog this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void actionPerformed(ActionEvent ae2) {
                        this.this$1.connectAction();
                    }
                });
                JButton cancelButton = new JButton(DeployToolWindow.access$1().getLocalString("deploytoolwindow.button_cancel", "Cancel"));
                cancelButton.addActionListener(new ActionListener(this){
                    private final /* synthetic */ AddServerDialog this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void actionPerformed(ActionEvent ae2) {
                        ((Component)this.this$1).setVisible(false);
                    }
                });
                JLabel label = new JLabel(DeployToolWindow.access$4());
                ((JPanel)this.getContentPane()).setBorder(new EmptyBorder(new Insets(8, 8, 8, 8)));
                JPanel buttonsPanel = new JPanel();
                buttonsPanel.add(cancelButton);
                buttonsPanel.add(connectButton);
                this.getContentPane().setLayout(new BorderLayout());
                this.getContentPane().add("North", label);
                this.getContentPane().add("Center", this.serverNameTextField);
                this.getContentPane().add("South", buttonsPanel);
                this.pack();
                int x2 = owner.getBounds().x + super.getBounds().width / 4;
                int y2 = owner.getBounds().y + super.getBounds().height / 4;
                int width = owner.getBounds().width / 2;
                int height = owner.getBounds().height / 2;
                ((Component)this).setBounds(x2, y2, super.getBounds().width, super.getBounds().height);
            }

            void connectAction() {
                try {
                    if ("".equals(this.serverNameTextField.getText())) {
                        JOptionPane.showMessageDialog(this.owner, DeployToolWindow.access$1().getLocalString("deploytoolwindow.supply_a_server_name", "Please supply the name of the host running the J2EE server"));
                    } else {
                        this.serverManager.addServer(this.serverNameTextField.getText());
                        ((Component)this).setVisible(false);
                    }
                }
                catch (Exception exception) {
                    JOptionPane.showMessageDialog(this.owner, String.valueOf(DeployToolWindow.access$1().getLocalString("deploytoolwindow.could_not_connect", "Could not connect to ")) + this.serverNameTextField.getText() + DeployToolWindow.access$1().getLocalString("deploytoolwindow.contact_server_admin", ".\nPlease consult your server administrator."));
                }
            }
        }
        AddServerDialog addServerDialog = new AddServerDialog((Frame)this, this.getDeployTool().getServerManager());
        addServerDialog.show();
    }

    private void addWebComponent(File webFile, Descriptor descriptor) {
        try {
            if (!WebBundleArchivist.isWebBundle(webFile)) {
                JOptionPane.showMessageDialog(this, String.valueOf(webFile.getName()) + localStrings.getLocalString("deploytoolwindow.not_valid_web_war", " does not appear to be a valid web JAR"));
                return;
            }
            if (descriptor != null) {
                if (descriptor instanceof Application) {
                    ((Application)descriptor).addWebJarFile(webFile);
                } else if (descriptor instanceof WebBundleDescriptor) {
                    WebBundleDescriptor bd2 = (WebBundleDescriptor)descriptor;
                    bd2.getApplication().getApplicationArchivist().addWebJarToWebJar(webFile, bd2);
                } else {
                    JOptionPane.showMessageDialog(this, localStrings.getLocalString("deploytoolwindow.select_app_or_web_war", "Please select either an application or an web WAR"));
                }
            }
            this.getApplicationView().expandApplication(this.getApplicationView().getSelectedApplication(descriptor));
        }
        catch (Exception ioe) {
            this.showErrorAddingDialog();
            ioe.printStackTrace();
        }
    }

    public void addWebComponentAction() {
        if (this.getDeployTool().getApplicationManager().getActiveApplication() != null) {
            this.jfc.setFileSelectionMode(0);
            int returnValue = this.jfc.showDialog(this, localStrings.getLocalString("deploytoolwindow.open_web_war", "Open Web WAR"));
            if (returnValue == 0) {
                File webJarFile = this.jfc.getSelectedFile();
                this.addWebComponent(webJarFile, this.getDeployTool().getApplicationManager().getActiveApplication());
            }
        } else {
            this.selectApplicationDialog();
        }
    }

    int checkSave(String applicationName) {
        return JOptionPane.showConfirmDialog(this, String.valueOf(applicationName) + localStrings.getLocalString("deploytoolwindow.has_unsaved_changes", " has unsaved changes. Save before closing ?"), localStrings.getLocalString("deploytoolwindow.confirm", "Confirm"), 1, 3);
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    public void cloneInspectorAction() {
        JComponent currentInspector = this.applicationInspectorManager.getCurrentInspector();
        if (currentInspector != null && currentInspector instanceof CopiableInspector) {
            Point screenLocation = currentInspector.getLocationOnScreen();
            JComponent copy = (JComponent)((Object)((CopiableInspector)((Object)currentInspector)).makeCopy());
            JFrame frame = new JFrame();
            ((Component)frame).setBounds(screenLocation.x + 10, screenLocation.y + 10, currentInspector.getBounds().width, currentInspector.getBounds().height);
            ((Component)frame).setVisible(true);
            frame.setTitle(String.valueOf(INSPECTING_LABEL) + this.getApplicationView().getSelectionAsString());
            frame.getContentPane().setLayout(new BorderLayout());
            UIUtils.addComponentToPanelWorkaround(copy, frame.getContentPane());
            if (currentInspector instanceof NotificationListener) {
                this.getDeployTool().getApplicationManager().addNotificationListener((NotificationListener)((Object)copy));
            }
        }
    }

    public void closeAction() {
        ApplicationManager applicationManager = this.getDeployTool().getApplicationManager();
        Application application = applicationManager.getActiveApplication();
        if (application == null) {
            JOptionPane.showMessageDialog(this, localStrings.getLocalString("deploytoolwindow.no_app_selected", "No application selected"));
            return;
        }
        this.closeAction(application, applicationManager);
    }

    private void closeAction(Application application, ApplicationManager applicationManager) {
        if (application.isDirty()) {
            int doSave = this.checkSave(application.getName());
            if (doSave == 2) {
                return;
            }
            if (doSave == 0) {
                try {
                    applicationManager.saveApplication(application);
                }
                catch (IOException ioe) {
                    Log.print(this, ioe);
                }
            }
        }
        applicationManager.closeApplication(application);
        this.refreshApplicationInspectorFor(applicationManager.getActiveApplication());
    }

    public void copyAction() {
        block9: {
            Component c10 = this.getTransferActionComponent();
            if (c10 instanceof JTextComponent) {
                ((JTextComponent)c10).grabFocus();
                ((JTextComponent)c10).copy();
                return;
            }
            if (!(c10 instanceof JTree) && c10 != null) break block9;
            try {
                Descriptor descriptor = this.applicationView.getSelectedDescriptor();
                if (descriptor == null) {
                    JOptionPane.showMessageDialog(this, localStrings.getLocalString("deploytoolwindow.nothing_to_copy", "Nothing to copy"));
                }
                if (descriptor instanceof Application) {
                    Application application = (Application)descriptor;
                    ApplicationArchivist oldArchivist = application.getApplicationArchivist();
                    File appFile = oldArchivist.getApplicationFile();
                    this.createNewClipboardFile();
                    oldArchivist.save(this.clipboard, true);
                    oldArchivist.setApplicationFile(appFile);
                    ((Application)descriptor).changed(true);
                } else if (descriptor instanceof EjbBundleDescriptor) {
                    Application application = ((BundleDescriptor)descriptor).getApplication();
                    this.createNewClipboardFile();
                    application.getApplicationArchivist().extractBundleToFile((EjbBundleDescriptor)descriptor, this.clipboard);
                } else if (descriptor instanceof WebBundleDescriptor) {
                    Application application = ((WebBundleDescriptor)descriptor).getApplication();
                    this.clipboard = this.createNewClipboardFile();
                    application.getApplicationArchivist().extractBundleToFile((WebBundleDescriptor)descriptor, this.clipboard);
                }
            }
            catch (Throwable throwable) {
                JOptionPane.showMessageDialog(this, localStrings.getLocalString("deploytoolwindow.error_while_copying", "Error while copying"));
            }
        }
    }

    private File createNewClipboardFile() throws IOException {
        if (this.clipboard.exists()) {
            this.clipboard.delete();
        }
        this.clipboard = File.createTempFile(localStrings.getLocalString("deploytoolwindow.j2ee", "J2EE"), localStrings.getLocalString("deploytoolwindow.clipboard", "clipboard"));
        this.clipboard.deleteOnExit();
        return this.clipboard;
    }

    public void cutAction() {
        this.copyAction();
        this.deleteAction();
    }

    public void deleteAction() {
        Component c10 = this.getTransferActionComponent();
        if (c10 instanceof JTextComponent) {
            ((JTextComponent)c10).cut();
            return;
        }
        if (c10 instanceof JTree || c10 == null) {
            Descriptor selectedDescriptor = this.applicationView.getSelectedDescriptor();
            if (selectedDescriptor == null) {
                JOptionPane.showMessageDialog(this, localStrings.getLocalString("deploytoolwindow.", "No object was selected"));
                return;
            }
            ApplicationManager applicationManager = this.getDeployTool().getApplicationManager();
            if (selectedDescriptor instanceof Application) {
                this.closeAction((Application)selectedDescriptor, applicationManager);
            } else if (selectedDescriptor instanceof BundleDescriptor) {
                BundleDescriptor bd2 = (BundleDescriptor)selectedDescriptor;
                try {
                    bd2.getApplication().getApplicationArchivist().removeBundleDescriptor(bd2);
                }
                catch (IOException ioe) {
                    JOptionPane.showMessageDialog(this, String.valueOf(localStrings.getLocalString("deploytoolwindow.delete_failed", "Delete failed: ")) + ioe.getMessage());
                }
            } else {
                JOptionPane.showMessageDialog(this, localStrings.getLocalString("deploytoolwindow.objects_not_delete", "Objects of this kind cannot be deleted"));
            }
        }
    }

    public void deployAction() {
        final Application application = this.getDeployTool().getApplicationManager().getActiveApplication();
        if (application == null) {
            JOptionPane.showMessageDialog(this, localStrings.getLocalString("deploytoolwindow.no_app_selected", "No application selected"));
            return;
        }
        final ServerManager serverManager = this.getDeployTool().getServerManager();
        if (serverManager.getCurrentServer() == null) {
            JOptionPane.showMessageDialog(this, localStrings.getLocalString("deploytoolwindow.connect_to_server", "Please connect to a server in order to deploy " + application.getName()));
            return;
        }
        try {
            if (serverManager.isInstalled(application.getName(), serverManager.getCurrentServer())) {
                JOptionPane.showMessageDialog(this, String.valueOf(application.getName()) + localStrings.getLocalString("deploytoolwindow.uninstall_first", " must be uninstalled before it can be re-deployed."));
                return;
            }
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(this, String.valueOf(localStrings.getLocalString("deploytoolwindow.error_communicating", "There was an error communicating with ")) + serverManager.getCurrentServer() + localStrings.getLocalString("deploytoolwindow.establish_whether", "\nto  establish whether this application was already deployed."));
            serverManager.removeServer(serverManager.getCurrentServer());
            return;
        }
        this.clientCodeFile = null;
        PreDeploymentWizard preDeploymentWizard = new PreDeploymentWizard((Frame)this, this.getDeployTool().getServerManager(), application);
        preDeploymentWizard.show();
        if (!preDeploymentWizard.didComplete()) {
            return;
        }
        this.saveApplicationAction();
        if (preDeploymentWizard.getClientFilename() != null) {
            this.clientCodeFile = new File(preDeploymentWizard.getClientFilename());
        }
        try {
            int ejbs = application.getEjbDescriptors().size();
            int webComponents = application.getWebBundleDescriptors().size();
            final ProgressPanel progressPanel = new ProgressPanel((Frame)this, ejbs, webComponents);
            final DeploymentSessionImpl session = (DeploymentSessionImpl)serverManager.createDeploymentSession(serverManager.getCurrentServer());
            session.addNotificationListener(progressPanel);
            Thread ppt = new Thread(){

                public void run() {
                    progressPanel.show();
                }
            };
            ppt.start();
            Thread deployThread = new Thread(){

                public void run() {
                    try {
                        this.getDeployTool().deploy(application, this.getDeployTool().getServerManager().getCurrentServer(), session, clientCodeFile);
                        progressPanel.done();
                    }
                    catch (ServerException se) {
                        JOptionPane.showMessageDialog(progressPanel, String.valueOf(localStrings.getLocalString("deploytoolwindow.connection_error", "There was a connection error: ")) + se.getMessage());
                        progressPanel.done();
                        serverManager.removeServer(serverManager.getCurrentServer());
                    }
                    catch (Throwable t2) {
                        JOptionPane.showMessageDialog(progressPanel, String.valueOf(localStrings.getLocalString("deploytoolwindow.deployment_error", "There was a deployment error:\n")) + t2);
                        progressPanel.done();
                    }
                }
            };
            deployThread.start();
        }
        catch (Exception e10) {
            Log.print(this, e10);
        }
    }

    public void doRestorations() {
        Throwable exception;
        Enumeration e10;
        Hashtable badRestorationsMap = null;
        try {
            badRestorationsMap = this.getDeployTool().getApplicationManager().restoreFromUserHome();
            e10 = badRestorationsMap.keys();
            while (e10.hasMoreElements()) {
                String filename = (String)e10.nextElement();
                exception = (Throwable)badRestorationsMap.get(filename);
                System.out.println(String.valueOf(localStrings.getLocalString("deploytoolwindow.could_not_reopen", "Warning: Couldn't re-open ")) + filename + exception.getMessage());
            }
        }
        catch (IOException iOException) {
            System.out.println(localStrings.getLocalString("deploytoolwindow.locating_or_corrupt", "Error locating or corrupt last known application list"));
        }
        try {
            badRestorationsMap = this.getDeployTool().getServerManager().restoreFromUserHome();
            e10 = badRestorationsMap.keys();
            while (e10.hasMoreElements()) {
                String servername = (String)e10.nextElement();
                exception = (Throwable)badRestorationsMap.get(servername);
                System.out.println(String.valueOf(localStrings.getLocalString("deploytoolwindow.could_not_reconnect", "Warning: Couldn't reconnect to ")) + servername + " " + exception.getMessage());
            }
        }
        catch (Exception exception2) {
            System.out.println(localStrings.getLocalString("deploytoolwindow.bad_server_list", "Error locating or corrupt last known server list"));
        }
        try {
            this.getDeployTool().getServerManager().addServer(ServerManager.LOCAL_HOST);
        }
        catch (Exception exception3) {}
    }

    public void exitAction() {
        try {
            this.getDeployTool().getApplicationManager().saveToUserHome();
            this.getDeployTool().getServerManager().saveToUserHome();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        System.exit(0);
    }

    public InspectorManager getApplicationInspectorManager() {
        if (this.applicationInspectorManager == null) {
            ApplicationManager am2 = this.getDeployTool().getApplicationManager();
            this.applicationInspectorManager = new InspectorManager();
            ApplicationInspector applicationInspector = new ApplicationInspector(this.getDeployTool().getServerManager());
            WebAppInspector webAppInspector = new WebAppInspector();
            WebComponentInspector webComponentInspector = new WebComponentInspector();
            AppClientInspector appClientInspector = new AppClientInspector();
            EjbJarInspector ejbJarInspector = new EjbJarInspector();
            EjbComponentInspector ejbComponentInspector = new EjbComponentInspector(this.getDeployTool().getServerManager());
            am2.addNotificationListener(applicationInspector);
            am2.addNotificationListener(ejbJarInspector);
            am2.addNotificationListener(ejbComponentInspector);
            am2.addNotificationListener(webAppInspector);
            am2.addNotificationListener(webComponentInspector);
            am2.addNotificationListener(appClientInspector);
            this.applicationInspectorManager.add(applicationInspector, class$com$sun$enterprise$deployment$Application != null ? class$com$sun$enterprise$deployment$Application : (class$com$sun$enterprise$deployment$Application = DeployToolWindow.class$("com.sun.enterprise.deployment.Application")));
            this.applicationInspectorManager.add(webAppInspector, class$com$sun$enterprise$deployment$WebBundleDescriptor != null ? class$com$sun$enterprise$deployment$WebBundleDescriptor : (class$com$sun$enterprise$deployment$WebBundleDescriptor = DeployToolWindow.class$("com.sun.enterprise.deployment.WebBundleDescriptor")));
            this.applicationInspectorManager.add(webComponentInspector, class$com$sun$enterprise$deployment$JspDescriptorImpl != null ? class$com$sun$enterprise$deployment$JspDescriptorImpl : (class$com$sun$enterprise$deployment$JspDescriptorImpl = DeployToolWindow.class$("com.sun.enterprise.deployment.JspDescriptorImpl")));
            this.applicationInspectorManager.add(webComponentInspector, class$com$sun$enterprise$deployment$ServletDescriptorImpl != null ? class$com$sun$enterprise$deployment$ServletDescriptorImpl : (class$com$sun$enterprise$deployment$ServletDescriptorImpl = DeployToolWindow.class$("com.sun.enterprise.deployment.ServletDescriptorImpl")));
            this.applicationInspectorManager.add(ejbJarInspector, class$com$sun$enterprise$deployment$EjbBundleDescriptor != null ? class$com$sun$enterprise$deployment$EjbBundleDescriptor : (class$com$sun$enterprise$deployment$EjbBundleDescriptor = DeployToolWindow.class$("com.sun.enterprise.deployment.EjbBundleDescriptor")));
            this.applicationInspectorManager.add(ejbComponentInspector, class$com$sun$enterprise$deployment$EjbEntityDescriptor != null ? class$com$sun$enterprise$deployment$EjbEntityDescriptor : (class$com$sun$enterprise$deployment$EjbEntityDescriptor = DeployToolWindow.class$("com.sun.enterprise.deployment.EjbEntityDescriptor")));
            this.applicationInspectorManager.add(ejbComponentInspector, class$com$sun$enterprise$deployment$EjbSessionDescriptor != null ? class$com$sun$enterprise$deployment$EjbSessionDescriptor : (class$com$sun$enterprise$deployment$EjbSessionDescriptor = DeployToolWindow.class$("com.sun.enterprise.deployment.EjbSessionDescriptor")));
            this.applicationInspectorManager.add(appClientInspector, class$com$sun$enterprise$deployment$ApplicationClientDescriptor != null ? class$com$sun$enterprise$deployment$ApplicationClientDescriptor : (class$com$sun$enterprise$deployment$ApplicationClientDescriptor = DeployToolWindow.class$("com.sun.enterprise.deployment.ApplicationClientDescriptor")));
        }
        return this.applicationInspectorManager;
    }

    ApplicationView getApplicationView() {
        if (this.applicationView == null) {
            final JTree tree = new JTree();
            FileDropRecipient fdr = new FileDropRecipient(){

                public void fileDropped(File f2) {
                }
            };
            final ApplicationView av2 = this.applicationView = new ApplicationView(tree, fdr);
            this.getDeployTool().getApplicationManager().addNotificationListener(this.applicationView);
            tree.addMouseListener(new MouseAdapter(){

                public void mouseClicked(MouseEvent e10) {
                    if (e10.getModifiers() == 17) {
                        DeployToolWindow.this.applicationView.buildView(DeployToolWindow.this.getDeployTool().getApplicationManager());
                        return;
                    }
                }
            });
            tree.addTreeSelectionListener(new TreeSelectionListener(){

                public void valueChanged(TreeSelectionEvent e10) {
                    TreePath selPath = tree.getSelectionModel().getSelectionPath();
                    if (selPath != null) {
                        Object leaf = selPath.getLastPathComponent();
                        DefaultMutableTreeNode node = (DefaultMutableTreeNode)leaf;
                        Object inspectable = node.getUserObject();
                        this.refreshApplicationInspectorFor(inspectable);
                        Application clickedApp = av2.getApplicationFor(selPath);
                        this.getDeployTool().getApplicationManager().setActiveApplication(clickedApp);
                        this.refreshApplicationInspectorFor(inspectable);
                    } else {
                        this.getDeployTool().getApplicationManager().setActiveApplication(null);
                        this.refreshApplicationInspectorFor(null);
                    }
                }
            });
        }
        this.applicationView.setPreferredSize(this.applicationView.getMaximumSize());
        return this.applicationView;
    }

    DeployTool getDeployTool() {
        return this.controller.getDeployTool();
    }

    private JComponent getInspectorHeader() {
        JPanel inspectorHeader = new JPanel();
        inspectorHeader.setLayout(new BorderLayout());
        this.inspectingLabel = new JLabel(String.valueOf(INSPECTING_LABEL) + "                                ");
        inspectorHeader.add(this.inspectingLabel);
        return inspectorHeader;
    }

    JComponent getServerPanel() {
        this.serverInspector = new ServerInspector(this.getDeployTool().getServerManager());
        this.getDeployTool().getServerManager().addNotificationListener(this.serverInspector);
        ServerView serverView = this.getServerView();
        JSplitPane serverPanel = new JSplitPane(1, serverView, this.serverInspector);
        serverPanel.setDividerSize(UIUtils.getDefaultDividerSize());
        serverPanel.setDividerLocation(150);
        this.serverInspector.refresh();
        return serverPanel;
    }

    ServerView getServerView() {
        ServerView serverView = new ServerView(this.getDeployTool().getServerManager());
        this.getDeployTool().getServerManager().addNotificationListener(serverView);
        return serverView;
    }

    private Component getTransferActionComponent() {
        return SwingUtilities.findFocusOwner(this.getWorkspacePanel());
    }

    protected JComponent getWorkspacePanel() {
        if (this.workspacePanel == null) {
            JPanel p2 = new JPanel();
            p2.setLayout(new BorderLayout());
            p2.add("North", this.getInspectorHeader());
            p2.add(this.applicationInspectorPlace);
            this.workspacePanel = new JSplitPane(1, this.getApplicationView(), p2);
            ((JSplitPane)this.workspacePanel).setDividerSize(UIUtils.getDefaultDividerSize());
            ((JSplitPane)this.workspacePanel).setDividerLocation(150);
        }
        return this.workspacePanel;
    }

    public void helpAction() {
        JOptionPane.showMessageDialog(this, localStrings.getLocalString("deploytoolwindow.online_help", "Online help will be available in the final release"));
    }

    JSplitPane initializeContents() {
        JComponent workspacePanel = this.getWorkspacePanel();
        JComponent serverPanel = this.getServerPanel();
        JSplitPane splitPane = new JSplitPane(0, workspacePanel, serverPanel);
        splitPane.setDividerSize(UIUtils.getDefaultDividerSize());
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add("Center", splitPane);
        this.applicationInspectorPlace.setLayout(new GridLayout(1, 1));
        return splitPane;
    }

    void initializeWindowClosing() {
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent we) {
                DeployToolWindow.this.exitAction();
            }
        });
    }

    public void newAppClientAction() {
        if (this.getDeployTool().getApplicationManager().getApplications().size() > 0) {
            TreeCombo targetChooser = this.getApplicationView().getTreeCombo(ApplicationView.APPS_ONLY);
            targetChooser.setSelectedDescriptor(this.getDeployTool().getApplicationManager().getActiveApplication());
            NewAppClientWizard acw = new NewAppClientWizard((Frame)this, targetChooser);
            Object target = targetChooser.getSelectedDescriptor();
            if (acw.getOutputFile() != null && target != null) {
                this.addApplicationClient(acw.getOutputFile(), acw.getLibraryJars(), (Application)target);
            }
        } else {
            this.showNeedApplicationDialog();
        }
    }

    public void newApplicationAction() {
        NewAppDialog myDialog = new NewAppDialog(this, this.getDeployTool().getApplicationManager());
        ((Component)myDialog).setVisible(true);
        this.refreshApplicationInspectorFor(this.getDeployTool().getApplicationManager().getActiveApplication());
    }

    public void newEjbJarAction() {
        if (this.getDeployTool().getApplicationManager().getApplications().size() > 0) {
            TreeCombo targetChooser = this.getApplicationView().getTreeCombo(ApplicationView.APPS_AND_EJB_JARS);
            targetChooser.setSelectedDescriptor(this.getApplicationView().getSelectedDescriptor());
            NewEjbWizard nejbw = new NewEjbWizard((Frame)this, targetChooser);
            Object target = targetChooser.getSelectedDescriptor();
            if (nejbw.getOutputFile() != null && target != null) {
                this.addEjbJar(nejbw.getOutputFile(), nejbw.getLibraryJars(), (Descriptor)target);
            }
        } else {
            this.showNeedApplicationDialog();
        }
    }

    public void newWebComponentAction() {
        if (this.getDeployTool().getApplicationManager().getApplications().size() > 0) {
            TreeCombo targetChooser = this.getApplicationView().getTreeCombo(ApplicationView.APPS_AND_WARS);
            targetChooser.setSelectedDescriptor(this.getApplicationView().getSelectedDescriptor());
            NewWebComponentWizard wcw = new NewWebComponentWizard((Frame)this, targetChooser);
            Object target = targetChooser.getSelectedDescriptor();
            if (wcw.getOutputFile() != null && target != null) {
                this.addWebComponent(wcw.getOutputFile(), (Descriptor)target);
            }
        } else {
            this.showNeedApplicationDialog();
        }
    }

    public void openApplicationAction() {
        block6: {
            this.jfc.setFileSelectionMode(0);
            int returnValue = this.jfc.showDialog(this, localStrings.getLocalString("deploytoolwindow.open_application", "Open Application"));
            if (returnValue != 0) break block6;
            File applicationFile = this.jfc.getSelectedFile();
            ApplicationManager applicationManager = this.getDeployTool().getApplicationManager();
            if (applicationManager.getApplicationWithJar(applicationFile) != null) {
                Application alreadyOpenApplication = applicationManager.getApplicationWithJar(applicationFile);
                int doUpdate = JOptionPane.showConfirmDialog(this, String.valueOf(alreadyOpenApplication.getName()) + localStrings.getLocalString("deploytoolwindow.is_already_open", " is already open. Continue by updating ") + alreadyOpenApplication.getName() + localStrings.getLocalString("deploytoolwindow.from_disk", " from disk ?"), localStrings.getLocalString("deploytoolwindow.confirm_action", "Confirm Action"), 0, 3);
                if (doUpdate == 0) {
                    applicationManager.closeApplication(applicationManager.getApplicationWithJar(applicationFile));
                } else {
                    return;
                }
            }
            try {
                if (!ApplicationArchivist.isApplication(applicationFile)) {
                    JOptionPane.showMessageDialog(this, String.valueOf(applicationFile.getName()) + localStrings.getLocalString("deploytoolwindow.not_valid_app_jar", " does not appear to be a valid application JAR"));
                    return;
                }
                applicationManager.openApplication(applicationFile);
                this.getApplicationView().expandApplication(applicationManager.getActiveApplication());
                this.refreshApplicationInspectorFor(this.getDeployTool().getApplicationManager().getActiveApplication());
            }
            catch (Exception ioe) {
                JOptionPane.showMessageDialog(this, String.valueOf(applicationFile.getName()) + localStrings.getLocalString("deploytoolwindow.is_corrupt", " is corrupt."));
                ioe.printStackTrace();
            }
        }
    }

    public void pasteAction() {
        block10: {
            Component c10 = this.getTransferActionComponent();
            if (c10 instanceof JTextComponent) {
                ((JTextComponent)c10).grabFocus();
                ((JTextComponent)c10).paste();
                return;
            }
            if (!(c10 instanceof JTree) && c10 != null) break block10;
            try {
                Application targetApplication = this.getDeployTool().getApplicationManager().getActiveApplication();
                if (targetApplication == null) {
                    JOptionPane.showMessageDialog(this, localStrings.getLocalString("deploytoolwindow.choose_an_application", "Choose an application onto which to paste"));
                    return;
                }
                if (this.clipboard == null || !this.clipboard.exists()) {
                    JOptionPane.showMessageDialog(this, localStrings.getLocalString("deploytoolwindow.nothing_to_paste", "Nothing to paste"));
                    return;
                }
                if (ApplicationArchivist.isApplication(this.clipboard)) {
                    targetApplication.getApplicationArchivist().addApplicationJar(this.clipboard);
                } else if (EjbBundleArchivist.isEjbBundle(this.clipboard)) {
                    targetApplication.getApplicationArchivist().addEjbJar(this.clipboard, new HashSet());
                } else if (WebBundleArchivist.isWebBundle(this.clipboard)) {
                    targetApplication.getApplicationArchivist().addWebJar(this.clipboard);
                }
            }
            catch (Throwable t2) {
                JOptionPane.showMessageDialog(this, localStrings.getLocalString("deploytoolwindow.error_while_pasting", "Error while pasting"));
                t2.printStackTrace();
            }
        }
    }

    void refreshApplicationInspectorFor(Object inspectable) {
        JComponent inspector = this.getApplicationInspectorManager().getInspectorFor(inspectable);
        if (this.applicationInspectorPlace.getComponentCount() == 1) {
            if (this.applicationInspectorPlace.getComponent(0) != inspector) {
                this.applicationInspectorPlace.removeAll();
                UIUtils.addComponentToPanelWorkaround(inspector, this.applicationInspectorPlace);
                this.applicationInspectorPlace.doLayout();
                this.applicationInspectorPlace.repaint();
            } else {
                this.applicationInspectorPlace.doLayout();
            }
        } else {
            UIUtils.addComponentToPanelWorkaround(inspector, this.applicationInspectorPlace);
            this.applicationInspectorPlace.doLayout();
        }
        ((Inspector)((Object)inspector)).setObject(inspectable);
        this.inspectingLabel.setText(String.valueOf(INSPECTING_LABEL) + this.getApplicationView().getSelectionAsString());
    }

    private void registerForTitleUpdates() {
        this.setTitle(TITLE);
        this.getDeployTool().getApplicationManager().addNotificationListener(new NotificationListener(){

            public void notification(NotificationEvent ne) {
                Application activeApplication = DeployToolWindow.this.getDeployTool().getApplicationManager().getActiveApplication();
                if (activeApplication != null) {
                    String title = String.valueOf(TITLE) + ": " + activeApplication.getName();
                    if (activeApplication.isDirty()) {
                        title = String.valueOf(title) + localStrings.getLocalString("deploytoolwindow.something_changed", " (changed)");
                    }
                    DeployToolWindow.this.setTitle(title);
                } else {
                    DeployToolWindow.this.setTitle(TITLE);
                }
            }
        });
    }

    public void removeServerAction() {
        ServerManager serverManager = this.getDeployTool().getServerManager();
        String currentServer = serverManager.getCurrentServer();
        if (currentServer != null) {
            serverManager.removeServer(currentServer);
        }
    }

    public void saveApplicationAction() {
        try {
            Application app = this.getDeployTool().getApplicationManager().getActiveApplication();
            if (app == null) {
                this.selectApplicationDialog();
                return;
            }
            this.getDeployTool().getApplicationManager().saveApplication(app);
        }
        catch (IOException ioe) {
            JOptionPane.showMessageDialog(this, localStrings.getLocalString("deploytoolwindow.save_failed", "Save failed."));
            ioe.printStackTrace();
        }
    }

    private void saveAs() throws Exception {
        ApplicationManager applicationManager = this.getDeployTool().getApplicationManager();
        Descriptor toSave = this.getApplicationView().getSelectedSavebleDescriptor();
        if (toSave != null) {
            if (toSave instanceof BundleDescriptor) {
                BundleDescriptor bd2 = (BundleDescriptor)toSave;
                String label = localStrings.getLocalString("deploytoolwindow.unknown", "Unknown");
                if (bd2 instanceof EjbBundleDescriptor) {
                    label = localStrings.getLocalString("deploytoolwindow.save_ejb_jar_as", "Save EJB JAR As");
                } else if (bd2 instanceof WebBundleDescriptor) {
                    label = localStrings.getLocalString("deploytoolwindow.save_war_as", "Save WAR As");
                } else if (bd2 instanceof ApplicationClientDescriptor) {
                    label = localStrings.getLocalString("deploytoolwindow.save_app_client_as", "Save Application Client As");
                }
                int returnValue = this.jfc.showDialog(this, label);
                if (returnValue == 0) {
                    File newFile = this.jfc.getSelectedFile();
                    if (newFile.exists()) {
                        int overwrite = JOptionPane.showConfirmDialog(this, String.valueOf(String.valueOf(newFile)) + localStrings.getLocalString("deploytoolwindow.already_exists", " already exists. Do you wish to overwrite ?"), localStrings.getLocalString("deploytoolwindow.confirm", "Confirm"), 0, 3);
                        if (overwrite == 0) {
                            newFile.delete();
                        } else {
                            return;
                        }
                    }
                    bd2.getApplication().getApplicationArchivist().extractBundleToFile(bd2, newFile);
                    JOptionPane.showMessageDialog(this, String.valueOf(toSave.getName()) + localStrings.getLocalString("deploytoolwindow.was_saved", " was saved to \n") + newFile);
                }
            } else if (toSave instanceof Application) {
                Application application = (Application)toSave;
                File currentFile = application.getApplicationArchivist().getApplicationFile();
                int returnValue = this.jfc.showDialog(this, localStrings.getLocalString("deploytoolwindow.save_as", "Save As"));
                if (returnValue == 0) {
                    File newFile = this.jfc.getSelectedFile();
                    if (newFile.exists()) {
                        int overwrite = JOptionPane.showConfirmDialog(this, String.valueOf(String.valueOf(newFile)) + localStrings.getLocalString("deploytoolwindow.already_exists", " already exists. Do you wish to overwrite ?"), localStrings.getLocalString("deploytoolwindow.confirm", "Confirm"), 0, 3);
                        if (overwrite == 0) {
                            if (applicationManager.getApplicationWithJar(newFile) != null) {
                                applicationManager.closeApplication(applicationManager.getApplicationWithJar(newFile));
                            }
                            newFile.delete();
                        } else {
                            return;
                        }
                    }
                    this.getDeployTool().getApplicationManager().saveAsApplication(application, newFile);
                }
            }
        }
    }

    public void saveAsAction() {
        try {
            this.saveAs();
        }
        catch (Exception e10) {
            JOptionPane.showMessageDialog(this, String.valueOf(localStrings.getLocalString("deploytoolwindow.error_saving", "There was an error saving the selected component or application:\n")) + e10.getMessage());
        }
    }

    private void selectApplicationDialog() {
        JOptionPane.showMessageDialog(this, localStrings.getLocalString("deploytoolwindow.select_app_first", "Please select an application first."));
    }

    public void showAboutBox() {
        AboutDialog a = new AboutDialog(this);
        ((Component)a).setVisible(true);
    }

    void showErrorAddingDialog() {
        JOptionPane.showMessageDialog(this, localStrings.getLocalString("deploytoolwindow.error_importing", "There was an error importing component(s) into this application. \nThe application file has not been updated. \n See the output for more details."));
    }

    private void showNeedApplicationDialog() {
        JOptionPane.showMessageDialog(this, localStrings.getLocalString("deploytoolwindow.create_new_app", "Please create a new application to hold your components."));
    }

    public String toString() {
        return localStrings.getLocalString("deploytoolwindow.my_name", "Deploy Tool Window");
    }

    public void verifyAction() {
        Descriptor selectedDescriptor = this.getApplicationView().getSelectedDescriptor();
        MainFrame verifierFrame = null;
        verifierFrame = selectedDescriptor != null && selectedDescriptor instanceof Application ? new MainFrame(((Application)selectedDescriptor).getApplicationArchivist().getApplicationFile().getAbsolutePath(), false) : new MainFrame();
        ((Component)verifierFrame).setBounds(this.getBounds().x + 20, this.getBounds().y + 20, this.getBounds().width + 50, this.getBounds().height);
        ((Component)verifierFrame).setVisible(true);
    }
}

