/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.deployment.ui;

import com.sun.enterprise.deployment.ApplicationClientArchivist;
import com.sun.enterprise.deployment.ApplicationClientDescriptor;
import com.sun.enterprise.deployment.FileContentsDescriptor;
import com.sun.enterprise.deployment.xml.ApplicationClientNode;
import com.sun.enterprise.deployment.xml.XMLUtils;
import com.sun.enterprise.tools.deployment.ui.DeployToolActions;
import com.sun.enterprise.tools.deployment.ui.HelpPanel;
import com.sun.enterprise.tools.deployment.ui.Inspector;
import com.sun.enterprise.tools.deployment.ui.Wizard;
import com.sun.enterprise.tools.deployment.ui.descriptor.AppClientGeneralInspector;
import com.sun.enterprise.tools.deployment.ui.descriptor.EjbRefsInspector;
import com.sun.enterprise.tools.deployment.ui.descriptor.EnvironmentInspector;
import com.sun.enterprise.tools.deployment.ui.descriptor.ResourceRefsInspector;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.util.NotificationEvent;
import com.sun.enterprise.util.NotificationListener;
import com.sun.xml.tree.XmlDocument;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.StringWriter;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import javax.help.CSH;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class NewAppClientWizard
extends Wizard {
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(class$com$sun$enterprise$tools$deployment$ui$NewAppClientWizard != null ? class$com$sun$enterprise$tools$deployment$ui$NewAppClientWizard : (class$com$sun$enterprise$tools$deployment$ui$NewAppClientWizard = NewAppClientWizard.class$("com.sun.enterprise.tools.deployment.ui.NewAppClientWizard")));
    private static String help = localStrings.getLocalString("newappclientwizard.help", "");
    private HelpPanel helpPanel = new HelpPanel(help, localStrings.getLocalString("newappclientwizard.wizard_title", "New Application Client Wizard"), "CWIntro");
    private ApplicationClientDescriptor applicationClientDescriptor;
    private AppClientGeneralInspector appClientGeneralInspector;
    private EnvironmentInspector environmentInspector;
    private EjbRefsInspector ejbRefsInspector;
    private ResourceRefsInspector resourceRefsInspector;
    private JTextArea xmlTextArea = new JTextArea();
    private File outputFile = null;
    static /* synthetic */ Class class$com$sun$enterprise$tools$deployment$ui$NewAppClientWizard;

    public NewAppClientWizard(Frame owner, JComponent targetChooser) {
        super(owner);
        this.createWands(targetChooser);
        this.notifyCurrentComponentAction();
        super.setBounds(100, 100, 700, 580);
        super.setTitle(localStrings.getLocalString("newappclientwizard.wizard_title", "New Application Client Wizard"));
        this.getApplicationClientDescriptor().addNotificationListener(new NotificationListener(){

            public void notification(NotificationEvent ae2) {
                NewAppClientWizard.this.descriptorChanged();
            }
        });
        super.show();
    }

    private void badClassAction() {
        String directoryList = "";
        Iterator itr = this.getFileContentsDescriptor().getDirectories();
        while (itr.hasNext()) {
            directoryList = String.valueOf(directoryList) + "\n" + itr.next();
        }
        JOptionPane.showMessageDialog(this, String.valueOf(localStrings.getLocalString("newappclientwizard.the_class", "The class (")) + this.getMainClass() + localStrings.getLocalString("newappclientwizard.not_loaded_from", ") could not be loaded from ") + directoryList);
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    private String convertToFilename(String classname) {
        return String.valueOf(classname.replace('.', '/')) + ".class";
    }

    private void createWands(JComponent targetChooser) {
        Vector inspectors = new Vector();
        this.appClientGeneralInspector = new AppClientGeneralInspector("DeveloperMode", targetChooser);
        super.addComponent(this.helpPanel, localStrings.getLocalString("newappclientwizard.intro", "Introduction"), "");
        super.addComponent(this.appClientGeneralInspector, localStrings.getLocalString("newappclientwizard.general", "General"), localStrings.getLocalString("newappclientwizard.set_app_client_properties", "Set Application Client General Properties"));
        CSH.setHelpIDString((Component)this.appClientGeneralInspector, (String)"CWJAR");
        this.environmentInspector = new EnvironmentInspector("DeveloperMode");
        super.addComponent(this.environmentInspector, localStrings.getLocalString("newappclientwizard.env_entries", "Environment Entries"), localStrings.getLocalString("newappclientwizard.set_env_entries", "Set Environment Entries"));
        CSH.setHelpIDString((Component)this.environmentInspector, (String)"CWEnv");
        this.ejbRefsInspector = new EjbRefsInspector("DeveloperMode");
        super.addComponent(this.ejbRefsInspector, localStrings.getLocalString("newappclientwizard.ejb_refs", "Enterprise Bean References"), localStrings.getLocalString("newappclientwizard.set_ejb_refs", "Set Enterprise Bean References"));
        CSH.setHelpIDString((Component)this.ejbRefsInspector, (String)"CWEJBRef");
        this.resourceRefsInspector = new ResourceRefsInspector("DeveloperMode");
        super.addComponent(this.resourceRefsInspector, localStrings.getLocalString("newappclientwizard.res_refs", "Resource References"), localStrings.getLocalString("newappclientwizard.set_res_refs", "Set Resource References"));
        CSH.setHelpIDString((Component)this.resourceRefsInspector, (String)"CWResourceRef");
        super.addComponent(new XMLDisplay(this.xmlTextArea), localStrings.getLocalString("newappclientwizard.review_settings", "Review Settings"), localStrings.getLocalString("newappclientwizard.inspect_xml", "Inspect XML descriptor"));
        DeployToolActions.enableHelpOnButton(this.helpButton, CSH.getHelpIDString((Component)this.helpPanel));
    }

    void delegateNotification(Object maybeInspector) {
        if (maybeInspector instanceof Inspector) {
            ((Inspector)maybeInspector).setObject(this.getApplicationClientDescriptor());
        }
    }

    private void descriptorChanged() {
        this.environmentInspector.setObject(this.getApplicationClientDescriptor());
        this.ejbRefsInspector.setObject(this.getApplicationClientDescriptor());
        this.resourceRefsInspector.setObject(this.getApplicationClientDescriptor());
    }

    public void finishAction() {
        super.finishAction();
        this.packageComponentAction();
    }

    private ApplicationClientDescriptor getApplicationClientDescriptor() {
        if (this.applicationClientDescriptor == null) {
            this.applicationClientDescriptor = new ApplicationClientDescriptor();
        }
        return this.applicationClientDescriptor;
    }

    private FileContentsDescriptor getFileContentsDescriptor() {
        return this.appClientGeneralInspector.getFileContentsDescriptor();
    }

    private String getJarFile() {
        return this.appClientGeneralInspector.getJarFile();
    }

    public Set getLibraryJars() {
        return this.getFileContentsDescriptor().getLibraryJars();
    }

    private String getMainClass() {
        return this.appClientGeneralInspector.getMainClass();
    }

    public File getOutputFile() {
        return this.outputFile;
    }

    public void goBackward() {
        super.goBackward();
        JComponent currentComponent = super.getCurrentComponent();
        DeployToolActions.enableHelpOnButton(this.helpButton, CSH.getHelpIDString((Component)currentComponent));
    }

    public void goForward() {
        JComponent currentComponent = super.getCurrentComponent();
        if (currentComponent instanceof AppClientGeneralInspector) {
            if (this.getJarFile().equals("")) {
                JOptionPane.showMessageDialog(this, localStrings.getLocalString("newappclientwizard.supply_jar_file_name", "Please supply the name of the JAR file of your application client."));
                return;
            }
            if (!this.getFileContentsDescriptor().getFiles().hasMoreElements()) {
                JOptionPane.showMessageDialog(this, localStrings.getLocalString("newappclientwizard.choose_content", "Please choose the content files for your application client."));
                return;
            }
            if (this.getMainClass().equals("")) {
                JOptionPane.showMessageDialog(this, localStrings.getLocalString("newappclientwizard.add_main_class", "Please add the name of the Main class for your application client."));
                return;
            }
            try {
                ClassLoader cl2 = this.getFileContentsDescriptor().getClassLoader();
                cl2.loadClass(this.getMainClass());
            }
            catch (ClassNotFoundException classNotFoundException) {
                this.badClassAction();
                return;
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                this.badClassAction();
                return;
            }
            catch (IOException iOException) {
                this.badClassAction();
                return;
            }
            if (this.getApplicationClientDescriptor().getName().equals("")) {
                this.getApplicationClientDescriptor().setName(localStrings.getLocalString("newappclientwizard.client", "client"));
            }
            this.finishButton.setEnabled(true);
        }
        super.goForward();
        currentComponent = super.getCurrentComponent();
        DeployToolActions.enableHelpOnButton(this.helpButton, CSH.getHelpIDString((Component)currentComponent));
        if (currentComponent instanceof XMLDisplay) {
            this.refreshXmlDisplay();
        }
        this.delegateNotification(currentComponent);
    }

    void notifyCurrentComponentAction() {
        this.delegateNotification(this.getCurrentComponent());
    }

    private void packageComponentAction() {
        String mainClassName = this.getMainClass();
        File jarFile = null;
        File descriptorFile = null;
        try {
            jarFile = File.createTempFile("application-client", ".jar");
            jarFile.deleteOnExit();
            descriptorFile = this.writeDescriptorAction();
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(this, localStrings.getLocalString("newappclientwizard.error_writing_xml", "There was an error writing the XML"));
            return;
        }
        try {
            ApplicationClientArchivist.createPackage(this.getFileContentsDescriptor(), mainClassName, descriptorFile, jarFile);
            this.outputFile = jarFile;
        }
        catch (Exception e10) {
            JOptionPane.showMessageDialog(this, String.valueOf(localStrings.getLocalString("newappclientwizard.error_writing_app_client", "There was an error writing the application client JAR\n")) + e10.getMessage());
            return;
        }
        descriptorFile.delete();
    }

    private void refreshXmlDisplay() {
        try {
            XmlDocument document = ApplicationClientNode.getDocument(this.getApplicationClientDescriptor());
            StringWriter sw = new StringWriter();
            XMLUtils.writeDocument(document, sw);
            this.xmlTextArea.setText(sw.toString());
        }
        catch (Throwable throwable) {
            System.out.println(localStrings.getLocalString("newappclientwizard.xml_forming_error", "Warning: error forming XML"));
        }
    }

    private File writeDescriptorAction() throws Exception {
        XmlDocument document = ApplicationClientNode.getDocument(this.getApplicationClientDescriptor());
        File descriptorFile = File.createTempFile("application-client", ".xml");
        FileWriter fw = new FileWriter(descriptorFile);
        XMLUtils.writeDocument(document, fw);
        fw.close();
        System.out.println(localStrings.getLocalString("newappclientwizard.done", "Done " + descriptorFile.getAbsolutePath()));
        return descriptorFile;
    }

    class XMLDisplay
    extends JPanel {
        public XMLDisplay(JTextArea ta) {
            CSH.setHelpIDString((Component)this, (String)"CWReview");
            this.setLayout(new BorderLayout());
            ta.setEnabled(false);
            this.add(new JScrollPane(ta));
        }
    }
}

