/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.deployment.ui;

import com.sun.enterprise.tools.deployment.main.ApplicationManager;
import com.sun.enterprise.tools.deployment.ui.DeployToolActions;
import com.sun.enterprise.tools.deployment.ui.UIUtils;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import javax.help.CSH;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EtchedBorder;

public class NewAppDialog
extends JDialog {
    boolean frameSizeAdjusted = false;
    JTextField appNameField = new JTextField();
    EtchedBorder etchedBorder1 = new EtchedBorder();
    JTextField locationField = new JTextField();
    JButton locationButton = new JButton();
    JButton okButton = new JButton();
    JButton cancelButton = new JButton();
    JButton helpButton = new JButton();
    JFrame parent;
    ApplicationManager applicationManager;
    JFileChooser openFileDialog;
    private static String helpSetMapID = "NewApp";
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(class$com$sun$enterprise$tools$deployment$ui$NewAppDialog != null ? class$com$sun$enterprise$tools$deployment$ui$NewAppDialog : (class$com$sun$enterprise$tools$deployment$ui$NewAppDialog = NewAppDialog.class$("com.sun.enterprise.tools.deployment.ui.NewAppDialog")));
    static /* synthetic */ Class class$com$sun$enterprise$tools$deployment$ui$NewAppDialog;

    public NewAppDialog(JFrame p2, ApplicationManager cMgr) {
        super(p2);
        CSH.setHelpIDString((Component)this, (String)helpSetMapID);
        this.parent = p2;
        this.applicationManager = cMgr;
        GridBagLayout gb1 = new GridBagLayout();
        this.getContentPane().setLayout(gb1);
        GridBagConstraints c10 = new GridBagConstraints();
        c10.fill = 1;
        c10.weightx = 0.5;
        this.setTitle(localStrings.getLocalString("newappdialog.title", "New Application"));
        this.setModal(true);
        this.openFileDialog = UIUtils.getFileChooser();
        JLabel AppNameLabel = new JLabel(localStrings.getLocalString("newappdialog.appname", "Application Name:"), 4);
        c10.gridx = 0;
        c10.gridy = 0;
        c10.gridwidth = 1;
        c10.gridheight = 1;
        c10.weightx = 0.0;
        c10.weighty = 0.0;
        c10.insets = new Insets(10, 5, 5, 5);
        gb1.setConstraints(AppNameLabel, c10);
        this.getContentPane().add(AppNameLabel);
        this.appNameField.setText(localStrings.getLocalString("newappdialog.default_appname", "Untitled"));
        c10.gridx = 1;
        c10.gridy = 0;
        c10.gridwidth = 3;
        c10.gridheight = 1;
        c10.weightx = 0.0;
        c10.weighty = 0.0;
        c10.insets = new Insets(10, 5, 5, 5);
        gb1.setConstraints(this.appNameField, c10);
        this.getContentPane().add(this.appNameField);
        JLabel LocationLabel = new JLabel(localStrings.getLocalString("newappdialog.location", "Location:"), 4);
        c10.gridx = 0;
        c10.gridy = 1;
        c10.gridwidth = 1;
        c10.gridheight = 1;
        c10.weightx = 0.0;
        c10.weighty = 0.0;
        c10.insets = new Insets(5, 5, 5, 5);
        c10.anchor = 13;
        gb1.setConstraints(LocationLabel, c10);
        this.getContentPane().add(LocationLabel);
        c10.anchor = 10;
        this.locationField.setText(localStrings.getLocalString("newappdialog.default_location", "Untitled.ear"));
        c10.gridx = 1;
        c10.gridy = 1;
        c10.gridwidth = 2;
        c10.gridheight = 1;
        c10.weightx = 0.5;
        c10.weighty = 0.0;
        c10.insets = new Insets(5, 5, 5, 5);
        gb1.setConstraints(this.locationField, c10);
        this.getContentPane().add(this.locationField);
        this.locationButton.setText(localStrings.getLocalString("newappdialog.browse", "..."));
        c10.gridx = 3;
        c10.gridy = 1;
        c10.gridwidth = 1;
        c10.gridheight = 1;
        c10.weightx = 0.0;
        c10.weighty = 0.0;
        c10.insets = new Insets(5, 0, 5, 5);
        gb1.setConstraints(this.locationButton, c10);
        this.getContentPane().add(this.locationButton);
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new GridLayout(1, 3, 5, 5));
        this.helpButton.setText(localStrings.getLocalString("newappdialog.help", "Help"));
        buttonPanel.add(this.helpButton);
        DeployToolActions.enableHelpOnButton(this.helpButton, helpSetMapID);
        this.okButton.setText(localStrings.getLocalString("newappdialog.ok", "OK"));
        buttonPanel.add(this.okButton);
        this.cancelButton.setText(localStrings.getLocalString("newappdialog.cancel", "Cancel"));
        buttonPanel.add(this.cancelButton);
        c10.gridx = 0;
        c10.gridy = 2;
        c10.gridwidth = 4;
        c10.gridheight = 1;
        c10.weightx = 0.0;
        c10.weighty = 0.0;
        c10.insets = new Insets(5, 5, 5, 5);
        c10.anchor = 13;
        c10.fill = 0;
        gb1.setConstraints(buttonPanel, c10);
        this.getContentPane().add(buttonPanel);
        this.openFileDialog.setFileSelectionMode(0);
        ConsoleAction consoleAction = new ConsoleAction();
        this.locationButton.addActionListener(consoleAction);
        this.okButton.addActionListener(consoleAction);
        this.cancelButton.addActionListener(consoleAction);
        this.helpButton.addActionListener(consoleAction);
        ((Component)this).setBounds(this.parent.getBounds().x + 20, this.parent.getBounds().y + 20, 420, 120);
    }

    boolean FieldCheck() {
        String applicationString = this.appNameField.getText();
        String locationString = this.locationField.getText();
        return applicationString.length() != 0 && locationString.length() != 0;
    }

    public void addNotify() {
        Dimension size = this.getSize();
        super.addNotify();
        if (this.frameSizeAdjusted) {
            return;
        }
        this.frameSizeAdjusted = true;
        Insets insets = this.getInsets();
        ((Component)this).setSize(insets.left + insets.right + size.width, insets.top + insets.bottom + size.height);
    }

    void cancelButton_actionPerformed(ActionEvent event) {
        ((Component)this).setVisible(false);
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    public Dimension getPreferredSize() {
        return new Dimension(300, 120);
    }

    void helpButton_actionPerformed(ActionEvent event) {
    }

    void locationButton_actionPerformed(ActionEvent event) {
        int returnValue = this.openFileDialog.showDialog(this, "New Application");
        if (returnValue == 0) {
            this.locationField.setText(this.openFileDialog.getSelectedFile().getAbsolutePath());
        }
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame();
        NewAppDialog myDialog = new NewAppDialog(frame, null);
        ((Component)frame).setVisible(true);
        ((Component)myDialog).setSize(((Container)myDialog).getPreferredSize());
        ((Component)myDialog).setVisible(true);
    }

    void okButton_actionPerformed(ActionEvent event) {
        if (!this.FieldCheck()) {
            JOptionPane.showMessageDialog(this.parent, localStrings.getLocalString("newappdialog.no_app_name", "You must fill in the application name and the location to add an application."));
        } else {
            String applicationString = this.appNameField.getText();
            String locationString = this.locationField.getText();
            File applicationFile = new File(locationString);
            File parentFile = new File(applicationFile.getAbsolutePath()).getParentFile();
            if (!(parentFile == null || parentFile.exists() && parentFile.canWrite())) {
                JOptionPane.showMessageDialog(this, localStrings.getLocalString("newappdialog.invalid_directory", "{0} does not exist or is read only.", new Object[]{parentFile}));
                return;
            }
            if (applicationFile.exists()) {
                int overwrite = JOptionPane.showConfirmDialog(this, localStrings.getLocalString("newappdialog.appfile_exists", "{0}  already exists. Do you wish to overwrite ?", new Object[]{locationString}), localStrings.getLocalString("newappdialog.confirm", "Confirm"), 0, 3);
                if (overwrite == 0) {
                    if (this.applicationManager.getApplicationWithJar(applicationFile) != null) {
                        this.applicationManager.closeApplication(this.applicationManager.getApplicationWithJar(applicationFile));
                    }
                    applicationFile.delete();
                } else {
                    return;
                }
            }
            try {
                this.applicationManager.newApplication(applicationString, new File(locationString).getCanonicalPath());
            }
            catch (IOException ioe) {
                JOptionPane.showMessageDialog(this, localStrings.getLocalString("newappdialog.error_creating", "Error creating new application: {0}", new Object[]{ioe.getMessage()}));
                return;
            }
            ((Component)this).setVisible(false);
        }
    }

    class ConsoleAction
    implements ActionListener {
        ConsoleAction() {
        }

        public void actionPerformed(ActionEvent event) {
            Object object = event.getSource();
            if (object == NewAppDialog.this.locationButton) {
                NewAppDialog.this.locationButton_actionPerformed(event);
            } else if (object == NewAppDialog.this.okButton) {
                NewAppDialog.this.okButton_actionPerformed(event);
            } else if (object == NewAppDialog.this.cancelButton) {
                NewAppDialog.this.cancelButton_actionPerformed(event);
            } else if (object == NewAppDialog.this.helpButton) {
                NewAppDialog.this.helpButton_actionPerformed(event);
            }
        }
    }
}

