/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.deployment.ui;

import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.tools.deployment.main.ServerManager;
import com.sun.enterprise.tools.deployment.ui.GetFilenamePanel;
import com.sun.enterprise.tools.deployment.ui.UIUtils;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import javax.help.CSH;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class PreDeploymentPanel
extends JPanel {
    private GetFilenamePanel filenamePanel;
    private JCheckBox checkBox = new JCheckBox("Return Client Jar");
    private JComboBox serverList;
    private UIUtils.ImagePanel imagePanel = new UIUtils.ImagePanel(UIUtils.getImageIconFor("wizard_deploy_full.gif").getImage());
    private JPanel clientPanel = new JPanel();
    private JPanel serverPanel = new JPanel();
    private JPanel checkBoxPanel = new JPanel();
    private static String helpSetMapID = "DServer";
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(class$com$sun$enterprise$tools$deployment$ui$PreDeploymentWizard != null ? class$com$sun$enterprise$tools$deployment$ui$PreDeploymentWizard : (class$com$sun$enterprise$tools$deployment$ui$PreDeploymentWizard = PreDeploymentPanel.class$("com.sun.enterprise.tools.deployment.ui.PreDeploymentWizard")));
    private ServerManager serverManager;
    static /* synthetic */ Class class$com$sun$enterprise$tools$deployment$ui$PreDeploymentWizard;

    public PreDeploymentPanel(ServerManager sm, Application app) {
        CSH.setHelpIDString((Component)this, (String)helpSetMapID);
        this.serverManager = sm;
        this.setLayout(new BorderLayout());
        this.serverList = new JComboBox<Object>(sm.getServerNames().toArray());
        this.serverList.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(), "Target Server"));
        this.serverList.setSelectedItem(sm.getCurrentServer());
        this.serverList.addItemListener(new ServerListListener());
        this.serverPanel.setLayout(new BorderLayout());
        this.serverPanel.add("Center", new HelpTextPanel("Please select the server that you want to deploy the application '" + app.getName() + "' to:", null, helpSetMapID));
        this.serverPanel.add("South", this.serverList);
        this.checkBoxPanel.setLayout(new BorderLayout());
        this.checkBoxPanel.add("Center", new HelpTextPanel(localStrings.getLocalString("predeploymentwizard.help_msg", "If you are going to write a stand-alone application client for this server application, a JAR file can be returned from the server . This JAR file contains the stub files needed to access the objects deployed in the server application"), localStrings.getLocalString("predeploymentwizard.client_code_jar_file", "Client Code JAR file"), helpSetMapID));
        this.checkBoxPanel.add("South", this.checkBox);
        String applicationDirectory = new File(app.getApplicationArchivist().getApplicationFile().getAbsolutePath()).getParentFile().toString();
        this.filenamePanel = new GetFilenamePanel(new File(applicationDirectory, String.valueOf(app.getName()) + "Client.jar").toString(), localStrings.getLocalString("predeploymentwizard.choose_client_code_name", "Choose a filename for the client code:"));
        this.clientPanel.setLayout(new BorderLayout());
        this.clientPanel.add("Center", this.checkBoxPanel);
        this.clientPanel.add("South", this.filenamePanel);
        this.filenamePanel.setVisible(this.checkBox.isSelected());
        this.checkBox.addChangeListener(new CheckBoxListener());
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints c10 = new GridBagConstraints();
        c10.insets = new Insets(5, 5, 5, 5);
        c10.fill = 1;
        c10.gridwidth = 0;
        c10.weightx = 1.0;
        c10.weighty = 1.0;
        JPanel inputPanel = new JPanel(gridbag);
        gridbag.setConstraints(this.serverPanel, c10);
        inputPanel.add(this.serverPanel);
        DividingLine line = new DividingLine();
        c10.weighty = 0.0;
        gridbag.setConstraints(line, c10);
        inputPanel.add(line);
        c10.gridheight = 0;
        c10.weighty = 1.0;
        gridbag.setConstraints(this.clientPanel, c10);
        inputPanel.add(this.clientPanel);
        this.add("West", this.imagePanel);
        this.add("Center", inputPanel);
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    public String getFilename() {
        return this.filenamePanel.getFilename();
    }

    public boolean shouldCreateClient() {
        return this.checkBox.isSelected();
    }

    class DividingLine
    extends JPanel {
        DividingLine() {
        }

        protected void paintComponent(Graphics g2) {
            g2.drawLine(0, this.getSize().height / 2, this.getSize().width, this.getSize().height / 2);
        }
    }

    class HelpTextPanel
    extends JPanel {
        public HelpTextPanel(String help, String title, String helpID) {
            if (helpID != null) {
                CSH.setHelpIDString((Component)this, (String)helpID);
            }
            if (title != null) {
                String helpString = String.valueOf(title) + "\n\n  " + help;
            } else {
                String helpString = help;
            }
            this.setLayout(new BorderLayout());
            JEditorPane helpTextArea = new JEditorPane("text/html", help);
            helpTextArea.setBackground(UIManager.getColor("Panel.background"));
            helpTextArea.setEditable(false);
            JScrollPane scrollArea = new JScrollPane(helpTextArea);
            scrollArea.setBorder(null);
            this.add((Component)scrollArea, "Center");
        }
    }

    class ServerListListener
    implements ItemListener {
        ServerListListener() {
        }

        public void itemStateChanged(ItemEvent e10) {
            PreDeploymentPanel.this.serverManager.setCurrentServer((String)e10.getItem());
        }
    }

    class CheckBoxListener
    implements ChangeListener {
        CheckBoxListener() {
        }

        public void stateChanged(ChangeEvent e10) {
            PreDeploymentPanel.this.filenamePanel.setVisible(PreDeploymentPanel.this.checkBox.isSelected());
        }
    }
}

