/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.deployment.ui;

import com.sun.enterprise.tools.deployment.main.ServerException;
import com.sun.enterprise.tools.deployment.main.ServerManager;
import com.sun.enterprise.tools.deployment.ui.Inspector;
import com.sun.enterprise.tools.deployment.ui.ServerInspector;
import com.sun.enterprise.tools.deployment.ui.UIUtils;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.util.NotificationEvent;
import com.sun.enterprise.util.NotificationListener;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class ServerInspector
extends JPanel
implements Inspector,
NotificationListener {
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(class$com$sun$enterprise$tools$deployment$ui$ServerInspector != null ? class$com$sun$enterprise$tools$deployment$ui$ServerInspector : (class$com$sun$enterprise$tools$deployment$ui$ServerInspector = ServerInspector.class$("com.sun.enterprise.tools.deployment.ui.ServerInspector")));
    JList applicationList = new JList();
    private static String NAME_LABEL = localStrings.getLocalString("serverinspector.server_apps", "Server Applications");
    private static String UNINSTALL_LABEL = localStrings.getLocalString("serverinspector.uninstall", "Uninstall");
    ServerManager serverManager;
    JButton uninstallButton;
    static /* synthetic */ Class class$com$sun$enterprise$tools$deployment$ui$ServerInspector;

    ServerInspector(ServerManager serverManager) {
        this.serverManager = serverManager;
        this.initializeWidgets();
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    private void initializeWidgets() {
        this.setLayout(new BorderLayout());
        JPanel p2 = null;
        p2 = UIUtils.createBorderedPanel(NAME_LABEL, new BorderLayout());
        p2.add("Center", new JScrollPane(this.applicationList));
        class ServerApplicationListCellRenderer
        extends DefaultListCellRenderer {
            ServerApplicationListCellRenderer() {
            }

            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                JLabel label = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                label.setIcon(UIUtils.getImageIconFor(UIUtils.APPLICATION_ICON));
                return label;
            }
        }
        this.applicationList.setCellRenderer(new ServerApplicationListCellRenderer());
        this.uninstallButton = new JButton(UNINSTALL_LABEL);
        this.uninstallButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae2) {
                ServerInspector.this.uninstallAction();
            }
        });
        JPanel buttonPanel = new JPanel();
        buttonPanel.add(this.uninstallButton);
        p2.add("East", buttonPanel);
        this.add(p2);
        this.refresh();
    }

    public void notification(NotificationEvent ne) {
        this.refresh();
    }

    public void refresh() {
        DefaultListModel listModel = new DefaultListModel();
        try {
            Vector applications = this.serverManager.getApplicationNames();
            if (applications != null) {
                int i2 = 0;
                while (i2 < applications.size()) {
                    listModel.addElement(applications.elementAt(i2));
                    ++i2;
                }
                this.uninstallButton.setEnabled(applications.size() > 0);
            } else {
                this.uninstallButton.setEnabled(false);
            }
        }
        catch (Exception exception) {
            this.uninstallButton.setEnabled(false);
        }
        this.applicationList.setModel(listModel);
    }

    public void setObject(Object o2) {
        DefaultListModel lm = new DefaultListModel();
        this.applicationList.setModel(lm);
        this.validate();
    }

    public String toString() {
        return localStrings.getLocalString("serverinspector.my_name", "Server inspector");
    }

    public void uninstallAction() {
        Object[] selection = this.applicationList.getSelectedValues();
        String currentServer = this.serverManager.getCurrentServer();
        if (currentServer != null && selection.length > 0) {
            String applicationsString = "";
            int i2 = 0;
            while (i2 < selection.length) {
                applicationsString = String.valueOf(applicationsString) + selection[i2] + "\n";
                ++i2;
            }
            int userChoice = JOptionPane.showConfirmDialog(this, String.valueOf(localStrings.getLocalString("serverinspector.chosen_uninstall", "You have chosen to uninstall the application(s)\n")) + applicationsString + localStrings.getLocalString("serverinspector.from", "from ") + this.serverManager.getCurrentServer() + localStrings.getLocalString("serverinspector.continue", ". Continue ?"), localStrings.getLocalString("serverinspector.confirm", "Confirm Action"), 0, 3);
            if (userChoice == 0) {
                int i3 = 0;
                while (i3 < selection.length) {
                    try {
                        this.serverManager.uninstall((String)selection[i3], currentServer);
                    }
                    catch (ServerException se) {
                        JOptionPane.showMessageDialog(this, localStrings.getLocalString("serverinspector.communication_error", "There was a communication error with the server: " + se.getMessage()));
                        this.serverManager.removeServer(currentServer);
                    }
                    catch (Throwable t2) {
                        JOptionPane.showMessageDialog(this, t2.getMessage());
                    }
                    ++i3;
                }
            }
        }
    }
}

