/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.deployment.ui;

import com.sun.enterprise.tools.deployment.backend.JarInstaller;
import com.sun.enterprise.tools.deployment.main.ServerManager;
import com.sun.enterprise.tools.deployment.ui.DeployToolActions;
import com.sun.enterprise.tools.deployment.ui.UsersTable;
import com.sun.enterprise.tools.deployment.ui.UsersTableModel;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.util.NotificationEvent;
import com.sun.enterprise.util.NotificationListener;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;

public class UsersDialog
extends JDialog {
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(class$com$sun$enterprise$tools$deployment$ui$UsersDialog != null ? class$com$sun$enterprise$tools$deployment$ui$UsersDialog : (class$com$sun$enterprise$tools$deployment$ui$UsersDialog = UsersDialog.class$("com.sun.enterprise.tools.deployment.ui.UsersDialog")));
    private static String helpSetMapID = "AIAddUser";
    ServerManager serverManager = null;
    UsersTableModel usersTableModel;
    UsersTable usersTable;
    UsersTableModel userGroupsTableModel;
    UsersTable userGroupsTable;
    JTextField tblText;
    JTextField tblDeleteText;
    JTextField ejbCreateText;
    JTextField ejbLoadText;
    JTextField ejbRemoveText;
    JTextField ejbStoreText;
    JButton okPB;
    JButton cancelPB;
    JButton helpPB;
    JButton dbSqlPB;
    static /* synthetic */ Class class$com$sun$enterprise$tools$deployment$ui$UsersDialog;

    public UsersDialog(Frame frame, boolean modal) {
        super(frame, localStrings.getLocalString("usersdialog.users", "Users"), modal);
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent we) {
                UsersDialog.this.cancelAction();
            }
        });
        JPanel contentPane = new JPanel();
        contentPane.setToolTipText(localStrings.getLocalString("usersdialog.tool_tip", "Select a user from list and press OK"));
        GridBagLayout gb1 = new GridBagLayout();
        contentPane.setLayout(gb1);
        GridBagConstraints c10 = new GridBagConstraints();
        c10.fill = 1;
        c10.weightx = 1.0;
        c10.gridwidth = 1;
        JLabel tblLabel = new JLabel(localStrings.getLocalString("usersdialog.users_colon", "Users:"));
        c10.weighty = 0.0;
        c10.gridx = 0;
        c10.gridy = 0;
        c10.insets = new Insets(5, 5, 0, 5);
        gb1.setConstraints(tblLabel, c10);
        contentPane.add(tblLabel);
        this.usersTableModel = new UsersTableModel(UsersTableModel.usersColumnNames);
        this.userGroupsTableModel = new UsersTableModel(UsersTableModel.userGroupsColumnNames);
        this.initializeUsersTableModel();
        this.usersTable = new UsersTable(this.usersTableModel);
        JScrollPane usersTablePane = new JScrollPane(this.usersTable);
        this.usersTable.setSelectionMode(0);
        this.usersTable.setAutoResizeMode(4);
        this.userGroupsTable = new UsersTable(this.userGroupsTableModel);
        JScrollPane userGroupsTablePane = new JScrollPane(this.userGroupsTable);
        this.userGroupsTable.setSelectionMode(0);
        this.userGroupsTable.setAutoResizeMode(4);
        ListSelectionModel usersSelectionModel = this.usersTable.getSelectionModel();
        usersTablePane.setPreferredSize(new Dimension(300, 200));
        userGroupsTablePane.setPreferredSize(new Dimension(300, 200));
        c10.gridx = 0;
        c10.gridy = 1;
        c10.gridwidth = 1;
        c10.gridheight = 1;
        c10.weightx = 0.5;
        c10.weighty = 0.5;
        c10.insets = new Insets(5, 5, 5, 5);
        c10.fill = 1;
        gb1.setConstraints(usersTablePane, c10);
        contentPane.add(usersTablePane);
        JLabel tblGroupLabel = new JLabel(localStrings.getLocalString("usersdialog.user_groups", "User Groups:"));
        c10.weighty = 0.0;
        c10.gridx = 0;
        c10.gridy = 2;
        c10.insets = new Insets(5, 5, 0, 5);
        gb1.setConstraints(tblGroupLabel, c10);
        contentPane.add(tblGroupLabel);
        c10.gridx = 0;
        c10.gridy = 3;
        c10.gridwidth = 1;
        c10.gridheight = 1;
        c10.weightx = 0.5;
        c10.weighty = 0.5;
        c10.insets = new Insets(5, 5, 5, 5);
        c10.fill = 1;
        gb1.setConstraints(userGroupsTablePane, c10);
        contentPane.add(userGroupsTablePane);
        JPanel dialogButtonPanel = new JPanel();
        dialogButtonPanel.setLayout(new GridLayout(1, 3, 5, 5));
        this.okPB = new JButton(localStrings.getLocalString("usersdialog.ok", "OK"));
        dialogButtonPanel.add(this.okPB);
        this.okPB.setMnemonic('O');
        this.okPB.setActionCommand("OK");
        this.okPB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e10) {
                UsersDialog.this.okAction();
            }
        });
        this.cancelPB = new JButton(localStrings.getLocalString("usersdialog.cancel", "Cancel"));
        dialogButtonPanel.add(this.cancelPB);
        this.cancelPB.setMnemonic('C');
        this.cancelPB.setActionCommand("Cancel");
        this.cancelPB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e10) {
                UsersDialog.this.cancelAction();
            }
        });
        this.helpPB = new JButton(localStrings.getLocalString("usersdialog.help", "Help"));
        DeployToolActions.enableHelpOnButton(this.helpPB, helpSetMapID);
        dialogButtonPanel.add(this.helpPB);
        this.helpPB.setMnemonic('H');
        this.helpPB.setActionCommand("Help");
        this.helpPB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e10) {
                UsersDialog.this.helpAction();
            }
        });
        c10.weighty = 0.0;
        c10.weightx = 0.0;
        c10.gridx = 0;
        c10.gridy = 4;
        c10.insets = new Insets(5, 5, 5, 5);
        c10.anchor = 13;
        c10.fill = 0;
        gb1.setConstraints(dialogButtonPanel, c10);
        contentPane.add(dialogButtonPanel);
        this.setContentPane(contentPane);
        contentPane.setMinimumSize(contentPane.getPreferredSize());
    }

    private void cancelAction() {
        this.usersTable.clearSelection();
        this.setVisible(false);
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    private void displayUsers() {
        this.usersTable.clearSelection();
        this.userGroupsTable.clearSelection();
        this.usersTableModel = new UsersTableModel(UsersTableModel.usersColumnNames);
        this.usersTable.setModel(this.usersTableModel);
        this.usersTable.sizeColumnsToFit(0);
        this.userGroupsTableModel = new UsersTableModel(UsersTableModel.userGroupsColumnNames);
        this.userGroupsTable.setModel(this.userGroupsTableModel);
        this.userGroupsTable.sizeColumnsToFit(0);
        this.initializeUsersTableModel();
    }

    public String getSelectedGroup() {
        int index;
        String selectedGroup = null;
        ListSelectionModel sm = this.userGroupsTable.getSelectionModel();
        if (!sm.isSelectionEmpty() && (index = this.userGroupsTable.getSelectedRow()) >= 0) {
            UsersTableModel model = (UsersTableModel)this.userGroupsTable.getModel();
            selectedGroup = model.getUserAt(index);
        }
        return selectedGroup;
    }

    public String getSelectedUser() {
        int index;
        String selectedUser = null;
        ListSelectionModel sm = this.usersTable.getSelectionModel();
        if (!sm.isSelectionEmpty() && (index = this.usersTable.getSelectedRow()) >= 0) {
            UsersTableModel model = (UsersTableModel)this.usersTable.getModel();
            selectedUser = model.getUserAt(index);
        }
        return selectedUser;
    }

    private void helpAction() {
    }

    private void initializeUsersTableModel() {
        int i2;
        JarInstaller jarInstaller = null;
        if (this.serverManager == null) {
            return;
        }
        try {
            jarInstaller = this.serverManager.getServerForName(this.serverManager.getCurrentServer());
        }
        catch (Exception e10) {
            e10.printStackTrace();
        }
        if (jarInstaller == null) {
            return;
        }
        try {
            Vector userNames = jarInstaller.getUserNames();
            i2 = 0;
            while (i2 < userNames.size()) {
                this.usersTableModel.addUser((String)userNames.get(i2));
                ++i2;
            }
        }
        catch (Exception e11) {
            e11.printStackTrace();
        }
        try {
            Vector groupNames = jarInstaller.getGroupNames();
            i2 = 0;
            while (i2 < groupNames.size()) {
                this.userGroupsTableModel.addUser((String)groupNames.get(i2));
                ++i2;
            }
        }
        catch (Exception e12) {
            e12.printStackTrace();
        }
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame();
        UsersDialog myDialog = new UsersDialog((Frame)frame, true);
        ((Component)frame).setVisible(true);
        ((Component)myDialog).setVisible(true);
    }

    private void okAction() {
        this.setVisible(false);
    }

    public void setServerManager(ServerManager serverManager) {
        this.serverManager = serverManager;
        serverManager.addNotificationListener(new NotificationListener(){

            public void notification(NotificationEvent ne) {
                if (UsersDialog.this.isVisible()) {
                    UsersDialog.this.displayUsers();
                    System.out.println(localStrings.getLocalString("usersdialog.server_changed", "Server Changed !!"));
                }
            }
        });
    }

    public void setVisible(boolean isVisible) {
        if (isVisible) {
            this.displayUsers();
        }
        super.setVisible(isVisible);
    }
}

