/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.deployment.ui.descriptor;

import com.sun.ejb.sqlgen.DBInfo;
import com.sun.ejb.sqlgen.SQLGenerator;
import com.sun.enterprise.deployment.EjbEntityDescriptor;
import com.sun.enterprise.deployment.MethodDescriptor;
import com.sun.enterprise.deployment.ResourceReferenceDescriptor;
import com.sun.enterprise.resource.ResourcePrincipal;
import com.sun.enterprise.tools.deployment.main.ServerManager;
import com.sun.enterprise.tools.deployment.ui.DeployToolActions;
import com.sun.enterprise.tools.deployment.ui.descriptor.DbSqlDialog;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class DeploymentSettingsDialog
extends JDialog {
    private static final boolean debug = true;
    private static final String TABLE_CREATE_METHOD = "Table Create";
    private static final String TABLE_DELETE_METHOD = "Table Delete";
    private JTextField dbNameText;
    private JTextField userNameText;
    private JTextField passwdText;
    private JTextField tblNameText;
    private JCheckBox createTblOnDeployCB;
    private JCheckBox deleteTblOnUnDeployCB;
    private JButton okPB;
    private JButton cancelPB;
    private JButton helpPB;
    private JButton dbSqlPB;
    private JButton sqlgenPB;
    private JList sqlMethodsList;
    private JTextArea sqlStmtText;
    private DbSqlDialog dbSqlDialog;
    private EjbEntityDescriptor descriptor;
    private String[] fieldTableColumnNames = new String[]{localStrings.getLocalString("enterprise.tools.deployment.ui.descriptor.fieldname", "Field Name"), localStrings.getLocalString("enterprise.tools.deployment.ui.descriptor.dbcolumnname", "DB Column Name"), localStrings.getLocalString("enterprise.tools.deployment.ui.descriptor.dbtype", "DB Type")};
    private Hashtable sqlStmtTable = new Hashtable();
    private final DeploymentSettingsDialog thisDialog = this;
    private ServerManager serverManager;
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(class$com$sun$enterprise$tools$deployment$ui$descriptor$DeploymentSettingsDialog != null ? class$com$sun$enterprise$tools$deployment$ui$descriptor$DeploymentSettingsDialog : (class$com$sun$enterprise$tools$deployment$ui$descriptor$DeploymentSettingsDialog = DeploymentSettingsDialog.class$("com.sun.enterprise.tools.deployment.ui.descriptor.DeploymentSettingsDialog")));
    private static String helpSetMapID = "EIDeploySetting";
    static /* synthetic */ Class class$com$sun$enterprise$tools$deployment$ui$descriptor$DeploymentSettingsDialog;

    public DeploymentSettingsDialog(Frame frame, boolean modal, ServerManager serverManager) {
        super(frame, localStrings.getLocalString("enterprise.tools.deployment.ui.descriptor.deploymentsettings", "Deployment settings"), modal);
        this.serverManager = serverManager;
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent we) {
                DeploymentSettingsDialog.this.cancelAction();
            }
        });
        JPanel contentPane = new JPanel();
        contentPane.setToolTipText(localStrings.getLocalString("enterprise.tools.deployment.ui.descriptor.deploymentsettings", "Deployment settings"));
        contentPane.setPreferredSize(new Dimension(450, 500));
        GridBagLayout gridbag = new GridBagLayout();
        contentPane.setLayout(gridbag);
        GridBagConstraints c10 = new GridBagConstraints();
        c10.fill = 1;
        c10.weightx = 0.5;
        JPanel dbSettingsPanel = new JPanel();
        dbSettingsPanel.setBorder(new TitledBorder(localStrings.getLocalString("enterprise.tools.deployment.ui.descriptor.dbsettings", "Database settings")));
        GridBagLayout gb1 = new GridBagLayout();
        dbSettingsPanel.setLayout(gb1);
        JLabel dbNameLabel = new JLabel(localStrings.getLocalString("enterprise.tools.deployment.ui.descriptor.dbjndiname", "Database JNDI Name:"));
        c10.weighty = 0.0;
        c10.gridx = 0;
        c10.gridy = 0;
        c10.insets = new Insets(0, 5, 0, 5);
        gb1.setConstraints(dbNameLabel, c10);
        dbSettingsPanel.add(dbNameLabel);
        this.dbNameText = new JTextField();
        c10.weighty = 0.0;
        c10.gridx = 0;
        c10.gridy = 1;
        c10.gridwidth = 2;
        c10.insets = new Insets(0, 5, 0, 5);
        gb1.setConstraints(this.dbNameText, c10);
        this.dbNameText.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent fe2) {
                if (DeploymentSettingsDialog.this.descriptor != null) {
                    DeploymentSettingsDialog.this.doButtonEnablement();
                }
            }
        });
        this.dbNameText.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent ke) {
                if (ke.getKeyCode() == 10) {
                    DeploymentSettingsDialog.this.doButtonEnablement();
                }
            }
        });
        dbSettingsPanel.add(this.dbNameText);
        c10.gridwidth = 1;
        JLabel userNameLabel = new JLabel(localStrings.getLocalString("enterprise.tools.deployment.ui.descriptor.username", "User name:"));
        c10.weighty = 0.0;
        c10.gridx = 0;
        c10.gridy = 2;
        c10.insets = new Insets(5, 5, 0, 5);
        gb1.setConstraints(userNameLabel, c10);
        dbSettingsPanel.add(userNameLabel);
        this.userNameText = new JTextField();
        c10.weighty = 0.0;
        c10.gridx = 0;
        c10.gridy = 3;
        c10.insets = new Insets(0, 5, 0, 5);
        gb1.setConstraints(this.userNameText, c10);
        dbSettingsPanel.add(this.userNameText);
        JLabel passwdLabel = new JLabel(localStrings.getLocalString("enterprise.tools.deployment.ui.descriptor.password", "Password:"));
        c10.weighty = 0.0;
        c10.gridx = 1;
        c10.gridy = 2;
        c10.insets = new Insets(5, 5, 0, 5);
        gb1.setConstraints(passwdLabel, c10);
        dbSettingsPanel.add(passwdLabel);
        this.passwdText = new JTextField();
        c10.weighty = 0.0;
        c10.gridx = 1;
        c10.gridy = 3;
        c10.insets = new Insets(0, 5, 0, 5);
        gb1.setConstraints(this.passwdText, c10);
        dbSettingsPanel.add(this.passwdText);
        c10.weighty = 0.0;
        c10.weightx = 0.5;
        c10.gridx = 0;
        c10.gridy = 0;
        c10.gridwidth = 2;
        c10.insets = new Insets(5, 5, 0, 5);
        gridbag.setConstraints(dbSettingsPanel, c10);
        contentPane.add(dbSettingsPanel);
        JPanel dialogButtonPanel = new JPanel();
        dialogButtonPanel.setLayout(new GridLayout(4, 1));
        this.okPB = new JButton(localStrings.getLocalString("enterprise.tools.deployment.ui.descriptor.okbutton", "OK"));
        dialogButtonPanel.add(this.okPB);
        this.okPB.setMnemonic('O');
        this.okPB.setActionCommand("OK");
        this.okPB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e10) {
                DeploymentSettingsDialog.this.okAction();
            }
        });
        this.cancelPB = new JButton(localStrings.getLocalString("enterprise.tools.deployment.ui.descriptor.cancelbutton", "Cancel"));
        dialogButtonPanel.add(this.cancelPB);
        this.cancelPB.setMnemonic('C');
        this.cancelPB.setActionCommand("Cancel");
        this.cancelPB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e10) {
                DeploymentSettingsDialog.this.cancelAction();
            }
        });
        this.helpPB = new JButton(localStrings.getLocalString("enterprise.tools.deployment.ui.descriptor.helpbutton", "Help"));
        this.okPB.setMnemonic('H');
        dialogButtonPanel.add(this.helpPB);
        DeployToolActions.enableHelpOnButton(this.helpPB, helpSetMapID);
        c10.weighty = 0.0;
        c10.weightx = 0.0;
        c10.gridx = 2;
        c10.gridy = 0;
        c10.gridwidth = 1;
        c10.insets = new Insets(10, 20, 3, 5);
        gridbag.setConstraints(dialogButtonPanel, c10);
        contentPane.add(dialogButtonPanel);
        c10.insets = new Insets(0, 0, 0, 0);
        JPanel dbTablePanel = new JPanel();
        dbTablePanel.setBorder(new TitledBorder(localStrings.getLocalString("enterprise.tools.deployment.ui.descriptor.dbtable", "Database table")));
        GridBagLayout gb2 = new GridBagLayout();
        dbTablePanel.setLayout(gb2);
        JLabel tblNameLabel = new JLabel(localStrings.getLocalString("enterprise.tools.deployment.ui.descriptor.tablename", "Table name:"));
        c10.weightx = 0.5;
        c10.weighty = 0.0;
        c10.gridx = 0;
        c10.gridy = 0;
        c10.insets = new Insets(5, 5, 0, 5);
        gb2.setConstraints(tblNameLabel, c10);
        this.tblNameText = new JTextField();
        c10.weightx = 0.5;
        c10.weighty = 0.0;
        c10.gridx = 0;
        c10.gridy = 1;
        c10.gridwidth = 1;
        c10.insets = new Insets(0, 5, 0, 5);
        gb2.setConstraints(this.tblNameText, c10);
        this.createTblOnDeployCB = new JCheckBox(localStrings.getLocalString("enterprise.tools.deployment.ui.descriptor.createtableondeploy", "Create table on deploy"));
        this.createTblOnDeployCB.setMnemonic('D');
        this.createTblOnDeployCB.setSelected(false);
        c10.weightx = 1.0;
        c10.weighty = 0.0;
        c10.gridx = 0;
        c10.gridy = 0;
        c10.insets = new Insets(5, 20, 0, 5);
        gb2.setConstraints(this.createTblOnDeployCB, c10);
        dbTablePanel.add(this.createTblOnDeployCB);
        this.deleteTblOnUnDeployCB = new JCheckBox(localStrings.getLocalString("enterprise.tools.deployment.ui.descriptor.deletetableondeploy", "Delete table on undeploy"));
        this.deleteTblOnUnDeployCB.setMnemonic('U');
        this.deleteTblOnUnDeployCB.setSelected(false);
        c10.weightx = 1.0;
        c10.weighty = 0.0;
        c10.gridx = 0;
        c10.gridy = 1;
        c10.insets = new Insets(0, 20, 0, 0);
        gb2.setConstraints(this.deleteTblOnUnDeployCB, c10);
        dbTablePanel.add(this.deleteTblOnUnDeployCB);
        c10.weighty = 0.0;
        c10.weightx = 0.5;
        c10.gridx = 0;
        c10.gridy = 1;
        c10.gridwidth = 3;
        c10.insets = new Insets(5, 5, 0, 5);
        gridbag.setConstraints(dbTablePanel, c10);
        contentPane.add(dbTablePanel);
        JPanel sqlMethodsPanel = new JPanel();
        sqlMethodsPanel.setBorder(new TitledBorder(localStrings.getLocalString("enterprise.tools.deployment.ui.descriptor.sqlfordbaccess", "SQL for database access")));
        GridBagLayout gb3 = new GridBagLayout();
        sqlMethodsPanel.setLayout(gb3);
        this.sqlgenPB = new JButton(localStrings.getLocalString("enterprise.tools.deployment.ui.descriptor.generatesqlnow", "Generate SQL now"));
        this.sqlgenPB.setMnemonic('G');
        this.sqlgenPB.setActionCommand(localStrings.getLocalString("enterprise.tools.deployment.ui.descriptor.generate", "Generate"));
        this.sqlgenPB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e10) {
                DeploymentSettingsDialog.this.generateSQL();
            }
        });
        c10.weightx = 0.5;
        c10.weighty = 0.0;
        c10.gridx = 0;
        c10.gridy = 0;
        c10.gridwidth = 1;
        c10.insets = new Insets(5, 5, 0, 5);
        gb3.setConstraints(this.sqlgenPB, c10);
        sqlMethodsPanel.add(this.sqlgenPB);
        JLabel sqlMethodLabel = new JLabel(localStrings.getLocalString("enterprise.tools.deployment.ui.descriptor.ejbmethod", "EJB method:"));
        c10.weightx = 0.5;
        c10.weighty = 0.0;
        c10.gridx = 0;
        c10.gridy = 1;
        c10.gridwidth = 1;
        c10.insets = new Insets(5, 5, 0, 5);
        gb3.setConstraints(sqlMethodLabel, c10);
        sqlMethodsPanel.add(sqlMethodLabel);
        this.sqlMethodsList = new JList();
        this.sqlMethodsList.addListSelectionListener(new SqlMethodsListener());
        this.sqlMethodsList.setSelectionMode(0);
        JScrollPane finderMethodsListScrollPane = new JScrollPane(this.sqlMethodsList);
        c10.weightx = 0.5;
        c10.weighty = 0.3;
        c10.gridx = 0;
        c10.gridy = 2;
        c10.gridwidth = 1;
        c10.insets = new Insets(0, 5, 5, 5);
        gb3.setConstraints(finderMethodsListScrollPane, c10);
        sqlMethodsPanel.add(finderMethodsListScrollPane);
        JLabel sqlStmtLabel = new JLabel(localStrings.getLocalString("enterprise.tools.deployment.ui.descriptor.sqlstatement", "SQL statement:"));
        c10.weightx = 0.5;
        c10.weighty = 0.0;
        c10.gridx = 1;
        c10.gridy = 1;
        c10.gridwidth = 2;
        c10.insets = new Insets(5, 5, 0, 5);
        gb3.setConstraints(sqlStmtLabel, c10);
        sqlMethodsPanel.add(sqlStmtLabel);
        this.sqlStmtText = new JTextArea();
        this.sqlStmtText.setLineWrap(true);
        this.sqlStmtText.addFocusListener(new SqlTextFocusListener());
        c10.weightx = 0.5;
        c10.weighty = 0.3;
        c10.gridx = 1;
        c10.gridy = 2;
        c10.gridwidth = 2;
        c10.insets = new Insets(0, 5, 5, 5);
        gb3.setConstraints(this.sqlStmtText, c10);
        sqlMethodsPanel.add(this.sqlStmtText);
        c10.weighty = 1.0;
        c10.weightx = 0.5;
        c10.gridx = 0;
        c10.gridy = 2;
        c10.gridwidth = 3;
        c10.insets = new Insets(5, 5, 5, 5);
        gridbag.setConstraints(sqlMethodsPanel, c10);
        contentPane.add(sqlMethodsPanel);
        this.setContentPane(contentPane);
    }

    private void cancelAction() {
        this.sqlStmtText.setText("");
        ((Component)this).setVisible(false);
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    void doButtonEnablement() {
        this.sqlgenPB.setEnabled(this.descriptor != null && !"".equals(this.dbNameText.getText()));
    }

    private void generateSQL() {
        block5: {
            try {
                String dbName = this.dbNameText.getText();
                if (dbName == null || dbName.equals("")) {
                    JOptionPane.showMessageDialog(this, localStrings.getLocalString("enterprise.tools.deployment.ui.descriptor.nodbnamespecified", "ERROR: No database name specified"), localStrings.getLocalString("enterprise.tools.deployment.ui.descriptor.error", "Error"), 0);
                    return;
                }
                ResourceReferenceDescriptor rrd = new ResourceReferenceDescriptor();
                rrd.setJndiName(this.dbNameText.getText());
                ResourcePrincipal rp = new ResourcePrincipal(this.userNameText.getText(), this.passwdText.getText());
                rrd.setResourcePrincipal(rp);
                if (this.serverManager != null && this.serverManager.getCurrentServer() != null) {
                    DBInfo dBInfo = this.serverManager.getDBInfo(this.serverManager.getCurrentServer());
                    String msg = SQLGenerator.generateSQL(this.descriptor, rrd, true, dBInfo);
                    JOptionPane.showMessageDialog(this, msg, localStrings.getLocalString("enterprise.tools.deployment.ui.descriptor.sqlgenerator", "SQL Generator"), 1);
                    break block5;
                }
                JOptionPane.showMessageDialog(this, localStrings.getLocalString("enterprise.tools.deployment.ui.descriptor.mustconnecttotargetservertogeneratesql", "You must connect to the target server to generate the SQL"));
                return;
            }
            catch (Exception ex2) {
                JOptionPane.showMessageDialog(this, localStrings.getLocalString("enterprise.tools.deployment.ui.descriptor.errorgenerataingsql", "ERROR: while generating SQL.{0} \nPlease make sure the database name/user/password is valid \nand the J2EE server and database are running.", new Object[]{ex2}), localStrings.getLocalString("enterprise.tools.deployment.ui.descriptor.error", "Error"), 0);
                ex2.printStackTrace();
                return;
            }
        }
        String msg = localStrings.getLocalString("enterprise.tools.deployment.ui.descriptor.sqlgeneratedsuccessfully", "SQL generated successfully.\n");
        msg = String.valueOf(msg) + localStrings.getLocalString("enterprise.tools.deployment.ui.descriptor.providesqlwhereclauseforfindermethods", "Please provide the SQL WHERE clause for the following finder methods:\n");
        Set sqlMethods = this.descriptor.getAllSqlStatementedMethods();
        Iterator it = sqlMethods.iterator();
        while (it.hasNext()) {
            MethodDescriptor md = (MethodDescriptor)it.next();
            String name = md.getName();
            if (!name.startsWith("find") || name.equals("findByPrimaryKey")) continue;
            msg = String.valueOf(msg) + md.getFormattedString() + "\n";
        }
        JOptionPane.showMessageDialog(this.thisDialog, msg, localStrings.getLocalString("enterprise.tools.deployment.ui.descriptor.providefindersql", "Provide finder SQL"), 1);
        this.updateSqlMethods();
    }

    private void okAction() {
        Set sqlMethods = this.descriptor.getAllSqlStatementedMethods();
        Iterator it = sqlMethods.iterator();
        while (it.hasNext()) {
            MethodDescriptor md = (MethodDescriptor)it.next();
            String name = md.getName();
            String sql = (String)this.sqlStmtTable.get(name);
            if (name.startsWith("find") && !name.equals("findByPrimaryKey")) {
                name = md.getFormattedString();
                sql = (String)this.sqlStmtTable.get(name);
                if (sql == null || sql.equals("")) {
                    JOptionPane.showMessageDialog(this, localStrings.getLocalString("enterprise.tools.deployment.ui.descriptor.sqlforfindermethodnamenotprovided", "Warning: SQL for finder method {0} not provided", new Object[]{name}), localStrings.getLocalString("enterprise.tools.deployment.ui.descriptor.warning", "Warning"), 0);
                } else if (sql.toLowerCase().indexOf("where") == -1) {
                    JOptionPane.showMessageDialog(this, localStrings.getLocalString("enterprise.tools.deployment.ui.descriptor.sqlforfindermethodnamedoesnothavewhereclause", "Warning: SQL for finder method {0} {0} does not have a WHERE clause", new Object[]{name}), localStrings.getLocalString("enterprise.tools.deployment.ui.descriptor.warning", "Warning"), 0);
                }
            }
            this.descriptor.setSqlStatementFor(md, sql);
        }
        this.descriptor.setTableCreateSqlStatement((String)this.sqlStmtTable.get(TABLE_CREATE_METHOD));
        this.descriptor.setTableRemoveSqlStatement((String)this.sqlStmtTable.get(TABLE_DELETE_METHOD));
        ResourceReferenceDescriptor rrd = new ResourceReferenceDescriptor();
        rrd.setJndiName(this.dbNameText.getText());
        ResourcePrincipal rp = new ResourcePrincipal(this.userNameText.getText(), this.passwdText.getText());
        rrd.setResourcePrincipal(rp);
        this.descriptor.setResourceReference(rrd);
        this.descriptor.setCreateTableOnDeployment(this.createTblOnDeployCB.isSelected());
        this.descriptor.setDeleteTableOnUndeployment(this.deleteTblOnUnDeployCB.isSelected());
        this.sqlStmtText.setText("");
        if (this.warnOnExit()) {
            int exit = JOptionPane.showConfirmDialog(this, localStrings.getLocalString("enterprise.tools.deployment.ui.descriptor.beanhasnosqlstmtstosupportcmp", "This entity bean has no SQL statements to support Container manager persistence. Continue ?"), localStrings.getLocalString("enterprise.tools.deployment.ui.descriptor.question", "Question"), 0, 3);
            if (exit == 0) {
                ((Component)this).setVisible(false);
            }
        } else {
            ((Component)this).setVisible(false);
        }
    }

    void setDescriptor(EjbEntityDescriptor d10) {
        this.descriptor = d10;
        if (this.descriptor == null) {
            return;
        }
        ResourceReferenceDescriptor rrd = d10.getResourceReference();
        if (rrd != null) {
            ResourcePrincipal rp = rrd.getResourcePrincipal();
            this.dbNameText.setText(rrd.getJndiName());
            this.userNameText.setText(rp.getName());
            this.passwdText.setText(rp.getPassword());
        } else {
            this.dbNameText.setText("");
            this.userNameText.setText("");
            this.passwdText.setText("");
        }
        this.doButtonEnablement();
        this.createTblOnDeployCB.setSelected(this.descriptor.getCreateTableOnDeployment());
        this.deleteTblOnUnDeployCB.setSelected(this.descriptor.getDeleteTableOnUndeployment());
        this.updateSqlMethods();
    }

    private void updateSqlMethods() {
        this.sqlStmtTable.clear();
        Set sqlMethods = this.descriptor.getAllSqlStatementedMethods();
        String[] methodNames = new String[sqlMethods.size() + 2];
        Iterator it = sqlMethods.iterator();
        int count = 0;
        while (it.hasNext()) {
            MethodDescriptor md = (MethodDescriptor)it.next();
            String name = md.getName();
            if (name.startsWith("find") && !name.equals("findByPrimaryKey")) {
                name = md.getFormattedString();
            }
            methodNames[count++] = name;
            String sql = this.descriptor.getSqlStatementFor(md);
            this.sqlStmtTable.put(name, sql);
        }
        methodNames[count++] = TABLE_CREATE_METHOD;
        this.sqlStmtTable.put(TABLE_CREATE_METHOD, this.descriptor.getTableCreateSqlStatement());
        methodNames[count++] = TABLE_DELETE_METHOD;
        this.sqlStmtTable.put(TABLE_DELETE_METHOD, this.descriptor.getTableRemoveSqlStatement());
        this.sqlMethodsList.setListData(methodNames);
        this.sqlStmtText.setText("");
    }

    boolean warnOnExit() {
        return this.descriptor.hasCMPData() ^ true;
    }

    private class SqlMethodsListener
    implements ListSelectionListener {
        SqlMethodsListener() {
        }

        public void valueChanged(ListSelectionEvent e10) {
            if (e10.getValueIsAdjusting()) {
                return;
            }
            Object value = DeploymentSettingsDialog.this.sqlMethodsList.getSelectedValue();
            if (value == null) {
                return;
            }
            String sql = (String)DeploymentSettingsDialog.this.sqlStmtTable.get(value);
            DeploymentSettingsDialog.this.sqlStmtText.setText(sql);
            DeploymentSettingsDialog.this.sqlStmtText.repaint();
        }
    }

    private class SqlTextFocusListener
    extends FocusAdapter {
        SqlTextFocusListener() {
        }

        public void focusLost(FocusEvent e10) {
            if (e10.isTemporary()) {
                return;
            }
            Object value = DeploymentSettingsDialog.this.sqlMethodsList.getSelectedValue();
            if (value == null) {
                return;
            }
            String sql = DeploymentSettingsDialog.this.sqlStmtText.getText();
            DeploymentSettingsDialog.this.sqlStmtTable.put(value, sql);
        }
    }
}

