/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.deployment.ui.descriptor;

import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.MethodDescriptor;
import com.sun.enterprise.deployment.RoleReference;
import com.sun.enterprise.security.acl.Role;
import com.sun.enterprise.tools.deployment.ui.Inspector;
import com.sun.enterprise.tools.deployment.ui.InspectorTable;
import com.sun.enterprise.tools.deployment.ui.InspectorTableModel;
import com.sun.enterprise.tools.deployment.ui.descriptor.MethodDescriptorTableCellRenderer;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.help.CSH;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListSelectionModel;
import javax.swing.border.TitledBorder;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;

public class EjbComponentSecurityInspector
extends JPanel
implements Inspector {
    EjbDescriptor descriptor;
    String mode;
    RoleNamesTable roleNamesTable;
    MethodPermissionsTableModel methodPermissionsTableModel;
    MethodPermissionsTable methodPermissionsTable;
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(class$com$sun$enterprise$tools$deployment$ui$descriptor$EjbComponentSecurityInspector != null ? class$com$sun$enterprise$tools$deployment$ui$descriptor$EjbComponentSecurityInspector : (class$com$sun$enterprise$tools$deployment$ui$descriptor$EjbComponentSecurityInspector = EjbComponentSecurityInspector.class$("com.sun.enterprise.tools.deployment.ui.descriptor.EjbComponentSecurityInspector")));
    private static String helpSetMapID = "EISecurity";
    static /* synthetic */ Class class$com$sun$enterprise$tools$deployment$ui$descriptor$EjbComponentSecurityInspector;
    static /* synthetic */ Class class$com$sun$enterprise$deployment$MethodDescriptor;
    static /* synthetic */ Class class$java$lang$Boolean;

    public EjbComponentSecurityInspector(String mode) {
        CSH.setHelpIDString((Component)this, (String)helpSetMapID);
        GridBagLayout gb1 = new GridBagLayout();
        this.setLayout(gb1);
        GridBagConstraints c10 = new GridBagConstraints();
        c10.fill = 1;
        c10.weightx = 0.5;
        JPanel roleNamesPanel = new JPanel();
        roleNamesPanel.setBorder(new TitledBorder(localStrings.getLocalString("enterprise.tools.deployment.ui.descriptor.rolesnamesrefrencedincode", "Role names referenced in code")));
        GridBagLayout gb2 = new GridBagLayout();
        roleNamesPanel.setLayout(gb2);
        c10.gridx = 0;
        c10.gridy = 0;
        c10.gridwidth = 1;
        c10.gridheight = 1;
        c10.weightx = 0.5;
        c10.weighty = 0.5;
        c10.insets = new Insets(5, 5, 5, 5);
        c10.fill = 1;
        gb1.setConstraints(roleNamesPanel, c10);
        this.add(roleNamesPanel);
        this.roleNamesTable = new RoleNamesTable(new RoleNamesTableModel(new HashSet()));
        this.roleNamesTable.setAutoResizeMode(4);
        JScrollPane roleNamesTablePane = new JScrollPane(this.roleNamesTable);
        roleNamesTablePane.setPreferredSize(new Dimension(400, 150));
        this.roleNamesTable.setSelectionMode(0);
        ListSelectionModel roleNamesSelectionModel = this.roleNamesTable.getSelectionModel();
        c10.gridx = 0;
        c10.gridy = 0;
        c10.gridwidth = 1;
        c10.gridheight = 1;
        c10.weightx = 0.5;
        c10.weighty = 0.5;
        c10.insets = new Insets(5, 5, 5, 5);
        c10.fill = 1;
        gb2.setConstraints(roleNamesTablePane, c10);
        roleNamesPanel.add(roleNamesTablePane);
        JPanel roleNamesButtonPanel = new JPanel();
        roleNamesButtonPanel.setLayout(new GridLayout(2, 1, 5, 5));
        c10.gridx = 1;
        c10.gridy = 0;
        c10.gridwidth = 1;
        c10.gridheight = 1;
        c10.weightx = 0.0;
        c10.weighty = 0.0;
        c10.insets = new Insets(5, 5, 5, 5);
        c10.fill = 0;
        c10.anchor = 13;
        gb2.setConstraints(roleNamesButtonPanel, c10);
        roleNamesPanel.add(roleNamesButtonPanel);
        c10.fill = 1;
        c10.anchor = 10;
        JButton addPB = new JButton(localStrings.getLocalString("enterprise.tools.deployment.ui.descriptor.addbutton", "Add"));
        roleNamesButtonPanel.add(addPB);
        addPB.setMnemonic('A');
        addPB.setActionCommand("Add");
        addPB.setEnabled("DeveloperMode".equals(mode));
        addPB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e10) {
                EjbComponentSecurityInspector.this.addRoleReferenceAction();
            }
        });
        JButton delPB = new JButton(localStrings.getLocalString("enterprise.tools.deployment.ui.descriptor.deletebutton", "Delete..."));
        delPB.setEnabled("DeveloperMode".equals(mode));
        roleNamesButtonPanel.add(delPB);
        delPB.setMnemonic('D');
        delPB.setActionCommand("Delete");
        delPB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e10) {
                EjbComponentSecurityInspector.this.deleteRoleAction();
            }
        });
        JPanel methodPermissionsPanel = new JPanel();
        methodPermissionsPanel.setBorder(new TitledBorder(localStrings.getLocalString("enterprise.tools.deployment.ui.descriptor.methodpermissions", "Method permissions")));
        GridBagLayout gb3 = new GridBagLayout();
        methodPermissionsPanel.setLayout(gb3);
        c10.gridx = 0;
        c10.gridy = 1;
        c10.gridwidth = 1;
        c10.gridheight = 1;
        c10.weightx = 0.5;
        c10.weighty = 0.5;
        c10.insets = new Insets(5, 5, 5, 5);
        c10.fill = 1;
        gb1.setConstraints(methodPermissionsPanel, c10);
        this.add(methodPermissionsPanel);
        this.methodPermissionsTable = new MethodPermissionsTable(new MethodPermissionsTableModel(null));
        JScrollPane methodPermissionsTablePane = new JScrollPane(this.methodPermissionsTable);
        this.methodPermissionsTable.setAutoResizeMode(4);
        methodPermissionsTablePane.setPreferredSize(new Dimension(400, 150));
        this.methodPermissionsTable.setSelectionMode(0);
        ListSelectionModel methodPermissionsSelectionModel = this.methodPermissionsTable.getSelectionModel();
        c10.gridx = 0;
        c10.gridy = 0;
        c10.gridwidth = 1;
        c10.gridheight = 1;
        c10.weightx = 0.5;
        c10.weighty = 0.5;
        c10.insets = new Insets(5, 5, 5, 5);
        c10.fill = 1;
        gb3.setConstraints(methodPermissionsTablePane, c10);
        methodPermissionsPanel.add(methodPermissionsTablePane);
        this.setInspectorMode(mode);
    }

    private void addRoleReferenceAction() {
        String newName = Descriptor.createUniqueNameAmongstNamedDescriptors(localStrings.getLocalString("enterprise.tools.deployment.ui.descriptor.rolerefname", "RoleRefName"), this.descriptor.getRoleReferences());
        RoleReference rr = new RoleReference(newName, "");
        rr.setValue("");
        this.descriptor.addRoleReference(rr);
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    private void deleteRoleAction() {
        RoleNamesTableModel model = (RoleNamesTableModel)this.roleNamesTable.getModel();
        int index = this.roleNamesTable.getSelectedRow();
        if (index >= 0) {
            int n2 = JOptionPane.showConfirmDialog(this, localStrings.getLocalString("enterprise.tools.deployment.ui.descriptor.surewanttodeleterole", "Are you sure you want to delete selected role?"), localStrings.getLocalString("enterprise.tools.deployment.ui.descriptor.deleterole", "Delete role"), 0);
            if (n2 == 0) {
                RoleReference rr = model.getRow(index);
                this.descriptor.removeRoleReference(rr);
            }
        } else {
            JOptionPane.showMessageDialog(this, localStrings.getLocalString("enterprise.tools.deployment.ui.descriptor.firstselectrolefromlist", "You must first select a role from list"));
        }
    }

    JComponent getComponent() {
        return this;
    }

    public void refresh() {
        ((InspectorTableModel)this.roleNamesTable.getModel()).updateTableData(this.descriptor.getRoleReferences());
        this.roleNamesTable.setupRolenamesColumn();
        this.roleNamesTable.sizeColumnsToFit(0);
        this.methodPermissionsTable.setModel(new MethodPermissionsTableModel(this.descriptor));
        TableColumn methodDescriptorTableColumn = this.methodPermissionsTable.getColumnModel().getColumn(0);
        this.methodPermissionsTable.setDefaultRenderer(class$com$sun$enterprise$deployment$MethodDescriptor != null ? class$com$sun$enterprise$deployment$MethodDescriptor : (class$com$sun$enterprise$deployment$MethodDescriptor = EjbComponentSecurityInspector.class$("com.sun.enterprise.deployment.MethodDescriptor")), new MethodDescriptorTableCellRenderer());
        this.methodPermissionsTable.sizeColumnsToFit(0);
    }

    public void setInspectorMode(String mode) {
        this.mode = mode;
        this.methodPermissionsTable.setEnabled("DeployerMode".equals(mode));
    }

    public void setObject(Object o2) {
        if (o2 instanceof EjbDescriptor) {
            this.descriptor = (EjbDescriptor)o2;
            this.refresh();
        }
    }

    private class RoleNamesTable
    extends InspectorTable {
        public RoleNamesTable(RoleNamesTableModel model) {
            super(model);
            this.setSelectionMode(0);
        }

        public void setupRolenamesColumn() {
            TableColumn typeColumn = this.getColumnModel().getColumn(1);
            JComboBox<String> typeComboBox = new JComboBox<String>();
            Iterator itr = EjbComponentSecurityInspector.this.descriptor.getEjbBundleDescriptor().getRoles().iterator();
            while (itr.hasNext()) {
                Role r2 = (Role)itr.next();
                typeComboBox.addItem(r2.getName());
            }
            typeColumn.setCellEditor(new DefaultCellEditor(typeComboBox));
            DefaultTableCellRenderer renderer = new DefaultTableCellRenderer();
            renderer.setToolTipText(localStrings.getLocalString("enterprise.tools.deployment.ui.descriptor.clicktoeditrolename", "Click to edit role name"));
            typeColumn.setCellRenderer(renderer);
        }
    }

    public class RoleNamesTableModel
    extends InspectorTableModel {
        String[] columnNames = new String[]{EjbComponentSecurityInspector.access$2().getLocalString("enterprise.tools.deployment.ui.descriptor.codedname", "Coded name"), EjbComponentSecurityInspector.access$2().getLocalString("enterprise.tools.deployment.ui.descriptor.rolename", "Role name")};

        public RoleNamesTableModel(Set roleReferenceSet) {
            this.data.addAll(roleReferenceSet);
        }

        public RoleReference get(int i2) {
            return (RoleReference)this.data.get(i2);
        }

        public int getColumnCount() {
            return this.columnNames.length;
        }

        public String getColumnName(int col) {
            return this.columnNames[col].toString();
        }

        ArrayList getRoleReferences() {
            return this.data;
        }

        public RoleReference getRow(int index) {
            if (index < 0 || index >= this.getRowCount()) {
                return null;
            }
            return (RoleReference)this.data.get(index);
        }

        public int getRowCount() {
            return this.data.size();
        }

        public Object getValueAt(int row, int col) {
            RoleReference roleReference = (RoleReference)this.data.get(row);
            String value = null;
            switch (col) {
                case 0: {
                    value = roleReference.getName();
                    break;
                }
                case 1: {
                    value = roleReference.getValue();
                    break;
                }
            }
            return value;
        }

        public boolean isCellEditable(int row, int col) {
            if ("DeveloperMode".equals(EjbComponentSecurityInspector.this.mode)) {
                return true;
            }
            return col != 0;
        }

        public void setValueAt(Object value, int row, int col) {
            RoleReference roleReference = (RoleReference)this.data.get(row);
            switch (col) {
                case 0: {
                    if (value == null) break;
                    roleReference.setName(value.toString());
                    break;
                }
                case 1: {
                    if (value == null) break;
                    roleReference.setValue(value.toString());
                    EjbComponentSecurityInspector.this.descriptor.changed();
                    break;
                }
            }
        }
    }

    private class MethodPermissionsTable
    extends InspectorTable {
        public MethodPermissionsTable(MethodPermissionsTableModel model) {
            super(model);
            this.setSelectionMode(0);
        }
    }

    public class MethodPermissionsTableModel
    extends AbstractTableModel {
        EjbDescriptor descriptor;
        ArrayList orderedRoles;
        ArrayList orderedMethodDescriptors;

        public MethodPermissionsTableModel(EjbDescriptor descriptor) {
            block2: {
                this.orderedRoles = new ArrayList();
                this.orderedMethodDescriptors = new ArrayList();
                this.descriptor = descriptor;
                if (descriptor == null) break block2;
                this.orderedRoles.addAll(descriptor.getEjbBundleDescriptor().getRoles());
                try {
                    this.orderedMethodDescriptors.addAll(descriptor.getMethodDescriptors());
                }
                catch (Throwable e10) {
                    JOptionPane.showMessageDialog(EjbComponentSecurityInspector.this.getComponent(), "There was a problem obtaining the list of methods on " + descriptor.getName() + " \n There may be a missing class ? \n" + e10.getMessage());
                }
            }
        }

        public Class getColumnClass(int col) {
            Class colClass = null;
            colClass = col == 0 ? (class$com$sun$enterprise$deployment$MethodDescriptor != null ? class$com$sun$enterprise$deployment$MethodDescriptor : (class$com$sun$enterprise$deployment$MethodDescriptor = EjbComponentSecurityInspector.class$("com.sun.enterprise.deployment.MethodDescriptor"))) : (class$java$lang$Boolean != null ? class$java$lang$Boolean : (class$java$lang$Boolean = EjbComponentSecurityInspector.class$("java.lang.Boolean")));
            return colClass;
        }

        public int getColumnCount() {
            if (this.descriptor != null) {
                return this.orderedRoles.size() + 1;
            }
            return 1;
        }

        public String getColumnName(int col) {
            if (this.descriptor != null) {
                if (col == 0) {
                    return "Method";
                }
                return ((Role)this.orderedRoles.get(col - 1)).getName();
            }
            return "";
        }

        public MethodDescriptor getMethodDescriptorAtRow(int index) {
            return (MethodDescriptor)this.orderedMethodDescriptors.get(index);
        }

        public int getRowCount() {
            if (this.descriptor != null) {
                return this.orderedMethodDescriptors.size();
            }
            return 1;
        }

        public Object getValueAt(int row, int col) {
            if (this.descriptor != null) {
                if (col == 0) {
                    return this.getMethodDescriptorAtRow(row);
                }
                MethodDescriptor md = this.getMethodDescriptorAtRow(row);
                String roleName = this.getColumnName(col);
                boolean b10 = this.descriptor.getPermissionedRolesFor(md).contains(new Role(roleName));
                return new Boolean(b10);
            }
            if (col == 0) {
                return "";
            }
            return new Boolean(false);
        }

        public boolean isCellEditable(int row, int col) {
            return col != 0;
        }

        public void setValueAt(Object value, int row, int col) {
            if (this.descriptor != null) {
                MethodDescriptor md = this.getMethodDescriptorAtRow(row);
                String roleName = this.getColumnName(col);
                Boolean bool = (Boolean)value;
                if (bool.booleanValue()) {
                    this.descriptor.addPermissionedRoleFor(new Role(roleName), md);
                } else {
                    this.descriptor.removePermissionedRoleFor(new Role(roleName), md);
                }
            }
        }
    }
}

