/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.deployment.ui.descriptor;

import com.sun.enterprise.deployment.ApplicationArchivist;
import com.sun.enterprise.deployment.EjbBundleDescriptor;
import com.sun.enterprise.deployment.FileContentsDescriptor;
import com.sun.enterprise.tools.deployment.ui.ContentChooser;
import com.sun.enterprise.tools.deployment.ui.IconChanger;
import com.sun.enterprise.tools.deployment.ui.IconInspector;
import com.sun.enterprise.tools.deployment.ui.Inspector;
import com.sun.enterprise.tools.deployment.ui.InspectorModes;
import com.sun.enterprise.tools.deployment.ui.OKCancelDialog;
import com.sun.enterprise.tools.deployment.ui.UIUtils;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.help.CSH;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;

public class EjbJarGeneralInspector
extends JPanel
implements Inspector,
InspectorModes,
IconChanger {
    private static String DESCRIPTION = "Description:";
    private static String LOCATION = "Location:";
    private static String TARGET = "Enterprise Bean will go in:";
    private static String MFCLASSPATH = "Manifest Classpath:";
    private static String CONTENTS = "Contents:";
    private static String BASEDIR = "Base directory:";
    private static String DISPLAYNAME = "Display name:";
    private static String DELETE = "Delete";
    private static String ADD = "Add...";
    private static final String CHOOSE_JAR_TITLE = "Choose JAR";
    private String mode = "DeployerMode";
    private String baseDirectory = new String();
    private JTextField locationField = new JTextField(50);
    private JTextField displayNameField = new JTextField(15);
    private IconInspector iconInspector;
    private JTextArea descriptionArea = new JTextArea("Description text goes here", 4, 1);
    private JList classpathList = new JList<String>(new String[]{"", "", "", ""});
    private JList contentsList;
    private DefaultListModel contentsListModel;
    private JButton addButton = new JButton(ADD);
    private JButton deleteButton = new JButton(DELETE);
    private JButton addLibButton;
    private JButton removeLibButton;
    private FileContentsDescriptor contentsMap = new FileContentsDescriptor();
    private ContentChooser contentChooser;
    private JComponent targetChooser;
    private EjbBundleDescriptor descriptor;
    private static String helpSetMapID = "JIGeneral";
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(class$com$sun$enterprise$tools$deployment$ui$descriptor$EjbJarGeneralInspector != null ? class$com$sun$enterprise$tools$deployment$ui$descriptor$EjbJarGeneralInspector : (class$com$sun$enterprise$tools$deployment$ui$descriptor$EjbJarGeneralInspector = EjbJarGeneralInspector.class$("com.sun.enterprise.tools.deployment.ui.descriptor.EjbJarGeneralInspector")));
    static /* synthetic */ Class class$com$sun$enterprise$tools$deployment$ui$descriptor$EjbJarGeneralInspector;
    static /* synthetic */ Class class$javax$swing$JFrame;
    static /* synthetic */ Class class$java$awt$Frame;

    public EjbJarGeneralInspector() {
        CSH.setHelpIDString((Component)this, (String)helpSetMapID);
        this.initialize();
    }

    public EjbJarGeneralInspector(String mode) {
        this();
        this.mode = mode;
    }

    public EjbJarGeneralInspector(String mode, JComponent targetChooser) {
        CSH.setHelpIDString((Component)this, (String)helpSetMapID);
        this.targetChooser = targetChooser;
        this.initialize();
        this.mode = mode;
    }

    private void addContents(FileContentsDescriptor fcd) {
        Enumeration e10 = fcd.getFiles();
        while (e10.hasMoreElements()) {
            File nextKey = (File)e10.nextElement();
            this.contentsMap.add(nextKey, fcd.getDirectoryFor(nextKey));
        }
        this.refresh();
    }

    private void addContentsAction() {
        if (this.contentChooser == null) {
            this.contentChooser = new ContentChooser("Choose the classes for the Enterprise Bean being package.", "Enterprise Bean JAR classes", "Choose directory", new File(""), null);
        }
        this.contentChooser.setContentsMap(new FileContentsDescriptor());
        Frame frame = (Frame)SwingUtilities.getAncestorOfClass(class$java$awt$Frame != null ? class$java$awt$Frame : (class$java$awt$Frame = EjbJarGeneralInspector.class$("java.awt.Frame")), this);
        OKCancelDialog d10 = ContentChooser.createDialog(this.contentChooser, frame, "Add Contents to .JAR - Select Enterprise Bean class files", "EWAddFile");
        d10.show();
        if (d10.isOK()) {
            this.addContents(this.contentChooser.getContentsMap());
        }
    }

    public void addLargeIcon(File iconFile) {
        if (!this.mode.equals("DeveloperMode")) {
            ApplicationArchivist archivist = this.descriptor.getApplication().getApplicationArchivist();
            try {
                archivist.add32Icon(this.descriptor, this.descriptor, iconFile);
            }
            catch (IOException ioe) {
                JOptionPane.showMessageDialog(this, "Icon could not be added.\n " + ioe.getMessage());
            }
        } else {
            if (!"".equals(this.descriptor.getLargeIconUri())) {
                this.contentsMap.removeFile(new File(this.descriptor.getLargeIconUri()));
            }
            File absoluteIconFile = new File(iconFile.getAbsolutePath());
            this.contentsMap.add(new File(absoluteIconFile.getName()), absoluteIconFile.getParentFile());
            this.descriptor.setLargeIconUri(absoluteIconFile.getName());
            this.refresh();
        }
    }

    private void addLibJarAction() {
        JFileChooser jfc = UIUtils.getFileChooser();
        jfc.setFileSelectionMode(0);
        int returnValue = jfc.showDialog(this, "Add Library JAR");
        if (returnValue == 0) {
            File libJarFile = jfc.getSelectedFile();
            this.getFileContentsDescriptor().addLibraryJar(libJarFile);
        }
        this.refresh();
    }

    public void addSmallIcon(File iconFile) {
        if (!this.mode.equals("DeveloperMode")) {
            ApplicationArchivist archivist = this.descriptor.getApplication().getApplicationArchivist();
            try {
                archivist.add16Icon(this.descriptor, this.descriptor, iconFile);
            }
            catch (IOException ioe) {
                JOptionPane.showMessageDialog(this, "Icon could not be added.\n " + ioe.getMessage());
            }
        } else {
            if (!"".equals(this.descriptor.getSmallIconUri())) {
                this.contentsMap.removeFile(new File(this.descriptor.getSmallIconUri()));
            }
            File absoluteIconFile = new File(iconFile.getAbsolutePath());
            this.contentsMap.add(new File(absoluteIconFile.getName()), absoluteIconFile.getParentFile());
            this.descriptor.setSmallIconUri(absoluteIconFile.getName());
            this.refresh();
        }
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    public String getBaseDirectory() {
        return this.baseDirectory;
    }

    public JList getContentList() {
        return this.contentsList;
    }

    public DefaultListModel getContentListModel() {
        return this.contentsListModel;
    }

    public FileContentsDescriptor getFileContentsDescriptor() {
        return this.contentsMap;
    }

    public String getJarFile() {
        return this.locationField.getText();
    }

    private void initialize() {
        this.initializeWidgets();
        this.wireWidgets();
    }

    private void initializeWidgets() {
        JPanel p1 = new JPanel();
        JPanel p2 = null;
        JPanel p3 = null;
        this.setLayout(new BoxLayout(this, 1));
        this.setBorder(new EmptyBorder(UIUtils.getDefaultBorderSpacing()));
        p1.setLayout(new BorderLayout());
        p2 = new JPanel();
        p2.setLayout(new BorderLayout());
        this.locationField.setText(new File("ejb.jar").getAbsolutePath());
        if (this.targetChooser != null) {
            p3 = UIUtils.createBorderedPanel(TARGET, new BorderLayout());
            p3.add("Center", this.targetChooser);
        } else {
            p3 = UIUtils.createBorderedPanel(LOCATION, new BorderLayout());
            p3.add("Center", this.locationField);
        }
        p2.add("Center", p3);
        p3 = UIUtils.createBorderedPanel(DISPLAYNAME, new BorderLayout());
        p3.add("West", this.displayNameField);
        p2.add("East", p3);
        p1.add("North", p2);
        p2 = new JPanel();
        p2.setLayout(new BoxLayout(p2, 1));
        p3 = UIUtils.createBorderedPanel(DESCRIPTION, new BorderLayout());
        p3.add(new JScrollPane(this.descriptionArea));
        p2.add(p3);
        p3 = new JPanel();
        p3.setLayout(new BoxLayout(p3, 0));
        JPanel p4 = UIUtils.createBorderedPanel(MFCLASSPATH, new BorderLayout());
        JPanel classPathPanel = new JPanel();
        classPathPanel.setLayout(new BorderLayout());
        classPathPanel.add("Center", new JScrollPane(this.classpathList));
        JPanel btnPanel = new JPanel();
        this.addLibButton = new JButton("Add...");
        this.removeLibButton = new JButton("Remove...");
        btnPanel.add(this.addLibButton);
        btnPanel.add(this.removeLibButton);
        this.addLibButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae2) {
                EjbJarGeneralInspector.this.addLibJarAction();
            }
        });
        this.removeLibButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae2) {
                EjbJarGeneralInspector.this.removeLibJarAction();
            }
        });
        p4.add("Center", classPathPanel);
        p4.add("South", btnPanel);
        this.iconInspector = new IconInspector(this);
        p3.add(p4);
        p3.add(this.iconInspector);
        p2.add(p3);
        p1.add("Center", p2);
        p2 = new JPanel();
        GridLayout gl = new GridLayout(4, 1);
        gl.setVgap(10);
        gl.setHgap(10);
        p2.setLayout(gl);
        p2.add(new JLabel(""));
        p2.add(this.addButton);
        p2.add(this.deleteButton);
        this.deleteButton.setEnabled(false);
        p3 = new JPanel();
        p3.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.black), "Contents"));
        p3.setLayout(new BorderLayout());
        this.contentsListModel = new DefaultListModel();
        this.contentsList = new JList(this.contentsListModel);
        p3.add("Center", new JScrollPane(this.contentsList));
        p3.add("East", p2);
        this.add(p1);
        this.add(p3);
        JFrame frame = (JFrame)SwingUtilities.getAncestorOfClass(class$javax$swing$JFrame != null ? class$javax$swing$JFrame : (class$javax$swing$JFrame = EjbJarGeneralInspector.class$("javax.swing.JFrame")), this);
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame();
        ((Component)frame).setBounds(0, 0, 300, 300);
        frame.setContentPane(new EjbJarGeneralInspector());
        ((Component)frame).setVisible(true);
    }

    private void refresh() {
        if (this.descriptor == null) {
            return;
        }
        this.iconInspector.setObject(this.descriptor);
        if (!this.mode.equals("DeveloperMode")) {
            block11: {
                this.locationField.setEnabled(false);
                this.addLibButton.setEnabled(false);
                this.removeLibButton.setEnabled(false);
                this.locationField.setText(this.descriptor.getArchivist().getArchiveUri());
                this.addButton.setEnabled(false);
                this.deleteButton.setEnabled(false);
                ZipFile jar = null;
                try {
                    File tmpFile = File.createTempFile("scratch", "jar");
                    this.descriptor.getApplication().getApplicationArchivist().extractBundleToFile(this.descriptor, tmpFile);
                    jar = new JarFile(tmpFile);
                    DefaultListModel<String> contentsListModel = new DefaultListModel<String>();
                    Enumeration<JarEntry> jarEntries = ((JarFile)jar).entries();
                    while (jarEntries.hasMoreElements()) {
                        ZipEntry entry = jarEntries.nextElement();
                        contentsListModel.addElement(entry.getName());
                    }
                    this.contentsList.setModel(contentsListModel);
                    jar.close();
                    tmpFile.delete();
                }
                catch (Throwable throwable) {
                    if (jar == null) break block11;
                    try {
                        jar.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            DefaultListModel<String> dlm = new DefaultListModel<String>();
            Iterator itr = this.descriptor.getArchivist().getManifestClasspaths().iterator();
            while (itr.hasNext()) {
                String next = (String)itr.next();
                dlm.addElement(next);
            }
            this.classpathList.setModel(dlm);
        } else {
            DefaultListModel dlm = new DefaultListModel();
            Enumeration e10 = this.contentsMap.getFiles();
            while (e10.hasMoreElements()) {
                dlm.addElement(e10.nextElement());
            }
            this.contentsList.setModel(dlm);
            this.deleteButton.setEnabled(true);
            dlm = new DefaultListModel();
            Iterator itr = this.getFileContentsDescriptor().getLibraryJars().iterator();
            while (itr.hasNext()) {
                File next = (File)itr.next();
                dlm.addElement(next);
            }
            this.classpathList.setModel(dlm);
        }
        this.displayNameField.setText(this.descriptor.getName());
        this.descriptionArea.setText(this.descriptor.getDescription());
        this.invalidate();
        this.validate();
    }

    private void removeContentsAction() {
        Object[] selection = this.contentsList.getSelectedValues();
        if (selection != null) {
            int i2 = 0;
            while (i2 < selection.length) {
                this.contentsMap.removeFile((File)selection[i2]);
                ++i2;
            }
            this.refresh();
        }
    }

    private void removeLibJarAction() {
        Object[] selection = this.classpathList.getSelectedValues();
        if (selection != null) {
            int i2 = 0;
            while (i2 < selection.length) {
                this.getFileContentsDescriptor().removeLibraryJar((File)selection[i2]);
                ++i2;
            }
            this.refresh();
        }
    }

    public void setBaseDirectory(String baseDirectory) {
        this.baseDirectory = baseDirectory;
    }

    public void setJarFile(String jarFilename) {
        this.locationField.setText(jarFilename);
    }

    public void setObject(Object o2) {
        if (o2 instanceof EjbBundleDescriptor) {
            this.descriptor = (EjbBundleDescriptor)o2;
            this.refresh();
        } else {
            this.descriptor = null;
        }
    }

    public String toString() {
        return "Ejb Jar Inspector";
    }

    private void wireWidgets() {
        ActionListener textListener = new ActionListener(){

            public void actionPerformed(ActionEvent e10) {
                if (e10.getSource() == EjbJarGeneralInspector.this.displayNameField) {
                    EjbJarGeneralInspector.this.descriptor.setName(EjbJarGeneralInspector.this.displayNameField.getText());
                }
            }
        };
        this.displayNameField.addActionListener(textListener);
        this.displayNameField.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent fe2) {
                if (EjbJarGeneralInspector.this.descriptor != null) {
                    EjbJarGeneralInspector.this.descriptor.setName(EjbJarGeneralInspector.this.displayNameField.getText().trim());
                }
            }
        });
        this.descriptionArea.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent fe2) {
                if (EjbJarGeneralInspector.this.descriptor != null) {
                    EjbJarGeneralInspector.this.descriptor.setDescription(EjbJarGeneralInspector.this.descriptionArea.getText().trim());
                }
            }
        });
        this.descriptionArea.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent ke) {
                if (UIUtils.isEnterKey(ke) && EjbJarGeneralInspector.this.descriptor != null) {
                    EjbJarGeneralInspector.this.descriptor.setDescription(EjbJarGeneralInspector.this.descriptionArea.getText().trim());
                }
            }
        });
        this.addButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e10) {
                EjbJarGeneralInspector.this.addContentsAction();
            }
        });
        this.deleteButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e10) {
                EjbJarGeneralInspector.this.removeContentsAction();
            }
        });
    }
}

