/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.deployment.ui.descriptor;

import com.sun.enterprise.deployment.ContainerTransaction;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.EjbSessionDescriptor;
import com.sun.enterprise.deployment.MethodDescriptor;
import com.sun.enterprise.tools.deployment.ui.Inspector;
import com.sun.enterprise.tools.deployment.ui.InspectorModes;
import com.sun.enterprise.tools.deployment.ui.UIUtils;
import com.sun.enterprise.tools.deployment.ui.descriptor.MethodDescriptorTableCellRenderer;
import com.sun.enterprise.tools.deployment.ui.descriptor.TransactionTableModel;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.util.NotificationEvent;
import com.sun.enterprise.util.NotificationListener;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Vector;
import javax.help.CSH;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

public class EjbTransactionInspector
extends JPanel
implements Inspector,
InspectorModes {
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(class$com$sun$enterprise$tools$deployment$ui$descriptor$EjbTransactionInspector != null ? class$com$sun$enterprise$tools$deployment$ui$descriptor$EjbTransactionInspector : (class$com$sun$enterprise$tools$deployment$ui$descriptor$EjbTransactionInspector = EjbTransactionInspector.class$("com.sun.enterprise.tools.deployment.ui.descriptor.EjbTransactionInspector")));
    static String[] COLUMN_LABELS = new String[]{localStrings.getLocalString("enterprise.tools.deployment.ui.descriptor.method", "Method"), localStrings.getLocalString("enterprise.tools.deployment.ui.descriptor.transactiontype", "Transaction Type")};
    private static JComboBox transactionTypeCombo = null;
    private JRadioButton beanManagedRadioButton;
    private JRadioButton containerManagedRadioButton;
    String mode;
    JTable transactionTable;
    EjbDescriptor descriptor;
    private static String helpSetMapID = "EITransaction";
    static /* synthetic */ Class class$com$sun$enterprise$tools$deployment$ui$descriptor$EjbTransactionInspector;
    static /* synthetic */ Class class$com$sun$enterprise$deployment$MethodDescriptor;

    public EjbTransactionInspector(String inspectorMode) {
        CSH.setHelpIDString((Component)this, (String)helpSetMapID);
        this.mode = inspectorMode;
        this.initializeWidgets();
        this.wireWidgets();
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    private static JComboBox getTransactionTypeCombo() {
        if (transactionTypeCombo == null) {
            transactionTypeCombo = new JComboBox();
            transactionTypeCombo.addItem(ContainerTransaction.MANDATORY);
            transactionTypeCombo.addItem(ContainerTransaction.NEVER);
            transactionTypeCombo.addItem(ContainerTransaction.NOT_SUPPORTED);
            transactionTypeCombo.addItem(ContainerTransaction.REQUIRED);
            transactionTypeCombo.addItem(ContainerTransaction.REQUIRES_NEW);
            transactionTypeCombo.addItem(ContainerTransaction.SUPPORTS);
        }
        return transactionTypeCombo;
    }

    public void headerClickedAction() {
    }

    private void initializeWidgets() {
        CSH.setHelpIDString((Component)this, (String)localStrings.getLocalString("enterprise.tools.deployment.ui.descriptor.ejbtxinspectortab", "EJB_Transactions_Inspector_Tab"));
        this.transactionTable = new JTable(new TransactionTableModel());
        this.setLayout(new BorderLayout());
        JPanel p2 = UIUtils.createBorderedPanel(localStrings.getLocalString("enterprise.tools.deployment.ui.descriptor.ejbtx", "EJB Transactions"), new GridLayout(2, 1));
        p2.setLayout(new BoxLayout(p2, 1));
        ButtonGroup group = new ButtonGroup();
        this.beanManagedRadioButton = new JRadioButton(localStrings.getLocalString("enterprise.tools.deployment.ui.descriptor.bmtransactions", "Bean-managed transactions."));
        this.containerManagedRadioButton = new JRadioButton(localStrings.getLocalString("enterprise.tools.deployment.ui.descriptor.cmtransactions", "Container-managed transactions."));
        group.add(this.beanManagedRadioButton);
        group.add(this.containerManagedRadioButton);
        p2.add(this.beanManagedRadioButton);
        p2.add(this.containerManagedRadioButton);
        this.add("North", p2);
        this.add(new JScrollPane(this.transactionTable));
        this.transactionTable.getTableHeader().addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e10) {
                if (e10.getClickCount() == 2) {
                    EjbTransactionInspector.this.headerClickedAction();
                }
            }
        });
    }

    public void radioButtonsChangedAction() {
        if (this.beanManagedRadioButton.isSelected()) {
            this.descriptor.setTransactionType(EjbDescriptor.BEAN_TRANSACTION_TYPE);
        } else {
            this.descriptor.setTransactionType(EjbDescriptor.CONTAINER_TRANSACTION_TYPE);
            this.tableChangedAction();
        }
    }

    public void refresh() {
        if (this.descriptor == null) {
            return;
        }
        if (this.descriptor.getTransactionType().equals(EjbDescriptor.CONTAINER_TRANSACTION_TYPE)) {
            this.containerManagedRadioButton.setSelected(true);
        } else {
            this.beanManagedRadioButton.setSelected(true);
        }
        boolean isBeanManaged = this.descriptor.getTransactionType().equals(EjbDescriptor.BEAN_TRANSACTION_TYPE);
        this.beanManagedRadioButton.setEnabled(this.mode.equals("DeveloperMode") && this.descriptor instanceof EjbSessionDescriptor);
        this.containerManagedRadioButton.setEnabled(this.mode.equals("DeveloperMode"));
        if (isBeanManaged) {
            this.transactionTable.setModel(new TransactionTableModel());
        } else {
            Vector methods = null;
            try {
                methods = new Vector(this.descriptor.getTransactionMethodDescriptors());
            }
            catch (Throwable e10) {
                JOptionPane.showMessageDialog(this, "There was a problem obtaining the list of methods on " + this.descriptor.getName() + " \nThere may be a missing class ? \n" + e10.getMessage());
                return;
            }
            Object[][] data = new Object[methods.size()][2];
            int i2 = 0;
            while (i2 < methods.size()) {
                MethodDescriptor md = (MethodDescriptor)methods.elementAt(i2);
                ContainerTransaction containerTransaction = this.descriptor.getContainerTransactionFor(md);
                Object[] tableRow = new Object[]{md, containerTransaction != null ? containerTransaction.getTransactionAttribute() : ContainerTransaction.MANDATORY};
                data[i2] = tableRow;
                ++i2;
            }
            TransactionTableModel ttm = new TransactionTableModel(data, true);
            this.transactionTable.setModel(ttm);
            ttm.addNotificationListener(new NotificationListener(){

                public void notification(NotificationEvent ne) {
                    EjbTransactionInspector.this.tableChangedAction();
                }
            });
        }
        this.transactionTable.setAutoResizeMode(4);
        this.transactionTable.sizeColumnsToFit(0);
        TableColumn methodDescriptorTableColumn = this.transactionTable.getColumn(COLUMN_LABELS[0]);
        this.transactionTable.setDefaultRenderer(class$com$sun$enterprise$deployment$MethodDescriptor != null ? class$com$sun$enterprise$deployment$MethodDescriptor : (class$com$sun$enterprise$deployment$MethodDescriptor = EjbTransactionInspector.class$("com.sun.enterprise.deployment.MethodDescriptor")), new MethodDescriptorTableCellRenderer());
        TableColumn transactionTypeColumn = this.transactionTable.getColumn(COLUMN_LABELS[1]);
        transactionTypeColumn.setCellEditor(new DefaultCellEditor(EjbTransactionInspector.getTransactionTypeCombo()));
    }

    public void setObject(Object o2) {
        if (o2 instanceof EjbDescriptor) {
            this.descriptor = (EjbDescriptor)o2;
            this.refresh();
        }
    }

    public void tableChangedAction() {
        TableModel tm;
        if (this.descriptor != null && (tm = this.transactionTable.getModel()).getRowCount() > 0 && tm.getColumnCount() > 1) {
            int rowIndex = 0;
            while (rowIndex < tm.getRowCount()) {
                MethodDescriptor md = (MethodDescriptor)tm.getValueAt(rowIndex, 0);
                ContainerTransaction containerTransaction = new ContainerTransaction((String)tm.getValueAt(rowIndex, 1), "");
                this.descriptor.setContainerTransactionFor(md, containerTransaction);
                ++rowIndex;
            }
        }
    }

    private void wireWidgets() {
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent ae2) {
                EjbTransactionInspector.this.radioButtonsChangedAction();
            }
        };
        this.beanManagedRadioButton.addActionListener(actionListener);
        this.containerManagedRadioButton.addActionListener(actionListener);
    }
}

