/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.deployment.ui.descriptor;

import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.EjbSessionDescriptor;
import com.sun.enterprise.deployment.MailConfiguration;
import com.sun.enterprise.deployment.ResourceReferenceDescriptor;
import com.sun.enterprise.deployment.WritableJndiNameEnvironment;
import com.sun.enterprise.resource.ResourcePrincipal;
import com.sun.enterprise.tools.deployment.ui.Inspector;
import com.sun.enterprise.tools.deployment.ui.InspectorTable;
import com.sun.enterprise.tools.deployment.ui.InspectorTableModel;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.util.NotificationEvent;
import com.sun.enterprise.util.NotificationListener;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.HashSet;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.text.JTextComponent;

public class ResourceRefsInspector
extends JPanel
implements Inspector {
    ResourceRefsTableModel resourceRefsTableModel;
    ResourceRefsTable resourceRefsTable;
    JButton addPB;
    JButton delPB;
    JTextArea descriptionText;
    JTextField linkValueText;
    JTextField userNameText;
    JPasswordField passwdText;
    JTextField mailFromText;
    JTextField mailHostText;
    JTextField mailUserNameText;
    JPanel deploymentSettingsPanel;
    JPanel cardPanel;
    CardLayout cardLayout;
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(class$com$sun$enterprise$tools$deployment$ui$descriptor$ResourceRefsInspector != null ? class$com$sun$enterprise$tools$deployment$ui$descriptor$ResourceRefsInspector : (class$com$sun$enterprise$tools$deployment$ui$descriptor$ResourceRefsInspector = ResourceRefsInspector.class$("com.sun.enterprise.tools.deployment.ui.descriptor.ResourceRefsInspector")));
    WritableJndiNameEnvironment descriptor;
    String inspectorMode = "DeveloperMode";
    static final String USER_PASSWD_PANEL = localStrings.getLocalString("enterprise.tools.deployment.ui.descriptor.userpasswdpanel", "Password");
    static final String JAVA_MAIL = localStrings.getLocalString("enterprise.tools.deployment.ui.descriptor.javamail", "Java Mail");
    String[] resourceTypes = new String[]{"javax.sql.DataSource", "javax.mail.Session", "java.net.URL"};
    String[] authTypes = new String[]{ResourceReferenceDescriptor.CONTAINER_AUTHORIZATION, ResourceReferenceDescriptor.APPLICATION_AUTHORIZATION};
    static /* synthetic */ Class class$com$sun$enterprise$tools$deployment$ui$descriptor$ResourceRefsInspector;

    public ResourceRefsInspector(String inspectorMode) {
        this.initializeLayout();
        this.setInspectorMode(inspectorMode);
    }

    private void addResourceRefAction() {
        String newName = Descriptor.createUniqueNameAmongstNamedDescriptors("ResourceRefName", this.descriptor.getResourceReferenceDescriptors());
        ResourceReferenceDescriptor resourceRef = new ResourceReferenceDescriptor();
        resourceRef.setName(newName);
        resourceRef.setType(this.resourceTypes[0]);
        resourceRef.setAuthorization(this.authTypes[0]);
        resourceRef.setDescription("A description for " + resourceRef.getName());
        this.descriptor.addResourceReferenceDescriptor(resourceRef);
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    private void deSelectAction() {
        this.descriptionText.setText("");
        this.linkValueText.setText("");
        this.userNameText.setText("");
        ((JTextComponent)this.passwdText).setText("");
        this.mailFromText.setText("");
        this.mailUserNameText.setText("");
        this.descriptionText.setEnabled(false);
        this.linkValueText.setEnabled(false);
        this.userNameText.setEnabled(false);
        this.passwdText.setEnabled(false);
        this.mailFromText.setEnabled(false);
        this.mailHostText.setEnabled(false);
        this.mailUserNameText.setEnabled(false);
    }

    private void deleteResourceRefAction() {
        ListSelectionModel sm = this.resourceRefsTable.getSelectionModel();
        int index = sm.getMinSelectionIndex();
        if (index >= 0) {
            int n2 = JOptionPane.showConfirmDialog(this, localStrings.getLocalString("enterprise.tools.deployment.ui.descriptor.surewanttodeleteselectedresourceref", "Are you sure you want to delete selected resource reference?"), localStrings.getLocalString("enterprise.tools.deployment.ui.descriptor.deleteresourceref", "Delete resource reference"), 0);
            if (n2 == 0) {
                ResourceReferenceDescriptor resourceRef = this.getTableModel().getRow(index);
                this.descriptor.removeResourceReferenceDescriptor(resourceRef);
            }
        } else {
            JOptionPane.showMessageDialog(this, localStrings.getLocalString("enterprise.tools.deployment.ui.descriptor.firstselectresourcereffromlist", "You must first select a resource reference from list"));
        }
    }

    ResourceReferenceDescriptor getSelectedResourceReference() {
        int minIndex;
        ResourceReferenceDescriptor resourceRef = null;
        ListSelectionModel lsm = this.resourceRefsTable.getSelectionModel();
        if (lsm.isSelectedIndex(minIndex = lsm.getMinSelectionIndex())) {
            resourceRef = this.getTableModel().getRow(minIndex);
        }
        return resourceRef;
    }

    ResourceRefsTableModel getTableModel() {
        return (ResourceRefsTableModel)this.resourceRefsTable.getModel();
    }

    private void initializeLayout() {
        GridBagLayout gb1 = new GridBagLayout();
        this.setLayout(gb1);
        GridBagConstraints c10 = new GridBagConstraints();
        c10.fill = 1;
        c10.weightx = 0.5;
        this.setLayout(gb1);
        JPanel resourceRefsPanel = new JPanel();
        GridBagLayout gb2 = new GridBagLayout();
        resourceRefsPanel.setLayout(gb2);
        resourceRefsPanel.setBorder(new TitledBorder(localStrings.getLocalString("enterprise.tools.deployment.ui.descriptor.resourcefactoriesrefrencedincode", "Resource factories referenced in code")));
        c10.gridx = 0;
        c10.gridy = 0;
        c10.gridwidth = 1;
        c10.gridheight = 1;
        c10.weightx = 0.5;
        c10.weighty = 0.5;
        c10.insets = new Insets(5, 5, 5, 5);
        c10.fill = 1;
        gb1.setConstraints(resourceRefsPanel, c10);
        this.add(resourceRefsPanel);
        this.resourceRefsTable = new ResourceRefsTable(new ResourceRefsTableModel(new HashSet()));
        this.resourceRefsTable.getSelectionModel().addListSelectionListener(new ResourceRefsSelectionListener());
        this.resourceRefsTable.setAutoResizeMode(4);
        JScrollPane resourceRefsTablePane = new JScrollPane(this.resourceRefsTable);
        resourceRefsTablePane.setBorder(BorderFactory.createLoweredBevelBorder());
        c10.gridx = 0;
        c10.gridy = 0;
        c10.gridwidth = 1;
        c10.gridheight = 1;
        c10.weightx = 0.5;
        c10.weighty = 0.66;
        c10.insets = new Insets(5, 5, 5, 5);
        c10.fill = 1;
        gb2.setConstraints(resourceRefsTablePane, c10);
        resourceRefsPanel.add(resourceRefsTablePane);
        JPanel resourceRefsButtonPanel = new JPanel();
        resourceRefsButtonPanel.setLayout(new GridLayout(2, 1, 5, 5));
        c10.gridx = 1;
        c10.gridy = 0;
        c10.gridwidth = 1;
        c10.gridheight = 1;
        c10.weightx = 0.0;
        c10.weighty = 0.0;
        c10.insets = new Insets(5, 5, 5, 5);
        c10.fill = 0;
        c10.anchor = 13;
        gb2.setConstraints(resourceRefsButtonPanel, c10);
        resourceRefsPanel.add(resourceRefsButtonPanel);
        c10.fill = 1;
        c10.anchor = 10;
        this.addPB = new JButton(localStrings.getLocalString("enterprise.tools.deployment.ui.descriptor.addbutton", "Add"));
        resourceRefsButtonPanel.add(this.addPB);
        this.addPB.setMnemonic('A');
        this.addPB.setActionCommand("Add");
        this.addPB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e10) {
                ResourceRefsInspector.this.addResourceRefAction();
            }
        });
        this.delPB = new JButton(localStrings.getLocalString("enterprise.tools.deployment.ui.descriptor.delete", "Delete..."));
        resourceRefsButtonPanel.add(this.delPB);
        this.delPB.setMnemonic('D');
        this.delPB.setActionCommand("Delete");
        this.delPB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e10) {
                ResourceRefsInspector.this.deleteResourceRefAction();
            }
        });
        JLabel descriptionLabel = new JLabel(localStrings.getLocalString("enterprise.tools.deployment.ui.descriptor.description", "Description:"));
        c10.weightx = 0.0;
        c10.weighty = 0.0;
        c10.gridx = 0;
        c10.gridy = 1;
        c10.gridwidth = 1;
        c10.gridheight = 1;
        c10.insets = new Insets(5, 5, 0, 5);
        gb2.setConstraints(descriptionLabel, c10);
        resourceRefsPanel.add(descriptionLabel);
        this.descriptionText = new JTextArea();
        JScrollPane descriptionTextPane = new JScrollPane(this.descriptionText);
        c10.weightx = 0.5;
        c10.weighty = 0.33;
        c10.gridx = 0;
        c10.gridy = 2;
        c10.gridwidth = 1;
        c10.gridheight = 1;
        c10.insets = new Insets(0, 5, 5, 5);
        gb2.setConstraints(descriptionTextPane, c10);
        resourceRefsPanel.add(descriptionTextPane);
        this.descriptionText.addMouseListener(new MouseAdapter(){

            public void mouseExited(MouseEvent me) {
                ResourceRefsInspector.this.storeDescription();
            }
        });
        this.descriptionText.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent ke) {
                if (ke.getKeyCode() == 10) {
                    ResourceRefsInspector.this.storeDescription();
                }
            }
        });
        this.deploymentSettingsPanel = new JPanel();
        GridBagLayout gb3 = new GridBagLayout();
        this.deploymentSettingsPanel.setLayout(gb3);
        this.deploymentSettingsPanel.setBorder(new TitledBorder(localStrings.getLocalString("enterprise.tools.deployment.ui.descriptor.deploymentsettings", "Deployment Settings")));
        c10.weighty = 0.0;
        c10.weightx = 0.5;
        c10.gridx = 0;
        c10.gridy = 1;
        c10.gridwidth = 1;
        c10.insets = new Insets(5, 5, 0, 5);
        gb1.setConstraints(this.deploymentSettingsPanel, c10);
        this.add(this.deploymentSettingsPanel);
        JLabel linkValueLabel = new JLabel(localStrings.getLocalString("enterprise.tools.deployment.ui.descriptor.linkvalue", "Link value:"));
        c10.weightx = 0.5;
        c10.weighty = 0.0;
        c10.gridx = 0;
        c10.gridy = 0;
        c10.gridwidth = 1;
        c10.insets = new Insets(0, 5, 0, 5);
        gb3.setConstraints(linkValueLabel, c10);
        this.deploymentSettingsPanel.add(linkValueLabel);
        this.linkValueText = new JTextField();
        c10.weighty = 0.0;
        c10.gridx = 0;
        c10.gridy = 1;
        c10.gridwidth = 2;
        c10.insets = new Insets(0, 5, 0, 5);
        gb3.setConstraints(this.linkValueText, c10);
        this.deploymentSettingsPanel.add(this.linkValueText);
        this.linkValueText.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent fe2) {
                ResourceRefsInspector.this.storeLinkValue();
            }
        });
        this.linkValueText.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent ke) {
                if (ke.getKeyCode() == 10) {
                    ResourceRefsInspector.this.storeLinkValue();
                }
            }
        });
        this.cardPanel = new JPanel();
        this.cardLayout = new CardLayout();
        this.cardPanel.setLayout(this.cardLayout);
        c10.weightx = 0.5;
        c10.weighty = 0.0;
        c10.gridx = 0;
        c10.gridy = 2;
        c10.gridwidth = 2;
        c10.insets = new Insets(0, 0, 0, 0);
        gb3.setConstraints(this.cardPanel, c10);
        this.deploymentSettingsPanel.add(this.cardPanel);
        JPanel userPasswdPanel = new JPanel();
        GridBagLayout gb4 = new GridBagLayout();
        userPasswdPanel.setLayout(gb4);
        this.cardPanel.add((Component)userPasswdPanel, USER_PASSWD_PANEL);
        JLabel userNameLabel = new JLabel(localStrings.getLocalString("enterprise.tools.deployment.ui.descriptor.username", "User name:"));
        c10.weighty = 0.0;
        c10.gridx = 0;
        c10.gridy = 0;
        c10.gridwidth = 1;
        c10.insets = new Insets(5, 5, 0, 5);
        gb4.setConstraints(userNameLabel, c10);
        userPasswdPanel.add(userNameLabel);
        this.userNameText = new JTextField();
        c10.weighty = 0.0;
        c10.gridx = 0;
        c10.gridy = 1;
        c10.insets = new Insets(0, 5, 0, 5);
        gb4.setConstraints(this.userNameText, c10);
        userPasswdPanel.add(this.userNameText);
        this.userNameText.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent fe2) {
                ResourceRefsInspector.this.storeUserName();
            }
        });
        this.userNameText.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent ke) {
                if (ke.getKeyCode() == 10) {
                    ResourceRefsInspector.this.storeUserName();
                }
            }
        });
        JLabel passwdLabel = new JLabel(localStrings.getLocalString("enterprise.tools.deployment.ui.descriptor.password", "Password:"));
        c10.weighty = 0.0;
        c10.gridx = 1;
        c10.gridy = 0;
        c10.gridwidth = 1;
        c10.insets = new Insets(5, 5, 0, 5);
        gb4.setConstraints(passwdLabel, c10);
        userPasswdPanel.add(passwdLabel);
        this.passwdText = new JPasswordField();
        c10.weighty = 0.0;
        c10.gridx = 1;
        c10.gridy = 1;
        c10.insets = new Insets(0, 5, 0, 5);
        gb4.setConstraints(this.passwdText, c10);
        userPasswdPanel.add(this.passwdText);
        this.passwdText.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent fe2) {
                ResourceRefsInspector.this.storePassword();
            }
        });
        this.passwdText.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent ke) {
                if (ke.getKeyCode() == 10) {
                    ResourceRefsInspector.this.storePassword();
                }
            }
        });
        JPanel mailPanel = new JPanel();
        GridBagLayout gb5 = new GridBagLayout();
        mailPanel.setLayout(gb5);
        this.cardPanel.add((Component)mailPanel, JAVA_MAIL);
        JLabel mailFromLabel = new JLabel(localStrings.getLocalString("enterprise.tools.deployment.ui.descriptor.from", "From:"));
        c10.weighty = 0.0;
        c10.gridx = 0;
        c10.gridy = 0;
        c10.gridwidth = 1;
        c10.insets = new Insets(5, 5, 0, 5);
        gb5.setConstraints(mailFromLabel, c10);
        mailPanel.add(mailFromLabel);
        this.mailFromText = new JTextField();
        c10.weighty = 0.0;
        c10.gridx = 0;
        c10.gridy = 1;
        c10.insets = new Insets(0, 5, 0, 5);
        gb5.setConstraints(this.mailFromText, c10);
        mailPanel.add(this.mailFromText);
        this.mailFromText.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent fe2) {
                ResourceRefsInspector.this.storeMailConfig();
            }
        });
        this.mailFromText.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent ke) {
                if (ke.getKeyCode() == 10) {
                    ResourceRefsInspector.this.storeMailConfig();
                }
            }
        });
        JLabel mailHostLabel = new JLabel(localStrings.getLocalString("enterprise.tools.deployment.ui.descriptor.host", "Host:"));
        c10.weighty = 0.0;
        c10.gridx = 1;
        c10.gridy = 0;
        c10.gridwidth = 1;
        c10.insets = new Insets(5, 5, 0, 5);
        gb5.setConstraints(mailHostLabel, c10);
        mailPanel.add(mailHostLabel);
        this.mailHostText = new JTextField();
        c10.weighty = 0.0;
        c10.gridx = 1;
        c10.gridy = 1;
        c10.insets = new Insets(0, 5, 0, 5);
        gb5.setConstraints(this.mailHostText, c10);
        mailPanel.add(this.mailHostText);
        this.mailHostText.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent fe2) {
                ResourceRefsInspector.this.storeMailConfig();
            }
        });
        this.mailHostText.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent ke) {
                if (ke.getKeyCode() == 10) {
                    ResourceRefsInspector.this.storeMailConfig();
                }
            }
        });
        JLabel mailUserNameLabel = new JLabel(localStrings.getLocalString("enterprise.tools.deployment.ui.descriptor.username", "User name:"));
        c10.weighty = 0.0;
        c10.gridx = 2;
        c10.gridy = 0;
        c10.gridwidth = 1;
        c10.insets = new Insets(5, 5, 0, 5);
        gb5.setConstraints(mailUserNameLabel, c10);
        mailPanel.add(mailUserNameLabel);
        this.mailUserNameText = new JTextField();
        c10.weighty = 0.0;
        c10.gridx = 2;
        c10.gridy = 1;
        c10.insets = new Insets(0, 5, 0, 5);
        gb5.setConstraints(this.mailUserNameText, c10);
        mailPanel.add(this.mailUserNameText);
        this.mailUserNameText.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent fe2) {
                ResourceRefsInspector.this.storeMailConfig();
            }
        });
        this.mailUserNameText.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent ke) {
                if (ke.getKeyCode() == 10) {
                    ResourceRefsInspector.this.storeMailConfig();
                }
            }
        });
        this.deSelectAction();
    }

    public static void main(String[] args) {
        final ResourceRefsInspector ei2 = new ResourceRefsInspector("DeveloperMode");
        JFrame f2 = new JFrame();
        ((Component)f2).setBounds(10, 10, 300, 300);
        f2.getContentPane().add(ei2);
        f2.show();
        final EjbSessionDescriptor descriptor = new EjbSessionDescriptor();
        descriptor.addNotificationListener(new NotificationListener(){

            public void notification(NotificationEvent ne) {
                ei2.setObject(descriptor);
            }
        });
        ei2.setObject(descriptor);
    }

    protected void refresh() {
        if (this.inspectorMode.equals("DeveloperMode")) {
            this.deploymentSettingsPanel.setEnabled(false);
        } else {
            this.deploymentSettingsPanel.setEnabled(true);
        }
        ((InspectorTableModel)this.resourceRefsTable.getModel()).updateTableData(this.descriptor.getResourceReferenceDescriptors());
        this.resourceRefsTable.sizeColumnsToFit(0);
        this.showResourceRef(this.getSelectedResourceReference());
    }

    private void selectAction() {
        this.descriptionText.setEnabled(true);
        this.showResourceRef(this.getSelectedResourceReference());
        if (!"DeveloperMode".equals(this.inspectorMode)) {
            this.linkValueText.setEnabled(true);
            this.userNameText.setEnabled(true);
            this.passwdText.setEnabled(true);
            this.mailFromText.setEnabled(true);
            this.mailHostText.setEnabled(true);
            this.mailUserNameText.setEnabled(true);
        }
    }

    public void setInspectorMode(String mode) {
        this.inspectorMode = mode;
        this.addPB.setEnabled(this.inspectorMode.equalsIgnoreCase("DeveloperMode"));
        this.delPB.setEnabled(this.inspectorMode.equalsIgnoreCase("DeveloperMode"));
    }

    public void setObject(Object o2) {
        if (o2 instanceof WritableJndiNameEnvironment) {
            this.descriptor = (WritableJndiNameEnvironment)o2;
            this.refresh();
        }
    }

    private void showResourceRef(ResourceReferenceDescriptor resourceRef) {
        if (resourceRef != null) {
            MailConfiguration mailConfig;
            this.descriptionText.setText(resourceRef.getDescription());
            this.linkValueText.setText(resourceRef.getJndiName());
            String resType = resourceRef.getType();
            this.showResourceType(resType);
            ResourcePrincipal principal = resourceRef.getResourcePrincipal();
            if (principal != null) {
                this.userNameText.setText(principal.getName());
                ((JTextComponent)this.passwdText).setText(principal.getPassword());
            }
            if ((mailConfig = resourceRef.getMailConfiguration()) != null) {
                this.mailUserNameText.setText(mailConfig.getUsername());
                this.mailFromText.setText(mailConfig.getMailFrom());
                this.mailHostText.setText(mailConfig.getMailHost());
            }
        }
    }

    void showResourceType(String resType) {
        if (resType.equals("javax.mail.Session")) {
            this.cardLayout.show(this.cardPanel, JAVA_MAIL);
        } else {
            this.cardLayout.show(this.cardPanel, USER_PASSWD_PANEL);
        }
    }

    void showUserPasswdPanel() {
        this.cardLayout.show(this.cardPanel, USER_PASSWD_PANEL);
    }

    private void storeDescription() {
        ResourceReferenceDescriptor resourceRef = this.getSelectedResourceReference();
        if (resourceRef != null) {
            resourceRef.setDescription(this.descriptionText.getText().trim());
        }
    }

    private void storeLinkValue() {
        ResourceReferenceDescriptor resourceRef = this.getSelectedResourceReference();
        if (resourceRef != null) {
            resourceRef.setJndiName(this.linkValueText.getText().trim());
            ((Descriptor)((Object)this.descriptor)).changed();
        }
    }

    private void storeMailConfig() {
        ResourceReferenceDescriptor resourceRef = this.getSelectedResourceReference();
        if (resourceRef != null) {
            String userName = this.mailUserNameText.getText();
            String host = this.mailHostText.getText();
            String mailFrom = this.mailFromText.getText();
            MailConfiguration mailConfig = new MailConfiguration(userName, mailFrom, host);
            resourceRef.setMailConfiguration(mailConfig);
            ((Descriptor)((Object)this.descriptor)).changed();
        }
    }

    private void storePassword() {
        ResourceReferenceDescriptor resourceRef = this.getSelectedResourceReference();
        if (resourceRef != null) {
            String rawPassword = new String(this.passwdText.getPassword());
            resourceRef.setResourcePrincipal(new ResourcePrincipal(this.userNameText.getText().trim(), rawPassword.trim()));
            ((Descriptor)((Object)this.descriptor)).changed();
        }
    }

    private void storeUserName() {
        ResourceReferenceDescriptor resourceRef = this.getSelectedResourceReference();
        if (resourceRef != null) {
            String rawPassword = new String(this.passwdText.getPassword());
            resourceRef.setResourcePrincipal(new ResourcePrincipal(this.userNameText.getText().trim(), rawPassword.trim()));
            ((Descriptor)((Object)this.descriptor)).changed();
        }
    }

    class ResourceRefsSelectionListener
    implements ListSelectionListener {
        ResourceRefsSelectionListener() {
        }

        public void valueChanged(ListSelectionEvent e10) {
            ListSelectionModel sm = (ListSelectionModel)e10.getSource();
            boolean isAdjusting = e10.getValueIsAdjusting();
            if (isAdjusting) {
                return;
            }
            if (sm.isSelectionEmpty()) {
                ResourceRefsInspector.this.deSelectAction();
            } else {
                ResourceRefsInspector.this.selectAction();
            }
        }
    }

    class ResourceTypeItemListener
    implements ItemListener {
        ResourceTypeItemListener() {
        }

        public void itemStateChanged(ItemEvent evt) {
            String item = (String)evt.getItem();
            ResourceRefsInspector.this.showResourceType(item);
        }
    }

    private class ResourceRefsTable
    extends InspectorTable {
        public ResourceRefsTable(ResourceRefsTableModel model) {
            super(model);
            this.setToolTipText(localStrings.getLocalString("enterprise.tools.deployment.ui.descriptor.tableofresourcerefs", "Table of resource references"));
            this.setSelectionMode(0);
            this.setupTypeColumn();
            this.setupAuthColumn();
        }

        void setupAuthColumn() {
            TableColumn authColumn = this.getColumnModel().getColumn(2);
            JComboBox<String> authComboBox = new JComboBox<String>(ResourceRefsInspector.this.authTypes);
            authColumn.setCellEditor(new DefaultCellEditor(authComboBox));
            DefaultTableCellRenderer renderer = new DefaultTableCellRenderer();
            renderer.setToolTipText(localStrings.getLocalString("enterprise.tools.deployment.ui.descriptor.clicktoeditresourceauthentication", "Click to edit resource authentication"));
            authColumn.setCellRenderer(renderer);
        }

        void setupTypeColumn() {
            TableColumn typeColumn = this.getColumnModel().getColumn(1);
            JComboBox<String> typeComboBox = new JComboBox<String>(ResourceRefsInspector.this.resourceTypes);
            typeComboBox.addItemListener(new ResourceTypeItemListener());
            typeColumn.setCellEditor(new DefaultCellEditor(typeComboBox));
            DefaultTableCellRenderer renderer = new DefaultTableCellRenderer();
            renderer.setToolTipText(localStrings.getLocalString("enterprise.tools.deployment.ui.descriptor.clicktoeditresourcetype", "Click to edit resource type"));
            typeColumn.setCellRenderer(renderer);
        }
    }

    public class ResourceRefsTableModel
    extends InspectorTableModel {
        ResourceRefsInspector inspector;
        String[] columnNames = new String[]{ResourceRefsInspector.access$9().getLocalString("enterprise.tools.deployment.ui.descriptor.codedname", "Coded Name"), ResourceRefsInspector.access$9().getLocalString("enterprise.tools.deployment.ui.descriptor.type", "Type"), ResourceRefsInspector.access$9().getLocalString("enterprise.tools.deployment.ui.descriptor.authentication", "Authentication")};

        public ResourceRefsTableModel(Set resourceReferenceDescriptors) {
            this.data.addAll(resourceReferenceDescriptors);
        }

        public int getColumnCount() {
            return this.columnNames.length;
        }

        public String getColumnName(int col) {
            return this.columnNames[col].toString();
        }

        public ResourceReferenceDescriptor getRow(int index) {
            if (index < 0 || index >= this.getRowCount()) {
                return null;
            }
            return (ResourceReferenceDescriptor)this.data.get(index);
        }

        public int getRowCount() {
            return this.data.size();
        }

        public Object getValueAt(int row, int col) {
            ResourceReferenceDescriptor resourceRef = (ResourceReferenceDescriptor)this.data.get(row);
            String value = null;
            switch (col) {
                case 0: {
                    value = resourceRef.getName();
                    break;
                }
                case 1: {
                    value = resourceRef.getType();
                    break;
                }
                case 2: {
                    value = resourceRef.getAuthorization();
                    break;
                }
            }
            return value;
        }

        public boolean isCellEditable(int row, int col) {
            if (ResourceRefsInspector.this.inspectorMode.equalsIgnoreCase("DeveloperMode")) {
                return true;
            }
            return col != 0;
        }

        public void setValueAt(Object value, int row, int col) {
            ResourceReferenceDescriptor resourceRef = (ResourceReferenceDescriptor)this.data.get(row);
            switch (col) {
                case 0: {
                    resourceRef.setName(value.toString());
                    return;
                }
                case 1: {
                    resourceRef.setType(value.toString());
                    break;
                }
                case 2: {
                    resourceRef.setAuthorization(value.toString());
                    break;
                }
            }
            ((Descriptor)((Object)ResourceRefsInspector.this.descriptor)).changed();
        }
    }
}

